/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onecode.api.plugin;

import com.geoway.adf.dms.common.config.UploadPathConfig;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.annotation.Resource;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class GraphDatabaseWriter {
    private static final Logger log = LoggerFactory.getLogger(GraphDatabaseWriter.class);
    @Value(value="${neo4j.baseUrl:#{null}}")
    private String baseUrl;
    @Resource
    private DataSourceManager dataSourceManager;

    public Driver getNeo4jDriver(String dbKey) {
        DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(dbKey);
        return GraphDatabase.driver((String)dataSourceDTO.getUrl(), (AuthToken)AuthTokens.basic((String)dataSourceDTO.getUserName(), (String)dataSourceDTO.getPassword()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGraphIndex(Driver driver) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            try (Session session = driver.session();){
                session.run(String.format("CREATE CONSTRAINT IF NOT EXISTS ON (n:`%s`) ASSERT n.%s IS UNIQUE", "\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53", "node_id"));
                session.run(String.format("CREATE INDEX IF NOT EXISTS FOR (n:`%s`) ON (n.%s)", "\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53", "stma"));
                session.run(String.format("CREATE INDEX IF NOT EXISTS FOR (n:`%s`) ON (n.%s)", "\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53", "stfl"));
                session.run(String.format("CREATE INDEX IF NOT EXISTS FOR (n:`%s`) ON (n.%s)", "\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53", "xzqdm"));
                session.run(String.format("CREATE INDEX IF NOT EXISTS FOR (n:`%s`) ON (n.%s)", "\u81ea\u7136\u8d44\u6e90\u4e1a\u52a1", "ywlx"));
            }
            catch (Exception e) {
                log.error("\u56fe\u5e93\u7d22\u5f15\u521b\u5efa\u5931\u8d25", (Throwable)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteNode(Driver driver, String datasetId) {
        try (Session session = driver.session();){
            Result result = session.run(String.format("Call apoc.periodic.iterate(\"MATCH (n:`%s`) return id(n) as id\", \"MATCH (n) WHERE id(n) = id DETACH DELETE n\", {batchSize:50000}) yield batches, total return batches, total", datasetId));
            log.info(result.next().toString());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u8282\u70b9\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public String getTempPath(String tempName) {
        return UploadPathConfig.getUploadPath() + File.separator + "entity" + File.separator + tempName;
    }

    public void appendEntityNode(BufferedWriter csvWriter, LinkedHashMap<String, String> nodePropertys) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        for (String key : nodePropertys.keySet()) {
            stringBuilder.append(this.replaceSpecialStr(nodePropertys.get(key))).append(",");
        }
        csvWriter.write(stringBuilder.toString(), 0, stringBuilder.length() - 1);
        csvWriter.newLine();
    }

    public void importEntityNode(Driver driver, String tag, String datasetId, Set<String> propertyFields, String csvPath, String csvName) {
        String fileUrl = this.baseUrl + "/input/csv?path=" + csvPath + "&fileName=" + csvName;
        try (Session sessionTemp = driver.session();){
            StringBuilder stringBuffer = new StringBuilder();
            stringBuffer.append(String.format("USING PERIODIC COMMIT 1000 Load CSV From '%s' as line with line Merge (c:%s {%s: line[0]}) on Create set ", fileUrl, "`" + tag + "`:`" + datasetId + "`", "node_id"));
            int startIndex = 0;
            for (String name : propertyFields) {
                stringBuffer.append(String.format("c.%s= line[%d],", name, startIndex));
                ++startIndex;
            }
            String cql = stringBuffer.substring(0, stringBuffer.length() - 1);
            sessionTemp.run(cql);
        }
    }

    public void appendEntityRelation(BufferedWriter csvWriter, String startId, String endId, LinkedHashMap<String, String> relationProperty) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.replaceSpecialStr(startId)).append(",");
        stringBuilder.append(this.replaceSpecialStr(endId)).append(",");
        for (String key : relationProperty.keySet()) {
            stringBuilder.append(this.replaceSpecialStr(relationProperty.get(key))).append(",");
        }
        csvWriter.write(stringBuilder.toString(), 0, stringBuilder.length() - 1);
        csvWriter.newLine();
    }

    public void importEntityRelation(Driver driver, String relationType, String startTag, String endTag, Set<String> propertyFields, String csvPath, String csvName) {
        String fileUrl = this.baseUrl + "/input/csv?path=" + csvPath + "&fileName=" + csvName;
        try (Session sessionTemp = driver.session();){
            int startIndex = 2;
            StringBuilder stringBuffer = new StringBuilder();
            for (String name : propertyFields) {
                stringBuffer.append(String.format("%s:line[%d],", name, startIndex));
                ++startIndex;
            }
            String cql = String.format("USING PERIODIC COMMIT 100 Load CSV From '%s' as line with line Match (start:`%s` {%s:line[0]}),(end:`%s` {%s:line[1]}) Merge (start)-[r:`%s` {%s}]->(end)", fileUrl, startTag, "stma", endTag, "stma", relationType, stringBuffer.substring(0, stringBuffer.length() - 1));
            sessionTemp.run(cql);
        }
    }

    private String replaceSpecialStr(String strValue) {
        if (strValue == null) {
            return strValue;
        }
        boolean hasSpecial = false;
        if (strValue.contains("\"")) {
            strValue = strValue.replace("\"", "\"\"");
            hasSpecial = true;
        }
        if (strValue.contains(",") || strValue.contains("\r") || strValue.contains("\n")) {
            hasSpecial = true;
        }
        if (hasSpecial) {
            strValue = "\"" + strValue + "\"";
        }
        return strValue;
    }
}

