/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onecode.api.service;

import cn.hutool.core.lang.UUID;
import com.geoway.adf.dms.common.dto.SpatialRefDTO;
import com.geoway.adf.dms.common.util.FileViewerUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dto.dict.DmDictValueDTO;
import com.geoway.adf.dms.config.dto.sysparam.SysParamDTO;
import com.geoway.adf.dms.config.entity.CmColorItem;
import com.geoway.adf.dms.config.service.ColorItemService;
import com.geoway.adf.dms.config.service.DictionaryService;
import com.geoway.adf.dms.config.service.SysParamsService;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.constant.DataStoreTypeEnum;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.FeatureClassDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.FeatureResult;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterDTO;
import com.geoway.adf.dms.datasource.dto.query.ReturnField;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.gis.basic.PageList;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.SpatialQueryFilter;
import com.geoway.adf.gis.geodb.filter.SpatialRelationType;
import com.geoway.dgt.onecode.dto.EntityClassSpecialDataDTO;
import com.geoway.dgt.onecode.entity.CodeEntityClass;
import com.geoway.dgt.onecode.service.CodeEntityClassService;
import com.geoway.dgt.onecode.service.CodeRecordService;
import com.geoway.onecode.api.dto.BizGroupDTO;
import com.geoway.onecode.api.dto.DltbDTO;
import com.geoway.onecode.api.dto.DltbThroughResultDTO;
import com.geoway.onecode.api.dto.EntityConditionFilterDTO;
import com.geoway.onecode.api.dto.EntityDTO;
import com.geoway.onecode.api.dto.EntityFilterDTO;
import com.geoway.onecode.api.dto.EntitySpatialFilterDTO;
import com.geoway.onecode.api.dto.RelateFileDTO;
import com.geoway.onecode.api.dto.TbDTO;
import com.geoway.onecode.api.dto.TbRelationDTO;
import com.geoway.onecode.api.dto.TbTypeEnum;
import com.geoway.onecode.api.service.RelatedResultsService;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.value.FloatValue;
import org.neo4j.driver.internal.value.IntegerValue;
import org.neo4j.driver.internal.value.StringValue;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Path;
import org.neo4j.driver.types.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class OneCodeQueryService {
    private static final Logger log = LoggerFactory.getLogger(OneCodeQueryService.class);
    @Resource
    private DataSourceManager dataSourceManager;
    @Resource
    private GeoDatabaseService geoDatabaseService;
    @Resource
    private DataSourceService dataSourceService;
    @Resource
    private CodeEntityClassService codeEntityClassService;
    @Resource
    private CodeRecordService codeRecordService;
    @Resource
    private DictionaryService dictionaryService;
    @Resource
    private ColorItemService colorItemService;
    @Resource
    private SysParamsService sysParamsService;
    @Resource
    private RelatedResultsService relatedResultsService;
    private final String colorSchemeName = "\u4e09\u8c03\u5730\u7c7b\u8272\u503c";
    private final List<String> invisibleFields = Arrays.asList("fid", "objectid", "objectid_1", "shape_length", "shape_len", "shape_leng", "shape_area", "f_frame", "f_importtime");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PageList<EntityDTO> queryEntitys(EntityFilterDTO filter) {
        try (Driver driver = this.getNeo4jDriver();){
            String whereClause = String.format("n.%s='01'", "code_type");
            if (!StringUtil.isEmptyOrWhiteSpace((String)filter.getEntityID())) {
                whereClause = whereClause + String.format(" and n.%s='%s'", "stma", filter.getEntityID().trim());
            }
            if (!StringUtil.isEmptyOrWhiteSpace((String)filter.getEntityClassIds())) {
                List classIds = Arrays.stream(filter.getEntityClassIds().trim().split(",")).distinct().collect(Collectors.toList());
                whereClause = whereClause + String.format(" and n.%s in [%s]", "stfl", String.join((CharSequence)",", ListUtil.convertAll(classIds, c -> "'" + c + "'")));
            }
            if (!StringUtil.isEmptyOrWhiteSpace((String)filter.getXzqdm())) {
                String shortXzqdm = filter.getXzqdm();
                while (shortXzqdm.endsWith("00")) {
                    shortXzqdm = shortXzqdm.substring(0, shortXzqdm.length() - 2);
                }
                if (shortXzqdm.length() > 0) {
                    whereClause = whereClause + String.format(" and n.%s STARTS WITH '%s'", "xzqdm", shortXzqdm);
                }
            }
            String sql = String.format("Match (n:`%s`) where %s", "\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53", whereClause);
            if (!StringUtil.isEmptyOrWhiteSpace((String)filter.getYygxCodes()) || !StringUtil.isEmptyOrWhiteSpace((String)filter.getYwlxCodes())) {
                String relWhereClause = String.format("(b:`\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53` OR b:`\u81ea\u7136\u8d44\u6e90\u4e1a\u52a1`)", "\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53", "\u81ea\u7136\u8d44\u6e90\u4e1a\u52a1");
                if (!StringUtil.isEmptyOrWhiteSpace((String)filter.getYygxCodes())) {
                    List yygxCodes = Arrays.stream(filter.getYygxCodes().trim().split(",")).distinct().collect(Collectors.toList());
                    relWhereClause = relWhereClause + String.format(" AND r.%s IN [%s]", "yygx", String.join((CharSequence)",", ListUtil.convertAll(yygxCodes, c -> "'" + c + "'")));
                }
                if (!StringUtil.isEmptyOrWhiteSpace((String)filter.getYwlxCodes())) {
                    List ywlxCodes = Arrays.stream(filter.getYwlxCodes().trim().split(",")).distinct().collect(Collectors.toList());
                    relWhereClause = relWhereClause + String.format(" AND b.%s IN [%s]", "ywlx", String.join((CharSequence)",", ListUtil.convertAll(ywlxCodes, c -> "'" + c + "'")));
                }
                sql = String.format("MATCH (m:`%s`)-[r]-(b) where %s WITH DISTINCT m MATCH (n:`%s`) WHERE m.%s = n.%s AND %s", "\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53", relWhereClause, "\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53", "stma", "stma", whereClause);
            }
            PageList pageResult = new PageList();
            ArrayList<EntityDTO> entityList = new ArrayList<EntityDTO>();
            pageResult.setTotal(Long.valueOf(0L));
            pageResult.setList(entityList);
            try (Session session = driver.session();){
                String countSql = sql + " return count(n)";
                Result countResult = session.run(countSql);
                if (!countResult.hasNext()) {
                    PageList record = pageResult;
                    return record;
                }
                Record record = countResult.next();
                pageResult.setTotal(Long.valueOf(((Value)record.values().get(0)).asLong()));
                List allEntityClass = this.codeEntityClassService.list();
                String entitySql = sql + String.format(" return n SKIP %d LIMIT %d", filter.getRows() * filter.getPage(), filter.getRows());
                Result result = session.run(entitySql);
                while (result.hasNext()) {
                    Record record2 = result.next();
                    Node node = record2.get("n").asNode();
                    entityList.add(this.convert2EntityRecord(node, allEntityClass));
                }
            }
            PageList pageList = pageResult;
            return pageList;
        }
        catch (Exception e) {
            throw new RuntimeException("\u5b9e\u4f53\u67e5\u8be2\u5931\u8d25\uff01" + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PageList<EntityDTO> queryEntitys(EntitySpatialFilterDTO filter) {
        Assert.isTrue((!StringUtil.isEmptyOrWhiteSpace((String)filter.getDatasetIds()) ? 1 : 0) != 0, (String)"\u6570\u636e\u96c6\u4e3a\u7a7a");
        Assert.isTrue((!StringUtil.isEmptyOrWhiteSpace((String)filter.getGeometry()) ? 1 : 0) != 0, (String)"\u67e5\u8be2\u8303\u56f4\u4e3a\u7a7a");
        try (Driver driver = this.getNeo4jDriver();){
            List<String> datasetIds = Arrays.asList(filter.getDatasetIds().trim().split(","));
            List<String> dltbIds = this.queryDLTBIds(datasetIds, filter);
            if (dltbIds.size() == 0) {
                throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u5730\u7c7b\u56fe\u6591\u6570\u636e");
            }
            List allEntityClass = this.codeEntityClassService.list();
            String sql = String.format("Match (n:`%s`) where n.%s in [%s] and n.%s IS NOT NULL RETURN n", "\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53", "node_id", String.join((CharSequence)",", ListUtil.convertAll(dltbIds, c -> "'" + c + "'")), "stma");
            LinkedHashMap<String, Node> nodeMap = new LinkedHashMap<String, Node>();
            try (Session session = driver.session();){
                Result result = session.run(sql);
                while (result.hasNext()) {
                    Record record = result.next();
                    Node node2 = record.get("n").asNode();
                    String entityID = node2.get("stma").asString();
                    if (nodeMap.containsKey(entityID)) {
                        String code_type = node2.get("code_type").asString();
                        if (!"01".equals(code_type)) continue;
                        nodeMap.put(entityID, node2);
                        continue;
                    }
                    nodeMap.put(entityID, node2);
                }
            }
            ArrayList entityList = new ArrayList();
            nodeMap.values().forEach(node -> entityList.add(this.convert2EntityRecord((Node)node, allEntityClass)));
            var10_12 = new PageList(entityList, filter.getPage(), filter.getRows());
            return var10_12;
        }
        catch (Exception e) {
            throw new RuntimeException("\u5b9e\u4f53\u67e5\u8be2\u5931\u8d25\uff01" + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DltbThroughResultDTO queryDLTBThrough(String dltbID) {
        try (Driver driver = this.getNeo4jDriver();){
            DltbThroughResultDTO throughResultDTO;
            ArrayList<String> throughYears;
            LinkedHashMap<String, TbDTO> nodes;
            block41: {
                Result result2;
                Object startNode;
                Session session = driver.session();
                Result result = session.run(String.format("MATCH (n:`%s` {%s: '%s'}) return n", "\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53", "node_id", dltbID));
                if (!result.hasNext()) {
                    log.error(dltbID);
                    throw new RuntimeException("\u6570\u636e\u4e0d\u5b58\u5728");
                }
                ArrayList<DmDictValueDTO> allBizCodeDictValues = this.dictionaryService.getDictionaryValueList("ZRZY_YWFL");
                if (allBizCodeDictValues == null) {
                    allBizCodeDictValues = new ArrayList<DmDictValueDTO>();
                }
                DmDictValueDTO relationDictValue = this.dictionaryService.getDictionaryTree("ZRZY_YYGX");
                List allEntityClass = this.codeEntityClassService.list();
                List colorItems = this.colorItemService.queryBySchemeName("\u4e09\u8c03\u5730\u7c7b\u8272\u503c");
                HashMap<String, String> dlbmColorMap = new HashMap<String, String>();
                for (CmColorItem cmColorItem : colorItems) {
                    dlbmColorMap.put(cmColorItem.getCode(), cmColorItem.getColor());
                }
                nodes = new LinkedHashMap<String, TbDTO>();
                ArrayList<TbRelationDTO> edges = new ArrayList<TbRelationDTO>();
                ArrayList<TbDTO> entityDltbS = new ArrayList<TbDTO>();
                throughYears = new ArrayList<String>();
                Node currentNode = result.next().get("n").asNode();
                String entityID = currentNode.get("stma").asString();
                throughResultDTO = new DltbThroughResultDTO();
                throughResultDTO.setTbID(dltbID);
                throughResultDTO.setName(currentNode.get("node_name").asString());
                throughResultDTO.setEntityId(entityID);
                throughResultDTO.setYear(this.valueOf(currentNode.get("year")));
                throughResultDTO.setEdges(edges);
                String entitySql = String.format("MATCH (n:`%s` {node_id: '%s'})\nMATCH path = (n)-[:`%s`*]-(m:`%s`)\nWHERE all(node IN nodes(path) WHERE node.%s = n.%s)\nWITH DISTINCT relationships(path) AS rels UNWIND rels AS rel\nRETURN DISTINCT startNode(rel) AS StartNode, rel AS Relationship, endNode(rel) AS EndNode", "\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53", dltbID, "GUOTUDIAOCHA", "\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53", "stma", "stma");
                result = session.run(entitySql);
                if (!result.hasNext()) {
                    TbDTO tbDTO = this.convert2TbDTO(currentNode, allBizCodeDictValues, allEntityClass, dlbmColorMap);
                    entityDltbS.add(tbDTO);
                    throughYears.add(tbDTO.getYear());
                    nodes.put(String.valueOf(currentNode.id()), tbDTO);
                }
                while (result.hasNext()) {
                    TbDTO tbDTO;
                    Record record = result.next();
                    Node startNode2 = record.get("StartNode").asNode();
                    Node endNode = record.get("EndNode").asNode();
                    Relationship relationship = record.get("Relationship").asRelationship();
                    if (!nodes.containsKey(String.valueOf(startNode2.id()))) {
                        tbDTO = this.convert2TbDTO(startNode2, allBizCodeDictValues, allEntityClass, dlbmColorMap);
                        entityDltbS.add(tbDTO);
                        throughYears.add(tbDTO.getYear());
                        nodes.put(String.valueOf(startNode2.id()), tbDTO);
                    }
                    if (!nodes.containsKey(String.valueOf(endNode.id()))) {
                        tbDTO = this.convert2TbDTO(endNode, allBizCodeDictValues, allEntityClass, dlbmColorMap);
                        entityDltbS.add(tbDTO);
                        throughYears.add(tbDTO.getYear());
                        nodes.put(String.valueOf(endNode.id()), tbDTO);
                    }
                    TbRelationDTO relationDto = this.convert2RelationDTO(relationship, relationDictValue);
                    relationDto.setFrom(startNode2.get("node_id").asString());
                    relationDto.setTo(endNode.get("node_id").asString());
                    edges.add(relationDto);
                }
                ArrayList<String> diffCodeNodeIds = new ArrayList<String>();
                entityDltbS.sort((t1, t2) -> t1.getYear().compareTo(t2.getYear()));
                TbDTO firstTB = (TbDTO)entityDltbS.get(0);
                TbDTO lastTB = (TbDTO)entityDltbS.get(entityDltbS.size() - 1);
                String diffCodeSql = String.format("MATCH path = (n:`%s` {%s: '%s'})-[:`%s`]->(m:`%s`) return path", "\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53", "node_id", lastTB.getTbID(), "GUOTUDIAOCHA", "\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53");
                diffCodeSql = diffCodeSql + " union ";
                diffCodeSql = diffCodeSql + String.format("MATCH path = (m:`%s`)-[:`%s`]->(n:`%s`{%s: '%s'}) return path", "\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53", "GUOTUDIAOCHA", "\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53", "node_id", firstTB.getTbID());
                Result diffCodeResult = session.run(diffCodeSql);
                while (diffCodeResult.hasNext()) {
                    Record record = diffCodeResult.next();
                    Path path = record.get(0).asPath();
                    for (Node node : path.nodes()) {
                        if (nodes.containsKey(String.valueOf(node.id()))) continue;
                        TbDTO tbDTO = this.convert2TbDTO(node, allBizCodeDictValues, allEntityClass, dlbmColorMap);
                        throughYears.add(tbDTO.getYear());
                        diffCodeNodeIds.add(tbDTO.getTbID());
                        nodes.put(String.valueOf(node.id()), tbDTO);
                    }
                    for (Relationship relationship : path.relationships()) {
                        TbRelationDTO relationDto = this.convert2RelationDTO(relationship, relationDictValue);
                        relationDto.setFrom(((TbDTO)nodes.get(String.valueOf(relationship.startNodeId()))).getTbID());
                        relationDto.setTo(((TbDTO)nodes.get(String.valueOf(relationship.endNodeId()))).getTbID());
                        edges.add(relationDto);
                    }
                }
                String entityNodeIds = entityDltbS.stream().map(n -> "'" + n.getTbID() + "'").collect(Collectors.joining(","));
                String diffNodeIds = diffCodeNodeIds.stream().map(n -> "'" + n + "'").collect(Collectors.joining(","));
                String bizSql = String.format("MATCH p = (n:`%s`)-[r]-(m:`%s`)\nWHERE n.%s IN [%s] AND NONE(rel IN relationships(p) WHERE type(rel) = '%s') \nWITH DISTINCT relationships(p) AS rels UNWIND rels AS rel\nRETURN DISTINCT startNode(rel) AS StartNode, rel AS Relationship, endNode(rel) AS EndNode", "\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53", "\u81ea\u7136\u8d44\u6e90\u4e1a\u52a1", "node_id", entityNodeIds, "GUOTUDIAOCHA");
                bizSql = bizSql + " UNION ";
                bizSql = bizSql + String.format("MATCH p = (n:`%s`)-[r]-(m:`%s`)-[r2]-(n2:`%s`)\nWHERE n.%s IN [%s] AND n2.%s IN [%s] AND NONE(rel IN relationships(p) WHERE type(rel) = '%s') \nWITH DISTINCT relationships(p) AS rels UNWIND rels AS rel\nRETURN DISTINCT startNode(rel) AS StartNode, rel AS Relationship, endNode(rel) AS EndNode", "\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53", "\u81ea\u7136\u8d44\u6e90\u4e1a\u52a1", "\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53", "node_id", entityNodeIds, "node_id", diffNodeIds, "GUOTUDIAOCHA");
                result = session.run(bizSql);
                HashMap<String, TbDTO> bizTbDTOs = new HashMap<String, TbDTO>();
                ArrayList<TbRelationDTO> bizRels = new ArrayList<TbRelationDTO>();
                while (result.hasNext()) {
                    TbDTO tbDTO;
                    Record record = result.next();
                    startNode = record.get("StartNode").asNode();
                    Node node = record.get("EndNode").asNode();
                    Relationship relationship = record.get("Relationship").asRelationship();
                    if ("\u81ea\u7136\u8d44\u6e90\u4e1a\u52a1".equals(startNode.get("node_class").asString()) && !bizTbDTOs.containsKey(String.valueOf(startNode.id()))) {
                        tbDTO = this.convert2TbDTO((Node)startNode, allBizCodeDictValues, allEntityClass, dlbmColorMap);
                        bizTbDTOs.put(String.valueOf(startNode.id()), tbDTO);
                    }
                    if ("\u81ea\u7136\u8d44\u6e90\u4e1a\u52a1".equals(node.get("node_class").asString()) && !bizTbDTOs.containsKey(String.valueOf(node.id()))) {
                        tbDTO = this.convert2TbDTO(node, allBizCodeDictValues, allEntityClass, dlbmColorMap);
                        bizTbDTOs.put(String.valueOf(node.id()), tbDTO);
                    }
                    TbRelationDTO relationDto = this.convert2RelationDTO(relationship, relationDictValue);
                    relationDto.setFrom(startNode.get("node_id").asString());
                    relationDto.setTo(node.get("node_id").asString());
                    if (bizRels.contains(relationDto)) continue;
                    bizRels.add(relationDto);
                }
                Map<String, List<TbDTO>> tbGroups = bizTbDTOs.values().stream().collect(Collectors.groupingBy(tb -> {
                    ArrayList<String> upRelCodes = new ArrayList<String>();
                    ArrayList<String> downRelCodes = new ArrayList<String>();
                    for (TbRelationDTO rel : bizRels) {
                        if (rel.getTo().equals(tb.getTbID())) {
                            upRelCodes.add(rel.getRelationClass() + "-" + rel.getRelationCode());
                        }
                        if (!rel.getFrom().equals(tb.getTbID())) continue;
                        downRelCodes.add(rel.getRelationClass() + "-" + rel.getRelationCode());
                    }
                    upRelCodes.sort(String::compareTo);
                    downRelCodes.sort(String::compareTo);
                    return tb.getBizCode() + ":" + tb.getYear() + ":" + String.join((CharSequence)",", upRelCodes) + ";" + String.join((CharSequence)",", downRelCodes);
                }));
                startNode = tbGroups.values().iterator();
                while (true) {
                    double sumMj;
                    Object tb22222;
                    ArrayList<TbRelationDTO> downRels;
                    BizGroupDTO bizGroupDTO;
                    if (startNode.hasNext()) {
                        List list = (List)startNode.next();
                        bizGroupDTO = new BizGroupDTO();
                        bizGroupDTO.setTbID(UUID.randomUUID().toString());
                        bizGroupDTO.setBizTbs(list);
                        nodes.put(bizGroupDTO.getTbID(), bizGroupDTO);
                        bizGroupDTO.setName(((TbDTO)list.get(0)).getBizName());
                        bizGroupDTO.setYear(((TbDTO)list.get(0)).getYear());
                        bizGroupDTO.setBizCode(((TbDTO)list.get(0)).getBizCode());
                        bizGroupDTO.setBizName(((TbDTO)list.get(0)).getBizName());
                        bizGroupDTO.setBizGroupCode(((TbDTO)list.get(0)).getBizGroupCode());
                        bizGroupDTO.setBizGroupName(((TbDTO)list.get(0)).getBizGroupName());
                        ArrayList<TbRelationDTO> upRels = new ArrayList<TbRelationDTO>();
                        downRels = new ArrayList<TbRelationDTO>();
                        for (TbRelationDTO rel : bizRels) {
                            for (Object tb22222 : list) {
                                if (rel.getTo().equals(((TbDTO)tb22222).getTbID())) {
                                    upRels.add(rel);
                                }
                                if (!rel.getFrom().equals(((TbDTO)tb22222).getTbID())) continue;
                                downRels.add(rel);
                            }
                        }
                        Map<String, List<TbRelationDTO>> upRelGroups = upRels.stream().collect(Collectors.groupingBy(r -> r.getFrom() + ":" + r.getRelationClass() + ":" + r.getRelationCode()));
                        sumMj = 0.0;
                        tb22222 = upRelGroups.values().iterator();
                    } else {
                        if (entityDltbS.size() > 1) {
                            String otherSql = String.format("MATCH path = (n:`%s`)-[:`%s`]-(m:`%s`) where n.%s IN [%s] AND m.%s<>'%s' return path", "\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53", "GUOTUDIAOCHA", "\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53", "node_id", entityNodeIds, "stma", entityID);
                            result2 = session.run(otherSql);
                            break;
                        }
                        break block41;
                    }
                    while (tb22222.hasNext()) {
                        List rels = (List)tb22222.next();
                        TbRelationDTO relationDto = new TbRelationDTO();
                        relationDto.setFrom(((TbRelationDTO)rels.get(0)).getFrom());
                        relationDto.setTo(bizGroupDTO.getTbID());
                        relationDto.setRelationCode(((TbRelationDTO)rels.get(0)).getRelationCode());
                        relationDto.setRelationName(((TbRelationDTO)rels.get(0)).getRelationName());
                        relationDto.setRelationClass(((TbRelationDTO)rels.get(0)).getRelationClass());
                        relationDto.setRelationClassName(((TbRelationDTO)rels.get(0)).getRelationClassName());
                        double mj = 0.0;
                        for (TbRelationDTO rel : rels) {
                            mj += rel.getMj().doubleValue();
                        }
                        relationDto.setMj(mj);
                        sumMj += mj;
                        edges.add(relationDto);
                    }
                    Map<String, List<TbRelationDTO>> downRelGroups = downRels.stream().collect(Collectors.groupingBy(r -> r.getTo() + ":" + r.getRelationClass() + ":" + r.getRelationCode()));
                    for (List<TbRelationDTO> rels : downRelGroups.values()) {
                        TbRelationDTO relationDto = new TbRelationDTO();
                        relationDto.setFrom(bizGroupDTO.getTbID());
                        relationDto.setTo(rels.get(0).getTo());
                        relationDto.setRelationCode(rels.get(0).getRelationCode());
                        relationDto.setRelationName(rels.get(0).getRelationName());
                        relationDto.setRelationClass(rels.get(0).getRelationClass());
                        relationDto.setRelationClassName(rels.get(0).getRelationClassName());
                        double mj = 0.0;
                        for (TbRelationDTO rel : rels) {
                            mj += rel.getMj().doubleValue();
                        }
                        relationDto.setMj(mj);
                        sumMj += mj;
                        edges.add(relationDto);
                    }
                    bizGroupDTO.setTbmj(sumMj);
                }
                while (result2.hasNext()) {
                    Record record = result2.next();
                    Path path = record.get(0).asPath();
                    for (Node node : path.nodes()) {
                        if (nodes.containsKey(String.valueOf(node.id()))) continue;
                        TbDTO tbDTO = this.convert2TbDTO(node, allBizCodeDictValues, allEntityClass, dlbmColorMap);
                        nodes.put(String.valueOf(node.id()), tbDTO);
                    }
                    for (Relationship relationship : path.relationships()) {
                        TbRelationDTO relationDto = this.convert2RelationDTO(relationship, relationDictValue);
                        relationDto.setFrom(((TbDTO)nodes.get(String.valueOf(relationship.startNodeId()))).getTbID());
                        relationDto.setTo(((TbDTO)nodes.get(String.valueOf(relationship.endNodeId()))).getTbID());
                        if (edges.contains(relationDto)) continue;
                        edges.add(relationDto);
                    }
                }
            }
            throughYears = throughYears.stream().distinct().sorted(String::compareTo).collect(Collectors.toList());
            throughResultDTO.setNodes(new ArrayList<TbDTO>(nodes.values()));
            throughResultDTO.setThroughYears(throughYears);
            DltbThroughResultDTO dltbThroughResultDTO = throughResultDTO;
            return dltbThroughResultDTO;
        }
        catch (Exception e) {
            log.error(dltbID);
            throw new RuntimeException("\u67e5\u8be2\u5931\u8d25\uff0c" + e.getMessage(), e);
        }
    }

    public DataQueryResult queryDLTBAttribute(String tbID, Boolean returnGeometry) {
        FeatureResult featureResult;
        String wkt;
        DataQueryResult result;
        int idx = tbID.lastIndexOf("-");
        if (idx < 0) {
            throw new RuntimeException("\u56fe\u6591id\u4e0d\u6b63\u786e:" + tbID);
        }
        String datasetId = tbID.substring(0, idx);
        String oid = tbID.substring(idx + 1);
        DatasetDTO datasetDTO = this.dataSourceService.getDatasetDetail(datasetId);
        SpatialRefDTO spatialRefDTO = null;
        if (datasetDTO instanceof FeatureClassDTO) {
            spatialRefDTO = ((FeatureClassDTO)datasetDTO).getSpatialRef();
        }
        if ((result = this.geoDatabaseService.queryByObjectId(datasetId, (Object)oid, null, returnGeometry)).getData().size() > 0 && Boolean.TRUE.equals(returnGeometry) && (wkt = (featureResult = (FeatureResult)result.getData().get(0)).getGeometry()) != null && spatialRefDTO != null && spatialRefDTO.getSrid() != 4490) {
            IGeometry geometry = GeometryFunc.createGeometry((String)wkt);
            ISpatialReferenceSystem srs = SpatialReferenceSystemFunc.createSpatialReference((String)spatialRefDTO.getWkt());
            ISpatialReferenceSystem targetSrs = SpatialReferenceSystemFunc.createSpatialReference((int)4490);
            geometry.project(srs, targetSrs);
            featureResult.setGeometry(geometry.toWkt());
        }
        this.removeQueryReturnFields(result);
        return result;
    }

    public List<RelateFileDTO> queryTBAttachments(String tbID) {
        try (Driver driver = this.getNeo4jDriver();){
            String xmmc;
            Session session = driver.session();
            Result result = session.run(String.format("MATCH (n) where (n:`%s` OR n:`%s`) AND n.%s='%s' return n", "\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53", "\u81ea\u7136\u8d44\u6e90\u4e1a\u52a1", "node_id", tbID));
            if (!result.hasNext()) {
                log.error(tbID);
                throw new RuntimeException("\u6570\u636e\u4e0d\u5b58\u5728");
            }
            Record record = result.next();
            Node node = record.get("n").asNode();
            String ywfl = node.get("ywlx").asString();
            String string = xmmc = node.get("xmmc").isNull() ? null : node.get("xmmc").asString();
            if (StringUtil.isEmptyOrWhiteSpace((String)xmmc)) {
                throw new RuntimeException("\u9879\u76ee\u540d\u79f0\u4e3a\u7a7a");
            }
            SysParamDTO sysParamDTO = this.sysParamsService.getDetail("YMQXFJ", ywfl);
            if (sysParamDTO == null) {
                throw new RuntimeException(ywfl + "\u672a\u914d\u7f6e\u9644\u4ef6\u8def\u5f84");
            }
            List<RelateFileDTO> list = this.relatedResultsService.queryAttachmentFiles(sysParamDTO.getValue(), xmmc);
            return list;
        }
    }

    public void previewTBAttachment(String tbID, String fileName, HttpServletRequest request, HttpServletResponse response) {
        try (Driver driver = this.getNeo4jDriver();){
            Session session = driver.session();
            Result result = session.run(String.format("MATCH (n) where (n:`%s` OR n:`%s`) AND n.%s='%s' return n", "\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53", "\u81ea\u7136\u8d44\u6e90\u4e1a\u52a1", "node_id", tbID));
            if (!result.hasNext()) {
                log.error(tbID);
                throw new RuntimeException("\u6570\u636e\u4e0d\u5b58\u5728");
            }
            File file = new File(fileName);
            if (!file.exists()) {
                throw new RuntimeException("\u9644\u4ef6\u4e0d\u5b58\u5728");
            }
            FileViewerUtil.viewFile((File)file, (HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    public List<DataQueryResult> queryDLTBSpecialData(String dltbID) {
        DataQueryResult result;
        String pid;
        String classCode;
        int idx = dltbID.lastIndexOf("-");
        if (idx < 0) {
            throw new RuntimeException("\u56fe\u6591id\u4e0d\u6b63\u786e:" + dltbID);
        }
        String datasetId = dltbID.substring(0, idx);
        String oid = dltbID.substring(idx + 1);
        try (Driver driver = this.getNeo4jDriver();){
            Session session = driver.session();
            Result result2 = session.run(String.format("MATCH (n:`%s` {%s: '%s'}) return n", "\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53", "node_id", dltbID));
            if (!result2.hasNext()) {
                log.error(dltbID);
                throw new RuntimeException("\u6570\u636e\u4e0d\u5b58\u5728");
            }
            Node currentNode = result2.next().get("n").asNode();
            classCode = currentNode.get("stfl").asString();
            Assert.notNull((Object)classCode, (String)"\u5b9e\u4f53\u5206\u7c7b\u4ee3\u7801\u4e3a\u7a7a");
        }
        List entityClassList = this.codeEntityClassService.list();
        CodeEntityClass codeEntityClass = (CodeEntityClass)ListUtil.find((List)entityClassList, c -> c.getCode().equals(classCode));
        Assert.notNull((Object)codeEntityClass, (String)"\u672a\u627e\u5230\u5b9e\u4f53\u5206\u7c7b\u4ee3\u7801\u914d\u7f6e");
        List specialDatasets = codeEntityClass.getSpecialDatasets();
        while (!(specialDatasets != null && specialDatasets.size() != 0 || StringUtil.isEmpty((String)codeEntityClass.getPid()) || (codeEntityClass = (CodeEntityClass)ListUtil.find((List)entityClassList, arg_0 -> OneCodeQueryService.lambda$queryDLTBSpecialData$12(pid = codeEntityClass.getPid(), arg_0))) == null)) {
            specialDatasets = codeEntityClass.getSpecialDatasets();
        }
        if (specialDatasets == null || specialDatasets.size() == 0) {
            throw new RuntimeException(classCode + "\u5b9e\u4f53\u5206\u7c7b\u672a\u914d\u7f6e\u4e13\u9879\u6570\u636e");
        }
        DatasetDTO datasetDTO = this.dataSourceService.getDatasetDetail(datasetId);
        Integer srid = null;
        if (datasetDTO instanceof FeatureClassDTO) {
            SpatialRefDTO spatialRefDTO = ((FeatureClassDTO)datasetDTO).getSpatialRef();
            Integer n = srid = spatialRefDTO == null ? null : spatialRefDTO.getSrid();
        }
        if ((result = this.geoDatabaseService.queryByObjectId(datasetId, (Object)oid, null, Boolean.valueOf(true))).getData().size() > 0) {
            FeatureResult featureResult = (FeatureResult)result.getData().get(0);
            String wkt = featureResult.getGeometry();
            QueryFilterDTO queryFilterDTO = new QueryFilterDTO();
            queryFilterDTO.setReturnGeometry(Boolean.valueOf(false));
            queryFilterDTO.setReturnCount(Boolean.valueOf(false));
            queryFilterDTO.setRelation(SpatialRelationType.Overlaps);
            queryFilterDTO.setGeometry(wkt);
            queryFilterDTO.setGeometrySrid(srid);
            ArrayList<DataQueryResult> specialResults = new ArrayList<DataQueryResult>();
            for (EntityClassSpecialDataDTO specialDataDTO : specialDatasets) {
                try {
                    DataQueryResult queryResult = this.geoDatabaseService.queryGeoDataset(specialDataDTO.getDatasetId(), queryFilterDTO);
                    this.removeQueryReturnFields(queryResult);
                    for (FeatureResult data : queryResult.getData()) {
                        DataQueryResult oneResult = new DataQueryResult();
                        oneResult.setId(queryResult.getId());
                        oneResult.setName(queryResult.getName());
                        oneResult.setFields(queryResult.getFields());
                        oneResult.setAliasName(queryResult.getAliasName());
                        oneResult.setData(Collections.singletonList(data));
                        specialResults.add(oneResult);
                    }
                }
                catch (Exception e) {
                    log.error(specialDataDTO.getName() + "\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
                }
            }
            return specialResults;
        }
        throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u5730\u7c7b\u56fe\u6591\u6570\u636e");
    }

    public DataQueryResult queryWYHCData(String dltbID) {
        int idx = dltbID.lastIndexOf("-");
        if (idx < 0) {
            throw new RuntimeException("\u56fe\u6591id\u4e0d\u6b63\u786e:" + dltbID);
        }
        String datasetId = dltbID.substring(0, idx);
        String oid = dltbID.substring(idx + 1);
        String ywfl = null;
        try (Driver driver = this.getNeo4jDriver();){
            Session session = driver.session();
            Result result = session.run(String.format("MATCH (n) where (n:`%s` OR n:`%s`) AND n.%s='%s' return n", "\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53", "\u81ea\u7136\u8d44\u6e90\u4e1a\u52a1", "node_id", dltbID));
            if (!result.hasNext()) {
                log.error(dltbID);
                throw new RuntimeException("\u6570\u636e\u4e0d\u5b58\u5728");
            }
            Record record = result.next();
            Node node = record.get("n").asNode();
            ywfl = node.get("ywlx").asString();
        }
        SysParamDTO sysParamDTO = this.sysParamsService.getDetail("YMQXWY", ywfl);
        if (sysParamDTO == null || StringUtil.isEmptyOrWhiteSpace((String)sysParamDTO.getValue())) {
            throw new RuntimeException("\u672a\u914d\u7f6e\u5916\u4e1a\u4fe1\u606f\u8868");
        }
        String tableName = sysParamDTO.getValue();
        DataQueryResult result = this.geoDatabaseService.queryByObjectId(datasetId, (Object)oid, null, Boolean.valueOf(false));
        if (result.getData().size() == 0) {
            log.error(dltbID);
            throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u56fe\u6591\u6570\u636e");
        }
        String bsm = null;
        Map attMap = ((FeatureResult)result.getData().get(0)).getAttributes();
        for (String fldName : attMap.keySet()) {
            if (!"bsm".equalsIgnoreCase(fldName)) continue;
            bsm = attMap.get(fldName) == null ? null : attMap.get(fldName).toString();
            break;
        }
        if (StringUtil.isEmptyOrWhiteSpace(bsm)) {
            throw new RuntimeException("\u5730\u5757\u6807\u8bc6\u7801\u4e3a\u7a7a");
        }
        if (result.getData().size() > 0) {
            QueryFilterDTO queryFilterDTO = new QueryFilterDTO();
            queryFilterDTO.setReturnGeometry(Boolean.valueOf(false));
            queryFilterDTO.setReturnCount(Boolean.valueOf(false));
            queryFilterDTO.setCondition(String.format("dkbsm='%s'", bsm));
            DatasetNameInfo datasetNameInfo = new DatasetNameInfo(dltbID);
            DataQueryResult queryResult = this.geoDatabaseService.queryGeoDataset(datasetNameInfo.getDsKey(), tableName, queryFilterDTO);
            this.removeQueryReturnFields(queryResult);
            for (ReturnField returnField : queryResult.getFields()) {
                if (!returnField.getName().equalsIgnoreCase("KZXX")) continue;
                queryResult.getFields().remove(returnField);
                break;
            }
            return queryResult;
        }
        throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u5916\u4e1a\u6838\u67e5\u6570\u636e");
    }

    public List<RelateFileDTO> queryJuZhengPictures(String tbID) {
        int idx = tbID.lastIndexOf("-");
        if (idx < 0) {
            throw new RuntimeException("\u56fe\u6591id\u4e0d\u6b63\u786e:" + tbID);
        }
        String datasetId = tbID.substring(0, idx);
        String oid = tbID.substring(idx + 1);
        String ywfl = null;
        try (Driver driver = this.getNeo4jDriver();){
            Session session = driver.session();
            Result result = session.run(String.format("MATCH (n) where (n:`%s` OR n:`%s`) AND n.%s='%s' return n", "\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53", "\u81ea\u7136\u8d44\u6e90\u4e1a\u52a1", "node_id", tbID));
            if (!result.hasNext()) {
                log.error(tbID);
                throw new RuntimeException("\u6570\u636e\u4e0d\u5b58\u5728");
            }
            Record record = result.next();
            Node node = record.get("n").asNode();
            ywfl = node.get("ywlx").asString();
        }
        DataQueryResult dataQueryResult = this.geoDatabaseService.queryByObjectId(datasetId, (Object)oid, null, Boolean.valueOf(false));
        if (dataQueryResult.getData().size() == 0) {
            log.error(tbID);
            throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u56fe\u6591\u6570\u636e");
        }
        String dkbh = null;
        Map attMap = ((FeatureResult)dataQueryResult.getData().get(0)).getAttributes();
        for (String fldName : attMap.keySet()) {
            if (!"dkbh".equalsIgnoreCase(fldName)) continue;
            dkbh = attMap.get(fldName) == null ? null : attMap.get(fldName).toString();
            break;
        }
        if (StringUtil.isEmptyOrWhiteSpace(dkbh)) {
            throw new RuntimeException("\u5730\u5757\u7f16\u53f7\u4e3a\u7a7a");
        }
        SysParamDTO sysParamDTO = this.sysParamsService.getDetail("YMQXJZZP", ywfl);
        if (sysParamDTO == null) {
            throw new RuntimeException(ywfl + "\u672a\u914d\u7f6e\u9644\u4ef6\u8def\u5f84");
        }
        File folder = new File(sysParamDTO.getValue(), dkbh);
        if (!folder.exists()) {
            throw new RuntimeException("\u5730\u5757\u7f16\u53f7" + dkbh + "\u7167\u7247\u4e0d\u5b58\u5728");
        }
        ArrayList<RelateFileDTO> fileDTOS = new ArrayList<RelateFileDTO>();
        File[] files = folder.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                if (!file.isFile() || !file.getName().toLowerCase().endsWith(".jpg") && !file.getName().toLowerCase().endsWith(".png")) continue;
                fileDTOS.add(new RelateFileDTO(file.getAbsolutePath(), file.getName(), false, new Date(file.lastModified())));
            }
        }
        return fileDTOS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TbDTO queryEntityByBSM(String bsm) {
        ArrayList<DmDictValueDTO> allBizCodeDictValues = this.dictionaryService.getDictionaryValueList("ZRZY_YWFL");
        if (allBizCodeDictValues == null) {
            allBizCodeDictValues = new ArrayList<DmDictValueDTO>();
        }
        List allEntityClass = this.codeEntityClassService.list();
        List colorItems = this.colorItemService.queryBySchemeName("\u4e09\u8c03\u5730\u7c7b\u8272\u503c");
        HashMap<String, String> dlbmColorMap = new HashMap<String, String>();
        for (CmColorItem cmColorItem : colorItems) {
            dlbmColorMap.put(cmColorItem.getCode(), cmColorItem.getColor());
        }
        try (Driver driver = this.getNeo4jDriver();){
            TbDTO tbDTO;
            String entitySql = String.format("MATCH (n:`%s` {%s: '%s'}) RETURN n ORDER BY n.%s DESC limit 1", "\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53", "bsm", bsm, "year");
            Session session = driver.session();
            Result result = session.run(entitySql);
            if (!result.hasNext()) {
                log.error(bsm);
                throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u5b9e\u4f53\u6570\u636e");
            }
            Node currentNode = result.next().get("n").asNode();
            TbDTO tbDTO2 = tbDTO = this.convert2TbDTO(currentNode, allBizCodeDictValues, allEntityClass, dlbmColorMap);
            return tbDTO2;
        }
        catch (Exception e) {
            throw new RuntimeException("\u5b9e\u4f53\u67e5\u8be2\u5931\u8d25\uff01" + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PageList<EntityDTO> queryEntitysByCondition(EntityConditionFilterDTO filter) {
        List<EntityConditionFilterDTO.EntityQueryCondition> conditions = filter.getConditions();
        if (conditions == null) throw new RuntimeException("\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        if (conditions.size() == 0) {
            throw new RuntimeException("\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try (Driver driver = this.getNeo4jDriver();){
            String firstYear = conditions.get(0).getYear();
            int firstIndex = 0;
            conditions.sort((c1, c2) -> {
                if (StringUtil.isEmptyOrWhiteSpace((String)c1.getYear()) || StringUtil.isEmptyOrWhiteSpace((String)c2.getYear())) {
                    throw new RuntimeException("\u6570\u636e\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
                }
                return c1.getYear().compareTo(c2.getYear());
            });
            ArrayList<String> whereList = new ArrayList<String>();
            int index = 0;
            for (EntityConditionFilterDTO.EntityQueryCondition condition : conditions) {
                if (condition.getYear().equals(firstYear)) {
                    firstIndex = index;
                }
                String where = String.format("n%d.year='%s'", index, condition.getYear());
                if (!(StringUtil.isEmptyOrWhiteSpace((String)condition.getField()) || StringUtil.isEmptyOrWhiteSpace((String)condition.getOperator()) || StringUtil.isEmptyOrWhiteSpace((String)condition.getValue()))) {
                    String field = condition.getField();
                    if (field.equalsIgnoreCase("dlmc")) {
                        field = "node_name";
                    }
                    String value = condition.getValue();
                    if (!field.equalsIgnoreCase("tbmj")) {
                        value = "'" + value + "'";
                    }
                    switch (condition.getOperator()) {
                        case "\u5305\u542b": {
                            where = where + String.format(" AND n%d.%s CONTAINS %s", index, field, value);
                            break;
                        }
                        case "\u7b49\u4e8e": {
                            where = where + String.format(" AND n%d.%s = %s", index, field, value);
                            break;
                        }
                        case "\u4e0d\u7b49\u4e8e": {
                            where = where + String.format(" AND n%d.%s <> %s", index, field, value);
                            break;
                        }
                        case "\u5927\u4e8e": {
                            where = where + String.format(" AND n%d.%s > %s", index, field, value);
                            break;
                        }
                        case "\u5927\u4e8e\u7b49\u4e8e": {
                            where = where + String.format(" AND n%d.%s >= %s", index, field, value);
                            break;
                        }
                        case "\u5c0f\u4e8e": {
                            where = where + String.format(" AND n%d.%s < %s", index, field, value);
                            break;
                        }
                        case "\u5c0f\u4e8e\u7b49\u4e8e": {
                            where = where + String.format(" AND n%d.%s <= %s", index, field, value);
                            break;
                        }
                        default: {
                            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u8fd0\u7b97\u7b26");
                        }
                    }
                }
                whereList.add(where);
                ++index;
            }
            String sql = String.format("MATCH (n%d:`%s`) WHERE %s", firstIndex, "\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53", whereList.get(firstIndex));
            if (conditions.size() > 1) {
                String relationSql = "MATCH ";
                for (int i = 0; i < whereList.size(); ++i) {
                    String node = i == firstIndex ? String.format("n%d", i) : String.format("n%d:`%s`", i, "\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53");
                    relationSql = i == 0 ? relationSql + String.format("(%s)", node) : relationSql + String.format("-[:GUOTUDIAOCHA*1..20]->(%s)", node);
                }
                whereList.remove(firstIndex);
                sql = sql + String.format(" AND EXISTS {%s WHERE %s} ", relationSql, String.join((CharSequence)" AND ", whereList));
            }
            PageList pageResult = new PageList();
            ArrayList<EntityDTO> entityList = new ArrayList<EntityDTO>();
            pageResult.setTotal(Long.valueOf(0L));
            pageResult.setList(entityList);
            try (Session session = driver.session();){
                String countSql = sql + String.format(" return count(n%d)", firstIndex);
                Result countResult = session.run(countSql);
                if (!countResult.hasNext()) {
                    PageList record = pageResult;
                    return record;
                }
                Record record = countResult.next();
                pageResult.setTotal(Long.valueOf(((Value)record.values().get(0)).asLong()));
                List allEntityClass = this.codeEntityClassService.list();
                String entitySql = sql + String.format(" return n%d SKIP %d LIMIT %d", firstIndex, filter.getRows() * filter.getPage(), filter.getRows());
                Result result = session.run(entitySql);
                while (result.hasNext()) {
                    Record record2 = result.next();
                    Node node = record2.get("n" + firstIndex).asNode();
                    entityList.add(this.convert2EntityRecord(node, allEntityClass));
                }
            }
            PageList pageList = pageResult;
            return pageList;
        }
        catch (Exception e) {
            throw new RuntimeException("\u5b9e\u4f53\u67e5\u8be2\u5931\u8d25\uff01" + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> queryDLTBIds(List<String> datasetIds, EntitySpatialFilterDTO filter) {
        List allCodeRecords = this.codeRecordService.getAll();
        ArrayList<String> dltbDatasetIds = new ArrayList<String>();
        for (String id : datasetIds) {
            if (!ListUtil.exist((List)allCodeRecords, r -> r.getDatasetId().equals(id))) continue;
            dltbDatasetIds.add(id);
        }
        if (dltbDatasetIds.size() == 0) {
            throw new RuntimeException("\u6570\u636e\u96c6\u672a\u8d4b\u7801");
        }
        ArrayList<String> dltbIDs = new ArrayList<String>();
        SpatialQueryFilter queryFilter = new SpatialQueryFilter();
        queryFilter.setGeometry(GeometryFunc.createGeometry((String)filter.getGeometry()));
        for (String datasetId : dltbDatasetIds) {
            DatasetNameInfo datasetNameInfo = new DatasetNameInfo(datasetId);
            IFeatureWorkspace workspace = this.geoDatabaseService.openGeoWorkspace(datasetNameInfo.getDsKey());
            IFeatureCursor cursor = null;
            try {
                IFeatureClass featureClass = workspace.openFeatureClass(datasetNameInfo.getName());
                if (featureClass == null) {
                    log.error(datasetNameInfo.getName() + "\u6253\u5f00\u5931\u8d25");
                    continue;
                }
                queryFilter.setSubFields(featureClass.getOidFieldName());
                cursor = featureClass.searchFeature((IQueryFilter)queryFilter);
                IFeature feature = cursor.nextFeature();
                while (feature != null) {
                    dltbIDs.add(datasetId + "-" + feature.getObjectId());
                    feature = cursor.nextFeature();
                }
            }
            catch (Exception e) {
                log.error(datasetNameInfo.getName() + "\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            }
            finally {
                if (cursor != null) {
                    cursor.release();
                }
                if (workspace == null) continue;
                workspace.close();
            }
        }
        return dltbIDs;
    }

    private EntityDTO convert2EntityRecord(Node node, List<CodeEntityClass> allEntityClass) {
        EntityDTO entityDTO = new EntityDTO();
        entityDTO.setEntityID(this.valueOf(node.get("stma")));
        entityDTO.setEntityName(this.valueOf(node.get("node_name")));
        entityDTO.setOriginalDltbID(this.valueOf(node.get("node_id")));
        String classID = this.valueOf(node.get("stfl"));
        entityDTO.setClassID(classID);
        CodeEntityClass codeEntityClass = (CodeEntityClass)ListUtil.find(allEntityClass, c -> StringUtil.equals((String)classID, (String)c.getCode()));
        if (codeEntityClass != null) {
            entityDTO.setClassName(codeEntityClass.getName());
            CodeEntityClass pEntityClass = (CodeEntityClass)ListUtil.find(allEntityClass, c -> StringUtil.equals((String)c.getId(), (String)codeEntityClass.getPid()));
            if (pEntityClass != null) {
                entityDTO.setParentClassName(pEntityClass.getName());
            }
        } else {
            entityDTO.setClassName(classID);
        }
        return entityDTO;
    }

    private TbDTO convert2TbDTO(Node node, List<DmDictValueDTO> allBizCodeDictValues, List<CodeEntityClass> allEntityClass, Map<String, String> dlbmColorMap) {
        DmDictValueDTO codeValue;
        TbDTO tbDTO;
        String classID;
        String node_class = this.valueOf(node.get("node_class"));
        if ("\u81ea\u7136\u8d44\u6e90\u5b9e\u4f53".equals(node_class)) {
            DltbDTO dltbDTO = new DltbDTO();
            dltbDTO.setName(this.valueOf(node.get("node_name")));
            dltbDTO.setTbType(TbTypeEnum.DLTB);
            dltbDTO.setEntityID(this.valueOf(node.get("stma")));
            dltbDTO.setBsm(this.valueOf(node.get("bsm")));
            dltbDTO.setDlbm(this.valueOf(node.get("dlbm")));
            dltbDTO.setXzqdm(this.valueOf(node.get("xzqdm")));
            classID = this.valueOf(node.get("stfl"));
            dltbDTO.setEntityClassID(classID);
            CodeEntityClass codeEntityClass = (CodeEntityClass)ListUtil.find(allEntityClass, c -> StringUtil.equals((String)classID, (String)c.getCode()));
            if (codeEntityClass != null) {
                dltbDTO.setEntityClassName(codeEntityClass.getName());
            } else {
                dltbDTO.setEntityClassName(classID);
            }
            if (dlbmColorMap.containsKey(dltbDTO.getDlbm())) {
                dltbDTO.setColor(dlbmColorMap.get(dltbDTO.getDlbm()));
            }
            dltbDTO.setEntityStatusColor(null);
            tbDTO = dltbDTO;
        } else {
            tbDTO = new TbDTO();
            tbDTO.setTbType(TbTypeEnum.BizTB);
            tbDTO.setTbly(this.valueOf(node.get("tbly")));
        }
        tbDTO.setTbID(this.valueOf(node.get("node_id")));
        tbDTO.setYear(this.valueOf(node.get("year")));
        tbDTO.setBizCode(this.valueOf(node.get("ywlx")));
        tbDTO.setBizName(tbDTO.getBizCode());
        tbDTO.setTbbh(this.valueOf(node.get("tbbh")));
        tbDTO.setTbmj(this.valueOfDouble(node.get("tbmj")));
        int idx = tbDTO.getTbID().lastIndexOf("-");
        if (idx > 0) {
            try {
                String datasetId = tbDTO.getTbID().substring(0, idx);
                DatasetNameInfo nameInfo = new DatasetNameInfo(datasetId);
                tbDTO.setTbTableName(nameInfo.getShortName());
            }
            catch (Exception e) {
                log.error(tbDTO.getTbID(), (Throwable)e);
            }
        }
        if ((codeValue = (DmDictValueDTO)ListUtil.find(allBizCodeDictValues, arg_0 -> OneCodeQueryService.lambda$convert2TbDTO$18(classID = tbDTO.getBizCode(), arg_0))) != null) {
            tbDTO.setBizName(codeValue.getName());
            DmDictValueDTO groupCodeValue = (DmDictValueDTO)ListUtil.find(allBizCodeDictValues, c -> c.getId().equals(codeValue.getFatherId()));
            if (groupCodeValue != null) {
                tbDTO.setBizGroupCode(groupCodeValue.getCode());
                tbDTO.setBizGroupName(groupCodeValue.getName());
                Long pid = groupCodeValue.getFatherId();
                groupCodeValue = (DmDictValueDTO)ListUtil.find(allBizCodeDictValues, c -> c.getId().equals(pid));
                if (groupCodeValue != null) {
                    tbDTO.setBizGroupCode(groupCodeValue.getCode());
                    tbDTO.setBizGroupName(groupCodeValue.getName());
                }
            }
        }
        if (tbDTO.getName() == null) {
            tbDTO.setName(tbDTO.getBizName());
        }
        return tbDTO;
    }

    private TbRelationDTO convert2RelationDTO(Relationship relationship, DmDictValueDTO relationDictValue) {
        Map edgeValues = relationship.asMap();
        TbRelationDTO relationDto = new TbRelationDTO();
        relationDto.setMj(this.valueOfDouble(edgeValues.get("mj")));
        if (edgeValues.get("yygx") != null) {
            relationDto.setRelationCode(edgeValues.get("yygx").toString());
            relationDto.setRelationName(relationDto.getRelationCode());
        } else {
            relationDto.setRelationName(this.valueOf(edgeValues.get("edge_name")));
        }
        if (edgeValues.get("edge_class") != null) {
            relationDto.setRelationClass(edgeValues.get("edge_class").toString());
            relationDto.setRelationClassName(relationDto.getRelationClass());
        }
        if (relationDictValue != null) {
            String groupClassID = relationDto.getRelationClass();
            DmDictValueDTO groupCodeValue = (DmDictValueDTO)ListUtil.find((List)relationDictValue.getChildren(), c -> StringUtil.equals((String)groupClassID, (String)c.getCode()));
            if (groupCodeValue != null) {
                relationDto.setRelationClassName(groupCodeValue.getName());
                String classID = relationDto.getRelationCode();
                DmDictValueDTO codeValue = (DmDictValueDTO)ListUtil.find((List)groupCodeValue.getChildren(), c -> StringUtil.equals((String)classID, (String)c.getCode()));
                if (codeValue != null) {
                    relationDto.setRelationName(codeValue.getName());
                }
            }
        }
        return relationDto;
    }

    private String valueOf(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Value) {
            if (((Value)value).isNull()) {
                return null;
            }
            if (value instanceof StringValue) {
                return ((StringValue)value).asString();
            }
            if (value instanceof FloatValue) {
                return String.valueOf(((FloatValue)value).asDouble());
            }
            if (value instanceof IntegerValue) {
                return String.valueOf(((IntegerValue)value).asInt());
            }
        }
        return value.toString();
    }

    private double valueOfDouble(Object value) {
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        try {
            if (value instanceof Value) {
                if (((Value)value).isNull()) {
                    return 0.0;
                }
                if (value instanceof StringValue) {
                    return Double.parseDouble(((StringValue)value).asString());
                }
                if (value instanceof FloatValue) {
                    return ((FloatValue)value).asDouble();
                }
                if (value instanceof IntegerValue) {
                    return ((IntegerValue)value).asInt();
                }
            }
            return Double.parseDouble(value.toString());
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    private Driver getNeo4jDriver() {
        DataSourceDTO dataSourceDTO = this.dataSourceManager.getDefaultDataSource(Integer.valueOf(DataStoreTypeEnum.GraphDatabase.getValue()), Integer.valueOf(DataSourceTypeEnum.Neo4j.getValue()));
        Assert.notNull((Object)dataSourceDTO, (String)"\u672a\u914d\u7f6e\u9ed8\u8ba4\u56fe\u5e93");
        return GraphDatabase.driver((String)dataSourceDTO.getUrl(), (AuthToken)AuthTokens.basic((String)dataSourceDTO.getUserName(), (String)dataSourceDTO.getPassword()));
    }

    private void removeQueryReturnFields(DataQueryResult queryResult) {
        if (queryResult == null || queryResult.getFields() == null) {
            return;
        }
        for (int i = 0; i < queryResult.getFields().size(); ++i) {
            ReturnField returnField = (ReturnField)queryResult.getFields().get(i);
            if (!this.invisibleFields.contains(returnField.getName().toLowerCase())) continue;
            queryResult.getFields().remove(i);
            --i;
        }
    }

    private static /* synthetic */ boolean lambda$convert2TbDTO$18(String classID, DmDictValueDTO c) {
        return StringUtil.equals((String)classID, (String)c.getCode());
    }

    private static /* synthetic */ boolean lambda$queryDLTBSpecialData$12(String pid, CodeEntityClass c) {
        return c.getId().equals(pid);
    }
}

