/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.webstore.api.action;

import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.common.web.ResponsePage;
import com.geoway.adf.dms.config.dto.user.LoginUserInfo;
import com.geoway.adf.dms.config.service.LoginUserService;
import com.geoway.adf.gis.basic.PageList;
import com.geoway.webstore.input.constant.TaskItemTypeEnum;
import com.geoway.webstore.input.dto.ImpSchemaDTO;
import com.geoway.webstore.input.dto.ImpTaskCreateDTO;
import com.geoway.webstore.input.dto.ImpTaskDTO;
import com.geoway.webstore.input.dto.ImpTaskDataResultDTO;
import com.geoway.webstore.input.dto.ImpTaskEditDTO;
import com.geoway.webstore.input.dto.ImpTaskItemDTO;
import com.geoway.webstore.input.dto.ImpTaskLogDTO;
import com.geoway.webstore.input.entity.ImpPlugin;
import com.geoway.webstore.input.entity.ImpSchema;
import com.geoway.webstore.input.service.ImpPluginService;
import com.geoway.webstore.input.service.ImpSchemeService;
import com.geoway.webstore.input.service.ImpTaskService;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/import"})
@Api(tags={"01-\u6570\u636e\u5165\u5e93"})
public class DataImportController {
    @Resource
    private ImpPluginService impPluginService;
    @Resource
    private ImpSchemeService impSchemeService;
    @Resource
    private ImpTaskService impTaskService;
    @Resource
    private LoginUserService loginUserService;

    @ApiOperation(value="01-\u83b7\u53d6\u5165\u5e93\u63d2\u4ef6\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="group", value="\u5206\u7ec4\u540d\u79f0", paramType="query"), @ApiImplicitParam(name="keyword", value="\u540d\u79f0\u8fc7\u6ee4", paramType="query")})
    @GetMapping(value={"/plugin/list"})
    public Response<List<ImpPlugin>> listPlugin(@RequestParam(required=false) String group, @RequestParam(required=false) String keyword) {
        return Response.ok((Object)this.impPluginService.list(group, keyword));
    }

    @ApiOperation(value="02-\u83b7\u53d6\u5165\u5e93\u65b9\u6848\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageIndex", value="\u5206\u9875\u7d22\u5f15", paramType="query", defaultValue="0"), @ApiImplicitParam(name="rows", value="\u6bcf\u9875\u6570\u91cf", paramType="query", defaultValue="10"), @ApiImplicitParam(name="type", value="\u5206\u7c7b\u540d\u79f0", paramType="query"), @ApiImplicitParam(name="keyword", value="\u540d\u79f0\u8fc7\u6ee4", paramType="query"), @ApiImplicitParam(name="withGeneral", value="\u662f\u5426\u83b7\u53d6\u901a\u7528\u65b9\u6848", paramType="query", defaultValue="false"), @ApiImplicitParam(name="withPlugin", value="\u662f\u5426\u83b7\u53d6\u63d2\u4ef6", paramType="query", defaultValue="false")})
    @GetMapping(value={"/schema/list"})
    public ResponsePage<ImpSchemaDTO> listSchema(@RequestParam(required=false, defaultValue="0") Integer pageIndex, @RequestParam(required=false, defaultValue="10") Integer rows, @RequestParam(required=false) String type, @RequestParam(required=false) String keyword, @RequestParam(required=false, defaultValue="false") Boolean withGeneral, @RequestParam(required=false, defaultValue="false") Boolean withPlugin) {
        return ResponsePage.ok((PageInfo)this.impSchemeService.listSchema(pageIndex.intValue(), rows.intValue(), type, keyword, withGeneral, withPlugin));
    }

    @ApiOperation(value="03-\u83b7\u53d6\u65b9\u6848\u5206\u7ec4\u540d\u79f0\u5217\u8868")
    @GetMapping(value={"/schema/listtype"})
    public Response<List<String>> listSchemaType() {
        return Response.ok((Object)this.impSchemeService.getTypeList());
    }

    @ApiOperation(value="04-\u83b7\u53d6\u5165\u5e93\u65b9\u6848\u8be6\u60c5")
    @GetMapping(value={"/schema/detail"})
    public Response<ImpSchemaDTO> getSchemaDetail(Long id) {
        return Response.ok((Object)this.impSchemeService.getSchemaDetail(id));
    }

    @ApiOperation(value="05-\u4fdd\u5b58\u5165\u5e93\u65b9\u6848")
    @PostMapping(value={"/schema/save"})
    public Response<ImpSchemaDTO> saveSchema(@RequestBody ImpSchema impSchema) {
        return Response.ok((Object)this.impSchemeService.saveSchema(impSchema));
    }

    @ApiOperation(value="06-\u5220\u9664\u5165\u5e93\u65b9\u6848")
    @PostMapping(value={"/schema/delete"})
    public Response deleteSchema(Long id) {
        this.impSchemeService.deleteSchema(id);
        return Response.ok();
    }

    @ApiOperation(value="07-\u83b7\u53d6\u4efb\u52a1\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageIndex", value="\u5206\u9875\u7d22\u5f15", paramType="query", defaultValue="0"), @ApiImplicitParam(name="rows", value="\u6bcf\u9875\u6570\u91cf", paramType="query", defaultValue="10"), @ApiImplicitParam(name="status", value="\u72b6\u6001", paramType="query", allowableValues="com.geoway.webstore.input.constant.TaskStatusEnum"), @ApiImplicitParam(name="keyword", value="\u540d\u79f0\u8fc7\u6ee4", paramType="query")})
    @GetMapping(value={"/task/list"})
    public ResponsePage<ImpTaskDTO> listTask(@RequestParam(required=false, defaultValue="0") Integer pageIndex, @RequestParam(required=false, defaultValue="10") Integer rows, @RequestParam(required=false) String status, @RequestParam(required=false) String keyword, @RequestParam(required=false) String taskTypes) {
        PageList list = this.impTaskService.list(pageIndex.intValue(), rows.intValue(), status, keyword, taskTypes);
        return ResponsePage.ok((PageList)list);
    }

    @ApiOperation(value="08-\u83b7\u53d6\u4efb\u52a1\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", required=true, value="\u4efb\u52a1id", paramType="query"), @ApiImplicitParam(name="withUnit", value="\u67e5\u8be2\u4efb\u52a1\u5355\u5143", paramType="query", defaultValue="false"), @ApiImplicitParam(name="pageIndex", value="\u5206\u9875\u7d22\u5f15", paramType="query", defaultValue="0"), @ApiImplicitParam(name="rows", value="\u6bcf\u9875\u6570\u91cf", paramType="query", defaultValue="10"), @ApiImplicitParam(name="status", value="\u72b6\u6001", paramType="query", allowableValues="com.geoway.webstore.input.constant.TaskStatusEnum"), @ApiImplicitParam(name="keyword", value="\u540d\u79f0\u8fc7\u6ee4", paramType="query")})
    @GetMapping(value={"/task/detail"})
    public Response<ImpTaskDTO> getTask(@RequestParam Long taskId, @RequestParam(required=false, defaultValue="false") Boolean withUnit, @RequestParam(required=false, defaultValue="0") Integer pageIndex, @RequestParam(required=false, defaultValue="10") Integer rows, @RequestParam(required=false) String status, @RequestParam(required=false) String keyword) {
        return Response.ok((Object)this.impTaskService.getTask(taskId, withUnit, pageIndex.intValue(), rows.intValue(), status, keyword));
    }

    @ApiOperation(value="09-\u83b7\u53d6\u4efb\u52a1\u6267\u884c\u60c5\u51b5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", required=true, value="\u4efb\u52a1id", paramType="query")})
    @GetMapping(value={"/task/detail/result"})
    public Response<ImpTaskDTO> getTask(@RequestParam Long taskId) {
        return Response.ok((Object)this.impTaskService.getTask(taskId));
    }

    @ApiOperation(value="10-\u521b\u5efa\u5165\u5e93\u4efb\u52a1")
    @PostMapping(value={"/task/create"})
    public Response<Long> createTask(@RequestBody ImpTaskCreateDTO taskCreateDTO, HttpServletRequest request) {
        LoginUserInfo userInfo = this.loginUserService.getUserInfo(request);
        String userName = userInfo.getUserName();
        taskCreateDTO.setCreateUser(userName);
        return Response.ok((Object)this.impTaskService.createTask(taskCreateDTO));
    }

    @ApiOperation(value="11-\u5f00\u59cb\u6267\u884c\u4efb\u52a1")
    @PostMapping(value={"/task/start"})
    public Response startTask(Long taskId) {
        this.impTaskService.startTask(taskId);
        return Response.ok();
    }

    @ApiOperation(value="12-\u505c\u6b62\u4efb\u52a1")
    @PostMapping(value={"/task/stop"})
    public Response stopTask(Long taskId) {
        this.impTaskService.stopTask(taskId);
        return Response.ok();
    }

    @ApiOperation(value="13-\u5220\u9664\u4efb\u52a1")
    @PostMapping(value={"/task/del"})
    public Response deleteTask(Long taskId) {
        this.impTaskService.deleteTask(taskId);
        return Response.ok();
    }

    @ApiOperation(value="14-\u83b7\u53d6\u4efb\u52a1\u5355\u5143\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", required=true, value="\u4efb\u52a1id", paramType="query"), @ApiImplicitParam(name="pageIndex", value="\u5206\u9875\u7d22\u5f15", paramType="query", defaultValue="0"), @ApiImplicitParam(name="rows", value="\u6bcf\u9875\u6570\u91cf", paramType="query", defaultValue="10"), @ApiImplicitParam(name="status", value="\u72b6\u6001", paramType="query", allowableValues="com.geoway.webstore.input.constant.TaskStatusEnum"), @ApiImplicitParam(name="keyword", value="\u540d\u79f0\u8fc7\u6ee4", paramType="query")})
    @PostMapping(value={"/task/listunit"})
    public ResponsePage<ImpTaskItemDTO> listTaskUnit(@RequestParam Long taskId, @RequestParam(required=false, defaultValue="0") Integer pageIndex, @RequestParam(required=false, defaultValue="10") Integer rows, @RequestParam(required=false) String status, @RequestParam(required=false) String keyword) {
        PageList list = this.impTaskService.listDataUnit(pageIndex.intValue(), rows.intValue(), taskId, status, keyword);
        return ResponsePage.ok((PageList)list);
    }

    @ApiOperation(value="15-\u83b7\u53d6\u4efb\u52a1\u65e5\u5fd7")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", required=true, paramType="query"), @ApiImplicitParam(name="type", value="\u7c7b\u578b", paramType="query", allowableValues="com.geoway.webstore.input.constant.TaskItemTypeEnum")})
    @GetMapping(value={"/task/log"})
    public Response<List<ImpTaskLogDTO>> listTaskData(Long id, Integer type) {
        return Response.ok((Object)this.impTaskService.getTaskLog(id, TaskItemTypeEnum.getByValue((Integer)type)));
    }

    @ApiOperation(value="16-\u83b7\u53d6\u4efb\u52a1\u6570\u636e\u7ed3\u679c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", required=true, value="\u4efb\u52a1id", paramType="query"), @ApiImplicitParam(name="pageIndex", value="\u5206\u9875\u7d22\u5f15", paramType="query", defaultValue="0"), @ApiImplicitParam(name="rows", value="\u6bcf\u9875\u6570\u91cf", paramType="query", defaultValue="10"), @ApiImplicitParam(name="status", value="\u72b6\u6001", paramType="query", allowableValues="com.geoway.webstore.input.constant.TaskStatusEnum"), @ApiImplicitParam(name="keyword", value="\u540d\u79f0\u8fc7\u6ee4", paramType="query")})
    @GetMapping(value={"/task/dataresult"})
    public ResponsePage<ImpTaskDataResultDTO> listDataResult(@RequestParam(required=false, defaultValue="0") Integer pageIndex, @RequestParam(required=false, defaultValue="10") Integer rows, @RequestParam Long taskId, @RequestParam(required=false) String status, @RequestParam(required=false) String keyword) {
        return ResponsePage.ok((PageList)this.impTaskService.getTaskDataResults(taskId, pageIndex.intValue(), rows.intValue(), status, keyword));
    }

    @ApiOperation(value="17-\u5bfc\u51fa\u4efb\u52a1\u6570\u636e\u7ed3\u679c")
    @GetMapping(value={"/task/exportresult"})
    public void downloadDataResult(Long taskId) {
        this.impTaskService.exportTaskDataResults(taskId);
    }

    @ApiOperation(value="18-\u4fee\u6539\u4efb\u52a1\u57fa\u672c\u4fe1\u606f")
    @PostMapping(value={"/task/update"})
    public Response updateTaskBasicInfo(@RequestBody ImpTaskEditDTO taskEditDTO) {
        this.impTaskService.updateTaskBasicInfo(taskEditDTO);
        return Response.ok();
    }
}

