/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.webstore.api.action;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpServerErrorException;

@RestController
@RequestMapping(value={"/"})
@Api(tags={"00-\u7248\u672c"})
public class WebstoreVersionController {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiOperation(value="webstore\u7248\u672c\u4fe1\u606f")
    @GetMapping(value={"/webstoreVersion"})
    public Map<String, String> version() {
        try (InputStream in = this.getClass().getResourceAsStream("/webstore/env.properties");){
            Properties properties = new Properties();
            properties.load(in);
            DateTime time = DateUtil.parseDateTime((CharSequence)properties.getProperty("buildTime"));
            String buildTime = DateUtil.offsetHour((Date)time, (int)8).toString("yyyy-MM-dd HH:mm:ss");
            String version = properties.getProperty("version");
            in.close();
            HashMap<String, String> rtnMap = new HashMap<String, String>();
            rtnMap.put("version", version);
            rtnMap.put("buildTime", buildTime);
            HashMap<String, String> hashMap = rtnMap;
            return hashMap;
        }
        catch (Exception e) {
            HttpServerErrorException errorException = new HttpServerErrorException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
            errorException.initCause((Throwable)e);
            throw errorException;
        }
    }
}

