/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.webstore.api.interceptor;

import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.webstore.datamodel.service.InputSpatialDataService;
import com.geoway.webstore.datamodel.service.SpatialTemporalDatasetService;
import java.io.PrintWriter;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class DataSourceInterceptor
implements HandlerInterceptor {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Resource
    private SpatialTemporalDatasetService spatialTemporalDatasetService;
    @Resource
    private InputSpatialDataService inputSpatialDataService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        if ("DELETE".equals(request.getMethod())) {
            String path = "/datasource/geodb/dataset/";
            String datasetId = request.getServletPath().substring(path.length());
            System.out.println(datasetId);
            try {
                DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo((String)datasetId);
                if (datasetNameInfo.getType().intValue() == DatasetTypeEnum.FeatureDataset.getValue() || datasetNameInfo.getType().intValue() == DatasetTypeEnum.MosaicDataset.getValue()) {
                    this.inputSpatialDataService.deleteInputInfoByDataset(datasetNameInfo.getDsKey(), datasetNameInfo.getShortName());
                }
            }
            catch (Exception e) {
                this.log.error(datasetId + "\u5220\u9664\u5165\u5e93\u6ce8\u518c\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            }
            if (this.spatialTemporalDatasetService.isSpatialTemporalDataset(datasetId).booleanValue()) {
                this.spatialTemporalDatasetService.deleteStDataset(datasetId);
                response.setContentType("application/json; charset=utf-8");
                PrintWriter writer = response.getWriter();
                Response result = new Response();
                writer.print(JSONObject.toJSONString((Object)result));
                writer.close();
                response.flushBuffer();
                return false;
            }
            return true;
        }
        return true;
    }
}

