/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.webstore.api.action;

import com.geoway.adf.dms.common.web.Response;
import com.geoway.webstore.datamodel.dto.spatialtemporal.SpatialTemporalDatasetCreateDTO;
import com.geoway.webstore.datamodel.dto.spatialtemporal.StFeatureClassDTO;
import com.geoway.webstore.datamodel.dto.spatialtemporal.StFeatureDatasetDTO;
import com.geoway.webstore.datamodel.dto.spatialtemporal.StHistoryVersionFeatureDatasetDTO;
import com.geoway.webstore.datamodel.dto.spatialtemporal.StHistoryVersionLayerDTO;
import com.geoway.webstore.datamodel.dto.spatialtemporal.UpdateRecordFeatureDatasetDTO;
import com.geoway.webstore.datamodel.dto.spatialtemporal.query.StDataQueryResult;
import com.geoway.webstore.datamodel.dto.spatialtemporal.query.StQueryFilterDTO;
import com.geoway.webstore.datamodel.service.SpatialTemporalDatasetService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/datasource/st"})
@Api(tags={"03-\u65f6\u7a7a\u6570\u636e\u6a21\u578b"})
public class StDatasetController {
    @Resource
    private SpatialTemporalDatasetService spatialTemporalDatasetService;

    @ApiOperation(value="01-\u521b\u5efa\u65f6\u7a7a\u6570\u636e\u6a21\u578b")
    @PostMapping(value={"/featuredataset/create"})
    public Response createSpatialTemporalDataset(@RequestBody SpatialTemporalDatasetCreateDTO createDTO) {
        this.spatialTemporalDatasetService.createSpatialTemporalDataset(createDTO);
        return Response.ok();
    }

    @ApiOperation(value="02-\u83b7\u53d6\u65f6\u7a7a\u6570\u636e\u6a21\u578b\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dsKey", value="\u6570\u636e\u6e90\u6807\u8bc6")})
    @GetMapping(value={"/list"})
    public Response<List<StFeatureDatasetDTO>> getAllSpatialTemporalDataset(@RequestParam(required=false) String dsKey) {
        return Response.ok((Object)this.spatialTemporalDatasetService.getAllSpatialTemporalDataset(dsKey));
    }

    @ApiOperation(value="03-\u83b7\u53d6\u65f6\u7a7a\u6570\u636e\u56fe\u5c42\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="datasetIds", value="\u6570\u636e\u96c6ID\u591a\u4e2a\u7528\u9017\u53f7\u9694\u5f00\uff0c\u53ef\u4e3a\u7a7a")})
    @GetMapping(value={"/layer/list"})
    public Response<List<StFeatureClassDTO>> getStFeatureClassList(@RequestParam(required=false) String datasetIds) {
        return Response.ok((Object)this.spatialTemporalDatasetService.getStFeatureClassList(datasetIds));
    }

    @ApiOperation(value="04-\u83b7\u53d6\u65f6\u7a7a\u6570\u636e\u96c6\u7248\u672c")
    @GetMapping(value={"/version/list"})
    public Response<List<StHistoryVersionFeatureDatasetDTO>> getStVersions() {
        return Response.ok((Object)this.spatialTemporalDatasetService.getStVersions());
    }

    @ApiOperation(value="05-\u83b7\u53d6\u65f6\u7a7a\u6570\u636e\u96c6\u7248\u672c\u56fe\u5c42")
    @ApiImplicitParams(value={@ApiImplicitParam(name="datasetId", value="\u65f6\u7a7a\u6570\u636e\u96c6\u6807\u8bc6", required=true), @ApiImplicitParam(name="versionName", value="\u7248\u672c\u540d\u79f0", required=true)})
    @GetMapping(value={"/version/layers"})
    public Response<List<StHistoryVersionLayerDTO>> getVersionLayers(@RequestParam String datasetId, @RequestParam String versionName) {
        return Response.ok((Object)this.spatialTemporalDatasetService.getVersionLayers(datasetId, versionName));
    }

    @ApiOperation(value="06-\u83b7\u53d6\u65f6\u7a7a\u6570\u636e\u96c6\u66f4\u65b0\u8bb0\u5f55(\u7528\u4e8e\u64a4\u9500)")
    @GetMapping(value={"/update/records"})
    public Response<List<UpdateRecordFeatureDatasetDTO>> getUpdateRecords() {
        return Response.ok((Object)this.spatialTemporalDatasetService.getUpdateRecords());
    }

    @ApiOperation(value="07-\u5220\u9664\u7248\u672c\u5c42")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u7248\u672c\u56fe\u5c42\u4e1a\u52a1\u6807\u8bc6", required=true)})
    @DeleteMapping(value={"/version"})
    public Response deleteHistoryVersion(@RequestParam Long id) {
        this.spatialTemporalDatasetService.deleteHistoryVersion(id);
        return Response.ok();
    }

    @ApiOperation(value="08-\u83b7\u53d6\u66f4\u65b0\u65f6\u95f4\u5b57\u6bb5")
    @GetMapping(value={"/update/time/field"})
    public Response<String> getUpdateTimeField() {
        return Response.ok((Object)this.spatialTemporalDatasetService.getUpdateTimeField());
    }

    @ApiOperation(value="09-\u65f6\u7a7a\u67e5\u8be2")
    @GetMapping(value={"/query/identify"})
    public Response<List<StDataQueryResult>> identityQueryData(StQueryFilterDTO queryFilterDTO) {
        return Response.ok((Object)this.spatialTemporalDatasetService.identifyQuery(queryFilterDTO));
    }
}

