/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.webstore.api.action;

import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.common.web.ResponsePage;
import com.geoway.adf.gis.basic.PageList;
import com.geoway.webstore.update.dto.UpdateTaskDTO;
import com.geoway.webstore.update.dto.UpdateTaskLogDTO;
import com.geoway.webstore.update.dto.create.UpdateTaskCreateDTO;
import com.geoway.webstore.update.service.SpatialTemporalTaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/update"})
@Api(tags={"04-\u6570\u636e\u66f4\u65b0\u4efb\u52a1\u6a21\u5757"})
public class UpdateTaskController {
    @Resource
    private SpatialTemporalTaskService spatialTemporalTaskService;

    @ApiOperation(value="01-\u83b7\u53d6\u4efb\u52a1\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageIndex", value="\u5206\u9875\u7d22\u5f15", paramType="query", defaultValue="0"), @ApiImplicitParam(name="rows", value="\u6bcf\u9875\u6570\u91cf", paramType="query", defaultValue="10"), @ApiImplicitParam(name="status", value="\u72b6\u6001", paramType="query", allowableValues="com.geoway.webstore.update.constant.TaskStatusEnum"), @ApiImplicitParam(name="types", value="\u72b6\u6001", paramType="query", allowableValues="com.geoway.webstore.update.constant.UpdateTaskTypeEnum"), @ApiImplicitParam(name="keyword", value="\u540d\u79f0\u8fc7\u6ee4", paramType="query")})
    @GetMapping(value={"/task/list"})
    public ResponsePage<UpdateTaskDTO> listTask(@RequestParam(required=false, defaultValue="0") Integer pageIndex, @RequestParam(required=false, defaultValue="10") Integer rows, @RequestParam(required=false) String status, @RequestParam(required=false) String types, @RequestParam(required=false) String keyword) {
        PageList list = this.spatialTemporalTaskService.list(pageIndex.intValue(), rows.intValue(), status, types, keyword);
        return ResponsePage.ok((PageList)list);
    }

    @ApiOperation(value="02-\u83b7\u53d6\u4efb\u52a1\u8be6\u60c5")
    @GetMapping(value={"/task/detail"})
    public Response<UpdateTaskDTO> getTaskDetail(@RequestParam Long taskId) {
        return Response.ok((Object)this.spatialTemporalTaskService.getTaskDetail(taskId));
    }

    @ApiOperation(value="03-\u521b\u5efa\u5e76\u6267\u884c\u66f4\u65b0\u4efb\u52a1")
    @PostMapping(value={"/task/create"})
    public Response<Long> addTask(@RequestBody UpdateTaskCreateDTO createDTO) {
        return Response.ok((Object)this.spatialTemporalTaskService.addTask(createDTO));
    }

    @ApiOperation(value="04-\u5f00\u59cb\u6267\u884c\u4efb\u52a1")
    @PostMapping(value={"/task/start"})
    public Response executeTask(@RequestParam Long taskId) {
        this.spatialTemporalTaskService.executeTask(taskId);
        return Response.ok();
    }

    @ApiOperation(value="05-\u5220\u9664\u4efb\u52a1")
    @DeleteMapping(value={"/task"})
    public Response deleteTask(@RequestParam Long taskId) {
        this.spatialTemporalTaskService.deleteTask(taskId);
        return Response.ok();
    }

    @ApiOperation(value="06-\u83b7\u53d6\u4efb\u52a1\u65e5\u5fd7")
    @GetMapping(value={"/task/logs"})
    public Response<List<UpdateTaskLogDTO>> getTaskLogs(@RequestParam Long taskId) {
        return Response.ok((Object)this.spatialTemporalTaskService.getTaskLogs(taskId));
    }

    @ApiOperation(value="07-\u5bfc\u51fa\u65e5\u5fd7")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u4efb\u52a1\u6807\u8bc6")})
    @GetMapping(value={"/task/logs/download"})
    public void downloadLogs(@RequestParam Long id) {
        this.spatialTemporalTaskService.downloadLogs(id);
    }
}

