/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.webstore.api.action;

import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.common.web.ResponsePage;
import com.geoway.adf.gis.basic.PageList;
import com.geoway.webstore.export.dto.ExportParamsDTO;
import com.geoway.webstore.export.dto.ExportTaskDTO;
import com.geoway.webstore.export.dto.ExportTaskDataResultDTO;
import com.geoway.webstore.export.entity.ExportTask;
import com.geoway.webstore.export.entity.ExportTaskData;
import com.geoway.webstore.export.entity.ExportTaskLog;
import com.geoway.webstore.export.entity.ExportTaskUnit;
import com.geoway.webstore.export.service.ExportTaskService;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"05-\u6570\u636e\u63d0\u53d6\u6a21\u5757"})
@RestController
@RequestMapping(value={"/exportTask"})
public class ExportTaskAction {
    @Resource
    private ExportTaskService exportTaskService;

    @ApiOperation(value="01-\u4efb\u52a1\u5217\u8868")
    @GetMapping(value={"/list"})
    public ResponsePage<ExportTask> list(@RequestParam(required=false, defaultValue="1") int pageIndex, @RequestParam(required=false, defaultValue="1000") int rows, @RequestParam(required=false, defaultValue="DESC") String sortType, @RequestParam(required=false) String keyword, @RequestParam(required=false) String status, @RequestParam(required=false, defaultValue="true") boolean success, @RequestParam(required=false) Integer dataType, @RequestParam(required=false) String taskTypes) {
        PageInfo list = this.exportTaskService.list(pageIndex, rows, sortType, status, success, keyword, dataType, taskTypes);
        return ResponsePage.ok((PageInfo)list);
    }

    @ApiOperation(value="02-\u521b\u5efa\u4efb\u52a1")
    @PostMapping(value={"/add"})
    public Response add(@RequestBody ExportParamsDTO exportVectorParamsDTO) {
        return Response.ok((Object)this.exportTaskService.addTask(exportVectorParamsDTO));
    }

    @ApiOperation(value="03-\u4fee\u6539\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", required=true), @ApiImplicitParam(name="name", value="\u540d\u79f0", required=false), @ApiImplicitParam(name="desc", value="\u63cf\u8ff0", required=false)})
    @PostMapping(value={"/update"})
    public Response update(@RequestParam Integer id, @RequestParam(required=false) String name, @RequestParam(required=false) String desc) {
        this.exportTaskService.update(id, name, desc);
        return Response.ok();
    }

    @ApiOperation(value="04-\u6267\u884c\u4efb\u52a1")
    @PostMapping(value={"/execute/{taskId}"})
    public Response execute(@PathVariable Integer taskId) {
        this.exportTaskService.execute(taskId);
        return Response.ok();
    }

    @ApiOperation(value="05-\u505c\u6b62\u4efb\u52a1")
    @PostMapping(value={"/stop/{taskId}"})
    public Response stop(@PathVariable Integer taskId) {
        this.exportTaskService.stop(taskId);
        return Response.ok();
    }

    @ApiOperation(value="06-\u5220\u9664\u4efb\u52a1")
    @DeleteMapping(value={"/delete/{taskId}"})
    public Response delete(@PathVariable Integer taskId) {
        this.exportTaskService.delete(taskId);
        return Response.ok();
    }

    @ApiOperation(value="07-\u4efb\u52a1\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", required=true, value="\u4efb\u52a1id", paramType="query"), @ApiImplicitParam(name="withUnit", value="\u67e5\u8be2\u4efb\u52a1\u5355\u5143", paramType="query", defaultValue="false"), @ApiImplicitParam(name="pageIndex", value="\u5206\u9875\u7d22\u5f15", paramType="query", defaultValue="0"), @ApiImplicitParam(name="rows", value="\u6bcf\u9875\u6570\u91cf", paramType="query", defaultValue="10"), @ApiImplicitParam(name="status", value="\u72b6\u6001", paramType="query", allowableValues="com.geoway.webstore.input.constant.TaskStatusEnum"), @ApiImplicitParam(name="keyword", value="\u540d\u79f0\u8fc7\u6ee4", paramType="query")})
    @GetMapping(value={"detail"})
    public Response<ExportTaskDTO> getDetail(@RequestParam Integer taskId, @RequestParam(required=false, defaultValue="false") Boolean withUnit, @RequestParam(required=false, defaultValue="0") Integer pageIndex, @RequestParam(required=false, defaultValue="10") Integer rows, @RequestParam(required=false) String status, @RequestParam(required=false) String keyword) {
        return Response.ok((Object)this.exportTaskService.getDetail(taskId, withUnit, pageIndex.intValue(), rows.intValue(), status, keyword));
    }

    @ApiOperation(value="08-\u4efb\u52a1\u6267\u884c\u60c5\u51b5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", required=true, value="\u4efb\u52a1id", paramType="query")})
    @GetMapping(value={"detail/result"})
    public Response<ExportTaskDTO> getDetail(@RequestParam Integer taskId) {
        return Response.ok((Object)this.exportTaskService.getDetail(taskId));
    }

    @ApiOperation(value="09-\u63d0\u53d6\u65e5\u5fd7")
    @GetMapping(value={"logs"})
    public Response<List<ExportTaskLog>> getLogs(@RequestParam(required=false) Integer taskId, @RequestParam(required=false) Integer taskUnitId, @RequestParam(required=false) Integer taskDataId) {
        return Response.ok((Object)this.exportTaskService.getLogs(taskId, taskUnitId, taskDataId));
    }

    @ApiOperation(value="10-\u4efb\u52a1\u5355\u5143\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageIndex", value="\u5206\u9875\u7d22\u5f15", paramType="query", defaultValue="0"), @ApiImplicitParam(name="rows", value="\u6bcf\u9875\u6570\u91cf", paramType="query", defaultValue="10"), @ApiImplicitParam(name="status", value="\u72b6\u6001", paramType="query", allowableValues="com.geoway.webstore.input.constant.TaskStatusEnum"), @ApiImplicitParam(name="keyword", value="\u540d\u79f0\u8fc7\u6ee4", paramType="query")})
    @GetMapping(value={"dataUnit/list"})
    public ResponsePage<ExportTaskUnit> listDataUnit(@RequestParam(required=false, defaultValue="1") int pageIndex, @RequestParam(required=false, defaultValue="1000") int rows, @RequestParam Integer taskId, @RequestParam(required=false) String status, @RequestParam(required=false) String keyword) {
        return ResponsePage.ok((PageList)this.exportTaskService.listDataUnit(pageIndex, rows, taskId, status, keyword));
    }

    @ApiOperation(value="11-\u83b7\u53d6\u4efb\u52a1\u6570\u636e\u7ed3\u679c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", required=true, value="\u4efb\u52a1id", paramType="query"), @ApiImplicitParam(name="pageIndex", value="\u5206\u9875\u7d22\u5f15", paramType="query", defaultValue="0"), @ApiImplicitParam(name="rows", value="\u6bcf\u9875\u6570\u91cf", paramType="query", defaultValue="10"), @ApiImplicitParam(name="status", value="\u72b6\u6001", paramType="query", allowableValues="com.geoway.webstore.input.constant.TaskStatusEnum"), @ApiImplicitParam(name="keyword", value="\u540d\u79f0\u8fc7\u6ee4", paramType="query")})
    @GetMapping(value={"/unit/result"})
    public ResponsePage<ExportTaskDataResultDTO> listDataResult(@RequestParam(required=false, defaultValue="0") Integer pageIndex, @RequestParam(required=false, defaultValue="10") Integer rows, @RequestParam Integer taskId, @RequestParam(required=false) String status, @RequestParam(required=false) String keyword) {
        return ResponsePage.ok((PageInfo)this.exportTaskService.getTaskDataResults(taskId, pageIndex.intValue(), rows.intValue(), status, keyword));
    }

    @ApiOperation(value="12-\u4efb\u52a1\u6570\u636e\u5217\u8868")
    @GetMapping(value={"data/list"})
    public ResponsePage<ExportTaskData> listData(@RequestParam(required=false, defaultValue="1") int pageIndex, @RequestParam(required=false, defaultValue="1000") int rows, @RequestParam Integer taskUnitId) {
        return ResponsePage.ok((PageInfo)this.exportTaskService.listData(pageIndex, rows, taskUnitId));
    }

    @ApiOperation(value="13-\u5bfc\u51faword\u683c\u5f0f\u65e5\u5fd7")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1\u6807\u8bc6")})
    @GetMapping(value={"/logs/word"})
    public void exportXml(@RequestParam Integer taskId) {
        this.exportTaskService.downloadWordLogs(taskId);
    }

    @ApiOperation(value="14-\u4e0b\u8f7d\u5230\u672c\u5730")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1\u6807\u8bc6")})
    @GetMapping(value={"/download"})
    public void downloadExportData(@RequestParam Integer taskId) {
        this.exportTaskService.downloadExportData(taskId);
    }
}

