/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.webstore.api.action;

import com.geoway.adf.dms.catalog.dto.query.StatQuerySingleResultDTO;
import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.webstore.datamodel.dto.metaData.MetaQueryFilterDTO;
import com.geoway.webstore.datamodel.dto.metaData.MetaStatQueryFilterDTO;
import com.geoway.webstore.datamodel.service.InputSpatialDataService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"06-\u5143\u6570\u636e\u67e5\u8be2"})
@RestController
@RequestMapping(value={"/frame/metadata"})
public class FrameMetaDataQueryController {
    @Resource
    private InputSpatialDataService inputSpatialDataService;

    @ApiOperation(value="01-\u67e5\u8be2\u5143\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageIndex", value="\u5206\u9875\u7d22\u5f15"), @ApiImplicitParam(name="rows", value="\u6bcf\u9875\u6570\u91cf")})
    @GetMapping(value={"/query"})
    public Response<List<DataQueryResult>> list(MetaQueryFilterDTO metaFilterDTO, @RequestParam(required=false, defaultValue="0") Integer pageIndex, @RequestParam(required=false, defaultValue="10") Integer rows) {
        return Response.ok((Object)this.inputSpatialDataService.queryDataWithMetaData(metaFilterDTO, pageIndex, rows));
    }

    @ApiOperation(value="02-\u7ed3\u679c\u5bfc\u51fa")
    @PostMapping(value={"/query/export"})
    public Response<String> exportQueryResult(@RequestBody MetaQueryFilterDTO metaFilterDTO, HttpServletResponse response) {
        return Response.ok((Object)this.inputSpatialDataService.exportMetaData(metaFilterDTO, response));
    }

    @ApiOperation(value="03-\u4e0b\u8f7d\u5bfc\u51fa\u7ed3\u679c")
    @GetMapping(value={"/query/download"})
    public void exportQueryResult(@RequestParam String id) {
        this.inputSpatialDataService.downloadMetaData(id);
    }

    @ApiOperation(value="04-\u7ed3\u679c\u7edf\u8ba1")
    @PostMapping(value={"/query/stat"})
    public Response<Map<String, List<StatQuerySingleResultDTO>>> queryStat(@RequestBody MetaStatQueryFilterDTO statDTO) {
        return Response.ok((Object)this.inputSpatialDataService.queryStat(statDTO));
    }

    @ApiOperation(value="05-i\u67e5\u8be2\u5143\u6570\u636e")
    @GetMapping(value={"/query/identify"})
    public Response<DataQueryResult> getDatumDataCatalog(@RequestParam String nodeId, @RequestParam String objectId) {
        return Response.ok((Object)this.inputSpatialDataService.identifyMetaData(nodeId, objectId));
    }

    @ApiOperation(value="06-\u6570\u636e\u96c6\u662f\u5426\u6709\u5143\u6570\u636e")
    @GetMapping(value={"/hasData"})
    public Response<Boolean> hasDatasetMetaData(@RequestParam String datasetId) {
        return Response.ok((Object)this.inputSpatialDataService.hasDatasetMetaData(datasetId));
    }

    @ApiOperation(value="07-\u5143\u6570\u636e\u8303\u56f4")
    @GetMapping(value={"/range"})
    public Response<List<String>> metaRange(@RequestParam String metaDatasetId, @RequestParam String oid) {
        return Response.ok((Object)this.inputSpatialDataService.getMetaDataRange(metaDatasetId, oid));
    }
}

