CREATE TABLE tbupdate_statconfig
(
    f_id             varchar(64) NULL,
    f_name           varchar(200) NULL,
    f_datasetid      varchar(500) NULL,
    f_datasourcename varchar(500) NULL,
    f_groupfield     varchar(100) NULL,
    f_order          int4 NULL,
    CONSTRAINT tbupdate_statconfig_pk PRIMARY KEY (f_id)
);
COMMENT ON TABLE tbupdate_statconfig IS '更新统计配置表';

COMMENT ON COLUMN tbupdate_statconfig.f_id IS '唯一标识';
COMMENT ON COLUMN tbupdate_statconfig.f_name IS '统计单元名称';
COMMENT ON COLUMN tbupdate_statconfig.f_datasetid IS '数据来源的数据集标识';
COMMENT ON COLUMN tbupdate_statconfig.f_datasourcename IS '数据来源的数据集标识';
COMMENT ON COLUMN tbupdate_statconfig.f_groupfield IS '分组字段';
COMMENT ON COLUMN tbupdate_statconfig.f_order IS '顺序';

CREATE TABLE tbupdate_statresult
(
    f_configid       varchar(64) NULL,
    f_name           varchar(200) NULL,
    f_add            int4 NULL,
    f_modify         int4 NULL,
    f_delete         int4 NULL,
    f_updatetime     timestamp(6) NULL,
    f_datasetnamenow varchar(200) NOT NULL,
    f_dskey          varchar(200) NOT NULL,
    f_datasetid      varchar(500) NULL
);
COMMENT ON TABLE tbupdate_statresult IS '更新统计结果表';

COMMENT ON COLUMN tbupdate_statresult.f_configid IS '更新统计配置标识';
COMMENT ON COLUMN tbupdate_statresult.f_name IS '统计结果项名称';
COMMENT ON COLUMN tbupdate_statresult.f_add IS '新增数量';
COMMENT ON COLUMN tbupdate_statresult.f_modify IS '修改数量';
COMMENT ON COLUMN tbupdate_statresult.f_delete IS '删除数量';
COMMENT ON COLUMN tbupdate_statresult.f_updatetime IS '更新时间';
COMMENT ON COLUMN tbupdate_statresult.f_datasetnamenow IS '时空数据集名称';
COMMENT ON COLUMN tbupdate_statresult.f_dskey IS '数据源标识';
COMMENT ON COLUMN tbupdate_statresult.f_datasetid IS '统计图层的标识';