/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.webstore.datamodel.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.FeatureClassDTO;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.webstore.datamodel.dao.CmExtractTemplateDao;
import com.geoway.webstore.datamodel.dto.extractTemplate.ExtractTemplateDTO;
import com.geoway.webstore.datamodel.dto.extractTemplate.ExtractTemplateFieldDTO;
import com.geoway.webstore.datamodel.dto.extractTemplate.ExtractTemplateLayerDTO;
import com.geoway.webstore.datamodel.dto.extractTemplate.ExtractTemplateSimpleDTO;
import com.geoway.webstore.datamodel.entity.CmExtractTemplate;
import com.geoway.webstore.datamodel.service.ExtractTemplateService;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ExtractTemplateServiceImpl
implements ExtractTemplateService {
    private static final Logger log = LoggerFactory.getLogger(ExtractTemplateServiceImpl.class);
    @Resource
    private CmExtractTemplateDao extractTemplateDao;
    @Resource
    private DataSourceService dataSourceService;

    @Override
    public List<ExtractTemplateSimpleDTO> list(String keyword) {
        List templates = this.extractTemplateDao.selectAll();
        if (templates.size() == 0) {
            return new ArrayList<ExtractTemplateSimpleDTO>();
        }
        if (StringUtil.isNotEmpty((String)keyword)) {
            templates = ListUtil.findAll(templates, f -> f.getName() != null && f.getName().contains(keyword));
        }
        ArrayList<ExtractTemplateSimpleDTO> dtoList = new ArrayList<ExtractTemplateSimpleDTO>();
        templates.forEach(item -> {
            ExtractTemplateSimpleDTO dto = new ExtractTemplateSimpleDTO();
            dto.setId(item.getId());
            dto.setName(item.getName());
            dto.setDesc(item.getDesc());
            dtoList.add(dto);
        });
        return dtoList;
    }

    @Override
    public String add(ExtractTemplateSimpleDTO createDTO) {
        Assert.notNull((Object)createDTO.getName(), (String)"\u8bf7\u8bbe\u7f6e\u540d\u79f0");
        if (this.exitSameName(createDTO.getName())) {
            throw new RuntimeException("\u540d\u79f0\uff1a" + createDTO.getName() + "\u91cd\u590d");
        }
        CmExtractTemplate template = new CmExtractTemplate();
        template.setId(UUID.randomUUID().toString());
        template.setName(createDTO.getName());
        template.setDesc(createDTO.getDesc());
        this.extractTemplateDao.insert(template);
        return template.getId();
    }

    @Override
    public void update(ExtractTemplateSimpleDTO editDTO) {
        CmExtractTemplate template = this.extractTemplateDao.selectByPrimaryKey(editDTO.getId());
        Assert.notNull((Object)template, (String)("\u672a\u67e5\u8be2\u5230\u6807\u8bc6\u4e3a" + editDTO.getId() + "\u7684\u6a21\u677f"));
        Assert.notNull((Object)editDTO.getName(), (String)"\u8bf7\u8bbe\u7f6e\u540d\u79f0");
        if (!editDTO.getName().equals(template.getName()) && this.exitSameName(editDTO.getName())) {
            throw new RuntimeException("\u540d\u79f0\uff1a" + editDTO.getName() + "\u91cd\u590d");
        }
        template.setName(editDTO.getName());
        template.setDesc(editDTO.getDesc());
        this.extractTemplateDao.updateByPrimaryKey(template);
    }

    @Override
    public void updateLayers(ExtractTemplateDTO editDTO) {
        CmExtractTemplate template = this.extractTemplateDao.selectByPrimaryKey(editDTO.getId());
        Assert.notNull((Object)template, (String)("\u672a\u67e5\u8be2\u5230\u6807\u8bc6\u4e3a" + editDTO.getId() + "\u7684\u6a21\u677f"));
        if (editDTO.getLayers() != null && editDTO.getLayers().size() > 0) {
            for (ExtractTemplateLayerDTO layerItem : editDTO.getLayers()) {
                if (layerItem.getFieldsMapping() != null && layerItem.getFieldsMapping().size() != 0) continue;
                layerItem.setFieldsMapping(this.createDefaultTemplateField(layerItem.getDatasetId()));
            }
            template.setLayers(JSONArray.toJSONString(editDTO.getLayers()));
        } else {
            template.setLayers("");
        }
        this.extractTemplateDao.updateByPrimaryKey(template);
    }

    @Override
    public void delete(String id) {
        this.extractTemplateDao.deleteByPrimaryKey(id);
    }

    @Override
    public ExtractTemplateDTO getDetail(String id) {
        CmExtractTemplate template = this.extractTemplateDao.selectByPrimaryKey(id);
        Assert.notNull((Object)template, (String)("\u672a\u67e5\u8be2\u5230\u6807\u8bc6\u4e3a" + id + "\u7684\u6a21\u677f"));
        ExtractTemplateDTO dto = new ExtractTemplateDTO();
        dto.setId(id);
        dto.setName(template.getName());
        dto.setDesc(template.getDesc());
        dto.setLayers(new ArrayList<ExtractTemplateLayerDTO>());
        if (StringUtil.isNotEmpty((String)template.getLayers())) {
            List layers = JSONArray.parseArray((String)template.getLayers(), ExtractTemplateLayerDTO.class);
            dto.setLayers(layers);
        }
        return dto;
    }

    @Override
    public List<String> getTemplateDataPhaseArray(String id) {
        CmExtractTemplate template = this.extractTemplateDao.selectByPrimaryKey(id);
        Assert.notNull((Object)template, (String)("\u672a\u67e5\u8be2\u5230\u6807\u8bc6\u4e3a" + id + "\u7684\u6a21\u677f"));
        ArrayList<String> dataPhaseArray = new ArrayList<String>();
        if (StringUtil.isNotEmpty((String)template.getLayers())) {
            List layers = JSONArray.parseArray((String)template.getLayers(), ExtractTemplateLayerDTO.class);
            for (ExtractTemplateLayerDTO layer : layers) {
                if (!StringUtil.isNotEmpty((String)layer.getDataPhase()) || dataPhaseArray.contains(layer.getDataPhase())) continue;
                dataPhaseArray.add(layer.getDataPhase());
            }
        }
        return dataPhaseArray;
    }

    private boolean exitSameName(String name) {
        List<CmExtractTemplate> list = this.extractTemplateDao.selectByName(name);
        return list.size() > 0;
    }

    private List<ExtractTemplateFieldDTO> createDefaultTemplateField(String datasetId) {
        ArrayList<ExtractTemplateFieldDTO> list = new ArrayList<ExtractTemplateFieldDTO>();
        DatasetDTO datasetDTO = this.dataSourceService.getDatasetDetail(datasetId);
        if (datasetDTO instanceof FeatureClassDTO) {
            List fields = ((FeatureClassDTO)datasetDTO).getFields();
            for (FieldDTO field : fields) {
                ExtractTemplateFieldDTO templateFieldDTO = new ExtractTemplateFieldDTO();
                templateFieldDTO.setSrcFieldName(field.getName());
                templateFieldDTO.setTargetFieldName(field.getName());
                list.add(templateFieldDTO);
            }
            return list;
        }
        throw new RuntimeException("\u6570\u636e\u96c6\u7684\u7c7b\u578b\u6709\u8bef\uff01");
    }
}

