/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.webstore.datamodel.service.impl;

import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.ObjectCloseUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.FeatureResult;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterDTO;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.webstore.datamodel.dao.CmIndexLayerDao;
import com.geoway.webstore.datamodel.dto.indexLayer.SysIndexLayerCreateDTO;
import com.geoway.webstore.datamodel.dto.indexLayer.SysIndexLayerEditDTO;
import com.geoway.webstore.datamodel.dto.indexLayer.SysIndexLayerQueryDTO;
import com.geoway.webstore.datamodel.dto.indexLayer.SysIndexLayerQueryResultDTO;
import com.geoway.webstore.datamodel.entity.CmIndexLayer;
import com.geoway.webstore.datamodel.service.IndexLayerService;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class IndexLayerServiceImpl
implements IndexLayerService {
    private static final Logger log = LoggerFactory.getLogger(IndexLayerServiceImpl.class);
    @Resource
    private CmIndexLayerDao cmIndexLayerDao;
    @Resource
    private DataSourceService dataSourceService;

    @Override
    public List<CmIndexLayer> list(String keyword) {
        return this.cmIndexLayerDao.queryByKeyword(keyword);
    }

    @Override
    public CmIndexLayer getSysIndexLayer(Long id) {
        return this.cmIndexLayerDao.selectByPrimaryKey(id);
    }

    @Override
    public List<CmIndexLayer> getSysIndexLayerByScale(String scale) {
        return this.cmIndexLayerDao.selectByScale(scale);
    }

    @Override
    public Long addSysIndexLayer(SysIndexLayerCreateDTO createDTO) {
        DatasetDTO dataset = this.dataSourceService.getDatasetDetail(createDTO.getDatasetId());
        Assert.notNull((Object)dataset, (String)"\u6570\u636e\u96c6\u4e0d\u5b58\u5728\uff01");
        DataSourceDTO dataSource = dataset.getDataSource();
        Assert.notNull((Object)dataSource, (String)"\u6570\u636e\u6e90\u4e0d\u5b58\u5728\uff01");
        CmIndexLayer indexLayer = new CmIndexLayer();
        indexLayer.setDatasetId(dataset.getId());
        indexLayer.setName(dataSource.getName() + "." + dataset.getName());
        indexLayer.setScale(createDTO.getScale());
        indexLayer.setMapNumberField(createDTO.getMapNumberField());
        this.cmIndexLayerDao.insert(indexLayer);
        return indexLayer.getId();
    }

    @Override
    public void updateSysIndexLayer(SysIndexLayerEditDTO editDTO) {
        CmIndexLayer indexLayer = this.cmIndexLayerDao.selectByPrimaryKey(editDTO.getId());
        Assert.notNull((Object)indexLayer, (String)"\u63a5\u56fe\u8868\u4e0d\u5b58\u5728\uff01");
        indexLayer.setScale(editDTO.getScale());
        this.cmIndexLayerDao.updateByPrimaryKey(indexLayer);
    }

    @Override
    public void delete(Long id) {
        this.cmIndexLayerDao.deleteByPrimaryKey(id);
    }

    @Override
    public List<SysIndexLayerQueryResultDTO> queryIndexLayer(SysIndexLayerQueryDTO queryDTO) {
        if (StringUtil.isEmptyOrWhiteSpace((String)queryDTO.getMapNumbers()) && StringUtil.isEmptyOrWhiteSpace((String)queryDTO.getGeometry())) {
            throw new RuntimeException("\u67e5\u8be2\u53c2\u6570\u6709\u8bef\uff01");
        }
        CmIndexLayer indexLayer = this.cmIndexLayerDao.selectByPrimaryKey(queryDTO.getId());
        Assert.notNull((Object)indexLayer, (String)"\u63a5\u56fe\u8868\u4e0d\u5b58\u5728\uff01");
        String datasetId = indexLayer.getDatasetId();
        QueryFilterDTO queryFilterDTO = new QueryFilterDTO();
        queryFilterDTO.setReturnGeometry(Boolean.valueOf(true));
        queryFilterDTO.setRows(Integer.valueOf(1000));
        queryFilterDTO.setGeometry(queryDTO.getGeometry());
        if (StringUtil.isNotEmpty((String)queryDTO.getMapNumbers())) {
            List numberList = Arrays.asList(queryDTO.getMapNumbers().split(","));
            numberList = ListUtil.convertAll(numberList, f -> String.format("'%s'", f));
            String condition = String.format("%s in (%s)", indexLayer.getMapNumberField(), String.join((CharSequence)",", numberList));
            queryFilterDTO.setCondition(condition);
        }
        DataQueryResult queryResult = this.dataSourceService.queryData(datasetId, queryFilterDTO);
        ArrayList<SysIndexLayerQueryResultDTO> result = new ArrayList<SysIndexLayerQueryResultDTO>();
        if (queryResult != null && queryResult.getData() != null) {
            List featureResults = queryResult.getData();
            for (FeatureResult feature : featureResults) {
                SysIndexLayerQueryResultDTO item = new SysIndexLayerQueryResultDTO();
                Object numberObject = feature.getAttributes().get(indexLayer.getMapNumberField());
                if (numberObject == null) continue;
                item.setMapNumber(numberObject.toString());
                item.setGeometry(feature.getGeometry());
                result.add(item);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readTxtFile(MultipartFile file) {
        BufferedReader reader = null;
        StringBuilder result = new StringBuilder();
        try {
            String tempString;
            reader = new BufferedReader(new InputStreamReader(file.getInputStream()));
            while ((tempString = reader.readLine()) != null) {
                result.append(tempString).append("\r\n");
            }
        }
        catch (Exception e) {
            try {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{reader});
                throw throwable;
            }
            ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{reader});
        }
        ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{reader});
        return result.toString();
    }
}

