/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.webstore.datamodel.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.geoway.adf.dms.catalog.dto.app.AppCatalogDataNodeDTO;
import com.geoway.adf.dms.catalog.dto.app.AppCatalogNodeDTO;
import com.geoway.adf.dms.catalog.dto.query.StatQuerySingleResultDTO;
import com.geoway.adf.dms.catalog.service.AppCatalogNodeService;
import com.geoway.adf.dms.common.config.OutputPathConfig;
import com.geoway.adf.dms.common.util.DownloadUtil;
import com.geoway.adf.dms.common.util.ExcelUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.FeatureClassDTO;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.FeatureResult;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterDTO;
import com.geoway.adf.dms.datasource.dto.query.ReturnField;
import com.geoway.adf.dms.datasource.dto.query.StatQueryFilterDTO;
import com.geoway.adf.dms.datasource.dto.query.StatQueryResultDTO;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.gis.basic.RefObject;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IMosaicDataset;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.cursor.ICursor;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.webstore.datamodel.dao.InputSpatialDataDao;
import com.geoway.webstore.datamodel.dto.indexLayer.SysIndexLayerQueryDTO;
import com.geoway.webstore.datamodel.dto.indexLayer.SysIndexLayerQueryResultDTO;
import com.geoway.webstore.datamodel.dto.metaData.MetaQueryFilterDTO;
import com.geoway.webstore.datamodel.dto.metaData.MetaStatQueryFilterDTO;
import com.geoway.webstore.datamodel.entity.CmIndexLayer;
import com.geoway.webstore.datamodel.entity.InputSpatialData;
import com.geoway.webstore.datamodel.service.IndexLayerService;
import com.geoway.webstore.datamodel.service.InputSpatialDataService;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class InputSpatialDataServiceImpl
implements InputSpatialDataService {
    private static final Logger log = LoggerFactory.getLogger(InputSpatialDataServiceImpl.class);
    @Resource
    private InputSpatialDataDao inputSpatialDataDao;
    @Resource
    private GeoDatabaseService geoDatabaseService;
    @Resource
    private AppCatalogNodeService appCatalogNodeService;
    @Resource
    private IndexLayerService indexLayerService;

    @Override
    public List<InputSpatialData> getInputSpatialDatas(String dbKey, String datasetName, String mapNum) {
        return this.inputSpatialDataDao.selectByMapNum(mapNum, dbKey, datasetName);
    }

    @Override
    public List<InputSpatialData> getInputSpatialDatas(String dsKey, String datasetName, List<String> mapNumList) {
        return this.inputSpatialDataDao.selectByMapNums(mapNumList, dsKey, datasetName);
    }

    @Override
    public List<InputSpatialData> getInputSpatialDataByTime(String time) {
        return this.inputSpatialDataDao.selectByTime(time);
    }

    @Override
    public synchronized boolean beginWriteInputInfo(InputSpatialData inputInfo, boolean skipRepeated, boolean onlyMeta, RefObject<Boolean> dataCanInput, RefObject<String> errorMsg) {
        dataCanInput.set((Object)false);
        List<InputSpatialData> existInputInfos = this.inputSpatialDataDao.selectByMapNum(inputInfo.getMapNo(), inputInfo.getDbKey(), inputInfo.getPhysicalDatasetName());
        if (existInputInfos.size() == 0) {
            if (onlyMeta) {
                errorMsg.set((Object)String.format("%s\u7a7a\u95f4\u6570\u636e\u672a\u5165\u5e93", inputInfo.getMapNo()));
                return false;
            }
            inputInfo.setId(null);
            inputInfo.setTransactionId(UUID.randomUUID().toString());
            inputInfo.setStartTime(new Date());
            this.inputSpatialDataDao.insert(inputInfo);
            dataCanInput.set((Object)true);
            return true;
        }
        InputSpatialData existInputInfo = existInputInfos.get(0);
        String year = existInputInfo.getYear();
        if (StringUtil.isEmpty((String)year) || StringUtil.isEmpty((String)inputInfo.getYear())) {
            errorMsg.set((Object)"\u8bf7\u8f93\u5165\u6570\u636e\u65f6\u76f8");
            return false;
        }
        if (year.length() == 4 && Integer.parseInt(year) > Integer.parseInt(inputInfo.getYear())) {
            errorMsg.set((Object)String.format("\u5b58\u5728\u5e74\u4ee3\u65e9\u4e8e%s\u7684\u6570\u636e", inputInfo.getYear()));
            return false;
        }
        if (year.length() >= 8 && DateUtil.parse((CharSequence)year).after((Date)DateUtil.parse((CharSequence)inputInfo.getYear()))) {
            errorMsg.set((Object)String.format("\u5b58\u5728\u65f6\u95f4\u65e9\u4e8e%s\u7684\u6570\u636e", inputInfo.getYear()));
            return false;
        }
        if (onlyMeta && !year.equals(inputInfo.getYear())) {
            errorMsg.set((Object)String.format("%s[%s]\u7a7a\u95f4\u6570\u636e\u672a\u5165\u5e93", inputInfo.getMapNo(), inputInfo.getYear()));
            return false;
        }
        if (!(!skipRepeated || onlyMeta && StringUtil.isEmptyOrWhiteSpace((String)existInputInfo.getMetaDataId()))) {
            errorMsg.set((Object)String.format("%s\u5b58\u5728\u91cd\u590d\u6570\u636e", inputInfo.getMapNo()));
            return true;
        }
        inputInfo.setMetadataPath(existInputInfo.getMetadataPath());
        inputInfo.setMetaTableName(existInputInfo.getMetaTableName());
        inputInfo.setMetaDataId(existInputInfo.getMetaDataId());
        inputInfo.setOidFieldName(existInputInfo.getOidFieldName());
        inputInfo.setId(existInputInfo.getId());
        inputInfo.setTransactionId(UUID.randomUUID().toString());
        inputInfo.setStartTime(new Date());
        this.inputSpatialDataDao.updateByPrimaryKey(inputInfo);
        dataCanInput.set((Object)true);
        return true;
    }

    @Override
    public void endWriteInputInfo(InputSpatialData inputInfo) {
        inputInfo.setFinishedTime(new Date());
        inputInfo.setTransactionId("0");
        this.inputSpatialDataDao.updateByPrimaryKey(inputInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean inputMetaData(InputSpatialData inputInfo, String newMetaTableName, Map<String, String> metaData) {
        String dbKey = inputInfo.getDbKey();
        String metaTableName = inputInfo.getMetaTableName();
        String metaTableFIDName = inputInfo.getOidFieldName();
        String metaOid = inputInfo.getMetaDataId();
        IFeatureWorkspace featureWorkspace = null;
        ICursor insertCursor = null;
        try {
            featureWorkspace = this.geoDatabaseService.openGeoWorkspace(dbKey);
            ITable table = null;
            if (StringUtil.isNotEmpty((String)metaTableName)) {
                table = featureWorkspace.openTable(metaTableName);
            }
            if (table != null && metaOid != null) {
                table.deleteRow((Object)metaOid);
            }
            if (!newMetaTableName.equalsIgnoreCase(metaTableName) && (table = featureWorkspace.openTable(newMetaTableName)) == null) {
                throw new RuntimeException(newMetaTableName + " \u5143\u6570\u636e\u8868\u6253\u5f00\u5931\u8d25");
            }
            IRow row = table.createRow();
            block3: for (String key : metaData.keySet()) {
                for (IField field : table.getFields()) {
                    if (!field.getName().equalsIgnoreCase(key) && !field.getAliasName().equalsIgnoreCase(key)) continue;
                    row.setValue(field.getName(), (Object)metaData.get(key));
                    continue block3;
                }
            }
            insertCursor = table.insertRow();
            insertCursor.insertRow(row);
            if (row.getObjectId() == null) {
                log.error("\u63d2\u5165\u5143\u6570\u636e\u672a\u751f\u6210\u4e3b\u952eid");
            }
            inputInfo.setMetaTableName(newMetaTableName);
            inputInfo.setMetaDataId(row.getObjectId().toString());
            inputInfo.setOidFieldName(table.getOidFieldName());
            boolean bl = true;
            return bl;
        }
        finally {
            if (insertCursor != null) {
                insertCursor.release();
            }
            if (featureWorkspace != null) {
                featureWorkspace.close();
            }
        }
    }

    @Override
    public int deleteInputInfoByDataset(String dbKey, String datasetName) {
        return this.inputSpatialDataDao.deleteByDataset(dbKey, datasetName);
    }

    @Override
    public boolean hasDatasetMetaData(String datasetId) {
        DatasetNameInfo nameInfo = DatasetUtil.getDatasetNameInfo((String)datasetId);
        return this.inputSpatialDataDao.selectMetaDataCount(nameInfo.getDsKey(), nameInfo.getShortName()) > 0;
    }

    @Override
    public List<DataQueryResult> queryDataWithMetaData(MetaQueryFilterDTO metaFilterDTO, Integer pageIndex, Integer rows) {
        List<InputSpatialData> dataList = this.getInputMetaDatas(metaFilterDTO);
        ArrayList<DataQueryResult> queryResults = new ArrayList<DataQueryResult>();
        if (dataList.size() == 0) {
            return queryResults;
        }
        Map<String, List<InputSpatialData>> dsKeyGroups = dataList.stream().collect(Collectors.groupingBy(InputSpatialData::getDbKey));
        for (String dsKey : dsKeyGroups.keySet()) {
            List<InputSpatialData> sameDbKeys = dsKeyGroups.get(dsKey);
            dsKey = dsKey.trim();
            Map<String, List<InputSpatialData>> tableNameGroups = sameDbKeys.stream().collect(Collectors.groupingBy(InputSpatialData::getMetaTableName));
            for (String tableName : tableNameGroups.keySet()) {
                List<InputSpatialData> items = tableNameGroups.get(tableName);
                String oidFldName = items.get(0).getOidFieldName();
                List metaDataIdFilters = ListUtil.convertAll(items, f -> String.format("%s = '%s'", oidFldName, f.getMetaDataId()));
                QueryFilterDTO queryFilter = new QueryFilterDTO();
                queryFilter.setPageIndex(pageIndex);
                queryFilter.setRows(rows);
                queryFilter.setReturnCount(Boolean.valueOf(true));
                queryFilter.setCondition(String.join((CharSequence)" or ", metaDataIdFilters));
                try {
                    DataQueryResult queryResult = this.geoDatabaseService.queryGeoDataset(dsKey, tableName, queryFilter);
                    queryResults.add(queryResult);
                }
                catch (Exception e) {
                    log.error("\u5143\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
                }
            }
        }
        return queryResults;
    }

    private List<InputSpatialData> getInputMetaDatas(MetaQueryFilterDTO metaFilterDTO) {
        DatasetNameInfo nameInfo;
        if (StringUtil.isEmptyOrWhiteSpace((String)metaFilterDTO.getDataPhase())) {
            metaFilterDTO.setDataPhase(null);
        }
        String datasetDsKey = null;
        String datasetName = null;
        String metaTableName = null;
        if (StringUtil.isNotEmpty((String)metaFilterDTO.getDatasetId())) {
            nameInfo = DatasetUtil.getDatasetNameInfo((String)metaFilterDTO.getDatasetId());
            datasetDsKey = nameInfo.getDsKey();
            datasetName = nameInfo.getShortName();
        }
        if (StringUtil.isNotEmpty((String)metaFilterDTO.getMetaDatasetId())) {
            nameInfo = DatasetUtil.getDatasetNameInfo((String)metaFilterDTO.getMetaDatasetId());
            metaTableName = nameInfo.getShortName();
        }
        List<InputSpatialData> dataList = this.inputSpatialDataDao.queryMetaData(metaFilterDTO.getFrames(), metaFilterDTO.getTypes(), metaFilterDTO.getDataPhase(), datasetDsKey, datasetName, metaTableName);
        return dataList;
    }

    @Override
    public String exportMetaData(MetaQueryFilterDTO metaFilterDTO, HttpServletResponse response) {
        File excelFile;
        DatasetNameInfo nameInfo = DatasetUtil.getDatasetNameInfo((String)metaFilterDTO.getMetaDatasetId());
        List<InputSpatialData> inputDataList = this.getInputMetaDatas(metaFilterDTO);
        if (inputDataList.size() == 0) {
            return "";
        }
        String dsKey = inputDataList.get(0).getDbKey();
        String metaTableName = inputDataList.get(0).getMetaTableName();
        String oidFldName = inputDataList.get(0).getOidFieldName();
        List metaDataIdFilters = ListUtil.convertAll(inputDataList, f -> String.format("%s = '%s'", oidFldName, f.getMetaDataId()));
        String excelPath = "";
        String id = UUID.randomUUID().toString();
        Path localPath = OutputPathConfig.getOutputPath().resolve(id);
        if (!localPath.toFile().exists()) {
            localPath.toFile().mkdirs();
        }
        if ((excelFile = new File(excelPath = Paths.get(localPath.toString(), nameInfo.getShortName() + ".xlsx").toString())).exists()) {
            excelFile.delete();
        }
        ExcelUtil.registerConverter();
        try (ExcelWriter excelWriter = EasyExcel.write((File)excelFile).build();){
            WriteSheet writeSheet = EasyExcel.writerSheet((String)nameInfo.getShortName()).build();
            QueryFilterDTO queryFilter = new QueryFilterDTO();
            queryFilter.setPageIndex(Integer.valueOf(0));
            queryFilter.setRows(Integer.valueOf(50000));
            queryFilter.setReturnCount(Boolean.valueOf(false));
            queryFilter.setCondition(String.join((CharSequence)" or ", metaDataIdFilters));
            DataQueryResult queryResult = this.geoDatabaseService.queryGeoDataset(dsKey, metaTableName, queryFilter);
            ArrayList<List> dataList = new ArrayList<List>();
            List titles = ListUtil.convertAll((List)queryResult.getFields(), ReturnField::getAlias);
            dataList.add(titles);
            for (FeatureResult feature : queryResult.getData()) {
                ArrayList item = new ArrayList();
                for (ReturnField field : queryResult.getFields()) {
                    Object valueObject = feature.getAttributes().get(field.getName());
                    item.add(valueObject);
                }
                dataList.add(item);
            }
            excelWriter.write(dataList, writeSheet);
        }
        return id;
    }

    @Override
    public void downloadMetaData(String id) {
        if (StringUtil.isEmptyOrWhiteSpace((String)id)) {
            return;
        }
        Path localPath = OutputPathConfig.getOutputPath().resolve(id);
        File dir = localPath.toFile();
        if (!dir.exists()) {
            log.error("\u6587\u4ef6\u4e22\u5931\uff0c\u4e0b\u8f7d\u5931\u8d25\uff01");
            return;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length > 0) {
            DownloadUtil.downloadFile((String)files[0].getPath());
        }
    }

    @Override
    public Map<String, List<StatQuerySingleResultDTO>> queryStat(MetaStatQueryFilterDTO statFilter) {
        List<InputSpatialData> inputDataList;
        DatasetNameInfo nameInfo;
        String datasetName = null;
        if (StringUtil.isNotEmpty((String)statFilter.getDatasetId())) {
            nameInfo = new DatasetNameInfo(statFilter.getDatasetId());
            datasetName = nameInfo.getShortName();
        }
        nameInfo = DatasetUtil.getDatasetNameInfo((String)statFilter.getMetaDatasetId());
        if (StringUtil.isEmptyOrWhiteSpace((String)statFilter.getDataPhase())) {
            statFilter.setDataPhase(null);
        }
        if ((inputDataList = this.inputSpatialDataDao.queryMetaData(statFilter.getFrames(), statFilter.getTypes(), statFilter.getDataPhase(), nameInfo.getDsKey(), datasetName, nameInfo.getShortName())).size() == 0) {
            return new LinkedHashMap<String, List<StatQuerySingleResultDTO>>();
        }
        String oidFldName = inputDataList.get(0).getOidFieldName();
        List metaDataIdFilters = ListUtil.convertAll(inputDataList, f -> String.format("%s = '%s'", oidFldName, f.getMetaDataId()));
        StatQueryFilterDTO statDTO = new StatQueryFilterDTO();
        statDTO.setStatMethod(statFilter.getStatMethod());
        statDTO.setGroupBy(statFilter.getGroupBy());
        statDTO.setFields(statFilter.getFields());
        statDTO.setPrecision(statFilter.getPrecision());
        statDTO.setCondition(String.join((CharSequence)" or ", metaDataIdFilters));
        List multiResult = this.geoDatabaseService.queryDataStatistics(nameInfo.getDsKey(), nameInfo.getName(), statDTO);
        HashMap<String, List<StatQuerySingleResultDTO>> statResult = new HashMap<String, List<StatQuerySingleResultDTO>>(0);
        for (StatQueryResultDTO result : multiResult) {
            String group = "";
            if (!StringUtil.isEmptyOrWhiteSpace((String)statDTO.getGroupBy())) {
                String groupFld = (String)result.getGroups().keySet().stream().findFirst().get();
                group = (String)result.getGroups().get(groupFld);
            }
            ArrayList<StatQuerySingleResultDTO> itemList = new ArrayList<StatQuerySingleResultDTO>();
            for (String statField : result.getValues().keySet()) {
                StatQuerySingleResultDTO item = new StatQuerySingleResultDTO();
                item.setName(statField);
                item.setGroupName(group);
                item.setValue((Double)result.getValues().get(statField));
                itemList.add(item);
            }
            statResult.put(group, itemList);
        }
        return statResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataQueryResult identifyMetaData(String nodeId, String objectId) {
        AppCatalogNodeDTO appCatalogNode = this.appCatalogNodeService.getNodeDetail(nodeId);
        Assert.notNull((Object)appCatalogNode, (String)"\u76ee\u5f55\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
        if (!(appCatalogNode instanceof AppCatalogDataNodeDTO)) {
            throw new RuntimeException("\u4e0d\u5b58\u5728\u5143\u6570\u636e\uff01");
        }
        DatasetDTO dataset = ((AppCatalogDataNodeDTO)appCatalogNode).getDataset();
        Assert.notNull((Object)dataset, (String)"\u6570\u636e\u5b9e\u4f53\u4e0d\u5b58\u5728\uff01");
        DatasetTypeEnum datasetType = DatasetTypeEnum.getByValue((Integer)dataset.getType());
        String dsKey = dataset.getDsKey();
        String physicalDatasetName = "";
        IFeatureWorkspace featureWorkspace = null;
        IFeature feature = null;
        switch (datasetType) {
            case FeatureClass: {
                FeatureClassDTO featureClassDTO = (FeatureClassDTO)dataset;
                if (!StringUtil.isNotEmpty((String)featureClassDTO.getParentId())) break;
                DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo((String)featureClassDTO.getParentId());
                physicalDatasetName = datasetNameInfo.getShortName();
                try {
                    featureWorkspace = this.geoDatabaseService.openGeoWorkspace(dataset.getDsKey());
                    IFeatureClass featureClass = featureWorkspace.openFeatureClass(dataset.getName());
                    feature = featureClass.getFeature((Object)objectId);
                    break;
                }
                finally {
                    if (featureWorkspace != null) {
                        featureWorkspace.close();
                    }
                }
            }
            case MosaicDataset: {
                physicalDatasetName = dataset.getName();
                try {
                    featureWorkspace = this.geoDatabaseService.openGeoWorkspace(dataset.getDsKey());
                    IMosaicDataset mosaicDataset = featureWorkspace.openMosaicDataset(dataset.getName());
                    feature = mosaicDataset.getCatalog().getFeature((Object)objectId);
                    break;
                }
                finally {
                    if (featureWorkspace != null) {
                        featureWorkspace.close();
                    }
                }
            }
            default: {
                throw new RuntimeException("\u4e0d\u5b58\u5728\u5143\u6570\u636e\uff01");
            }
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)physicalDatasetName) || feature == null) {
            throw new RuntimeException("\u4e0d\u5b58\u5728\u5143\u6570\u636e\uff01");
        }
        int fieldIndex = feature.getFields().findFieldIndex("f_frame");
        if (fieldIndex < 0) {
            throw new RuntimeException("\u65e0\u5206\u5e45\u5b57\u6bb5\uff0c\u4e0d\u5b58\u5728\u5143\u6570\u636e\uff01");
        }
        Object valueObj = feature.getValue(fieldIndex);
        if (valueObj == null) {
            throw new RuntimeException("\u65e0\u56fe\u5e45\u53f7\uff0c\u4e0d\u5b58\u5728\u5143\u6570\u636e\uff01");
        }
        List<InputSpatialData> inputInfos = this.inputSpatialDataDao.selectByMapNum(valueObj.toString(), dsKey, physicalDatasetName);
        if (inputInfos.size() == 0) {
            throw new RuntimeException("\u65e0\u5143\u6570\u636e\uff01");
        }
        String metaTableName = inputInfos.get(0).getMetaTableName();
        String oidFieldName = inputInfos.get(0).getOidFieldName();
        QueryFilterDTO queryFilter = new QueryFilterDTO();
        queryFilter.setReturnCount(Boolean.valueOf(true));
        queryFilter.setCondition(String.join((CharSequence)" or ", ListUtil.convertAll(inputInfos, f -> String.format("%s = '%s'", oidFieldName, f.getMetaDataId()))));
        DataQueryResult queryResult = null;
        try {
            queryResult = this.geoDatabaseService.queryGeoDataset(dsKey, metaTableName, queryFilter);
        }
        catch (Exception e) {
            log.error("\u5143\u6570\u636e\u8868\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u5143\u6570\u636e\u8868\u67e5\u8be2\u5931\u8d25\uff01");
        }
        if (queryResult == null || queryResult.getData() == null || queryResult.getData().size() == 0) {
            throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u5143\u6570\u636e\uff01");
        }
        return queryResult;
    }

    @Override
    public List<String> getMetaDataRange(String metaDatasetId, String oid) {
        DatasetNameInfo nameInfo = DatasetUtil.getDatasetNameInfo((String)metaDatasetId);
        InputSpatialData inputSpatialData = this.inputSpatialDataDao.selectMetaData(nameInfo.getDsKey(), nameInfo.getShortName(), oid);
        Assert.notNull((Object)inputSpatialData, (String)"\u5143\u6570\u636e\u4e0d\u5b58\u5728");
        List<CmIndexLayer> indexLayers = this.indexLayerService.getSysIndexLayerByScale(inputSpatialData.getScale());
        if (indexLayers == null || indexLayers.size() == 0) {
            throw new RuntimeException(inputSpatialData.getScale() + "\u63a5\u56fe\u8868\u4e0d\u5b58\u5728");
        }
        SysIndexLayerQueryDTO queryDTO = new SysIndexLayerQueryDTO();
        queryDTO.setId(indexLayers.get(0).getId());
        queryDTO.setMapNumbers(inputSpatialData.getMapNo());
        List<SysIndexLayerQueryResultDTO> resultDTOS = this.indexLayerService.queryIndexLayer(queryDTO);
        return ListUtil.convertAll(resultDTOS, r -> r.getGeometry());
    }
}

