/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.webstore.datamodel.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.common.dto.NameMapping;
import com.geoway.adf.dms.common.gis.WorkspaceUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.FeatureClassDTO;
import com.geoway.adf.dms.datasource.dto.dataset.FeatureDatasetDTO;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.FeatureResult;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterDTO;
import com.geoway.adf.dms.datasource.dto.query.ReturnField;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.dms.datasource.util.FieldUtil;
import com.geoway.adf.dms.datasource.util.GeoDatasetUtil;
import com.geoway.adf.gis.basic.geometry.CoordinateType;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.geodb.GeoDatasetType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureDataset;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.field.Field;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.Fields;
import com.geoway.adf.gis.geodb.field.GeometryField;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.field.IFields;
import com.geoway.webstore.datamodel.constant.UpdateGWFieldNameConstant;
import com.geoway.webstore.datamodel.dao.LayerUpdateInfoDao;
import com.geoway.webstore.datamodel.dao.LayerVersionKeyInfoDao;
import com.geoway.webstore.datamodel.dao.UpdateCaseInfoDao;
import com.geoway.webstore.datamodel.dao.VersionHistoryInfoDao;
import com.geoway.webstore.datamodel.dto.spatialtemporal.LayerGuidFieldDTO;
import com.geoway.webstore.datamodel.dto.spatialtemporal.SpatialTemporalDatasetCreateDTO;
import com.geoway.webstore.datamodel.dto.spatialtemporal.StFeatureClassDTO;
import com.geoway.webstore.datamodel.dto.spatialtemporal.StFeatureDatasetDTO;
import com.geoway.webstore.datamodel.dto.spatialtemporal.StHistoryVersionDTO;
import com.geoway.webstore.datamodel.dto.spatialtemporal.StHistoryVersionFeatureDatasetDTO;
import com.geoway.webstore.datamodel.dto.spatialtemporal.StHistoryVersionLayerDTO;
import com.geoway.webstore.datamodel.dto.spatialtemporal.UpdateRecordDTO;
import com.geoway.webstore.datamodel.dto.spatialtemporal.UpdateRecordFeatureDatasetDTO;
import com.geoway.webstore.datamodel.dto.spatialtemporal.UpdateRecordLayerDTO;
import com.geoway.webstore.datamodel.dto.spatialtemporal.VersionDatasetInfo;
import com.geoway.webstore.datamodel.dto.spatialtemporal.query.FeatureUpdateInfo;
import com.geoway.webstore.datamodel.dto.spatialtemporal.query.StDataQueryResult;
import com.geoway.webstore.datamodel.dto.spatialtemporal.query.StFeatureResult;
import com.geoway.webstore.datamodel.dto.spatialtemporal.query.StQueryFilterDTO;
import com.geoway.webstore.datamodel.entity.LayerUpdateInfo;
import com.geoway.webstore.datamodel.entity.LayerVersionKeyInfo;
import com.geoway.webstore.datamodel.entity.UpdateCaseInfo;
import com.geoway.webstore.datamodel.entity.VersionHistoryInfo;
import com.geoway.webstore.datamodel.service.SpatialTemporalDatasetService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SpatialTemporalDatasetServiceImpl
implements SpatialTemporalDatasetService {
    private static final Logger log = LoggerFactory.getLogger(SpatialTemporalDatasetServiceImpl.class);
    @Resource
    private DataSourceManager dataSourceManager;
    @Resource
    private GeoDatabaseService geoDatabaseService;
    @Resource
    private DataSourceService dataSourceService;
    @Resource
    private LayerVersionKeyInfoDao layerVersionKeyInfoDao;
    @Resource
    private VersionHistoryInfoDao versionHistoryInfoDao;
    @Resource
    private LayerUpdateInfoDao layerUpdateInfoDao;
    @Resource
    private UpdateCaseInfoDao updateCaseInfoDao;

    @Override
    public void createSpatialTemporalDataset(SpatialTemporalDatasetCreateDTO createDTO) {
        this.addNonceFeatureDataset(createDTO);
        this.addWorkerFeatureDataset(createDTO);
    }

    @Override
    public Boolean isSpatialTemporalDataset(String datasetId) {
        try {
            DatasetDTO datasetDTO = this.dataSourceService.getDatasetDetail(datasetId);
            DatasetTypeEnum datasetType = DatasetTypeEnum.getByValue((Integer)datasetDTO.getType());
            switch (datasetType) {
                case FeatureDataset: {
                    return this.isStFeatureDataset(datasetDTO);
                }
                case FeatureClass: {
                    return this.isStFeatureClass(datasetDTO);
                }
            }
            return false;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u662f\u5426\u65f6\u7a7a\u6570\u636e\u96c6\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    @Override
    public Boolean canDelete(String datasetId) {
        DatasetDTO datasetDTO = this.dataSourceService.getDatasetDetail(datasetId);
        DatasetTypeEnum datasetType = DatasetTypeEnum.getByValue((Integer)datasetDTO.getType());
        switch (datasetType) {
            case FeatureDataset: {
                return this.allowDeleteFeatureDataset(datasetDTO);
            }
            case FeatureClass: {
                return this.allowDeleteFeatureClass(datasetDTO);
            }
        }
        return true;
    }

    @Override
    public void deleteStDataset(String datasetId) {
        DatasetDTO datasetDTO = this.dataSourceService.getDatasetDetail(datasetId);
        DatasetTypeEnum datasetType = DatasetTypeEnum.getByValue((Integer)datasetDTO.getType());
        switch (datasetType) {
            case FeatureDataset: {
                if (!this.allowDeleteFeatureDataset(datasetDTO).booleanValue()) break;
                this.deleteStFeatureDataset(datasetId);
                break;
            }
            case FeatureClass: {
                if (!this.allowDeleteFeatureClass(datasetDTO).booleanValue()) break;
                this.deleteStFeatureClass(datasetId);
                break;
            }
            case Table: 
            case RasterDataset: 
            case MosaicDataset: 
            case TableView: {
                this.geoDatabaseService.deleteDataset(datasetId);
                break;
            }
        }
    }

    @Override
    public List<StFeatureDatasetDTO> getAllSpatialTemporalDataset(String dsKey) {
        ArrayList<StFeatureDatasetDTO> result = new ArrayList<StFeatureDatasetDTO>();
        List<LayerVersionKeyInfo> allLayers = this.layerVersionKeyInfoDao.selectByDsKey(dsKey);
        Map<String, List<LayerVersionKeyInfo>> dsKeyGroups = allLayers.stream().collect(Collectors.groupingBy(LayerVersionKeyInfo::getDsKey));
        for (String key : dsKeyGroups.keySet()) {
            Map<String, List<LayerVersionKeyInfo>> datasetGroup = dsKeyGroups.get(key).stream().collect(Collectors.groupingBy(item -> {
                VersionDatasetInfo versionDatasetInfo = (VersionDatasetInfo)JSONObject.parseObject((String)item.getVersionInfo(), VersionDatasetInfo.class);
                return versionDatasetInfo.getDatasetNameNow();
            }));
            for (String datasetName : datasetGroup.keySet()) {
                StFeatureDatasetDTO datasetDTO = new StFeatureDatasetDTO();
                datasetDTO.setName(datasetName);
                datasetDTO.setDsKey(key);
                datasetDTO.setDatasetId(DatasetUtil.getDatasetId((String)key, (DatasetTypeEnum)DatasetTypeEnum.FeatureDataset, (String)datasetName));
                datasetDTO.setSubsets(ListUtil.convertAll(datasetGroup.get(datasetName), this::convertToDto));
                result.add(datasetDTO);
            }
        }
        return result;
    }

    @Override
    public List<StFeatureClassDTO> getStFeatureClassList(String datasetIds) {
        List<Object> allLayers = new ArrayList();
        if (StringUtil.isEmptyOrWhiteSpace((String)datasetIds)) {
            allLayers = this.layerVersionKeyInfoDao.selectAll();
        } else {
            List datasetIdList = StringUtil.split((String)datasetIds, (String)",", f -> f);
            if (datasetIdList.size() > 0) {
                allLayers = this.layerVersionKeyInfoDao.selectByFeatureClassIdList(datasetIdList);
            }
        }
        List<VersionHistoryInfo> versionLayers = this.versionHistoryInfoDao.selectAll();
        ArrayList<StFeatureClassDTO> result = new ArrayList<StFeatureClassDTO>();
        for (LayerVersionKeyInfo layerVersionKeyInfo : allLayers) {
            StFeatureClassDTO stLayer = this.convertToDto(layerVersionKeyInfo);
            List historyInfos = ListUtil.findAll(versionLayers, f -> f.getVersionKey().equals(layer.getId()));
            ArrayList<StHistoryVersionLayerDTO> historyVersions = new ArrayList<StHistoryVersionLayerDTO>();
            for (VersionHistoryInfo info : historyInfos) {
                StHistoryVersionLayerDTO historyLayer = new StHistoryVersionLayerDTO();
                historyLayer.setDatasetId(info.getDatasetId());
                historyLayer.setVersionTime(info.getStartTime());
                historyLayer.setSpatial(stLayer.getSpatial());
                historyLayer.setId(info.getId());
                historyLayer.setName(info.getLayerName());
                historyLayer.setAliasName(info.getVersionAliasName());
                historyLayer.setDescription(info.getDescription());
                historyVersions.add(historyLayer);
            }
            stLayer.setHistoryVersions(historyVersions);
            result.add(stLayer);
        }
        return result;
    }

    @Override
    public List<StHistoryVersionFeatureDatasetDTO> getStVersions() {
        ArrayList<StHistoryVersionFeatureDatasetDTO> result = new ArrayList<StHistoryVersionFeatureDatasetDTO>();
        List<VersionHistoryInfo> versionLayers = this.versionHistoryInfoDao.selectAll();
        if (versionLayers.size() == 0) {
            return result;
        }
        List<LayerVersionKeyInfo> allVersionKeyInfos = this.layerVersionKeyInfoDao.selectAll();
        HashMap<String, FeatureDatasetDTO> cacheDataset = new HashMap<String, FeatureDatasetDTO>(0);
        HashMap<String, Integer> countingMap = new HashMap<String, Integer>(0);
        Map<Long, List<VersionHistoryInfo>> featureDatasetGroups = versionLayers.stream().collect(Collectors.groupingBy(VersionHistoryInfo::getVersionKey));
        for (Long versionKey : featureDatasetGroups.keySet()) {
            StHistoryVersionFeatureDatasetDTO item = new StHistoryVersionFeatureDatasetDTO();
            LayerVersionKeyInfo versionKeyInfo = (LayerVersionKeyInfo)ListUtil.find(allVersionKeyInfos, f -> versionKey.equals(f.getId()));
            if (versionKeyInfo == null) continue;
            VersionDatasetInfo versionDatasetInfo = (VersionDatasetInfo)JSONObject.parseObject((String)versionKeyInfo.getVersionInfo(), VersionDatasetInfo.class);
            String datasetId = DatasetUtil.getDatasetId((String)versionKeyInfo.getDsKey(), (DatasetTypeEnum)DatasetTypeEnum.FeatureDataset, (String)versionDatasetInfo.getDatasetNameNow());
            item.setName(versionDatasetInfo.getDatasetNameNow());
            item.setDatasetId(datasetId);
            FeatureDatasetDTO dataset = null;
            try {
                dataset = cacheDataset.get(datasetId) == null ? (FeatureDatasetDTO)this.dataSourceService.getDatasetDetail(datasetId) : (FeatureDatasetDTO)cacheDataset.get(datasetId);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            if (dataset == null) continue;
            cacheDataset.put(datasetId, dataset);
            item.setLayerCount(dataset.getSubsets().size());
            StHistoryVersionFeatureDatasetDTO targetDataset = (StHistoryVersionFeatureDatasetDTO)ListUtil.find(result, f -> item.getDatasetId().equals(f.getDatasetId()));
            ArrayList<StHistoryVersionDTO> versions = new ArrayList();
            if (targetDataset != null) {
                versions = targetDataset.getVersions();
            }
            for (VersionHistoryInfo layer : featureDatasetGroups.get(versionKey)) {
                StHistoryVersionDTO stHistoryVersion = new StHistoryVersionDTO();
                stHistoryVersion.setVersionName(layer.getVersionName());
                stHistoryVersion.setVersionAliasName(layer.getVersionAliasName());
                stHistoryVersion.setDsKey(versionKeyInfo.getDsKey());
                if (!countingMap.containsKey(datasetId + stHistoryVersion.getVersionName())) {
                    countingMap.put(datasetId + stHistoryVersion.getVersionName(), 1);
                    stHistoryVersion.setLayerCount(1);
                    versions.add(stHistoryVersion);
                    continue;
                }
                int count = (Integer)countingMap.get(datasetId + stHistoryVersion.getVersionName()) + 1;
                countingMap.put(datasetId + stHistoryVersion.getVersionName(), count);
                StHistoryVersionDTO targetVersion = (StHistoryVersionDTO)ListUtil.find(versions, f -> layer.getVersionName().equals(f.getVersionName()));
                targetVersion.setLayerCount(count);
            }
            if (targetDataset != null) continue;
            item.setVersions(versions);
            result.add(item);
        }
        return result;
    }

    @Override
    public List<StHistoryVersionLayerDTO> getVersionLayers(String datasetId, String versionName) {
        DatasetDTO datasetDTO = this.dataSourceService.getDatasetDetail(datasetId);
        Assert.notNull((Object)datasetDTO, (String)"\u65f6\u7a7a\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01");
        DatasetTypeEnum datasetType = DatasetTypeEnum.getByValue((Integer)datasetDTO.getType());
        ArrayList<StHistoryVersionLayerDTO> result = new ArrayList<StHistoryVersionLayerDTO>();
        if (datasetType == DatasetTypeEnum.FeatureDataset) {
            List<LayerVersionKeyInfo> allVersionKeyInfos = this.layerVersionKeyInfoDao.selectByDsKey(datasetDTO.getDsKey());
            List datasetList = ((FeatureDatasetDTO)datasetDTO).getSubsets();
            List<VersionHistoryInfo> versionLayers = this.versionHistoryInfoDao.selectByVersionName(versionName);
            for (DatasetDTO dataset : datasetList) {
                LayerVersionKeyInfo versionKeyInfo = (LayerVersionKeyInfo)ListUtil.find(allVersionKeyInfos, f -> dataset.getId().equals(f.getDatasetId()));
                VersionHistoryInfo historyInfo = (VersionHistoryInfo)ListUtil.find(versionLayers, f -> versionKeyInfo.getId().equals(f.getVersionKey()));
                if (historyInfo == null) continue;
                DatasetDTO historyDataset = this.dataSourceService.getDatasetDetail(historyInfo.getDatasetId());
                StHistoryVersionLayerDTO layerDto = new StHistoryVersionLayerDTO();
                layerDto.setDatasetId(historyDataset.getId());
                layerDto.setVersionTime(historyInfo.getStartTime());
                FeatureClassDTO featureClassDTO = (FeatureClassDTO)historyDataset;
                layerDto.setSpatial(featureClassDTO.getSpatialRef().getName());
                layerDto.setId(historyInfo.getId());
                layerDto.setName(historyDataset.getName());
                layerDto.setAliasName(historyDataset.getAliasName());
                layerDto.setDescription(historyInfo.getDescription());
                result.add(layerDto);
            }
        }
        return result;
    }

    @Override
    public List<UpdateRecordFeatureDatasetDTO> getUpdateRecords() {
        ArrayList<UpdateRecordFeatureDatasetDTO> result = new ArrayList<UpdateRecordFeatureDatasetDTO>();
        List allUpdateLayers = this.layerUpdateInfoDao.selectAll();
        List<UpdateCaseInfo> allUpdateRecords = this.updateCaseInfoDao.selectAll();
        try {
            Date errorDate = new SimpleDateFormat("yyyy-MM-dd").parse("9999-12-30");
            allUpdateLayers = ListUtil.findAll(allUpdateLayers, f -> !errorDate.equals(f.getPostDateTime()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        Map<String, List<LayerUpdateInfo>> dsKeyNameGroups = allUpdateLayers.stream().collect(Collectors.groupingBy(LayerUpdateInfo::getDatabaseKey));
        for (String dsKey : dsKeyNameGroups.keySet()) {
            Map<String, List<LayerUpdateInfo>> datasetNameGroups = dsKeyNameGroups.get(dsKey).stream().collect(Collectors.groupingBy(LayerUpdateInfo::getDatasetName));
            for (String datasetName : datasetNameGroups.keySet()) {
                UpdateRecordFeatureDatasetDTO dto = new UpdateRecordFeatureDatasetDTO();
                dto.setName(datasetName);
                String datasetId = DatasetUtil.getDatasetId((String)dsKey, (DatasetTypeEnum)DatasetTypeEnum.FeatureDataset, (String)datasetName);
                dto.setDatasetId(datasetId);
                dto.setUpdateRecords(this.getUpdateRecords(datasetName, allUpdateRecords, dsKeyNameGroups.get(dsKey)));
                if (dto.getUpdateRecords().size() <= 0) continue;
                result.add(dto);
            }
        }
        return result;
    }

    @Override
    public UpdateRecordDTO getUpdateRecordDetail(Long caseId) {
        UpdateCaseInfo caseInfo = this.updateCaseInfoDao.selectByPrimaryKey(caseId);
        Assert.notNull((Object)caseInfo, (String)"\u66f4\u65b0\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01");
        List<LayerUpdateInfo> updateLayers = this.layerUpdateInfoDao.selectByTaskID(caseId);
        return this.convertUpdateRecord(caseInfo, updateLayers);
    }

    @Override
    public Boolean checkHistoryVersionValid(String dsKey, String nonceLayerName, Date versionTime, String versionName) {
        LayerVersionKeyInfo versionKeyInfo = this.layerVersionKeyInfoDao.selectByNonceLayer(dsKey, nonceLayerName);
        List<VersionHistoryInfo> versionLayers = this.versionHistoryInfoDao.selectByKeyInfoId(versionKeyInfo.getId());
        if (versionLayers.size() > 0) {
            for (VersionHistoryInfo historyInfo : versionLayers) {
                if (versionName.equals(historyInfo.getVersionName())) {
                    throw new RuntimeException(nonceLayerName + "\u5df2\u5b58\u5728\u7248\u672c" + versionName);
                }
                if (!versionTime.equals(historyInfo.getStartTime())) continue;
                throw new RuntimeException(nonceLayerName + "\u5df2\u5b58\u5728\u65f6\u95f4\u4e3a" + new SimpleDateFormat("yyyy-MM-dd").format(versionTime) + "\u7684\u7248\u672c");
            }
        }
        return true;
    }

    @Override
    public void deleteHistoryVersion(Long id) {
        VersionHistoryInfo versionHistoryInfo = this.versionHistoryInfoDao.selectByPrimaryKey(id);
        if (versionHistoryInfo != null) {
            LayerVersionKeyInfo keyInfo = this.layerVersionKeyInfoDao.selectByPrimaryKey(versionHistoryInfo.getVersionKey());
            VersionDatasetInfo versionDatasetInfo = (VersionDatasetInfo)JSONObject.parseObject((String)keyInfo.getVersionInfo(), VersionDatasetInfo.class);
            this.geoDatabaseService.deleteDataset(versionHistoryInfo.getDatasetId());
            this.versionHistoryInfoDao.deleteByPrimaryKey(versionHistoryInfo.getId());
            this.deleteEmptyFeatureDataset(versionDatasetInfo.getDatasetNameNow() + "_" + versionHistoryInfo.getVersionName(), keyInfo.getDsKey());
        }
    }

    @Override
    public String getUpdateTimeField() {
        UpdateGWFieldNameConstant.getUpdateField();
        return UpdateGWFieldNameConstant.FLD_NAME_GW_UPDATETIME;
    }

    @Override
    public List<StDataQueryResult> identifyQuery(StQueryFilterDTO queryFilterDTO) {
        List datasetIds;
        try {
            datasetIds = Arrays.stream(queryFilterDTO.getDatasetIds().split(",")).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u76ee\u5f55\u8282\u70b9\u53c2\u6570\u6709\u8bef");
        }
        ArrayList<StDataQueryResult> results = new ArrayList<StDataQueryResult>();
        QueryFilterDTO queryFilter = new QueryFilterDTO();
        queryFilter.setGeometry(queryFilterDTO.getGeometry());
        for (String datasetId : datasetIds) {
            LayerVersionKeyInfo keyInfo = this.layerVersionKeyInfoDao.selectByFeatureClassId(datasetId);
            if (keyInfo == null) continue;
            String guidFld = keyInfo.getUniqueField().toUpperCase(Locale.ROOT);
            queryFilter.setFields(guidFld);
            DatasetNameInfo nameInfo = DatasetUtil.getDatasetNameInfo((String)datasetId);
            String workDatasetId = DatasetUtil.getDatasetId((String)nameInfo.getDsKey(), (DatasetTypeEnum)DatasetTypeEnum.FeatureClass, (String)(nameInfo.getName() + "_WORK"));
            HashMap<String, String> guidMap = new HashMap<String, String>(0);
            DataQueryResult workQueryResult = this.dataSourceService.queryData(workDatasetId, queryFilter);
            ReturnField returnField = (ReturnField)ListUtil.find((List)workQueryResult.getFields(), f -> f.getName().toUpperCase(Locale.ROOT).equals(guidFld));
            for (FeatureResult featureResult : workQueryResult.getData()) {
                if (guidMap.containsKey(featureResult.getAttributes().get(guidFld).toString())) continue;
                guidMap.put(featureResult.getAttributes().get(returnField.getName()).toString(), workDatasetId);
            }
            queryFilter.setFields(null);
            DataQueryResult nonceQueryResult = this.dataSourceService.queryData(datasetId, queryFilter);
            returnField = (ReturnField)ListUtil.find((List)nonceQueryResult.getFields(), f -> f.getName().toUpperCase(Locale.ROOT).equals(guidFld));
            for (FeatureResult featureResult : nonceQueryResult.getData()) {
                if (guidMap.containsKey(featureResult.getAttributes().get(guidFld).toString())) continue;
                guidMap.put(featureResult.getAttributes().get(returnField.getName()).toString(), datasetId);
            }
            for (String guid : guidMap.keySet()) {
                String workCondition = guidFld + " = '" + guid + "'";
                QueryFilterDTO filter = new QueryFilterDTO();
                filter.setCondition(workCondition);
                filter.setReturnGeometry(Boolean.valueOf(true));
                DataQueryResult layerResult = this.dataSourceService.queryData((String)guidMap.get(guid), filter);
                if (layerResult == null || layerResult.getData() == null || layerResult.getData().size() <= 0) continue;
                returnField = (ReturnField)ListUtil.find((List)layerResult.getFields(), f -> f.getName().toUpperCase(Locale.ROOT).equals(guidFld));
                ReturnField dateField = (ReturnField)ListUtil.find((List)layerResult.getFields(), f -> f.getName().toUpperCase(Locale.ROOT).equals("F_TIME"));
                StDataQueryResult stQueryResult = new StDataQueryResult();
                stQueryResult.setId(nonceQueryResult.getId());
                stQueryResult.setName(nonceQueryResult.getName());
                stQueryResult.setAliasName(nonceQueryResult.getAliasName());
                stQueryResult.setFields(layerResult.getFields());
                List<StFeatureResult> data = this.toStFeatureResult(layerResult.getData(), returnField.getName(), dateField.getName());
                stQueryResult.setData(data);
                stQueryResult.setTotal(Long.valueOf(data.size()));
                results.add(stQueryResult);
            }
        }
        return results;
    }

    private List<StFeatureResult> toStFeatureResult(List<FeatureResult> results, String guidFld, String dateFld) {
        ArrayList<StFeatureResult> stFeatureResults = new ArrayList<StFeatureResult>();
        if (results == null || results.size() == 0) {
            return stFeatureResults;
        }
        Map<String, List<FeatureResult>> resultMap = results.stream().collect(Collectors.groupingBy(f -> f.getAttributes().get(guidFld) == null ? "" : f.getAttributes().get(guidFld).toString()));
        for (Map.Entry<String, List<FeatureResult>> keyValue : resultMap.entrySet()) {
            if (keyValue.getKey().length() == 0) continue;
            StFeatureResult featureResult = new StFeatureResult();
            featureResult.setGuid(keyValue.getKey());
            featureResult.setUpdateInfos(keyValue.getValue().stream().map(f -> this.getFeatureUpdateInfo((FeatureResult)f, dateFld)).collect(Collectors.toList()));
            featureResult.getUpdateInfos().sort(Comparator.comparing(FeatureUpdateInfo::getTimeSpan).reversed());
            stFeatureResults.add(featureResult);
        }
        return stFeatureResults;
    }

    private Boolean allowDeleteFeatureClass(DatasetDTO datasetDTO) {
        VersionHistoryInfo versionHistoryInfo = this.versionHistoryInfoDao.selectByFeatureClassId(datasetDTO.getId());
        Assert.isNull((Object)versionHistoryInfo, (String)"\u7248\u672c\u5c42\u4e0d\u5141\u8bb8\u76f4\u63a5\u5220\u9664");
        LayerVersionKeyInfo keyVersionInfo = this.layerVersionKeyInfoDao.selectByWorkLayer(datasetDTO.getDsKey(), datasetDTO.getName());
        Assert.isNull((Object)keyVersionInfo, (String)"\u589e\u91cf\u5c42\u4e0d\u5141\u8bb8\u76f4\u63a5\u5220\u9664");
        return true;
    }

    private Boolean allowDeleteFeatureDataset(DatasetDTO datasetDTO) {
        FeatureDatasetDTO featureDatasetDTO = (FeatureDatasetDTO)datasetDTO;
        if (featureDatasetDTO == null || featureDatasetDTO.getSubsets() == null || featureDatasetDTO.getSubsets().size() == 0) {
            return true;
        }
        for (DatasetDTO subset : featureDatasetDTO.getSubsets()) {
            if (this.allowDeleteFeatureClass(subset).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private StFeatureClassDTO convertToDto(LayerVersionKeyInfo versionKeyInfo) {
        StFeatureClassDTO stFeatureClassDTO = new StFeatureClassDTO();
        stFeatureClassDTO.setName(versionKeyInfo.getLayerName());
        stFeatureClassDTO.setVersionKey(versionKeyInfo.getId());
        stFeatureClassDTO.setDatasetId(versionKeyInfo.getDatasetId());
        stFeatureClassDTO.setWorkLayerName(versionKeyInfo.getWorkLayer());
        DatasetNameInfo nameInfo = DatasetUtil.getDatasetNameInfo((String)versionKeyInfo.getDatasetId());
        String workLayerId = DatasetUtil.getDatasetId((String)nameInfo.getDsKey(), (DatasetTypeEnum)DatasetTypeEnum.FeatureClass, (String)("public." + versionKeyInfo.getWorkLayer()));
        stFeatureClassDTO.setWorkLayerDatasetId(workLayerId);
        stFeatureClassDTO.setUniqueField(versionKeyInfo.getUniqueField());
        stFeatureClassDTO.setTimestamp(versionKeyInfo.getTimestamp());
        VersionDatasetInfo versionDatasetInfo = (VersionDatasetInfo)JSONObject.parseObject((String)versionKeyInfo.getVersionInfo(), VersionDatasetInfo.class);
        stFeatureClassDTO.setVersionDatasetInfo(versionDatasetInfo);
        stFeatureClassDTO.setSpatial(versionKeyInfo.getSpatial());
        return stFeatureClassDTO;
    }

    private void addNonceFeatureDataset(SpatialTemporalDatasetCreateDTO createDTO) {
        this.createFeatureDataset(createDTO, false);
    }

    private void addWorkerFeatureDataset(SpatialTemporalDatasetCreateDTO createDTO) {
        createDTO.setName(createDTO.getName() + "_WORK");
        createDTO.setAliasName(createDTO.getAliasName() + "_WORK");
        this.createFeatureDataset(createDTO, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFeatureDataset(SpatialTemporalDatasetCreateDTO createDTO, Boolean isWorkLayer) {
        String dsKey = createDTO.getDsKey();
        try (IFeatureWorkspace featureWorkspace = this.geoDatabaseService.openGeoWorkspace(dsKey);){
            String newDatasetName = createDTO.getName();
            if (!StringUtil.isEmptyOrWhiteSpace((String)createDTO.getSchemaName())) {
                newDatasetName = createDTO.getSchemaName() + "." + createDTO.getName();
            }
            if (featureWorkspace.datasetExist(newDatasetName)) {
                throw new RuntimeException(newDatasetName + " \u5df2\u5b58\u5728\uff01");
            }
            String templateFile = createDTO.getTemplateFile();
            Assert.notNull((Object)srcWorkspace, (String)"\u6a21\u677f\u6570\u636e\u6253\u5f00\u5931\u8d25\uff01");
            try (IFeatureWorkspace srcWorkspace = WorkspaceUtil.openLocalFileGeodatabase((String)templateFile);){
                ISpatialReferenceSystem spatialReferenceSystem = SpatialReferenceSystemFunc.createSpatialReference((int)createDTO.getSrid());
                IFeatureDataset featureDataset = featureWorkspace.createFeatureDataset(newDatasetName, spatialReferenceSystem);
                Assert.notNull((Object)featureDataset, (String)"\u8981\u7d20\u6570\u636e\u96c6\u521b\u5efa\u5931\u8d25\uff01");
                if (StringUtil.isNotEmpty((String)createDTO.getAliasName()) && !createDTO.getAliasName().equals(createDTO.getName())) {
                    featureDataset.alterAliasName(createDTO.getAliasName());
                }
                String datasetId = GeoDatasetUtil.getGeoDatasetId((String)dsKey, (IGeoDataset)featureDataset);
                String dataPhase = createDTO.getDataPhase();
                if (StringUtil.isNotEmpty((String)dataPhase)) {
                    this.dataSourceManager.saveDatasetDataPhase(datasetId, dataPhase);
                }
                List srcDatasetList = srcWorkspace.getDatasets(new GeoDatasetType[]{GeoDatasetType.FeatureClass});
                for (IGeoDataset dataset : srcDatasetList) {
                    NameMapping nameMapping = (NameMapping)ListUtil.find((List)createDTO.getFeatureClassNameList(), nm -> dataset.getName().equals(nm.getSrcName()));
                    if (nameMapping == null) continue;
                    LayerGuidFieldDTO guidField = (LayerGuidFieldDTO)ListUtil.find(createDTO.getLayerGuidFieldList(), gf -> nameMapping.getTargetName().equals(gf.getTargetName()));
                    String guidFieldName = guidField == null ? "F_GUID" : guidField.getGuidFieldName();
                    IFeatureClass featureClass = this.createFeatureClass((IFeatureClass)dataset, nameMapping.getTargetName(), featureDataset, isWorkLayer, guidFieldName);
                    String id = GeoDatasetUtil.getGeoDatasetId((String)dsKey, (IGeoDataset)featureClass);
                    if (StringUtil.isNotEmpty((String)dataPhase)) {
                        this.dataSourceManager.saveDatasetDataPhase(id, dataPhase);
                    }
                    if (isWorkLayer.booleanValue()) continue;
                    LayerVersionKeyInfo versionKeyInfo = new LayerVersionKeyInfo();
                    versionKeyInfo.setDatasetId(id);
                    versionKeyInfo.setDsKey(dsKey);
                    versionKeyInfo.setLayerName(nameMapping.getTargetName());
                    versionKeyInfo.setWorkLayer(nameMapping.getTargetName() + "_WORK");
                    versionKeyInfo.setUniqueField(guidFieldName);
                    versionKeyInfo.setSpatial(featureClass.getSpatialReferenceSystem().getName());
                    versionKeyInfo.setScale(null);
                    VersionDatasetInfo versionDatasetInfo = new VersionDatasetInfo();
                    versionDatasetInfo.setDatasetNameNow(createDTO.getName());
                    versionDatasetInfo.setDatasetNameWork(createDTO.getName() + "_WORK");
                    versionKeyInfo.setVersionInfo(JSONObject.toJSONString((Object)versionDatasetInfo));
                    versionKeyInfo.setTimestamp(new Date());
                    this.layerVersionKeyInfoDao.insert(versionKeyInfo);
                }
            }
        }
    }

    private IFeatureClass createFeatureClass(IFeatureClass srcFeatClass, String name, IFeatureDataset targetFeatureDataset, Boolean isWorkLayer, String guidField) {
        if (isWorkLayer.booleanValue()) {
            name = name + "_WORK";
        }
        String shapeFieldName = srcFeatClass.getShapeFieldName();
        Fields newFields = new Fields();
        for (int i = 0; i < srcFeatClass.getFields().getFieldCount(); ++i) {
            IField tempField = srcFeatClass.getFields().getField(i).clone();
            if (tempField.getFieldType() == FieldType.Shape) {
                tempField.setName(shapeFieldName);
                ((GeometryField)tempField).setSpatialReferenceSystem(targetFeatureDataset.getSpatialReferenceSystem());
                ((GeometryField)tempField).setCoordinateType(CoordinateType.XY);
            }
            if (newFields.findFieldIndex(tempField.getName()) >= 0) continue;
            newFields.addField(tempField);
        }
        List<FieldDTO> exFields = isWorkLayer != false ? this.getWorkerLayerExFields(guidField) : this.getNonceLayerExFields(guidField);
        exFields.add(FieldUtil.convertField((IField)new Field("f_frame", "\u5206\u5e45\u540d\u79f0", FieldType.String, 60)));
        exFields.add(FieldUtil.convertField((IField)new Field("f_importtime", "\u5165\u5e93\u65f6\u95f4", FieldType.DateTime)));
        exFields.forEach(arg_0 -> SpatialTemporalDatasetServiceImpl.lambda$createFeatureClass$17((IFields)newFields, arg_0));
        IFeatureClass featureClass = targetFeatureDataset.createFeatureClass(name, (IFields)newFields, srcFeatClass.getFeatureType(), shapeFieldName, srcFeatClass.getSubTypeFieldName());
        if (featureClass == null) {
            throw new RuntimeException("\u8981\u7d20\u7c7b\u521b\u5efa\u5931\u8d25");
        }
        featureClass.createSpatialIndex();
        return featureClass;
    }

    private List<FieldDTO> getWorkerLayerExFields(String guidFld) {
        List<FieldDTO> result = this.getNonceLayerExFields(guidFld);
        result.add(this.buildFieldDTO("F_UPDATETYPE", "\u66f4\u65b0\u7c7b\u578b", FieldType.String, 200));
        result.add(this.buildFieldDTO("F_UPDATETIME", "\u66f4\u65b0\u65f6\u95f4", FieldType.DateTime, null));
        result.add(this.buildFieldDTO("F_TASKID2", "\u66f4\u65b0\u4efb\u52a1ID", FieldType.Long, null));
        return result;
    }

    private List<FieldDTO> getNonceLayerExFields(String guidFld) {
        ArrayList<FieldDTO> result = new ArrayList<FieldDTO>();
        result.add(this.buildFieldDTO(guidFld, "\u65f6\u7a7a\u6a21\u578b\u552f\u4e00\u6807\u8bc6", FieldType.String, 200));
        result.add(this.buildFieldDTO("F_TASKID", "\u66f4\u65b0\u4efb\u52a1ID", FieldType.Long, null));
        result.add(this.buildFieldDTO("F_FRAME", "\u66f4\u65b0\u533a\u57df", FieldType.String, 200));
        result.add(this.buildFieldDTO("F_TIME", "\u8981\u7d20\u65f6\u76f8", FieldType.DateTime, null));
        return result;
    }

    private FieldDTO buildFieldDTO(String name, String aliasName, FieldType fieldType, Integer length) {
        FieldDTO field = new FieldDTO();
        field.setName(name);
        field.setAliasName(aliasName);
        field.setFieldType(Integer.valueOf(fieldType.getValue()));
        field.setLength(length);
        field.setScale(null);
        field.setNullable(Boolean.valueOf(true));
        field.setDefaultValue(null);
        return field;
    }

    private Boolean isStFeatureClass(DatasetDTO datasetDTO) {
        LayerVersionKeyInfo keyVersionInfo = this.layerVersionKeyInfoDao.selectByFeatureClassId(datasetDTO.getId());
        if (keyVersionInfo != null) {
            return true;
        }
        VersionHistoryInfo versionHistoryInfo = this.versionHistoryInfoDao.selectByFeatureClassId(datasetDTO.getId());
        if (versionHistoryInfo != null) {
            return true;
        }
        keyVersionInfo = this.layerVersionKeyInfoDao.selectByWorkLayer(datasetDTO.getDsKey(), datasetDTO.getName());
        if (keyVersionInfo != null) {
            return true;
        }
        return false;
    }

    private Boolean isStFeatureDataset(DatasetDTO datasetDTO) {
        FeatureDatasetDTO featureDatasetDTO = (FeatureDatasetDTO)datasetDTO;
        if (featureDatasetDTO == null || featureDatasetDTO.getSubsets() == null || featureDatasetDTO.getSubsets().size() == 0) {
            return false;
        }
        for (DatasetDTO subset : featureDatasetDTO.getSubsets()) {
            if (!this.isStFeatureClass(subset).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private void deleteStFeatureClass(String datasetId) {
        LayerVersionKeyInfo keyInfo = this.layerVersionKeyInfoDao.selectByFeatureClassId(datasetId);
        VersionDatasetInfo versionDatasetInfo = (VersionDatasetInfo)JSONObject.parseObject((String)keyInfo.getVersionInfo(), VersionDatasetInfo.class);
        this.geoDatabaseService.deleteDataset(datasetId);
        this.deleteEmptyFeatureDataset(versionDatasetInfo.getDatasetNameNow(), keyInfo.getDsKey());
        String workLayerId = DatasetUtil.getDatasetId((String)keyInfo.getDsKey(), (DatasetTypeEnum)DatasetTypeEnum.FeatureClass, (String)keyInfo.getWorkLayer());
        this.geoDatabaseService.deleteDataset(workLayerId);
        this.deleteEmptyFeatureDataset(versionDatasetInfo.getDatasetNameWork(), keyInfo.getDsKey());
        List<VersionHistoryInfo> historyInfos = this.versionHistoryInfoDao.selectByKeyInfoId(keyInfo.getId());
        if (historyInfos != null) {
            for (VersionHistoryInfo historyInfo : historyInfos) {
                this.geoDatabaseService.deleteDataset(historyInfo.getDatasetId());
                this.versionHistoryInfoDao.deleteByPrimaryKey(historyInfo.getId());
                this.deleteEmptyFeatureDataset(versionDatasetInfo.getDatasetNameNow() + "_" + historyInfo.getVersionName(), keyInfo.getDsKey());
            }
        }
        this.layerVersionKeyInfoDao.deleteByPrimaryKey(keyInfo.getId());
        this.layerUpdateInfoDao.deleteByFeatureClassId(datasetId);
    }

    private void deleteEmptyFeatureDataset(String datasetName, String dsKey) {
        String datasetId = DatasetUtil.getDatasetId((String)dsKey, (DatasetTypeEnum)DatasetTypeEnum.FeatureDataset, (String)datasetName);
        FeatureDatasetDTO featureDatasetDTO = (FeatureDatasetDTO)this.dataSourceService.getDatasetDetail(datasetId);
        if (featureDatasetDTO != null && featureDatasetDTO.getSubsets().size() == 0) {
            this.geoDatabaseService.deleteDataset(datasetId);
        }
    }

    private void deleteStFeatureDataset(String datasetId) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo((String)datasetId);
        List<LayerUpdateInfo> layerUpdateInfos = this.layerUpdateInfoDao.selectByDbKeyAndDatasetName(datasetNameInfo.getDsKey(), datasetNameInfo.getName());
        List taskIds = ListUtil.convertAll(layerUpdateInfos, LayerUpdateInfo::getCaseId);
        FeatureDatasetDTO featureDatasetDTO = (FeatureDatasetDTO)this.dataSourceService.getDatasetDetail(datasetId);
        for (DatasetDTO dataset : featureDatasetDTO.getSubsets()) {
            this.deleteStFeatureClass(dataset.getId());
        }
        for (Long id : taskIds) {
            this.updateCaseInfoDao.deleteByPrimaryKey(id);
        }
    }

    private List<UpdateRecordDTO> getUpdateRecords(String datasetName, List<UpdateCaseInfo> allCaseInfos, List<LayerUpdateInfo> datasetGroup) {
        LinkedList<UpdateRecordDTO> result = new LinkedList<UpdateRecordDTO>();
        Map<Long, List<LayerUpdateInfo>> taskGroups = datasetGroup.stream().collect(Collectors.groupingBy(LayerUpdateInfo::getCaseId));
        for (Long caseId : taskGroups.keySet()) {
            if (!datasetName.equals(taskGroups.get(caseId).get(0).getDatasetName())) continue;
            UpdateCaseInfo updateCaseInfo = (UpdateCaseInfo)ListUtil.find(allCaseInfos, f -> f.getId().equals(caseId));
            result.add(this.convertUpdateRecord(updateCaseInfo, taskGroups.get(caseId)));
        }
        if (result.size() > 0) {
            result.sort((o1, o2) -> o1.getTime().before(o2.getTime()) ? 1 : -1);
            ((UpdateRecordDTO)result.get(0)).setCanCancel(true);
        }
        return result;
    }

    private UpdateRecordDTO convertUpdateRecord(UpdateCaseInfo updateCaseInfo, List<LayerUpdateInfo> updateLayers) {
        UpdateRecordDTO record = new UpdateRecordDTO();
        record.setCaseId(updateCaseInfo.getId());
        record.setCanCancel(false);
        record.setName(updateCaseInfo.getName());
        record.setDescription(updateCaseInfo.getDescription());
        record.setCreatePerson(updateCaseInfo.getBuildPerson());
        record.setResPerson(updateCaseInfo.getOperator());
        record.setTime(updateCaseInfo.getBuildTime());
        ArrayList<UpdateRecordLayerDTO> layers = new ArrayList<UpdateRecordLayerDTO>();
        for (LayerUpdateInfo layer : updateLayers) {
            UpdateRecordLayerDTO item = new UpdateRecordLayerDTO();
            item.setLayerName(layer.getLayerName());
            item.setPostDateTime(layer.getPostDateTime());
            item.setPreDateTime(layer.getPreDateTime());
            layers.add(item);
        }
        record.setLayers(layers);
        return record;
    }

    private FeatureUpdateInfo getFeatureUpdateInfo(FeatureResult featureResult, String dateFld) {
        FeatureUpdateInfo updateInfo = new FeatureUpdateInfo();
        updateInfo.setObjectId(featureResult.getObjectId());
        updateInfo.setGeometry(featureResult.getGeometry());
        updateInfo.setAttributes(featureResult.getAttributes());
        Object dateObj = featureResult.getAttributes().get(dateFld);
        updateInfo.setTimeSpan((Date)dateObj);
        return updateInfo;
    }

    private static /* synthetic */ void lambda$createFeatureClass$17(IFields newFields, FieldDTO field) {
        IField originField = newFields.findField(field.getName());
        if (originField != null) {
            originField.setAliasName(field.getAliasName());
        } else {
            newFields.addField(FieldUtil.convertField((FieldDTO)field));
        }
    }
}

