/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.webstore.datamodel.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.common.config.OutputPathConfig;
import com.geoway.adf.dms.common.util.DateTimeUtil;
import com.geoway.adf.dms.common.util.DownloadUtil;
import com.geoway.adf.dms.common.util.ExcelUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DatabaseDTO;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.dms.datasource.util.SpatailQueryUtil;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.geodb.FeatureType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.SpatialQueryFilter;
import com.geoway.adf.gis.geodb.filter.SpatialRelationType;
import com.geoway.webstore.datamodel.dao.LayerVersionKeyInfoDao;
import com.geoway.webstore.datamodel.dao.UpdateStatConfigDao;
import com.geoway.webstore.datamodel.dao.UpdateStatResultDao;
import com.geoway.webstore.datamodel.dto.spatialtemporal.VersionDatasetInfo;
import com.geoway.webstore.datamodel.dto.spatialtemporal.stat.UpdateStatFilterDTO;
import com.geoway.webstore.datamodel.dto.spatialtemporal.stat.UpdateStatResultDTO;
import com.geoway.webstore.datamodel.dto.spatialtemporal.stat.UpdateStatResultTableDTO;
import com.geoway.webstore.datamodel.entity.LayerVersionKeyInfo;
import com.geoway.webstore.datamodel.entity.UpdateStatConfig;
import com.geoway.webstore.datamodel.entity.UpdateStatResult;
import com.geoway.webstore.datamodel.service.SpatialTemporalStatService;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SpatialTemporalStatServiceImpl
implements SpatialTemporalStatService {
    private static final Logger log = LoggerFactory.getLogger(SpatialTemporalStatServiceImpl.class);
    @Resource
    private UpdateStatConfigDao statConfigDao;
    @Resource
    private UpdateStatResultDao statResultDao;
    @Resource
    private LayerVersionKeyInfoDao layerVersionKeyInfoDao;
    @Resource
    private GeoDatabaseService geoDatabaseService;
    private Map<String, Boolean> statingConfig = new HashMap<String, Boolean>(0);

    @Override
    public List<UpdateStatConfig> list() {
        return this.statConfigDao.selectAll();
    }

    @Override
    public String addConfig(UpdateStatConfig statConfig) {
        statConfig.setId(UUID.randomUUID().toString().replace("-", ""));
        if (StringUtil.isEmptyOrWhiteSpace((String)statConfig.getName())) {
            throw new RuntimeException("\u8bf7\u8bbe\u7f6e\u7edf\u8ba1\u5355\u5143\u540d\u79f0\uff01");
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)statConfig.getDatasetId())) {
            throw new RuntimeException("\u8bf7\u8bbe\u7f6e\u6570\u636e\u6765\u6e90\uff01");
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)statConfig.getGroupField())) {
            throw new RuntimeException("\u8bf7\u8bbe\u7f6e\u5206\u7ec4\u5b57\u6bb5\uff01");
        }
        DatasetNameInfo nameInfo = DatasetUtil.getDatasetNameInfo((String)statConfig.getDatasetId());
        if (nameInfo.getType().intValue() != DatasetTypeEnum.FeatureClass.getValue()) {
            throw new RuntimeException("\u6570\u636e\u6765\u6e90\u53ea\u80fd\u662f\u8981\u7d20\u7c7b\uff01");
        }
        Integer order = this.statConfigDao.queryMaxOrder();
        if (order == null) {
            order = 0;
        }
        statConfig.setOrder(order);
        this.statConfigDao.insert(statConfig);
        return statConfig.getId();
    }

    @Override
    public void updateConfig(UpdateStatConfig statConfig) {
        if (StringUtil.isEmptyOrWhiteSpace((String)statConfig.getId())) {
            throw new RuntimeException("\u4fee\u6539\u65f6\u8bf7\u8bbe\u7f6e\u6807\u8bc6");
        }
        UpdateStatConfig target = this.statConfigDao.selectByPrimaryKey(statConfig.getId());
        if (StringUtil.isEmptyOrWhiteSpace((String)statConfig.getName())) {
            throw new RuntimeException("\u8bf7\u8bbe\u7f6e\u7edf\u8ba1\u5355\u5143\u540d\u79f0\uff01");
        }
        target.setName(statConfig.getName());
        this.statConfigDao.updateByPrimaryKey(target);
    }

    @Override
    public void delete(String id) {
        this.statConfigDao.deleteByPrimaryKey(id);
        this.statResultDao.deleteByConfigId(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateStatResultTableDTO updateStat(UpdateStatFilterDTO statFilter) {
        List<UpdateStatResult> statResultList;
        UpdateStatResultTableDTO resultTableDTO = new UpdateStatResultTableDTO();
        String statConfigId = statFilter.getStatConfigId() == null ? "" : statFilter.getStatConfigId();
        boolean bySTDataset = StringUtil.isEmptyOrWhiteSpace((String)statConfigId);
        resultTableDTO.setDisplayDatasetNameNow(bySTDataset);
        resultTableDTO.setNameTile(bySTDataset ? "\u56fe\u5c42\u540d\u79f0" : "\u7edf\u8ba1\u5355\u5143");
        LinkedList<String> titles = new LinkedList<String>();
        if ("\u5168\u90e8".equals(statFilter.getUpdateType())) {
            titles.add("\u589e\u52a0");
            titles.add("\u4fee\u6539");
            titles.add("\u5220\u9664");
        } else {
            String[] typeList = statFilter.getUpdateType().split(",");
            titles.addAll(Arrays.asList(typeList));
        }
        resultTableDTO.setDisplayAdd(titles.contains("\u589e\u52a0"));
        resultTableDTO.setDisplayModify(titles.contains("\u4fee\u6539"));
        resultTableDTO.setDisplayDelete(titles.contains("\u5220\u9664"));
        List<LayerVersionKeyInfo> versionKeyInfoList = null;
        if (statFilter.getDatasetIdList() != null && statFilter.getDatasetIdList().size() > 0) {
            versionKeyInfoList = this.layerVersionKeyInfoDao.selectByFeatureClassIdList(statFilter.getDatasetIdList());
            resultTableDTO.setDisplayDatasetNameNow(false);
        } else {
            versionKeyInfoList = StringUtil.isNotEmpty((String)statFilter.getDsKey()) ? this.layerVersionKeyInfoDao.selectByDsKey(statFilter.getDsKey()) : this.layerVersionKeyInfoDao.selectAll();
        }
        if (versionKeyInfoList.size() == 0) {
            return resultTableDTO;
        }
        List datasetIdList = ListUtil.convertAll(versionKeyInfoList, LayerVersionKeyInfo::getDatasetId);
        if (!Boolean.TRUE.equals(statFilter.getUpdateStatResult())) {
            statResultList = this.statResultDao.selectByDatasetId(statConfigId, datasetIdList);
            if (statResultList == null || statResultList.size() == 0) {
                if (this.statingConfig.containsKey(statConfigId) && this.statingConfig.get(statConfigId).booleanValue()) {
                    throw new RuntimeException("\u6b63\u5728\u66f4\u65b0\u7edf\u8ba1\u7ed3\u679c\uff0c\u8bf7\u7a0d\u7b49\uff01");
                }
                try {
                    this.statingConfig.put(statConfigId, true);
                    this.stat(versionKeyInfoList, statConfigId);
                }
                finally {
                    this.statingConfig.put(statConfigId, false);
                }
            }
            return this.convertStatResult(statFilter, statResultList, resultTableDTO);
        }
        if (this.statingConfig.containsKey(statConfigId) && this.statingConfig.get(statConfigId).booleanValue()) {
            throw new RuntimeException("\u6b63\u5728\u66f4\u65b0\u7edf\u8ba1\u7ed3\u679c\uff0c\u8bf7\u7a0d\u7b49\uff01");
        }
        try {
            this.statingConfig.put(statConfigId, true);
            this.statResultDao.deleteByDatasetId(statConfigId, datasetIdList);
            this.stat(versionKeyInfoList, statConfigId);
        }
        finally {
            this.statingConfig.put(statConfigId, false);
        }
        statResultList = this.statResultDao.selectByDatasetId(statConfigId, datasetIdList);
        return this.convertStatResult(statFilter, statResultList, resultTableDTO);
    }

    @Override
    public String exportStatResult(UpdateStatFilterDTO statFilter) {
        File excelFile;
        statFilter.setUpdateStatResult(false);
        UpdateStatResultTableDTO resultTable = this.updateStat(statFilter);
        String excelPath = "";
        String id = UUID.randomUUID().toString();
        Path localPath = OutputPathConfig.getOutputPath().resolve(id);
        if (!localPath.toFile().exists()) {
            localPath.toFile().mkdirs();
        }
        if ((excelFile = new File(excelPath = Paths.get(localPath.toString(), "\u7edf\u8ba1\u7ed3\u679c.xlsx").toString())).exists()) {
            excelFile.delete();
        }
        ExcelUtil.registerConverter();
        try (ExcelWriter excelWriter = EasyExcel.write((File)excelFile).build();){
            WriteSheet writeSheet = EasyExcel.writerSheet((String)"\u7edf\u8ba1\u7ed3\u679c").build();
            ArrayList dataList = new ArrayList();
            LinkedList<String> titles = new LinkedList<String>();
            if (resultTable.getDisplayDatasetNameNow().booleanValue()) {
                titles.add("\u6570\u636e\u96c6");
            }
            titles.add(resultTable.getNameTile());
            if (resultTable.getDisplayAdd().booleanValue()) {
                titles.add("\u589e\u52a0");
            }
            if (resultTable.getDisplayModify().booleanValue()) {
                titles.add("\u4fee\u6539");
            }
            if (resultTable.getDisplayDelete().booleanValue()) {
                titles.add("\u5220\u9664");
            }
            titles.add("\u5408\u8ba1");
            dataList.add(titles);
            for (UpdateStatResultDTO statResult : resultTable.getStatResult()) {
                LinkedList<Object> item = new LinkedList<Object>();
                if (resultTable.getDisplayDatasetNameNow().booleanValue()) {
                    item.add(statResult.getDatasetName());
                }
                item.add(statResult.getName());
                if (resultTable.getDisplayAdd().booleanValue()) {
                    item.add(statResult.getAddCount());
                }
                if (resultTable.getDisplayModify().booleanValue()) {
                    item.add(statResult.getModifyCount());
                }
                if (resultTable.getDisplayDelete().booleanValue()) {
                    item.add(statResult.getDeleteCount());
                }
                dataList.add(item);
            }
            excelWriter.write(dataList, writeSheet);
        }
        return id;
    }

    @Override
    public void downloadStatResult(String id) {
        Path localPath = OutputPathConfig.getOutputPath().resolve(id);
        File dir = localPath.toFile();
        if (!dir.exists()) {
            log.error("\u6587\u4ef6\u4e22\u5931\uff0c\u4e0b\u8f7d\u5931\u8d25\uff01");
            return;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length > 0) {
            DownloadUtil.downloadFile((String)files[0].getPath());
        }
    }

    private UpdateStatResultTableDTO convertStatResult(UpdateStatFilterDTO statFilter, List<UpdateStatResult> statResultList, UpdateStatResultTableDTO resultTable) {
        DateTime startDate = null;
        DateTime endDate = null;
        if (StringUtil.isNotEmpty((String)statFilter.getStartTime()) && StringUtil.isNotEmpty((String)statFilter.getEndTime())) {
            startDate = DateUtil.parseDate((CharSequence)statFilter.getStartTime());
            endDate = DateUtil.parseDate((CharSequence)statFilter.getEndTime());
            String startDateStr = DateTimeUtil.dateString((Date)startDate, (String)"yyyy-MM-dd") + " 00:00:00";
            String endDateStr = DateTimeUtil.dateString((Date)endDate, (String)"yyyy-MM-dd") + " 23:59:59";
            startDate = DateUtil.parseDate((CharSequence)startDateStr);
            endDate = DateUtil.parseDate((CharSequence)endDateStr);
        }
        ArrayList<UpdateStatResultDTO> resultList = new ArrayList<UpdateStatResultDTO>();
        if (statResultList == null || statResultList.size() == 0) {
            return resultTable;
        }
        int addSum = 0;
        int modifySum = 0;
        int deleteSum = 0;
        Map<String, List<UpdateStatResult>> group = null;
        group = StringUtil.isEmptyOrWhiteSpace((String)statFilter.getStatConfigId()) ? statResultList.stream().collect(Collectors.groupingBy(UpdateStatResult::getDatasetId)) : statResultList.stream().collect(Collectors.groupingBy(UpdateStatResult::getName));
        for (String datasetId : group.keySet()) {
            List<UpdateStatResult> list = group.get(datasetId);
            int addCount = 0;
            int modifyCount = 0;
            int deleteCount = 0;
            UpdateStatResultDTO result = new UpdateStatResultDTO();
            if (resultTable.getDisplayDatasetNameNow().booleanValue()) {
                result.setDatasetName(list.get(0).getDatasetNameNow());
            } else {
                result.setDatasetName("");
            }
            for (UpdateStatResult item : list) {
                if (startDate != null && (item.getUpdateTime() == null || item.getUpdateTime().before((Date)startDate) || item.getUpdateTime().after((Date)endDate))) continue;
                if (!resultTable.getDisplayAdd().booleanValue()) {
                    item.setAdd(0);
                }
                if (!resultTable.getDisplayModify().booleanValue()) {
                    item.setModify(0);
                }
                if (!resultTable.getDisplayDelete().booleanValue()) {
                    item.setDelete(0);
                }
                addCount += item.getAdd().intValue();
                modifyCount += item.getModify().intValue();
                deleteCount += item.getDelete().intValue();
            }
            result.setName(list.get(0).getName());
            result.setAddCount(addCount);
            result.setModifyCount(modifyCount);
            result.setDeleteCount(deleteCount);
            result.setCount(addCount + modifyCount + deleteCount);
            resultList.add(result);
            addSum += addCount;
            modifySum += modifyCount;
            deleteSum += deleteCount;
        }
        UpdateStatResultDTO sum = new UpdateStatResultDTO();
        if (resultTable.getDisplayDatasetNameNow().booleanValue()) {
            sum.setDatasetName("\u5408\u8ba1");
            sum.setName("");
            resultList.sort(Comparator.comparing(UpdateStatResultDTO::getDatasetName));
        } else {
            sum.setDatasetName("");
            sum.setName("\u5408\u8ba1");
            resultList.sort(Comparator.comparing(UpdateStatResultDTO::getName));
        }
        sum.setAddCount(addSum);
        sum.setModifyCount(modifySum);
        sum.setDeleteCount(deleteSum);
        sum.setCount(addSum + modifySum + deleteSum);
        resultList.add(sum);
        resultTable.setStatResult(resultList);
        return resultTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stat(List<LayerVersionKeyInfo> versionKeyInfoList, String statConfigId) {
        HashMap<String, IGeometry> groupMap = new HashMap<String, IGeometry>(0);
        ISpatialReferenceSystem rangeSr = null;
        if (StringUtil.isNotEmpty((String)statConfigId)) {
            UpdateStatConfig statConfig = this.statConfigDao.selectByPrimaryKey(statConfigId);
            Assert.notNull((Object)statConfig, (String)"\u672a\u627e\u5230\u66f4\u65b0\u7edf\u8ba1\u914d\u7f6e\uff01");
            DatasetNameInfo nameInfo = DatasetUtil.getDatasetNameInfo((String)statConfig.getDatasetId());
            DatabaseDTO databaseDTO = this.geoDatabaseService.getDatabaseDetail(nameInfo.getDsKey());
            Assert.notNull((Object)statConfig, (String)"\u672a\u627e\u5230\u66f4\u65b0\u7edf\u8ba1\u914d\u7f6e\u7684\u7a7a\u95f4\u5e93\uff01");
            IFeatureWorkspace workspace = null;
            IFeatureCursor cursor = null;
            try {
                workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)databaseDTO);
                IFeatureClass fc = workspace.openFeatureClass(nameInfo.getShortName());
                Assert.notNull((Object)statConfig, (String)"\u66f4\u65b0\u7edf\u8ba1\u914d\u7f6e\u7684\u8981\u7d20\u91cf\u6253\u5f00\u5931\u8d25\uff01");
                int groupFiledIndex = fc.getFields().findFieldIndex(statConfig.getGroupField());
                if (groupFiledIndex < 0) {
                    throw new RuntimeException("\u672a\u627e\u5230\u66f4\u65b0\u7edf\u8ba1\u914d\u7f6e\u7684\u5206\u7ec4\u5b57\u6bb5\uff01");
                }
                rangeSr = fc.getSpatialReferenceSystem();
                cursor = fc.searchFeature(null);
                IFeature feature = null;
                while ((feature = cursor.nextFeature()) != null) {
                    Object groupNameObj = feature.getValue(groupFiledIndex);
                    String groupName = "<\u7a7a\u503c>";
                    if (groupNameObj != null && StringUtil.isNotEmpty((String)groupNameObj.toString())) {
                        groupName = groupNameObj.toString();
                    }
                    if (groupMap.containsKey(groupName)) {
                        IGeometry unionGeometry = ((IGeometry)groupMap.get(groupName)).union(feature.getGeometry());
                        if (unionGeometry == null) continue;
                        groupMap.put(groupName, unionGeometry);
                        continue;
                    }
                    groupMap.put(groupName, feature.getGeometry());
                }
                if (groupMap.size() == 0) {
                    throw new RuntimeException("\u66f4\u65b0\u7edf\u8ba1\u914d\u7f6e\u6570\u636e\u6e90\u4e2d\u672a\u627e\u5230\u7edf\u8ba1\u8303\u56f4\uff01");
                }
            }
            finally {
                if (cursor != null) {
                    cursor.release();
                }
                if (workspace != null) {
                    workspace.close();
                }
            }
        }
        ArrayList<UpdateStatResult> resultList = new ArrayList<UpdateStatResult>();
        Map<String, List<LayerVersionKeyInfo>> dsGroup = versionKeyInfoList.stream().collect(Collectors.groupingBy(LayerVersionKeyInfo::getDsKey));
        for (String dsKey : dsGroup.keySet()) {
            List<LayerVersionKeyInfo> layerList = dsGroup.get(dsKey);
            DatabaseDTO databaseDTO = this.geoDatabaseService.getDatabaseDetail(dsKey);
            IFeatureWorkspace workspace = null;
            try {
                workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)databaseDTO);
                for (LayerVersionKeyInfo keyInfo : layerList) {
                    resultList.addAll(this.statLayer(workspace, keyInfo, groupMap, rangeSr, statConfigId));
                }
            }
            finally {
                if (workspace == null) continue;
                workspace.close();
            }
        }
        if (resultList.size() > 0) {
            this.statResultDao.batchInsert(resultList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<UpdateStatResult> statLayer(IFeatureWorkspace workspace, LayerVersionKeyInfo keyInfo, Map<String, IGeometry> groupMap, ISpatialReferenceSystem rangeSr, String configId) {
        VersionDatasetInfo versionDatasetInfo = (VersionDatasetInfo)JSONObject.parseObject((String)keyInfo.getVersionInfo(), VersionDatasetInfo.class);
        String datasetNameNow = versionDatasetInfo.getDatasetNameNow();
        ArrayList<UpdateStatResult> resultList = new ArrayList<UpdateStatResult>();
        IFeatureClass fc = workspace.openFeatureClass(keyInfo.getWorkLayer());
        if (fc == null) {
            log.error(String.format("\u66f4\u65b0\u7edf\u8ba1[%s]\u7684\u589e\u91cf\u5c42[%s]\u6253\u5f00\u5931\u8d25\uff01", keyInfo.getLayerName(), keyInfo.getWorkLayer()));
            return new ArrayList<UpdateStatResult>();
        }
        if (groupMap.size() > 0) {
            for (String groupName : groupMap.keySet()) {
                IFeatureCursor cursor = null;
                IGeometry queryGeometry = groupMap.get(groupName);
                queryGeometry = queryGeometry.projectToCopy(rangeSr, fc.getSpatialReferenceSystem());
                SpatialQueryFilter filter = new SpatialQueryFilter();
                filter.setGeometry(queryGeometry);
                filter.setSpatialRels(SpatailQueryUtil.getSpatialRelationships((SpatialRelationType)SpatialRelationType.Overlaps, (IGeometry)queryGeometry, (FeatureType)fc.getFeatureType()));
                filter.setWhereClause(String.format("%s is not null", "F_UPDATETYPE"));
                try {
                    cursor = fc.searchFeature((IQueryFilter)filter);
                    IFeature feature = null;
                    HashMap<Date, UpdateStatResult> updateTimeGroup = new HashMap<Date, UpdateStatResult>(0);
                    int featureCount = 0;
                    while ((feature = cursor.nextFeature()) != null) {
                        ++featureCount;
                        String updateType = feature.getValue("F_UPDATETYPE").toString();
                        Date updateTime = (Date)feature.getValue("F_UPDATETIME");
                        UpdateStatResult result = null;
                        result = updateTimeGroup.containsKey(updateTime) ? (UpdateStatResult)updateTimeGroup.get(updateTime) : new UpdateStatResult(configId, groupName, 0, 0, 0, updateTime, datasetNameNow, keyInfo.getDsKey(), keyInfo.getDatasetId());
                        if (updateType.contains("\u4fee\u6539")) {
                            result.setModify(result.getModify() + 1);
                        } else if ("\u589e\u52a0".equals(updateType)) {
                            result.setAdd(result.getAdd() + 1);
                        } else if ("\u5220\u9664".equals(updateType)) {
                            result.setDelete(result.getDelete() + 1);
                        }
                        updateTimeGroup.put(updateTime, result);
                    }
                    for (Date time : updateTimeGroup.keySet()) {
                        resultList.add((UpdateStatResult)updateTimeGroup.get(time));
                    }
                    if (featureCount != 0) continue;
                    resultList.add(new UpdateStatResult(configId, groupName, 0, 0, 0, null, datasetNameNow, keyInfo.getDsKey(), keyInfo.getDatasetId()));
                }
                finally {
                    if (cursor == null) continue;
                    cursor.release();
                }
            }
        } else {
            String statSql = String.format("select %s, %s, count(%s) as count from %s where %s is not null group by %s, %s", "F_UPDATETYPE", "F_UPDATETIME", "F_UPDATETYPE", keyInfo.getWorkLayer(), "F_UPDATETYPE", "F_UPDATETYPE", "F_UPDATETIME");
            List queryData = workspace.queryList(statSql, new Object[0]);
            HashMap<Date, UpdateStatResult> updateTimeGroup = new HashMap<Date, UpdateStatResult>(0);
            if (queryData.size() == 0) {
                resultList.add(new UpdateStatResult(configId, keyInfo.getLayerName(), 0, 0, 0, null, datasetNameNow, keyInfo.getDsKey(), keyInfo.getDatasetId()));
            }
            for (Map map : queryData) {
                String updateType = map.get("F_UPDATETYPE".toLowerCase(Locale.ROOT)).toString();
                Date updateTime = (Date)map.get("F_UPDATETIME".toLowerCase(Locale.ROOT));
                int count = Integer.parseInt(map.get("count").toString());
                UpdateStatResult result = null;
                result = updateTimeGroup.containsKey(updateTime) ? (UpdateStatResult)updateTimeGroup.get(updateTime) : new UpdateStatResult(configId, keyInfo.getLayerName(), 0, 0, 0, updateTime, datasetNameNow, keyInfo.getDsKey(), keyInfo.getDatasetId());
                if (updateType.contains("\u4fee\u6539")) {
                    result.setModify(result.getModify() + count);
                } else if ("\u589e\u52a0".equals(updateType)) {
                    result.setAdd(result.getAdd() + count);
                } else if ("\u5220\u9664".equals(updateType)) {
                    result.setDelete(result.getDelete() + count);
                }
                updateTimeGroup.put(updateTime, result);
            }
            for (Date time : updateTimeGroup.keySet()) {
                resultList.add((UpdateStatResult)updateTimeGroup.get(time));
            }
        }
        return resultList;
    }
}

