/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.webstore.datamodel.typehandler;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class BlobToJSONObjectTypeHandler
extends BaseTypeHandler<JSONObject> {
    private static final String DEFAULT_CHARSET = "utf-8";

    public void setNonNullParameter(PreparedStatement ps, int i, JSONObject parameter, JdbcType paramJdbcType) throws SQLException {
        try {
            String jsonString = parameter.toJSONString();
            byte[] data = jsonString.getBytes(DEFAULT_CHARSET);
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            ps.setBinaryStream(i, (InputStream)bis, data.length);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public JSONObject getNullableResult(ResultSet rs, String columnName) throws SQLException {
        byte[] returnValue = rs.getBytes(columnName);
        JSONObject result = null;
        try {
            if (returnValue != null) {
                String jsonString = new String(returnValue, DEFAULT_CHARSET);
                result = JSONObject.parseObject((String)jsonString);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public JSONObject getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        byte[] returnValue = rs.getBytes(columnIndex);
        JSONObject result = null;
        try {
            if (returnValue != null) {
                String jsonString = new String(returnValue, DEFAULT_CHARSET);
                result = JSONObject.parseObject((String)jsonString);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public JSONObject getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        byte[] returnValue = cs.getBytes(columnIndex);
        JSONObject result = null;
        try {
            if (returnValue != null) {
                String jsonString = new String(returnValue, DEFAULT_CHARSET);
                result = JSONObject.parseObject((String)jsonString);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }
}

