/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.webstore.datamodel.util;

import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.constant.ServiceFormatEnum;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.ServiceDatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.TileDatasetDTO;
import com.geoway.adf.gis.geosrv.ServiceType;
import com.geoway.adf.gis.tile.ITileDataset;
import com.geoway.adf.gis.tile.TileType;
import com.geoway.adf.gis.tile.meta.MapExtent;
import com.geoway.adf.gis.tile.meta.TileRange;
import com.geoway.adf.gis.tile.meta.TileSchema;
import com.geoway.adf.gis.tile.meta.TileTransform;
import com.geoway.adf.gis.tile.mongo.MongoTileDataSource;
import com.geoway.adf.gis.tile.wmts.WMTSTileDataSource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class TileUtil {
    public static List<MapExtent> parseToBundleMultiPartExtent(TileSchema tileSchema, int level, MapExtent totalExtent) {
        TileRange tileRange = TileTransform.worldToTile((MapExtent)totalExtent, (int)level, (TileSchema)tileSchema);
        int startRow = tileRange.getFirstRow();
        int endRow = tileRange.getFirstRow() + tileRange.getRowCount() - 1;
        int startCol = tileRange.getFirstCol();
        int endCol = tileRange.getFirstCol() + tileRange.getColCount() - 1;
        int tilePreCount = TileUtil.getTilePreCount(tileRange);
        int bundleStartCol = startCol / tilePreCount;
        int bundleEndCol = endCol / tilePreCount;
        int bundleStartRow = startRow / tilePreCount;
        int bundleEndRow = endRow / tilePreCount;
        ArrayList<MapExtent> tileExtents = new ArrayList<MapExtent>();
        for (int col = bundleStartCol; col <= bundleEndCol; ++col) {
            for (int row = bundleStartRow; row <= bundleEndRow; ++row) {
                TileRange range = new TileRange(col * tilePreCount, row * tilePreCount, tilePreCount, tilePreCount);
                MapExtent subExtent = TileTransform.tileToWorld((TileRange)range, (int)level, (TileSchema)tileSchema);
                double minX = Math.max(subExtent.getMinX().doubleValue(), totalExtent.getMinX().doubleValue());
                double minY = Math.max(subExtent.getMinY().doubleValue(), totalExtent.getMinY().doubleValue());
                double maxX = Math.min(subExtent.getMaxX().doubleValue(), totalExtent.getMaxX().doubleValue());
                double maxY = Math.min(subExtent.getMaxY().doubleValue(), totalExtent.getMaxY().doubleValue());
                MapExtent rangeExtent = new MapExtent();
                rangeExtent.setMinX(new BigDecimal(minX));
                rangeExtent.setMinY(new BigDecimal(minY));
                rangeExtent.setMaxX(new BigDecimal(maxX));
                rangeExtent.setMaxY(new BigDecimal(maxY));
                if (rangeExtent.getMinX().doubleValue() >= rangeExtent.getMaxX().doubleValue() || rangeExtent.getMinY().doubleValue() >= rangeExtent.getMaxY().doubleValue()) {
                    throw new RuntimeException(String.format("\u7ea7\u522b%d\u7684\u8303\u56f4%s\u5904\u7406\u51fa\u9519\u3002", level, totalExtent.toString()));
                }
                tileExtents.add(rangeExtent);
            }
        }
        return tileExtents;
    }

    public static int getTilePreCount(TileRange tileRange) {
        int[] tilePreCountArray = new int[]{1024, 512, 256, 128, 64};
        int tilePreCount = tilePreCountArray[0];
        int threadCount = 4;
        int[] nArray = tilePreCountArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int item;
            tilePreCount = item = nArray[i];
            if ((tileRange.getRowCount() + tileRange.getColCount()) / tilePreCount > threadCount) break;
        }
        return tilePreCount;
    }

    public static ITileDataset convertTileDataset(DatasetDTO datasetDTO) {
        DatasetTypeEnum datasetType = DatasetTypeEnum.getByValue((Integer)datasetDTO.getType());
        switch (datasetType) {
            case TileDataset: {
                TileDatasetDTO tileDatasetDTO = (TileDatasetDTO)datasetDTO;
                if (tileDatasetDTO.getTileType().intValue() != TileType.RasterTile.getValue() || datasetDTO.getDataSource().getDataSourceType().intValue() != DataSourceTypeEnum.MongoDB.getValue()) break;
                MongoTileDataSource mongoTileDataSource = new MongoTileDataSource(datasetDTO.getDataSource().getUrl(), datasetDTO.getDataSource().getUserName(), datasetDTO.getDataSource().getPassword());
                if (!mongoTileDataSource.connect()) {
                    throw new RuntimeException(datasetDTO.getDataSource().getUrl() + "\u8fde\u63a5\u5931\u8d25");
                }
                ITileDataset tileDataset = mongoTileDataSource.getDataset(datasetDTO.getName());
                if (tileDataset == null) {
                    mongoTileDataSource.close();
                    throw new RuntimeException(datasetDTO.getName() + " \u74e6\u7247\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25");
                }
                return tileDataset;
            }
            case ServiceDataset: {
                ServiceDatasetDTO serviceDatasetDTO = (ServiceDatasetDTO)datasetDTO;
                if (serviceDatasetDTO.getServiceType().intValue() != ServiceType.RasterTileService.getValue() || !Integer.valueOf(ServiceFormatEnum.WMTS.getValue()).equals(serviceDatasetDTO.getServiceFormat())) break;
                WMTSTileDataSource wmtsTileDataSource = new WMTSTileDataSource(serviceDatasetDTO.getServiceUrl());
                if (!wmtsTileDataSource.connect()) {
                    throw new RuntimeException(datasetDTO.getDataSource().getUrl() + "\u8fde\u63a5\u5931\u8d25");
                }
                List tileDatasetList = wmtsTileDataSource.getDatasets();
                if (tileDatasetList == null || tileDatasetList.size() == 0) {
                    throw new RuntimeException("\u672a\u8bfb\u53d6\u5230wmts\u670d\u52a1\u56fe\u5c42");
                }
                return (ITileDataset)tileDatasetList.get(0);
            }
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u96c6\u7c7b\u578b\uff1a" + datasetType);
    }
}

