/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.webstore.update.manager;

import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DatabaseDTO;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureDataset;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.webstore.datamodel.entity.LayerVersionKeyInfo;
import com.geoway.webstore.datamodel.entity.VersionHistoryInfo;
import com.geoway.webstore.update.dto.LayerUpdateLogRecord;
import com.geoway.webstore.update.dto.SpatioTemporalDatasetInfo;
import com.geoway.webstore.update.manager.DataUpdater;
import com.geoway.webstore.update.manager.LayerUpdaterHistoryVer;
import com.geoway.webstore.update.manager.listener.IProgressMessageCallBack;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeowayDataUpdaterHistoryVer
extends DataUpdater {
    private static final Logger log = LoggerFactory.getLogger(GeowayDataUpdaterHistoryVer.class);
    public IProgressMessageCallBack createVersionDatasetFinished;
    private IFeatureWorkspace workspace;

    protected void invokeCreateVersionDatasetFinished(String msg) {
        if (this.createVersionDatasetFinished != null) {
            this.createVersionDatasetFinished.callBack(msg);
        }
    }

    @Override
    public void setTargetDbKey(String dbKey) {
        super.setTargetDbKey(dbKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean run() {
        DatabaseDTO dataSourceDTO = this.geoDatabaseService.getDatabaseDetail(this.dbKey);
        this.workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)dataSourceDTO);
        if (this.workspace == null) {
            throw new RuntimeException("\u65e0\u6cd5\u6253\u5f00\u5de5\u4f5c\u7a7a\u95f4");
        }
        String sMessage = "";
        this.logRecords.clear();
        String versionLayerName = "";
        this.invokeProgressCountChanged(this.layers.size());
        int count = 0;
        try {
            for (SpatioTemporalDatasetInfo stDataInfo : this.layers) {
                this.invokeProgressPositionChanged(count++);
                this.invokeLayerUpdateChanged(stDataInfo);
                versionLayerName = stDataInfo.getTargetLayerName();
                this.invokeProgressMessageChanged(String.format("\u5f00\u59cb\u521b\u5efa\u56fe\u5c42[%s]\u2026", versionLayerName));
                this.registerHistoryVersion(stDataInfo, versionLayerName, count);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.invokeProgressMessageChanged(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.workspace != null) {
                this.workspace.close();
            }
        }
        this.invokeProgressPositionChanged(this.layers.size());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerHistoryVersion(SpatioTemporalDatasetInfo stDataInfo, String versionLayerName, Integer index) {
        String sMessage = "";
        ISpatialReferenceSystem spatialRef = null;
        SimpleDateFormat formatDay = new SimpleDateFormat("yyyy-MM-dd");
        LayerUpdateLogRecord logRecord = new LayerUpdateLogRecord();
        logRecord.setSrcLayerName(stDataInfo.getSourceLayerName());
        logRecord.setTarLayerName(stDataInfo.getTargetLayerName());
        String targetDatasetName = stDataInfo.getTargetDatasetName();
        try {
            SpatioTemporalDatasetInfo versionDatasetInfo = new SpatioTemporalDatasetInfo();
            versionDatasetInfo.setTime(stDataInfo.getTime());
            versionDatasetInfo.setTargetDatasetName(targetDatasetName);
            versionDatasetInfo.setTargetLayerName(stDataInfo.getTargetLayerName());
            IFeatureClass nonceFc = (IFeatureClass)stDataInfo.getDatasetObj();
            Date versionTime = stDataInfo.getTime();
            LayerVersionKeyInfo versionKeyInfo = this.versionKeyInfoDao.selectByNonceLayer(this.dbKey, stDataInfo.getSourceLayerName());
            if (versionKeyInfo == null) {
                sMessage = String.format("\u56fe\u5c42[%s]\u521b\u5efa\u5f02\u5e38\u3002\u539f\u56e0\uff1a\u672a\u67e5\u8be2\u5230\u65f6\u7a7a\u6570\u636e\u96c6\uff01", versionLayerName);
                logRecord.setSuccess(false);
                return;
            }
            Date nearVersionTime = versionKeyInfo.getTimestamp();
            VersionHistoryInfo nearVersion = this.getNearestVersion(versionKeyInfo, versionTime);
            if (nearVersion == null) {
                nearVersionTime = versionKeyInfo.getTimestamp();
                versionDatasetInfo.setSourceLayerName(stDataInfo.getSourceLayerName());
                versionDatasetInfo.setDatasetObj(nonceFc);
            } else {
                if (nearVersion.getStartTime() == versionTime) {
                    sMessage = String.format("\u56fe\u5c42[%s]\u5df2\u5b58\u5728\u65f6\u76f8[%s]\u7684\u7248\u672c\uff0c\u4e0d\u518d\u521b\u5efa\u3002", stDataInfo.getSourceLayerName(), formatDay.format(versionTime));
                    logRecord.setSuccess(true);
                    return;
                }
                nearVersionTime = nearVersion.getStartTime();
                IFeatureClass nearVersionFc = this.workspace.openFeatureClass(nearVersion.getLayerName());
                versionDatasetInfo.setSourceLayerName(nearVersion.getLayerName());
                versionDatasetInfo.setDatasetObj(nearVersionFc);
            }
            IFeatureClass versionFc = this.createVersion(nonceFc, targetDatasetName, versionLayerName, spatialRef);
            if (versionFc == null) {
                sMessage = String.format("\u56fe\u5c42[%s]\u521b\u5efa\u5931\u8d25\u3002", versionLayerName);
                logRecord.setSuccess(false);
                return;
            }
            this.invokeCreateVersionDatasetFinished(versionLayerName);
            LayerUpdaterHistoryVer updater = new LayerUpdaterHistoryVer();
            updater.progressMessageChanged = x$0 -> super.invokeProgressMessageChanged(x$0);
            updater.versionKeyInfo = versionKeyInfo;
            updater.nearestVersionTime = nearVersionTime;
            updater.setGwWorkspace(this.dbKey);
            updater.update(versionDatasetInfo, logRecord);
            sMessage = logRecord.getSuccess().booleanValue() ? String.format("\u56fe\u5c42[%s]\u521b\u5efa\u5b8c\u6210\u3002", versionLayerName) : logRecord.getLogInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
            sMessage = String.format("\u56fe\u5c42[%s]\u521b\u5efa\u5f02\u5e38\u3002\u539f\u56e0\uff1a%s", versionLayerName, e.getMessage());
            logRecord.setSuccess(false);
        }
        finally {
            logRecord.setLogInfo(sMessage);
            this.logRecords.add(logRecord);
            this.invokeProgressMessageChanged(sMessage);
            this.invokeProgressPositionChanged(index);
            this.invokeLayerUpdateFinished(stDataInfo, logRecord);
        }
    }

    private IFeatureClass createVersion(IFeatureClass srcFc, String targetDatasetName, String targetFcName, ISpatialReferenceSystem spatialRef) {
        IFeatureDataset tarFeatureDataset = null;
        String sMessage = "";
        if (spatialRef == null) {
            spatialRef = srcFc.getSpatialReferenceSystem();
        }
        tarFeatureDataset = this.createFeatureDataset(targetDatasetName, spatialRef);
        IFeatureClass nonceFc = null;
        if (this.workspace.datasetExist(targetFcName)) {
            sMessage = String.format("\u56fe\u5c42[%s]\u5df2\u7ecf\u5b58\u5728\u3002", targetFcName);
            nonceFc = this.workspace.openFeatureClass(targetFcName);
        } else {
            nonceFc = tarFeatureDataset.createFeatureClass(targetFcName, srcFc.getFields(), srcFc.getFeatureType(), srcFc.getShapeFieldName(), srcFc.getSubTypeFieldName());
            if (null != nonceFc) {
                sMessage = String.format("\u521b\u5efa\u56fe\u5c42[%s]\u6210\u529f\u3002", targetFcName);
                nonceFc.createSpatialIndex();
            } else {
                sMessage = String.format("\u521b\u5efa\u56fe\u5c42[%s]\u5931\u8d25\u3002", targetFcName);
            }
        }
        this.invokeProgressMessageChanged(sMessage);
        return nonceFc;
    }

    private IFeatureDataset createFeatureDataset(String featureDataSetName, ISpatialReferenceSystem spatialRef) {
        IFeatureDataset iFeatureDataset = this.workspace.openFeatureDataset(featureDataSetName);
        if (iFeatureDataset == null && (iFeatureDataset = this.workspace.createFeatureDataset(featureDataSetName, spatialRef)) == null) {
            throw new RuntimeException("\u521b\u5efa\u8981\u7d20\u96c6\u5931\u8d25");
        }
        return iFeatureDataset;
    }

    private VersionHistoryInfo getNearestVersion(LayerVersionKeyInfo versionKeyInfo, Date versionTime) {
        SimpleDateFormat formatDay = new SimpleDateFormat("yyyy-MM-dd");
        VersionHistoryInfo version = null;
        try {
            Date nearVersionTime = formatDay.parse("9999-12-30");
            List versions = this.versionHistoryInfoDao.selectByKeyInfoId(versionKeyInfo.getId());
            if (versions != null && versions.size() != 0) {
                for (int i = 0; i < versions.size(); ++i) {
                    boolean isAfter;
                    boolean bl = isAfter = ((VersionHistoryInfo)versions.get(i)).getStartTime().after(versionTime) || ((VersionHistoryInfo)versions.get(i)).getStartTime() == versionTime;
                    if (!isAfter || !((VersionHistoryInfo)versions.get(i)).getStartTime().before(nearVersionTime)) continue;
                    version = (VersionHistoryInfo)versions.get(i);
                    nearVersionTime = ((VersionHistoryInfo)versions.get(i)).getStartTime();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return version;
    }
}

