/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.webstore.update.manager;

import com.geoway.adf.dms.common.config.UploadPathConfig;
import com.geoway.adf.dms.common.dto.TransferResult;
import com.geoway.adf.dms.common.gis.VectorDataTransfer;
import com.geoway.adf.dms.common.gis.WorkspaceUtil;
import com.geoway.adf.dms.common.util.DateTimeUtil;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DatabaseDTO;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.gis.basic.RefObject;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.IEnvelope;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.QueryFilter;
import com.geoway.webstore.datamodel.entity.LayerVersionKeyInfo;
import com.geoway.webstore.update.dto.LayerUpdateLogRecord;
import com.geoway.webstore.update.dto.SpatioTemporalDatasetInfo;
import com.geoway.webstore.update.manager.DataUpdater;
import com.geoway.webstore.update.util.CopyFeatureHelper;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeowayVectorInput
extends DataUpdater {
    private static final Logger log = LoggerFactory.getLogger(GeowayVectorInput.class);
    private IFeatureWorkspace workspace = null;
    private boolean overwrite = false;

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean run() {
        DatabaseDTO dataSourceDTO = this.geoDatabaseService.getDatabaseDetail(this.dbKey);
        this.workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)dataSourceDTO);
        if (this.workspace == null) {
            throw new RuntimeException("\u65e0\u6cd5\u6253\u5f00\u5de5\u4f5c\u7a7a\u95f4");
        }
        Date startTime = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat formatDay = new SimpleDateFormat("yyyy-MM-dd");
        this.invokeProgressMessageChanged(String.format("\u5f00\u59cb\u672c\u5e95\u5165\u5e93\uff0c\u4e00\u5171\u6709[%d]\u4e2a\u56fe\u5c42\u5f85\u5165\u5e93\u3002\u65f6\u95f4\uff1a%s", this.layers.size(), format.format(startTime)));
        String sMessage = "";
        this.logRecords.clear();
        String sourceLayerName = "";
        Object spatialRef = null;
        this.invokeProgressCountChanged(this.layers.size());
        int count = 0;
        boolean success = true;
        for (SpatioTemporalDatasetInfo stDataInfo : this.layers) {
            this.invokeProgressPositionChanged(++count);
            this.invokeLayerUpdateChanged(stDataInfo);
            File sourceFile = UploadPathConfig.getFullPath((String)stDataInfo.getSourceLayerName()).toFile();
            File layerPath = sourceFile.getParentFile();
            sourceLayerName = FileUtil.getFileNameWithoutExtension((String)sourceFile.getName());
            String code = FileUtil.getFileNameWithoutExtension((String)layerPath.getName());
            LayerUpdateLogRecord logRecord = new LayerUpdateLogRecord();
            logRecord.setSrcLayerName(sourceLayerName);
            logRecord.setTarLayerName(String.format("%s(%s)", stDataInfo.getFrameName(), stDataInfo.getTargetLayerName()));
            LayerVersionKeyInfo versionKeyInfo = this.versionKeyInfoDao.selectByNonceLayer(this.dbKey, stDataInfo.getTargetLayerName());
            if (versionKeyInfo == null) {
                sMessage = String.format("\u56fe\u5c42[%s]\u5165\u5e93\u8df3\u8fc7\uff1a\u76ee\u6807\u56fe\u5c42\u975e\u65f6\u7a7a\u6570\u636e\u96c6\u56fe\u5c42\uff01", sourceLayerName);
                logRecord.setSuccess(false);
                success = false;
                logRecord.setLogInfo(sMessage);
                this.invokeLayerUpdateFinished(stDataInfo, logRecord);
                continue;
            }
            IFeatureWorkspace srcWorkspace = null;
            try {
                srcWorkspace = WorkspaceUtil.openLocalFileGeodatabase((String)layerPath.toString());
                IFeatureClass srcFc = srcWorkspace.openFeatureClass(sourceLayerName);
                if (srcFc == null) {
                    sMessage = String.format("\u56fe\u5c42[%s]\u5165\u5e93\u5931\u8d25\uff1a\u539f\u59cb\u56fe\u5c42\u6253\u5f00\u5931\u8d25\uff01", sourceLayerName);
                    logRecord.setSuccess(false);
                    success = false;
                    logRecord.setLogInfo(sMessage);
                    this.invokeLayerUpdateFinished(stDataInfo, logRecord);
                    continue;
                }
                IFeatureClass targetFc = this.workspace.openFeatureClass(stDataInfo.getTargetLayerName());
                if (targetFc == null) {
                    sMessage = String.format("\u56fe\u5c42[%s]\u5165\u5e93\u5931\u8d25\uff1a\u76ee\u6807\u56fe\u5c42\u6253\u5f00\u5931\u8d25\uff01", sourceLayerName);
                    logRecord.setSuccess(false);
                    success = false;
                    logRecord.setLogInfo(sMessage);
                    this.invokeLayerUpdateFinished(stDataInfo, logRecord);
                    continue;
                }
                if (this.overwrite) {
                    String filter = String.format("%s = '%s'", "f_frame", code.toUpperCase());
                    this.deleteRows((ITable)targetFc, filter);
                }
                Map<String, Object> defaultValues = this.getDefaultValues(code, stDataInfo.getTime());
                RefObject extent = new RefObject();
                TransferResult transferResult = this.inputFeatureClass(srcFc, targetFc, defaultValues, versionKeyInfo, (RefObject<IEnvelope>)extent);
                logRecord.setSuccess(transferResult.isSuccess());
                if (transferResult.isSuccess()) {
                    logRecord.dataUpdateExtent = extent.get() == null ? null : GeometryFunc.createGeometry((String)((IEnvelope)extent.get()).toWkt());
                    this.updateSpatialTimePara(stDataInfo, versionKeyInfo);
                }
                sMessage = transferResult.getErrorMessage();
            }
            catch (Exception e) {
                sMessage = String.format("\u56fe\u5c42[%s]\u5165\u5e93\u5f02\u5e38\u3002\u539f\u56e0\uff1a%s", sourceLayerName, e.getMessage());
                log.error(sMessage);
                logRecord.setSuccess(false);
                success = false;
                logRecord.setLogInfo(sMessage);
                this.invokeLayerUpdateFinished(stDataInfo, logRecord);
            }
            finally {
                if (srcWorkspace != null) {
                    srcWorkspace.close();
                }
                logRecord.setLogInfo(sMessage);
                this.logRecords.add(logRecord);
                if (StringUtil.isNotEmpty((String)sMessage)) {
                    this.invokeProgressMessageChanged(sMessage);
                }
                this.invokeLayerUpdateFinished(stDataInfo, logRecord);
            }
        }
        return success;
    }

    protected TransferResult inputFeatureClass(IFeatureClass sourceFeatureClass, IFeatureClass targetFeatureClass, Map<String, Object> defaultValues, LayerVersionKeyInfo versionKeyInfo, RefObject<IEnvelope> extent) {
        Date startTime = new Date();
        VectorDataTransfer vectorDataTransfer = new VectorDataTransfer();
        vectorDataTransfer.setDefaultValues(defaultValues);
        vectorDataTransfer.setPropertyValueSettingCallback((srcBuffer, trgBuffer) -> {
            Object value;
            String guid = "";
            int uniqueFldIndex = trgBuffer.getFields().findFieldIndex(versionKeyInfo.getUniqueField());
            if (uniqueFldIndex > -1 && StringUtil.isEmptyOrWhiteSpace((String)(guid = (value = trgBuffer.getValue(uniqueFldIndex)) != null ? value.toString() : ""))) {
                guid = String.format("{%s}", UUID.randomUUID());
                trgBuffer.setValue(uniqueFldIndex, (Object)guid);
            }
        });
        vectorDataTransfer.setErrorCallback(msg -> {
            if (StringUtil.isNotEmpty((String)msg)) {
                log.error(msg);
                this.invokeProgressMessageChanged((String)msg);
            }
        });
        TransferResult result = vectorDataTransfer.copyFeature(sourceFeatureClass, targetFeatureClass, null, extent);
        if (result.isSuccess()) {
            IEnvelope srcExtent = targetFeatureClass.getExtent();
            if (extent.get() != null && !((IEnvelope)extent.get()).isEmpty()) {
                CopyFeatureHelper.unionExtent((IEnvelope)extent.get(), srcExtent);
                targetFeatureClass.changeExtent((IEnvelope)extent.get());
            }
        }
        Date endTime = new Date();
        String text = DateTimeUtil.getTimeIntervalStr((Date)startTime, (Date)endTime);
        this.invokeProgressMessageChanged(String.format("%s\u5165\u5e93%s\uff1a\u5171%s\u4e2a\uff0c\u6210\u529f%s\u4e2a\uff0c\u5931\u8d25%s\u4e2a\u3002\u603b\u8017\u65f6:%s", sourceFeatureClass.getName(), result.isSuccess() ? "\u6210\u529f" : "\u5931\u8d25", result.getTotalCount(), result.getSuccessCount(), result.getFailCount(), text));
        return result;
    }

    protected long deleteRows(ITable table, String whereClause) {
        try {
            Date startTime = new Date();
            QueryFilter filter = new QueryFilter();
            filter.setWhereClause(whereClause);
            long deleteCount = table.count((IQueryFilter)filter);
            if (deleteCount > 0L) {
                table.deleteRow((IQueryFilter)filter);
            }
            this.invokeProgressMessageChanged(String.format("[%s]\u5220\u9664\u6570\u636e%s\u4e2a\uff1a%s", table.getName(), deleteCount, DateTimeUtil.getTimeIntervalStr((Date)startTime, (Date)new Date())));
            return deleteCount;
        }
        catch (Exception ex) {
            log.error("\u5220\u9664\u6570\u636e\u5931\u8d25", (Throwable)ex);
            this.invokeProgressMessageChanged("\u5220\u9664\u6570\u636e\u5931\u8d25\uff0c" + ex.getMessage());
            return -1L;
        }
    }

    protected Map<String, Object> getDefaultValues(String code, Date timePhase) {
        HashMap<String, Object> defaultValues = new HashMap<String, Object>(0);
        defaultValues.put("f_frame", code.toUpperCase());
        defaultValues.put("f_importtime", new Date());
        defaultValues.put("F_TIME", timePhase);
        defaultValues.put("F_TASKID", null);
        return defaultValues;
    }

    private void updateSpatialTimePara(SpatioTemporalDatasetInfo layer, LayerVersionKeyInfo versionKeyInfo) {
        if (versionKeyInfo.getTimestamp().before(layer.getTime())) {
            return;
        }
        versionKeyInfo.setTimestamp(layer.getTime());
        this.versionKeyInfoDao.updateByPrimaryKey(versionKeyInfo);
    }
}

