/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.webstore.update.manager.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.PinyinUtil;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.config.dto.user.LoginUserInfo;
import com.geoway.adf.dms.config.util.ThreadLocalUtil;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DatabaseDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.VTileServiceCreateDTO;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.service.RenderIndexService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureDataset;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.webstore.datamodel.dao.LayerVersionKeyInfoDao;
import com.geoway.webstore.datamodel.dao.VersionHistoryInfoDao;
import com.geoway.webstore.datamodel.dto.spatialtemporal.VersionDatasetInfo;
import com.geoway.webstore.datamodel.entity.LayerVersionKeyInfo;
import com.geoway.webstore.datamodel.entity.VersionHistoryInfo;
import com.geoway.webstore.update.constant.TaskStatusEnum;
import com.geoway.webstore.update.constant.UpdateTaskTypeEnum;
import com.geoway.webstore.update.dao.UpdateTaskDao;
import com.geoway.webstore.update.dao.UpdateTaskLogDao;
import com.geoway.webstore.update.dto.LayerUpdateLogRecord;
import com.geoway.webstore.update.dto.SpatioTemporalDatasetInfo;
import com.geoway.webstore.update.dto.VersionRegisterInfo;
import com.geoway.webstore.update.dto.param.RegisterTaskParameter;
import com.geoway.webstore.update.entity.UpdateTask;
import com.geoway.webstore.update.entity.UpdateTaskLog;
import com.geoway.webstore.update.manager.DataUpdater;
import com.geoway.webstore.update.manager.DataUpdaterFactory;
import com.geoway.webstore.update.manager.GeowayDataUpdaterHistoryVer;
import com.geoway.webstore.update.manager.task.IUpdateTaskExecutor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class RegisterTaskExecutor
implements IUpdateTaskExecutor {
    private static final Logger log = LoggerFactory.getLogger(RegisterTaskExecutor.class);
    private final UpdateTaskDao updateTaskDao = (UpdateTaskDao)SpringContextUtil.getBean(UpdateTaskDao.class);
    private final ThreadPoolTaskExecutor executor = (ThreadPoolTaskExecutor)SpringContextUtil.getBean((String)"threadPoolTaskExecutorData", ThreadPoolTaskExecutor.class);
    private final UpdateTaskLogDao updateTaskLogDao = (UpdateTaskLogDao)SpringContextUtil.getBean(UpdateTaskLogDao.class);
    protected final LayerVersionKeyInfoDao versionKeyInfoDao = (LayerVersionKeyInfoDao)SpringContextUtil.getBean(LayerVersionKeyInfoDao.class);
    private final VersionHistoryInfoDao versionHistoryInfoDao = (VersionHistoryInfoDao)SpringContextUtil.getBean(VersionHistoryInfoDao.class);
    private final RenderIndexService renderIndexService = (RenderIndexService)SpringContextUtil.getBean(RenderIndexService.class);
    private final GeoDatabaseService geoDatabaseService = (GeoDatabaseService)SpringContextUtil.getBean(GeoDatabaseService.class);
    private IFeatureWorkspace workspace;
    private DatabaseDTO dataSourceDTO;
    private List<VersionRegisterInfo> versions;
    private UpdateTask updateTask;
    private boolean success = true;

    @Override
    public void execute(UpdateTask updateTask) {
        LoginUserInfo loginUserInfo = ThreadLocalUtil.getCurrentUser();
        this.executor.execute(() -> {
            if (loginUserInfo != null) {
                ThreadLocalUtil.addCurrentUser((LoginUserInfo)loginUserInfo);
            }
            this.doExecutor(updateTask);
            if (loginUserInfo != null) {
                ThreadLocalUtil.removeUser();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecutor(UpdateTask updateTask) {
        this.updateTask = updateTask;
        AtomicInteger totalCount = new AtomicInteger();
        AtomicReference logRecords = new AtomicReference(new ArrayList());
        AtomicReference<SpatioTemporalDatasetInfo> curStDatasetInfo = new AtomicReference<SpatioTemporalDatasetInfo>(new SpatioTemporalDatasetInfo());
        UpdateTaskTypeEnum taskTypeEnum = UpdateTaskTypeEnum.getByValue(updateTask.getTaskType());
        if (taskTypeEnum == UpdateTaskTypeEnum.Register) {
            block7: {
                try {
                    updateTask.setStatus(TaskStatusEnum.Processing.getValue());
                    updateTask.setStartTime(new Date());
                    updateTask.setEndTime(null);
                    this.updateTaskDao.updateByPrimaryKey(updateTask);
                    String taskParameter = updateTask.getParam();
                    RegisterTaskParameter registerTaskParameter = (RegisterTaskParameter)JSON.parseObject((String)taskParameter, RegisterTaskParameter.class);
                    DataUpdater dataUpdater = DataUpdaterFactory.createHistoryVersion();
                    this.completeUpdater(registerTaskParameter, dataUpdater);
                    curStDatasetInfo.set(dataUpdater.getLayers().get(0));
                    dataUpdater.progressMessageChanged = msg -> this.insertUpdateTaskLog(((SpatioTemporalDatasetInfo)curStDatasetInfo.get()).getTargetLayerName(), msg);
                    dataUpdater.progressCountChanged = totalCount::set;
                    dataUpdater.progressPositionChanged = value -> {
                        updateTask.setProgress(value / totalCount.get() * 100);
                        this.updateTaskDao.updateByPrimaryKey(updateTask);
                    };
                    dataUpdater.layerUpdateChanged = curStDatasetInfo::set;
                    if (dataUpdater instanceof GeowayDataUpdaterHistoryVer) {
                        ((GeowayDataUpdaterHistoryVer)dataUpdater).createVersionDatasetFinished = this::createVersionDatasetFinished;
                    }
                    dataUpdater.layerUpdateFinished = this::layerUpdateFinished;
                    dataUpdater.run();
                    if (this.workspace == null) break block7;
                }
                catch (Exception e) {
                    block8: {
                        try {
                            log.error(e.getMessage(), (Throwable)e);
                            UpdateTaskLog taskLog = new UpdateTaskLog();
                            taskLog.setTaskId(updateTask.getId());
                            taskLog.setTime(new Date());
                            taskLog.setLayerName(updateTask.getName());
                            taskLog.setContent(e.getMessage());
                            this.updateTaskLogDao.insert(taskLog);
                            if (this.workspace == null) break block8;
                        }
                        catch (Throwable throwable) {
                            if (this.workspace != null) {
                                this.workspace.close();
                            }
                            updateTask.setSucceed(this.success ? 1 : 0);
                            updateTask.setStatus(this.success ? TaskStatusEnum.FinishedSuccessed.getValue() : TaskStatusEnum.FinishedFailed.getValue());
                            updateTask.setEndTime(new Date());
                            updateTask.setLog(JSONObject.toJSONString(logRecords.get()));
                            this.updateTaskDao.updateByPrimaryKey(updateTask);
                            throw throwable;
                        }
                        this.workspace.close();
                    }
                    updateTask.setSucceed(this.success ? 1 : 0);
                    updateTask.setStatus(this.success ? TaskStatusEnum.FinishedSuccessed.getValue() : TaskStatusEnum.FinishedFailed.getValue());
                    updateTask.setEndTime(new Date());
                    updateTask.setLog(JSONObject.toJSONString(logRecords.get()));
                    this.updateTaskDao.updateByPrimaryKey(updateTask);
                }
                this.workspace.close();
            }
            updateTask.setSucceed(this.success ? 1 : 0);
            updateTask.setStatus(this.success ? TaskStatusEnum.FinishedSuccessed.getValue() : TaskStatusEnum.FinishedFailed.getValue());
            updateTask.setEndTime(new Date());
            updateTask.setLog(JSONObject.toJSONString(logRecords.get()));
            this.updateTaskDao.updateByPrimaryKey(updateTask);
        }
    }

    private void completeUpdater(RegisterTaskParameter registerTaskParameter, DataUpdater dataUpdater) {
        this.versions = new ArrayList<VersionRegisterInfo>();
        this.dataSourceDTO = this.geoDatabaseService.getDatabaseDetail(registerTaskParameter.getDsKey());
        this.workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)this.dataSourceDTO);
        SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
        for (VersionRegisterInfo info : registerTaskParameter.getRegisterInfos()) {
            LayerVersionKeyInfo keyInfo = this.versionKeyInfoDao.selectByFeatureClassId(info.getObjectClassId());
            info.setVersionKey(keyInfo.getId());
            info.setLayerName(String.format("%s_%s_%s", info.getLayerName(), info.getVersionName(), format.format(info.getRegisterTime())));
            this.versions.add(info);
        }
        if (this.versions.size() <= 0) {
            throw new RuntimeException("\u7248\u672c\u6ce8\u518c\u53c2\u6570\u5f02\u5e38\uff01");
        }
        dataUpdater.setTargetDbKey(registerTaskParameter.getDsKey());
        dataUpdater.setLayers(this.getLayers(this.versions));
    }

    private List<SpatioTemporalDatasetInfo> getLayers(List<VersionRegisterInfo> versions) {
        ArrayList<SpatioTemporalDatasetInfo> spatioTemporalDatasetInfos = new ArrayList<SpatioTemporalDatasetInfo>();
        for (VersionRegisterInfo info : versions) {
            SpatioTemporalDatasetInfo stInfo = new SpatioTemporalDatasetInfo();
            stInfo.setIsCheck(false);
            LayerVersionKeyInfo keyInfo = this.versionKeyInfoDao.selectByPrimaryKey(info.getVersionKey());
            stInfo.setSourceLayerName(keyInfo.getLayerName());
            VersionDatasetInfo versionDatasetInfo = (VersionDatasetInfo)JSONObject.parseObject((String)keyInfo.getVersionInfo(), VersionDatasetInfo.class);
            String sourceDatasetName = versionDatasetInfo.getDatasetNameNow();
            stInfo.setTargetDatasetName(String.format("%s_%s", sourceDatasetName, info.getVersionName()));
            stInfo.setTargetLayerName(info.getLayerName());
            String fullName = info.getLayerName().contains(".") ? info.getLayerName() : "public." + info.getLayerName();
            String targetLayerId = DatasetUtil.getDatasetId((String)this.dataSourceDTO.getKey(), (DatasetTypeEnum)DatasetTypeEnum.FeatureClass, (String)fullName);
            stInfo.setTargetLayerId(targetLayerId);
            stInfo.setUniqueField("F_GUID");
            stInfo.setTime(info.getRegisterTime());
            IFeatureClass datasetInfo = this.workspace.openFeatureClass(stInfo.getSourceLayerName());
            if (datasetInfo == null) continue;
            stInfo.setDatasetObj(datasetInfo);
            spatioTemporalDatasetInfos.add(stInfo);
        }
        return spatioTemporalDatasetInfos;
    }

    private void createVersionDatasetFinished(String versionLayerName) {
        try {
            VersionRegisterInfo version = (VersionRegisterInfo)ListUtil.find(this.versions, f -> f.getLayerName().equals(versionLayerName));
            if (version == null) {
                return;
            }
            IFeatureWorkspace featureWorkspace = this.workspace;
            LayerVersionKeyInfo keyInfo = this.versionKeyInfoDao.selectByPrimaryKey(version.getVersionKey());
            VersionDatasetInfo versionDatasetInfo = (VersionDatasetInfo)JSONObject.parseObject((String)keyInfo.getVersionInfo(), VersionDatasetInfo.class);
            String versionDatasetName = versionDatasetInfo.getDatasetNameNow() + "_" + version.getVersionName();
            IFeatureDataset dataset = featureWorkspace.openFeatureDataset(versionDatasetName);
            if (dataset == null) {
                this.insertUpdateTaskLog(versionLayerName, String.format("\u5199\u5165\u4e1a\u52a1\u8868\u8bb0\u5f55\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u6570\u636e\u96c6%s\u4e0d\u5b58\u5728\u3002", versionLayerName));
                return;
            }
            IGeoDataset geoDataset = (IGeoDataset)ListUtil.find((List)dataset.getSubsets(), f -> f.getName().equals(version.getLayerName()));
            if (geoDataset != null) {
                String datasetId = DatasetUtil.getDatasetId((String)this.dataSourceDTO.getKey(), (DatasetTypeEnum)DatasetTypeEnum.FeatureClass, (String)("public." + version.getLayerName()));
                version.setObjectClassId(datasetId);
            }
            if (this.versionHistoryInfoDao.insert(this.getHistoryInfo(version)) < 1) {
                this.insertUpdateTaskLog(versionLayerName, String.format("%s\u5199\u5165\u4e1a\u52a1\u8868\u8bb0\u5f55\u5931\u8d25\u3002", versionLayerName));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void insertUpdateTaskLog(String layerName, String msg) {
        UpdateTaskLog taskLog = new UpdateTaskLog();
        taskLog.setTaskId(this.updateTask.getId());
        taskLog.setTime(new Date());
        taskLog.setLayerName(layerName);
        taskLog.setContent(msg);
        this.updateTaskLogDao.insert(taskLog);
    }

    private VersionHistoryInfo getHistoryInfo(VersionRegisterInfo registerInfo) {
        VersionHistoryInfo version = new VersionHistoryInfo();
        version.setVersionKey(registerInfo.getVersionKey());
        version.setVersionName(registerInfo.getVersionName());
        version.setLayerName(registerInfo.getLayerName());
        version.setVersionAliasName(registerInfo.getVersionAliasName());
        version.setStartTime(registerInfo.getRegisterTime());
        version.setDescription(registerInfo.getDescription());
        version.setDatasetId(registerInfo.getObjectClassId());
        return version;
    }

    private void layerUpdateFinished(SpatioTemporalDatasetInfo info, LayerUpdateLogRecord logRecord) {
        try {
            if (!logRecord.getSuccess().booleanValue()) {
                this.success = false;
            } else {
                String serviceName = PinyinUtil.convertToPinYin((String)info.getTargetLayerName()).toLowerCase(Locale.ROOT);
                if (serviceName.length() > 60) {
                    serviceName = serviceName.substring(0, 60);
                }
                VTileServiceCreateDTO serviceCreateDTO = new VTileServiceCreateDTO();
                serviceCreateDTO.setServiceName(serviceName);
                serviceCreateDTO.setDatasetId(info.getTargetLayerId());
                this.renderIndexService.createVectorRenderIndex(serviceCreateDTO);
            }
        }
        catch (Exception e) {
            UpdateTaskLog taskLog = new UpdateTaskLog();
            taskLog.setTaskId(this.updateTask.getId());
            taskLog.setTime(new Date());
            taskLog.setLayerName(logRecord.getTarLayerName());
            taskLog.setContent(e.getMessage());
            this.updateTaskLogDao.insert(taskLog);
        }
    }
}

