/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.webstore.update.manager.task;

import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.common.config.UploadPathConfig;
import com.geoway.adf.dms.common.gis.WorkspaceUtil;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.PinyinUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.config.dto.user.LoginUserInfo;
import com.geoway.adf.dms.config.util.ThreadLocalUtil;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.renderindex.DatasetRenderDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.VTileServiceCreateDTO;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.RenderIndexService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.webstore.datamodel.dao.LayerVersionKeyInfoDao;
import com.geoway.webstore.datamodel.dao.UpdateCaseInfoDao;
import com.geoway.webstore.datamodel.entity.LayerVersionKeyInfo;
import com.geoway.webstore.datamodel.entity.UpdateCaseInfo;
import com.geoway.webstore.update.constant.TaskStatusEnum;
import com.geoway.webstore.update.constant.UpdateTaskTypeEnum;
import com.geoway.webstore.update.dao.UpdateTaskDao;
import com.geoway.webstore.update.dao.UpdateTaskLogDao;
import com.geoway.webstore.update.dto.LayerUpdateLogRecord;
import com.geoway.webstore.update.dto.SpatioTemporalDatasetInfo;
import com.geoway.webstore.update.dto.param.UpdateTaskParameter;
import com.geoway.webstore.update.entity.UpdateTask;
import com.geoway.webstore.update.entity.UpdateTaskLog;
import com.geoway.webstore.update.manager.DataUpdater;
import com.geoway.webstore.update.manager.DataUpdaterFactory;
import com.geoway.webstore.update.manager.VTileRenderIndexUpdater;
import com.geoway.webstore.update.manager.VectorUpdateScanner;
import com.geoway.webstore.update.manager.task.IUpdateTaskExecutor;
import com.geoway.webstore.update.util.WorkRenderStyles;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class UpdateTaskExecutor
implements IUpdateTaskExecutor {
    private static final Logger log = LoggerFactory.getLogger(UpdateTaskExecutor.class);
    private final UpdateTaskDao updateTaskDao = (UpdateTaskDao)SpringContextUtil.getBean(UpdateTaskDao.class);
    private final UpdateCaseInfoDao updateCaseinfoDao = (UpdateCaseInfoDao)SpringContextUtil.getBean(UpdateCaseInfoDao.class);
    private final UpdateTaskLogDao updateTaskLogDao = (UpdateTaskLogDao)SpringContextUtil.getBean(UpdateTaskLogDao.class);
    private final ThreadPoolTaskExecutor executor = (ThreadPoolTaskExecutor)SpringContextUtil.getBean((String)"threadPoolTaskExecutorData", ThreadPoolTaskExecutor.class);
    private final LayerVersionKeyInfoDao versionKeyInfoDao = (LayerVersionKeyInfoDao)SpringContextUtil.getBean(LayerVersionKeyInfoDao.class);
    private final RenderIndexService renderIndexService = (RenderIndexService)SpringContextUtil.getBean(RenderIndexService.class);
    private final DataSourceManager dataSourceManager = (DataSourceManager)SpringContextUtil.getBean(DataSourceManager.class);
    private String targetDsKey;
    private List<IFeatureWorkspace> workspaceList;
    private Long taskId;

    @Override
    public void execute(UpdateTask updateTask) {
        LoginUserInfo loginUserInfo = ThreadLocalUtil.getCurrentUser();
        this.executor.execute(() -> {
            if (loginUserInfo != null) {
                ThreadLocalUtil.addCurrentUser((LoginUserInfo)loginUserInfo);
            }
            this.doExecutor(updateTask);
            if (loginUserInfo != null) {
                ThreadLocalUtil.removeUser();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecutor(UpdateTask updateTask) {
        this.taskId = updateTask.getId();
        AtomicInteger totalCount = new AtomicInteger();
        AtomicReference<SpatioTemporalDatasetInfo> curStDatasetInfo = new AtomicReference<SpatioTemporalDatasetInfo>(new SpatioTemporalDatasetInfo());
        AtomicReference logRecords = new AtomicReference(new ArrayList());
        UpdateTaskTypeEnum taskTypeEnum = UpdateTaskTypeEnum.getByValue(updateTask.getTaskType());
        if (taskTypeEnum == UpdateTaskTypeEnum.Update) {
            boolean success;
            block9: {
                success = false;
                try {
                    updateTask.setStatus(TaskStatusEnum.Processing.getValue());
                    updateTask.setStartTime(new Date());
                    updateTask.setEndTime(null);
                    this.updateTaskDao.updateByPrimaryKey(updateTask);
                    this.workspaceList = new LinkedList<IFeatureWorkspace>();
                    String taskParameter = updateTask.getParam();
                    UpdateTaskParameter updateTaskParameter = (UpdateTaskParameter)JSONObject.parseObject((String)taskParameter, UpdateTaskParameter.class);
                    DataUpdater dataUpdater = DataUpdaterFactory.createDataUpdater();
                    this.completeUpdater(updateTaskParameter, dataUpdater);
                    curStDatasetInfo.set(dataUpdater.getLayers().get(0));
                    UpdateCaseInfo caseInfo = new UpdateCaseInfo();
                    this.insertUpdateCaseInfo(updateTask, updateTaskParameter, caseInfo);
                    dataUpdater.setUpdateTaskId(caseInfo.getId());
                    dataUpdater.progressMessageChanged = msg -> {
                        UpdateTaskLog taskLog = new UpdateTaskLog();
                        taskLog.setTaskId(updateTask.getId());
                        taskLog.setTime(new Date());
                        String layerName = String.format("%s(%s)", ((SpatioTemporalDatasetInfo)curStDatasetInfo.get()).getFrameName(), ((SpatioTemporalDatasetInfo)curStDatasetInfo.get()).getTargetLayerName());
                        taskLog.setLayerName(layerName);
                        taskLog.setContent(msg);
                        this.updateTaskLogDao.insert(taskLog);
                    };
                    dataUpdater.progressCountChanged = totalCount::set;
                    dataUpdater.progressPositionChanged = value -> {
                        updateTask.setProgress(value / totalCount.get() * 100);
                        this.updateTaskDao.updateByPrimaryKey(updateTask);
                    };
                    dataUpdater.layerUpdateChanged = curStDatasetInfo::set;
                    dataUpdater.layerUpdateFinished = this::layerUpdateFinished;
                    success = dataUpdater.run();
                    if (this.workspaceList.size() <= 0) break block9;
                }
                catch (Exception e) {
                    block10: {
                        try {
                            log.error(e.getMessage(), (Throwable)e);
                            UpdateTaskLog taskLog = new UpdateTaskLog();
                            taskLog.setTaskId(updateTask.getId());
                            taskLog.setTime(new Date());
                            taskLog.setLayerName(updateTask.getName());
                            taskLog.setContent(e.getMessage());
                            this.updateTaskLogDao.insert(taskLog);
                            if (this.workspaceList.size() <= 0) break block10;
                        }
                        catch (Throwable throwable) {
                            if (this.workspaceList.size() > 0) {
                                for (IFeatureWorkspace workspace : this.workspaceList) {
                                    if (workspace == null) continue;
                                    workspace.close();
                                }
                            }
                            updateTask.setSucceed(success ? 1 : 0);
                            updateTask.setStatus(success ? TaskStatusEnum.FinishedSuccessed.getValue() : TaskStatusEnum.FinishedFailed.getValue());
                            updateTask.setEndTime(new Date());
                            updateTask.setLog(JSONObject.toJSONString(logRecords.get()));
                            this.updateTaskDao.updateByPrimaryKey(updateTask);
                            throw throwable;
                        }
                        for (IFeatureWorkspace workspace : this.workspaceList) {
                            if (workspace == null) continue;
                            workspace.close();
                        }
                    }
                    updateTask.setSucceed(success ? 1 : 0);
                    updateTask.setStatus(success ? TaskStatusEnum.FinishedSuccessed.getValue() : TaskStatusEnum.FinishedFailed.getValue());
                    updateTask.setEndTime(new Date());
                    updateTask.setLog(JSONObject.toJSONString(logRecords.get()));
                    this.updateTaskDao.updateByPrimaryKey(updateTask);
                }
                for (IFeatureWorkspace workspace : this.workspaceList) {
                    if (workspace == null) continue;
                    workspace.close();
                }
            }
            updateTask.setSucceed(success ? 1 : 0);
            updateTask.setStatus(success ? TaskStatusEnum.FinishedSuccessed.getValue() : TaskStatusEnum.FinishedFailed.getValue());
            updateTask.setEndTime(new Date());
            updateTask.setLog(JSONObject.toJSONString(logRecords.get()));
            this.updateTaskDao.updateByPrimaryKey(updateTask);
        }
    }

    private void insertUpdateCaseInfo(UpdateTask updateTask, UpdateTaskParameter updateTaskParameter, UpdateCaseInfo caseInfo) {
        caseInfo.setBuildPerson(updateTask.getCreatePerson());
        caseInfo.setBuildTime(updateTask.getCreateDateTime());
        caseInfo.setDescription(updateTask.getDescription());
        caseInfo.setDisplayFilter("");
        ArrayList<String> selectedLayerNames = new ArrayList<String>(updateTaskParameter.getLayerDict().values());
        caseInfo.setLayerVersions(String.join((CharSequence)"|", selectedLayerNames));
        caseInfo.setName(updateTask.getName());
        caseInfo.setOperator(updateTask.getResPerson());
        caseInfo.setType(Integer.valueOf(2));
        this.updateCaseinfoDao.insert(caseInfo);
    }

    private void completeUpdater(UpdateTaskParameter updateTaskParameter, DataUpdater dataUpdater) {
        ArrayList<SpatioTemporalDatasetInfo> layers = new ArrayList<SpatioTemporalDatasetInfo>();
        dataUpdater.setTargetDbKey(updateTaskParameter.getDsKey());
        this.targetDsKey = updateTaskParameter.getDsKey();
        String path = UploadPathConfig.getFullPath((String)updateTaskParameter.getPackagePath()).toString();
        VectorUpdateScanner scanner = new VectorUpdateScanner(path, null);
        scanner.scan(dataPath -> {
            IFeatureWorkspace srcWorkspace = WorkspaceUtil.openLocalFileGeodatabase((String)dataPath);
            if (srcWorkspace == null) {
                throw new RuntimeException("\u6587\u4ef6 [" + dataPath + "] \u6253\u5f00\u5931\u8d25! ");
            }
            String frameName = FileUtil.getFileNameWithoutExtension((String)dataPath);
            this.workspaceList.add(srcWorkspace);
            List datasetList = srcWorkspace.getDatasets();
            for (IGeoDataset dataset : datasetList) {
                if (!updateTaskParameter.getLayerDict().containsKey(dataset.getName()) || !(dataset instanceof IFeatureClass)) continue;
                SpatioTemporalDatasetInfo datasetInfo = new SpatioTemporalDatasetInfo();
                datasetInfo.setFrameName(frameName);
                datasetInfo.setDatasetObj(dataset);
                datasetInfo.setTargetDatasetName(updateTaskParameter.getDatasetName());
                String targetLayerName = updateTaskParameter.getLayerDict().get(dataset.getName());
                datasetInfo.setTargetLayerName(targetLayerName);
                datasetInfo.setSourceLayerName(dataset.getName());
                String fullName = targetLayerName.contains(".") ? targetLayerName : "public." + targetLayerName;
                String targetLayerId = DatasetUtil.getDatasetId((String)updateTaskParameter.getDsKey(), (DatasetTypeEnum)DatasetTypeEnum.FeatureClass, (String)fullName);
                datasetInfo.setTargetLayerId(targetLayerId);
                layers.add(datasetInfo);
            }
        });
        dataUpdater.setLayers(layers);
    }

    private void layerUpdateFinished(SpatioTemporalDatasetInfo info, LayerUpdateLogRecord logRecord) {
        try {
            if (StringUtil.isNotEmpty((String)logRecord.getLogInfo())) {
                UpdateTaskLog taskLog = new UpdateTaskLog();
                taskLog.setTaskId(this.taskId);
                taskLog.setTime(new Date());
                taskLog.setLayerName(logRecord.getTarLayerName());
                taskLog.setContent(logRecord.getLogInfo());
                this.updateTaskLogDao.insert(taskLog);
            }
            if (logRecord.getSuccess().booleanValue()) {
                String type;
                LayerVersionKeyInfo versionKeyInfo;
                DatasetRenderDTO render = this.dataSourceManager.getDatasetRender(info.getTargetLayerId());
                if (render != null) {
                    VTileRenderIndexUpdater vTileUpdater = new VTileRenderIndexUpdater();
                    vTileUpdater.updateVTileService(render, logRecord);
                }
                if ((versionKeyInfo = this.versionKeyInfoDao.selectByNonceLayer(this.targetDsKey, info.getTargetLayerName())) == null) {
                    throw new RuntimeException("\u672a\u627e\u5230\u589e\u91cf\u5c42\uff01");
                }
                VTileServiceCreateDTO serviceCreateDTO = this.getVTileServiceCreateDTO(versionKeyInfo.getWorkLayer());
                switch (info.getFeatureType()) {
                    case Point: {
                        type = "point-mark";
                        break;
                    }
                    case Polyline: {
                        type = "line";
                        break;
                    }
                    case Polygon: {
                        type = "polygon";
                        break;
                    }
                    default: {
                        throw new RuntimeException("\u56fe\u5c42\u7c7b\u578b\u672a\u77e5\uff0c\u589e\u91cf\u5c42\u6e32\u67d3\u7d22\u5f15\u66f4\u65b0\u5931\u8d25\uff01");
                    }
                }
                JSONObject jsonObject = WorkRenderStyles.getWorkRenderStyle(serviceCreateDTO.getServiceName(), type, info.getUpdateTypeFld());
                serviceCreateDTO.setStyleJson(jsonObject.toJSONString());
                serviceCreateDTO.setStyleId("work");
                this.renderIndexService.createVectorRenderIndex(serviceCreateDTO);
            }
        }
        catch (Exception e) {
            log.error(info.getTargetLayerName(), (Throwable)e);
        }
    }

    private VTileServiceCreateDTO getVTileServiceCreateDTO(String layerName) {
        String serviceName = PinyinUtil.convertToPinYin((String)layerName).toLowerCase(Locale.ROOT);
        if (serviceName.length() > 60) {
            serviceName = serviceName.substring(0, 60);
        }
        VTileServiceCreateDTO serviceCreateDTO = new VTileServiceCreateDTO();
        serviceCreateDTO.setServiceName(serviceName);
        String layerId = DatasetUtil.getDatasetId((String)this.targetDsKey, (DatasetTypeEnum)DatasetTypeEnum.FeatureClass, (String)("public." + layerName));
        serviceCreateDTO.setDatasetId(layerId);
        return serviceCreateDTO;
    }
}

