/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.webstore.update.util;

import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.FeatureDatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.webstore.datamodel.dao.LayerUpdateInfoDao;
import com.geoway.webstore.datamodel.dao.LayerVersionKeyInfoDao;
import com.geoway.webstore.datamodel.dao.UpdateCaseInfoDao;
import com.geoway.webstore.datamodel.dao.VersionHistoryInfoDao;
import com.geoway.webstore.datamodel.dto.spatialtemporal.VersionDatasetInfo;
import com.geoway.webstore.datamodel.entity.LayerUpdateInfo;
import com.geoway.webstore.datamodel.entity.LayerVersionKeyInfo;
import com.geoway.webstore.datamodel.entity.VersionHistoryInfo;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionDeleteHelper {
    private static final Logger log = LoggerFactory.getLogger(VersionDeleteHelper.class);
    private static final LayerVersionKeyInfoDao versionKeyInfoDao = (LayerVersionKeyInfoDao)SpringContextUtil.getBean(LayerVersionKeyInfoDao.class);
    private static final LayerUpdateInfoDao layerUpdateInfoDao = (LayerUpdateInfoDao)SpringContextUtil.getBean(LayerUpdateInfoDao.class);
    private static final VersionHistoryInfoDao versionHistoryInfoDao = (VersionHistoryInfoDao)SpringContextUtil.getBean(VersionHistoryInfoDao.class);
    private static final GeoDatabaseService geoDatabaseService = (GeoDatabaseService)SpringContextUtil.getBean(GeoDatabaseService.class);
    private static final DataSourceService dataSourceService = (DataSourceService)SpringContextUtil.getBean(DataSourceService.class);
    private static final UpdateCaseInfoDao updateCaseInfoDao = (UpdateCaseInfoDao)SpringContextUtil.getBean(UpdateCaseInfoDao.class);

    public static Boolean delete(String datasetId) {
        try {
            DatasetDTO datasetDTO = dataSourceService.getDatasetDetail(datasetId);
            if (datasetDTO != null) {
                List workKeyInfos;
                LayerVersionKeyInfo workKeyInfo;
                VersionHistoryInfo historyInfo;
                LayerVersionKeyInfo keyInfo = versionKeyInfoDao.selectByFeatureClassId(datasetId);
                if (keyInfo != null) {
                    VersionDeleteHelper.deleteNonceLayer(datasetId);
                }
                if ((historyInfo = versionHistoryInfoDao.selectByFeatureClassId(datasetId)) != null) {
                    VersionDeleteHelper.deleteVersionLayer(historyInfo, true);
                }
                return (workKeyInfo = (LayerVersionKeyInfo)ListUtil.find((List)(workKeyInfos = versionKeyInfoDao.selectByWorkLayerName(datasetDTO.getName())), info -> DatasetUtil.getDatasetNameInfo((String)info.getDatasetId()).getDsKey().equals(datasetDTO.getDsKey()))) == null;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void deleteKeyInfo(LayerVersionKeyInfo keyInfo) {
        List tempVersions = versionHistoryInfoDao.selectByKeyInfoId(keyInfo.getId());
        if (tempVersions != null && tempVersions.size() != 0) {
            tempVersions.forEach(v -> versionHistoryInfoDao.deleteByPrimaryKey(v.getId()));
        }
        VersionDeleteHelper.deleteUpdateInfoByLayerId(keyInfo.getDatasetId());
        versionKeyInfoDao.deleteByPrimaryKey(keyInfo.getId());
    }

    public static void deleteUpdateInfoByLayerId(String objectId) {
        List lstRegionInfo = layerUpdateInfoDao.selectByFeatureClassId(objectId);
        if (lstRegionInfo == null || lstRegionInfo.size() == 0) {
            return;
        }
        for (LayerUpdateInfo regionInfo : lstRegionInfo) {
            layerUpdateInfoDao.deleteByPrimaryKey(regionInfo.getId());
        }
        Map<Long, List<LayerUpdateInfo>> groupSeconds = lstRegionInfo.stream().collect(Collectors.groupingBy(LayerUpdateInfo::getCaseId));
        for (Long itemKey : groupSeconds.keySet()) {
            List tempLayerUpdateInfo = layerUpdateInfoDao.selectByTaskID(itemKey);
            if (tempLayerUpdateInfo != null && tempLayerUpdateInfo.size() != 0) continue;
            updateCaseInfoDao.deleteByPrimaryKey(itemKey);
        }
    }

    public static Boolean deleteVersionLayer(VersionHistoryInfo info, Boolean dropPhyData) {
        boolean flag = false;
        try {
            DatasetDTO dsInfo;
            boolean bl = flag = versionHistoryInfoDao.deleteByPrimaryKey(info.getId()) > 0;
            if (dropPhyData.booleanValue() && (dsInfo = dataSourceService.getDatasetDetail(info.getDatasetId())) != null) {
                flag = VersionDeleteHelper.deleteDataset(dsInfo);
                LayerVersionKeyInfo keyInfo = versionKeyInfoDao.selectByPrimaryKey(info.getVersionKey());
                if (keyInfo != null) {
                    VersionDatasetInfo versionDatasetInfo = (VersionDatasetInfo)JSONObject.parseObject((String)keyInfo.getVersionInfo(), VersionDatasetInfo.class);
                    VersionDeleteHelper.deleteEmptyVersionDataset(String.format("%s_%s", versionDatasetInfo.getDatasetNameNow(), info.getVersionName()), dsInfo.getDataSource());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            flag = false;
        }
        return flag;
    }

    public static void deleteNonceLayer(String datasetId) {
        DatasetDTO dsInfo;
        String workLayerId;
        DatasetDTO workDataset;
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo((String)datasetId);
        LayerVersionKeyInfo keyInfo = versionKeyInfoDao.selectByFeatureClassId(datasetId);
        if (keyInfo == null) {
            return;
        }
        VersionDatasetInfo versionDatasetInfo = (VersionDatasetInfo)JSONObject.parseObject((String)keyInfo.getVersionInfo(), VersionDatasetInfo.class);
        DataSourceDTO dataSourceDTO = dataSourceService.getDataSourceDetail(datasetNameInfo.getDsKey());
        List versions = versionHistoryInfoDao.selectByKeyInfoId(keyInfo.getId());
        if (versions != null) {
            for (VersionHistoryInfo version : versions) {
                if (!VersionDeleteHelper.deleteVersionLayer(version, true).booleanValue()) {
                    throw new RuntimeException(String.format("\u5220\u9664\u7248\u672c\u5c42%s\u7684\u65f6\u5019\u5931\u8d25\uff01", version.getLayerName()));
                }
                VersionDeleteHelper.deleteEmptyVersionDataset(String.format("%s_%s", versionDatasetInfo.getDatasetNameNow(), version.getVersionName()), dataSourceDTO);
            }
        }
        if ((workDataset = dataSourceService.getDatasetDetail(workLayerId = DatasetUtil.getDatasetId((String)datasetNameInfo.getDsKey(), (DatasetTypeEnum)DatasetTypeEnum.FeatureClass, (String)keyInfo.getWorkLayer()))) != null) {
            if (!VersionDeleteHelper.deleteDataset(workDataset).booleanValue()) {
                throw new RuntimeException(String.format("\u5220\u9664\u5de5\u4f5c\u5c42%s\u7684\u65f6\u5019\u5931\u8d25\uff01", keyInfo.getWorkLayer()));
            }
            VersionDeleteHelper.deleteEmptyVersionDataset(String.format("%s%s", versionDatasetInfo.getDatasetNameNow(), "_WORK"), dataSourceDTO);
        }
        if ((dsInfo = dataSourceService.getDatasetDetail(keyInfo.getDatasetId())) != null) {
            if (!VersionDeleteHelper.deleteDataset(dsInfo).booleanValue()) {
                throw new RuntimeException(String.format("\u5220\u9664\u73b0\u52bf%s\u7684\u65f6\u5019\u5931\u8d25\uff01", keyInfo.getLayerName()));
            }
            VersionDeleteHelper.deleteEmptyVersionDataset(versionDatasetInfo.getDatasetNameNow(), dataSourceDTO);
        }
        VersionDeleteHelper.deleteKeyInfo(keyInfo);
    }

    private static void deleteEmptyVersionDataset(String datasetName, DataSourceDTO dataSourceDTO) {
        FeatureDatasetDTO datasetDTO = (FeatureDatasetDTO)geoDatabaseService.getDatasetDetail(dataSourceDTO, DatasetTypeEnum.FeatureDataset, datasetName);
        if (datasetDTO == null) {
            return;
        }
        List subsets = datasetDTO.getSubsets();
        if (subsets != null && subsets.size() != 0) {
            return;
        }
        geoDatabaseService.deleteDataset(datasetDTO.getId());
    }

    private static Boolean deleteDataset(DatasetDTO dsInfo) {
        try {
            geoDatabaseService.deleteDataset(dsInfo.getId());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }
}

