/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.webstore.update.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Locale;

public class WorkRenderStyles {
    public static final String POINT = "point-mark";
    public static final String POLYGON = "polygon";
    public static final String LINE = "line";

    public static JSONObject getWorkRenderStyle(String serverName, String type, String typeFieldName) {
        JSONObject renderStyle = new JSONObject(true);
        renderStyle.put("background", (Object)WorkRenderStyles.getBackground());
        renderStyle.put("GlobalStyle", (Object)new JSONObject());
        renderStyle.put("layers", (Object)WorkRenderStyles.getLayers(serverName, type));
        typeFieldName = typeFieldName.toLowerCase(Locale.ROOT).replace("_", "");
        renderStyle.put("styles", (Object)WorkRenderStyles.getWorkStyles(serverName, type, typeFieldName));
        return renderStyle;
    }

    private static JSONObject getBackground() {
        JSONObject background = new JSONObject(true);
        background.put("backgroundColor", (Object)"");
        background.put("watermark", (Object)"");
        background.put("fillOpacity", (Object)100);
        background.put("waterMarkOpacity", (Object)100);
        background.put("rule", (Object)"across");
        return background;
    }

    private static JSONArray getLayers(String serverName, String type) {
        JSONArray layers = new JSONArray();
        JSONObject layer = new JSONObject(true);
        layer.put("filter", (Object)"");
        layer.put("avoidWeight", (Object)0);
        layer.put("data", (Object)serverName);
        layer.put("isVisbile", (Object)true);
        layer.put("query", (Object)"");
        layer.put("name", (Object)serverName);
        layer.put("avoid", (Object)"");
        layer.put("id", (Object)serverName);
        layer.put("isleaf", (Object)true);
        layer.put("type", (Object)type);
        layer.put("status", (Object)0);
        layers.add((Object)layer);
        return layers;
    }

    private static JSONObject getWorkStyles(String serverName, String type, String typeFieldName) {
        JSONObject styles = new JSONObject(true);
        JSONArray items = new JSONArray();
        String addQuery = String.format("Q_%s_S_EQ=\u589e\u52a0", typeFieldName);
        String addFilter = String.format("%s  =  '\u589e\u52a0'", typeFieldName);
        String deleteQuery = String.format("Q_%s_S_EQ=\u5220\u9664", typeFieldName);
        String deleteFilter = String.format("%s  =  '\u5220\u9664'", typeFieldName);
        String updateQuery = String.format("Q_%s_S_EQ=\u56fe\u5c5e\u4fee\u6539 OR Q_%s_S_EQ=\u56fe\u5f62\u4fee\u6539 OR Q_%s_S_EQ=\u5c5e\u6027\u4fee\u6539", typeFieldName, typeFieldName, typeFieldName);
        String updateFilter = String.format("%s= '\u56fe\u5c5e\u4fee\u6539' or %s= '\u56fe\u5f62\u4fee\u6539' or %s= '\u5c5e\u6027\u4fee\u6539'", typeFieldName, typeFieldName, typeFieldName);
        JSONObject add = WorkRenderStyles.getUnitStyles(serverName, type, "add", addQuery, addFilter, "#7ed321", false);
        JSONObject delete = WorkRenderStyles.getUnitStyles(serverName, type, "delete", deleteQuery, deleteFilter, "#e60606", false);
        JSONObject update = WorkRenderStyles.getUnitStyles(serverName, type, "update", updateQuery, updateFilter, "#f5a623", false);
        items.add((Object)add);
        items.add((Object)delete);
        items.add((Object)update);
        styles.put("1-30", (Object)items);
        return styles;
    }

    private static JSONObject getUnitStyles(String serverName, String type, String name, String query, String filter, String color, boolean stroke) {
        JSONObject item = new JSONObject(true);
        item.put("data", (Object)serverName);
        item.put("query", (Object)query);
        item.put("type", (Object)"style");
        item.put("layer", (Object)serverName);
        item.put("parentId", (Object)"1-30");
        item.put("filter", (Object)filter);
        item.put("expanded", (Object)true);
        item.put("children", (Object)new JSONArray());
        item.put("isVisbile", (Object)true);
        item.put("iconType", (Object)type);
        item.put("name", (Object)name);
        switch (type) {
            case "point-mark": {
                item.put("style", (Object)WorkRenderStyles.getPointStyle(color));
                break;
            }
            case "polygon": {
                item.put("style", (Object)WorkRenderStyles.getPolygonStyle(color, stroke));
                item.put("avoid", (Object)new JSONObject(true));
                item.put("styleError", (Object)false);
                break;
            }
            case "line": {
                item.put("style", (Object)WorkRenderStyles.getLineStyle(color));
                JSONObject avoid = new JSONObject(true);
                avoid.put("avoidWeight", (Object)0);
                avoid.put("avoidField", (Object)"");
                item.put("avoid", (Object)avoid);
                item.put("styleError", (Object)false);
                break;
            }
            default: {
                throw new RuntimeException("\u65e0\u8be5\u7c7b\u578b\u6837\u5f0f");
            }
        }
        item.put("id", (Object)String.format("1-30_%s", name));
        item.put("isleaf", (Object)true);
        item.put("status", (Object)0);
        return item;
    }

    private static JSONArray getPointStyle(String color) {
        JSONArray items = new JSONArray();
        JSONObject item = new JSONObject(true);
        item.put("imageWidth", (Object)0);
        item.put("circleWidth", (Object)0);
        item.put("texture", (Object)"");
        item.put("labelType", (Object)"\u6563\u70b9\u56fe");
        item.put("circleR", (Object)5);
        item.put("fillAlpha", (Object)1);
        item.put("type", (Object)"scatter");
        item.put("imageHeight", (Object)0);
        item.put("defaultRadius", (Object)25);
        item.put("fillColor", (Object)color);
        item.put("fillType", (Object)"circle");
        item.put("strokeAlpha", (Object)1);
        item.put("strokeColor", (Object)"#cccccc");
        items.add((Object)item);
        return items;
    }

    private static JSONArray getLineStyle(String color) {
        JSONArray items = new JSONArray();
        JSONObject item = new JSONObject(true);
        item.put("strokeWidth", (Object)1);
        item.put("lineCap", (Object)"butt");
        item.put("lineJoin", (Object)"miter");
        item.put("sparsity", (Object)1);
        item.put("strokeColor", (Object)color);
        item.put("dash", (Object)"");
        item.put("stroke", (Object)true);
        item.put("strokeOpacity", (Object)1);
        items.add((Object)item);
        return items;
    }

    private static JSONArray getPolygonStyle(String fillColor, boolean stroke) {
        JSONArray items = new JSONArray();
        JSONObject item = new JSONObject(true);
        item.put("strokeWidth", (Object)1);
        item.put("xspace", (Object)0);
        item.put("fillOpacity", (Object)0.5);
        item.put("cross", (Object)false);
        item.put("sparsity", (Object)1);
        item.put("fill", (Object)true);
        item.put("stroke", (Object)stroke);
        item.put("yspace", (Object)0);
        item.put("fillColor", (Object)fillColor);
        item.put("shadowHight", (Object)0);
        item.put("textureratio", (Object)1);
        item.put("textureOpacity", (Object)1);
        item.put("strokeColor", (Object)"#ef261f");
        item.put("dash", (Object)"");
        item.put("shadowColor", (Object)"");
        item.put("strokeOpacity", (Object)1);
        items.add((Object)item);
        return items;
    }
}

