/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.webstore.update.manager;

import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.webstore.datamodel.dao.LayerUpdateInfoDao;
import com.geoway.webstore.datamodel.dao.LayerVersionKeyInfoDao;
import com.geoway.webstore.datamodel.dao.VersionHistoryInfoDao;
import com.geoway.webstore.datamodel.entity.LayerUpdateInfo;
import com.geoway.webstore.datamodel.entity.LayerVersionKeyInfo;
import com.geoway.webstore.update.dto.LayerUpdateLogRecord;
import com.geoway.webstore.update.dto.SpatioTemporalDatasetInfo;
import com.geoway.webstore.update.manager.listener.ILayerUpdateChangedCallBack;
import com.geoway.webstore.update.manager.listener.ILayerUpdateFinishedCallBack;
import com.geoway.webstore.update.manager.listener.IProgressCallBack;
import com.geoway.webstore.update.manager.listener.IProgressMessageCallBack;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public abstract class DataUpdater {
    protected final LayerVersionKeyInfoDao versionKeyInfoDao = (LayerVersionKeyInfoDao)SpringContextUtil.getBean(LayerVersionKeyInfoDao.class);
    protected final LayerUpdateInfoDao layerUpdateInfoDao = (LayerUpdateInfoDao)SpringContextUtil.getBean(LayerUpdateInfoDao.class);
    protected final VersionHistoryInfoDao versionHistoryInfoDao = (VersionHistoryInfoDao)SpringContextUtil.getBean(VersionHistoryInfoDao.class);
    protected final GeoDatabaseService geoDatabaseService = (GeoDatabaseService)SpringContextUtil.getBean(GeoDatabaseService.class);
    protected String dbKey;
    protected List<SpatioTemporalDatasetInfo> layers;
    private Date updateTime;
    protected Long updateTaskId;
    private Integer featureDatasetId;
    protected List<Object> successfulResultObjects;
    private Map<String, String> extendFields;
    protected List<LayerUpdateLogRecord> logRecords = new ArrayList<LayerUpdateLogRecord>();
    public IProgressMessageCallBack progressMessageChanged;
    public IProgressCallBack progressCountChanged;
    public IProgressCallBack progressPositionChanged;
    public ILayerUpdateChangedCallBack layerUpdateChanged;
    public ILayerUpdateFinishedCallBack layerUpdateFinished;

    public List<SpatioTemporalDatasetInfo> getLayers() {
        return this.layers;
    }

    public void setLayers(List<SpatioTemporalDatasetInfo> layers) {
        this.layers = layers;
    }

    public Long getUpdateTaskId() {
        return this.updateTaskId;
    }

    public void setUpdateTaskId(Long updateTaskId) {
        this.updateTaskId = updateTaskId;
    }

    protected void invokeProgressMessageChanged(String msg) {
        if (this.progressMessageChanged != null) {
            this.progressMessageChanged.callBack(msg);
        }
    }

    protected void invokeProgressCountChanged(Integer value) {
        if (this.progressCountChanged != null) {
            this.progressCountChanged.callBack(value);
        }
    }

    protected void invokeProgressPositionChanged(Integer value) {
        if (this.progressPositionChanged != null) {
            this.progressPositionChanged.callBack(value);
        }
    }

    protected void invokeLayerUpdateChanged(SpatioTemporalDatasetInfo info) {
        if (null != this.layerUpdateChanged) {
            this.layerUpdateChanged.callBack(info);
        }
    }

    protected void invokeLayerUpdateFinished(SpatioTemporalDatasetInfo datasetInfo, LayerUpdateLogRecord logRecord) {
        if (this.layerUpdateFinished != null) {
            this.layerUpdateFinished.callBack(datasetInfo, logRecord);
        }
    }

    protected DataUpdater() {
        this.successfulResultObjects = new ArrayList<Object>();
    }

    public void setTargetDbKey(String dbKey) {
        this.dbKey = dbKey;
    }

    protected void updateTimeSpan(String dbKey, String nonceLayerName, Date dt) {
        LayerVersionKeyInfo keyInfo = this.versionKeyInfoDao.selectByNonceLayer(dbKey, nonceLayerName);
        if (keyInfo != null) {
            keyInfo.setTimestamp(dt);
            this.versionKeyInfoDao.updateByPrimaryKey(keyInfo);
        }
    }

    protected LayerUpdateInfo insertUpdateInfo(SpatioTemporalDatasetInfo stDataInfo) {
        LayerVersionKeyInfo keyInfo = this.versionKeyInfoDao.selectByFeatureClassId(stDataInfo.getTargetLayerId());
        LayerUpdateInfo layerUpdateInfo = new LayerUpdateInfo();
        layerUpdateInfo.setDatabaseKey(this.dbKey);
        layerUpdateInfo.setDatasetName(stDataInfo.getTargetDatasetName());
        layerUpdateInfo.setLayerName(stDataInfo.getTargetLayerName());
        layerUpdateInfo.setCaseId(this.updateTaskId);
        layerUpdateInfo.setPreDateTime(keyInfo.getTimestamp());
        try {
            layerUpdateInfo.setPostDateTime(new SimpleDateFormat("yyyy-MM-dd").parse("9999-12-30"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        layerUpdateInfo.setDatasetId(stDataInfo.getTargetLayerId());
        this.layerUpdateInfoDao.insert(layerUpdateInfo);
        return layerUpdateInfo;
    }

    public abstract boolean run();
}

