/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.webstore.update.manager;

import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.webstore.datamodel.constant.STDataChangeTypeEnum;
import com.geoway.webstore.datamodel.constant.UpdateGWFieldNameConstant;
import com.geoway.webstore.datamodel.constant.UpdateTypeValueConstant;
import com.geoway.webstore.datamodel.entity.LayerUpdateInfo;
import com.geoway.webstore.update.dto.LayerUpdateLogRecord;
import com.geoway.webstore.update.dto.SpatioTemporalDatasetInfo;
import com.geoway.webstore.update.manager.DataUpdater;
import com.geoway.webstore.update.manager.LayerUpdater;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class GeowayDataUpdater
extends DataUpdater {
    protected String fldChangeType;
    protected String fldUpdateTime;
    protected Map<STDataChangeTypeEnum, String> dicUpdateValue;

    @Override
    public void setTargetDbKey(String dbKey) {
        super.setTargetDbKey(dbKey);
        UpdateGWFieldNameConstant.getUpdateField();
        UpdateTypeValueConstant.getUpdateTypeValue();
        this.fldChangeType = UpdateGWFieldNameConstant.FLD_NAME_GW_UpdateType;
        this.fldUpdateTime = UpdateGWFieldNameConstant.FLD_NAME_GW_UPDATETIME;
        this.dicUpdateValue = new HashMap<STDataChangeTypeEnum, String>(0);
        this.dicUpdateValue.put(STDataChangeTypeEnum.Add, UpdateTypeValueConstant.FLD_NAME_ADD);
        this.dicUpdateValue.put(STDataChangeTypeEnum.Delete, UpdateTypeValueConstant.FLD_NAME_DELETE);
        this.dicUpdateValue.put(STDataChangeTypeEnum.AllChange, UpdateTypeValueConstant.FLD_NAME_ALLMODIFY);
        this.dicUpdateValue.put(STDataChangeTypeEnum.ShapeChange, UpdateTypeValueConstant.FLD_NAME_GRAPHMODIFY);
        this.dicUpdateValue.put(STDataChangeTypeEnum.PropertyChange, UpdateTypeValueConstant.FLD_NAME_PROPMODIFY);
    }

    @Override
    public boolean run() {
        this.invokeProgressCountChanged(this.layers.size());
        int count = 0;
        this.successfulResultObjects = new ArrayList();
        Map<String, List<SpatioTemporalDatasetInfo>> layerGroup = this.layers.stream().collect(Collectors.groupingBy(SpatioTemporalDatasetInfo::getTargetLayerId));
        for (String layerId : layerGroup.keySet()) {
            List<SpatioTemporalDatasetInfo> layerList = layerGroup.get(layerId);
            LayerUpdateInfo layerUpdateInfo = this.insertUpdateInfo(layerList.get(0));
            ArrayList<LayerUpdateLogRecord> currentLogRecords = new ArrayList<LayerUpdateLogRecord>();
            for (SpatioTemporalDatasetInfo stDataInfo : layerList) {
                this.invokeProgressPositionChanged(count++);
                this.invokeLayerUpdateChanged(stDataInfo);
                this.invokeProgressMessageChanged(String.format("\u5f00\u59cb\u66f4\u65b0\u56fe\u5c42%s", stDataInfo.getSourceLayerName()));
                LayerUpdateLogRecord logRecord = new LayerUpdateLogRecord();
                logRecord.setSrcLayerName(stDataInfo.getSourceLayerName());
                logRecord.setTarLayerName(String.format("%s(%s)", stDataInfo.getFrameName(), stDataInfo.getTargetLayerName()));
                LayerUpdater updater = new LayerUpdater();
                updater.setFldChangeType(this.fldChangeType);
                updater.setFldUpdateTime(this.fldUpdateTime);
                updater.setDicUpdateValue(this.dicUpdateValue);
                updater.updateTaskId = this.updateTaskId;
                updater.progressMessageChanged = x$0 -> super.invokeProgressMessageChanged(x$0);
                updater.setGwWorkspace(this.dbKey);
                updater.update(stDataInfo, logRecord);
                this.logRecords.add(logRecord);
                if (logRecord.getSuccess().booleanValue()) {
                    currentLogRecords.add(logRecord);
                    this.invokeProgressMessageChanged(String.format("\u603b\u5171\u66f4\u65b0%d\u6761\u8981\u7d20\uff0c\u5176\u4e2d\u589e\u52a0%d\u6761\u8981\u7d20\uff0c\u4fee\u6539%d\u6761\u8981\u7d20\uff0c\u5220\u9664%d\u6761\u8981\u7d20,\u5931\u8d25%d\u6761\u8981\u7d20", logRecord.allFeatureCount, logRecord.addFeatureCount, logRecord.updateFeatureCount, logRecord.delFeatureCount, logRecord.allFeatureCount - logRecord.addFeatureCount - logRecord.updateFeatureCount - logRecord.delFeatureCount));
                } else if (StringUtil.isNotEmpty((String)logRecord.getLogInfo())) {
                    this.invokeProgressMessageChanged(logRecord.getLogInfo());
                }
                if (StringUtil.isNotEmpty((String)logRecord.getLogInfo())) {
                    this.invokeProgressMessageChanged(logRecord.getLogInfo());
                }
                this.invokeProgressMessageChanged(String.format("\u56fe\u5c42%s\u66f4\u65b0\u5b8c\u6210", stDataInfo.getSourceLayerName()));
                if (logRecord.addFeatureCount + logRecord.updateFeatureCount + logRecord.delFeatureCount <= 0) continue;
                this.updateTimeSpan(this.dbKey, stDataInfo.getTargetLayerName(), logRecord.maxUpdateTime);
                this.successfulResultObjects.add(stDataInfo.getSourceLayerName());
            }
            SpatioTemporalDatasetInfo currentStDataInfo = new SpatioTemporalDatasetInfo();
            currentStDataInfo.setTargetLayerId(layerId);
            currentStDataInfo.setTargetLayerName(layerList.get(0).getTargetLayerName());
            currentStDataInfo.setTargetDatasetName(layerList.get(0).getTargetDatasetName());
            currentStDataInfo.setUniqueField(layerList.get(0).getUniqueField());
            currentStDataInfo.setFeatureType(layerList.get(0).getFeatureType());
            currentStDataInfo.setUpdateTypeFld(layerList.get(0).getUpdateTypeFld());
            currentStDataInfo.setTime(layerList.get(0).getTime());
            LayerUpdateLogRecord udpateLogRecord = new LayerUpdateLogRecord();
            udpateLogRecord.setTarLayerName(currentStDataInfo.getTargetLayerName());
            udpateLogRecord.setSuccess(false);
            for (LayerUpdateLogRecord logRecord : currentLogRecords) {
                if (logRecord.getSuccess().booleanValue()) {
                    udpateLogRecord.setSuccess(true);
                }
                if (logRecord.maxUpdateTime.after(udpateLogRecord.maxUpdateTime)) {
                    udpateLogRecord.maxUpdateTime = logRecord.maxUpdateTime;
                }
                if (logRecord.dataUpdateExtent == null) continue;
                if (udpateLogRecord.dataUpdateExtent == null) {
                    udpateLogRecord.dataUpdateExtent = logRecord.dataUpdateExtent;
                    continue;
                }
                IGeometry geo = udpateLogRecord.dataUpdateExtent.union(logRecord.dataUpdateExtent);
                if (geo == null) continue;
                udpateLogRecord.dataUpdateExtent = geo;
            }
            if (udpateLogRecord.getSuccess().booleanValue()) {
                layerUpdateInfo.setPostDateTime(udpateLogRecord.maxUpdateTime);
                this.layerUpdateInfoDao.updateByPrimaryKey(layerUpdateInfo);
            }
            this.invokeLayerUpdateFinished(currentStDataInfo, udpateLogRecord);
        }
        this.invokeProgressPositionChanged(this.layers.size());
        return true;
    }
}

