/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.webstore.update.manager;

import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.DatasetRenderDTO;
import com.geoway.adf.dms.datasource.geosrv.AtlasServer;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.service.GeoServerEngineService;
import com.geoway.adf.dms.datasource.util.FieldUtil;
import com.geoway.adf.gis.basic.geometry.GeometryType;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.geodb.FeatureType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.field.Field;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.Fields;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.field.IFields;
import com.geoway.adf.gis.geosrv.IGeoServer;
import com.geoway.adf.gis.geosrv.vtile.VTileServer;
import com.geoway.webstore.update.dto.LayerUpdateLogRecord;
import com.geoway.webstore.update.dto.SpatioTemporalDatasetInfo;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VTileRenderIndexUpdater {
    private static final Logger log = LoggerFactory.getLogger(VTileRenderIndexUpdater.class);
    private final GeoDatabaseService geoDatabaseService = (GeoDatabaseService)SpringContextUtil.getBean(GeoDatabaseService.class);
    private final DataSourceService dataSourceService = (DataSourceService)SpringContextUtil.getBean(DataSourceService.class);
    private final GeoServerEngineService geoServerEngineService = (GeoServerEngineService)SpringContextUtil.getBean(GeoServerEngineService.class);

    public void updateVTileService(DatasetRenderDTO datasetRenderDTO, LayerUpdateLogRecord logRecord) {
        VTileServer vtileServer;
        if (logRecord.getDataUpdateExtent() == null) {
            return;
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)datasetRenderDTO.getServerKey())) {
            return;
        }
        DataSourceDTO serverSourceDTO = this.dataSourceService.getDataSourceDetail(datasetRenderDTO.getServerKey());
        IGeoServer geoServer = this.geoServerEngineService.getGeoServer(serverSourceDTO);
        if (geoServer instanceof AtlasServer) {
            vtileServer = ((AtlasServer)geoServer).getVTileServer();
        } else if (geoServer instanceof VTileServer) {
            vtileServer = (VTileServer)geoServer;
        } else {
            log.error("\u4e0d\u652f\u6301\u7684GeoServer\u7c7b\u578b");
            return;
        }
        String updateGeometry = logRecord.getDataUpdateExtent().toWkt();
        Date updateTime = logRecord.getMaxUpdateTime();
        updateTime = new Date();
        vtileServer.createUpdateTileTask(datasetRenderDTO.getServiceName(), updateGeometry, updateTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordUpdateExtent(SpatioTemporalDatasetInfo info, LayerUpdateLogRecord logRecord) {
        try {
            String dsKey = new DatasetNameInfo(info.getTargetLayerId()).getDsKey();
            IFeatureWorkspace workspace = this.geoDatabaseService.openGeoWorkspace(dsKey);
            IFeatureClass fc = this.openUpdateFeatureClass(workspace);
            if (fc == null) {
                log.error("public.tboutput_elemap\u6253\u5f00\u5931\u8d25");
                return;
            }
            int first = workspace.dataExist("select f_targetlayer from public.tboutput_elemap where f_targetlayer=?", new Object[]{info.getTargetLayerName().toLowerCase()}) ? 1 : 0;
            IFeatureCursor cursor = fc.insertFeature();
            try {
                IFeature feature = fc.createFeature();
                feature.setGeometry(logRecord.getDataUpdateExtent());
                feature.setValue("f_targetlayer", (Object)info.getTargetLayerName().toLowerCase());
                feature.setValue("f_opertime", (Object)new Date());
                feature.setValue("f_datatime", (Object)logRecord.getMaxUpdateTime());
                feature.setValue("f_first", (Object)first);
                cursor.insertFeature(feature);
                cursor.release();
            }
            finally {
                if (cursor != null) {
                    cursor.release();
                }
            }
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u8303\u56f4\u8bb0\u5f55\u5f02\u5e38", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IFeatureClass openUpdateFeatureClass(IFeatureWorkspace workspace) {
        String tableName = "public.tboutput_elemap";
        IFeatureClass fc = workspace.openFeatureClass(tableName);
        if (fc != null) {
            return fc;
        }
        VTileRenderIndexUpdater vTileRenderIndexUpdater = this;
        synchronized (vTileRenderIndexUpdater) {
            fc = workspace.openFeatureClass(tableName);
            if (fc != null) {
                return fc;
            }
            ISpatialReferenceSystem sp = SpatialReferenceSystemFunc.createSpatialReference((int)4490);
            Fields newFileds = new Fields();
            newFileds.addField(FieldUtil.buildShapeField((String)"shape", (String)"shape", (GeometryType)GeometryType.Polygon, (int)sp.getSrid()));
            newFileds.addField(FieldUtil.buildObjectIdField((String)"f_oid", (String)"f_oid"));
            newFileds.addField((IField)new Field("f_targetlayer", "f_targetlayer", FieldType.String, 255));
            newFileds.addField((IField)new Field("f_source", "f_source", FieldType.String));
            newFileds.addField((IField)new Field("f_opertime", "f_opertime", FieldType.DateTime));
            newFileds.addField((IField)new Field("f_datatime", "f_datatime", FieldType.DateTime));
            newFileds.addField((IField)new Field("f_first", "f_first", FieldType.Short));
            fc = workspace.createFeatureClass(tableName, (IFields)newFileds, FeatureType.Polygon, "shape", "");
            if (fc != null) {
                fc.createSpatialIndex();
            }
            return fc;
        }
    }
}

