/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.webstore.update.manager.task;

import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.PinyinUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.config.dto.user.LoginUserInfo;
import com.geoway.adf.dms.config.util.ThreadLocalUtil;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.renderindex.DatasetRenderDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.VTileServiceCreateDTO;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.RenderIndexService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.webstore.update.constant.MyTuple;
import com.geoway.webstore.update.constant.TaskStatusEnum;
import com.geoway.webstore.update.constant.UpdateTaskTypeEnum;
import com.geoway.webstore.update.dao.UpdateTaskDao;
import com.geoway.webstore.update.dao.UpdateTaskLogDao;
import com.geoway.webstore.update.dto.LayerUpdateLogRecord;
import com.geoway.webstore.update.dto.SpatioTemporalDatasetInfo;
import com.geoway.webstore.update.dto.param.InputTaskParameter;
import com.geoway.webstore.update.dto.param.LayerRelationship;
import com.geoway.webstore.update.entity.UpdateTask;
import com.geoway.webstore.update.entity.UpdateTaskLog;
import com.geoway.webstore.update.manager.DataUpdater;
import com.geoway.webstore.update.manager.DataUpdaterFactory;
import com.geoway.webstore.update.manager.GeowayVectorInput;
import com.geoway.webstore.update.manager.VTileRenderIndexUpdater;
import com.geoway.webstore.update.manager.task.IUpdateTaskExecutor;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class InputTaskExecutor
implements IUpdateTaskExecutor {
    private static final Logger log = LoggerFactory.getLogger(InputTaskExecutor.class);
    private final UpdateTaskDao updateTaskDao = (UpdateTaskDao)SpringContextUtil.getBean(UpdateTaskDao.class);
    private final ThreadPoolTaskExecutor executor = (ThreadPoolTaskExecutor)SpringContextUtil.getBean((String)"threadPoolTaskExecutorData", ThreadPoolTaskExecutor.class);
    private final UpdateTaskLogDao updateTaskLogDao = (UpdateTaskLogDao)SpringContextUtil.getBean(UpdateTaskLogDao.class);
    private final RenderIndexService renderIndexService = (RenderIndexService)SpringContextUtil.getBean(RenderIndexService.class);
    private final DataSourceManager dataSourceManager = (DataSourceManager)SpringContextUtil.getBean(DataSourceManager.class);
    private Long taskId;

    @Override
    public void execute(UpdateTask updateTask) {
        LoginUserInfo loginUserInfo = ThreadLocalUtil.getCurrentUser();
        this.executor.execute(() -> {
            if (loginUserInfo != null) {
                ThreadLocalUtil.addCurrentUser((LoginUserInfo)loginUserInfo);
            }
            this.doExecutor(updateTask);
            if (loginUserInfo != null) {
                ThreadLocalUtil.removeUser();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecutor(UpdateTask updateTask) {
        this.taskId = updateTask.getId();
        AtomicInteger totalCount = new AtomicInteger();
        AtomicReference logRecords = new AtomicReference(new ArrayList());
        UpdateTaskTypeEnum taskTypeEnum = UpdateTaskTypeEnum.getByValue(updateTask.getTaskType());
        AtomicReference<SpatioTemporalDatasetInfo> curStDatasetInfo = new AtomicReference<SpatioTemporalDatasetInfo>(new SpatioTemporalDatasetInfo());
        if (taskTypeEnum == UpdateTaskTypeEnum.Input) {
            boolean success = false;
            try {
                updateTask.setStatus(TaskStatusEnum.Processing.getValue());
                updateTask.setStartTime(new Date());
                updateTask.setEndTime(null);
                this.updateTaskDao.updateByPrimaryKey(updateTask);
                InputTaskParameter inputTaskParameter = (InputTaskParameter)JSONObject.parseObject((String)updateTask.getParam(), InputTaskParameter.class);
                GeowayVectorInput dataUpdater = (GeowayVectorInput)DataUpdaterFactory.createVectorInput();
                dataUpdater.setOverwrite(inputTaskParameter.isOverwrite());
                this.completeUpdater(inputTaskParameter, dataUpdater);
                LinkedHashMap<String, List<MyTuple<SpatioTemporalDatasetInfo, LayerUpdateLogRecord>>> updateDatasetMap = new LinkedHashMap<String, List<MyTuple<SpatioTemporalDatasetInfo, LayerUpdateLogRecord>>>();
                curStDatasetInfo.set(dataUpdater.getLayers().get(0));
                dataUpdater.progressMessageChanged = msg -> {
                    UpdateTaskLog taskLog = new UpdateTaskLog();
                    taskLog.setTaskId(updateTask.getId());
                    taskLog.setTime(new Date());
                    String layerName = String.format("%s(%s)", ((SpatioTemporalDatasetInfo)curStDatasetInfo.get()).getFrameName(), ((SpatioTemporalDatasetInfo)curStDatasetInfo.get()).getTargetLayerName());
                    taskLog.setLayerName(layerName);
                    taskLog.setContent(msg);
                    this.updateTaskLogDao.insert(taskLog);
                };
                dataUpdater.progressCountChanged = totalCount::set;
                dataUpdater.progressPositionChanged = value -> {
                    double progress = (double)value.intValue() / (double)totalCount.get() * 100.0;
                    updateTask.setProgress((int)progress);
                    this.updateTaskDao.updateByPrimaryKey(updateTask);
                };
                dataUpdater.layerUpdateChanged = curStDatasetInfo::set;
                dataUpdater.layerUpdateFinished = (info, logRecord) -> {
                    this.layerInputFinish(info, logRecord);
                    if (!updateDatasetMap.containsKey(info.getTargetLayerId())) {
                        updateDatasetMap.put(info.getTargetLayerId(), new ArrayList());
                    }
                    ((List)updateDatasetMap.get(info.getTargetLayerId())).add(new MyTuple<SpatioTemporalDatasetInfo, LayerUpdateLogRecord>(info, logRecord));
                };
                success = dataUpdater.run();
                this.updateVTileRenderIndex(updateDatasetMap);
                updateTask.setSucceed(success ? 1 : 0);
                updateTask.setStatus(success ? TaskStatusEnum.FinishedSuccessed.getValue() : TaskStatusEnum.FinishedFailed.getValue());
                updateTask.setEndTime(new Date());
                updateTask.setLog(JSONObject.toJSONString(logRecords.get()));
                this.updateTaskDao.updateByPrimaryKey(updateTask);
            }
            catch (Exception e) {
                try {
                    log.error(e.getMessage(), (Throwable)e);
                    UpdateTaskLog taskLog = new UpdateTaskLog();
                    taskLog.setTaskId(updateTask.getId());
                    taskLog.setTime(new Date());
                    taskLog.setLayerName(updateTask.getName());
                    taskLog.setContent(e.getMessage());
                    this.updateTaskLogDao.insert(taskLog);
                    updateTask.setSucceed(success ? 1 : 0);
                    updateTask.setStatus(success ? TaskStatusEnum.FinishedSuccessed.getValue() : TaskStatusEnum.FinishedFailed.getValue());
                    updateTask.setEndTime(new Date());
                    updateTask.setLog(JSONObject.toJSONString(logRecords.get()));
                    this.updateTaskDao.updateByPrimaryKey(updateTask);
                }
                catch (Throwable throwable) {
                    updateTask.setSucceed(success ? 1 : 0);
                    updateTask.setStatus(success ? TaskStatusEnum.FinishedSuccessed.getValue() : TaskStatusEnum.FinishedFailed.getValue());
                    updateTask.setEndTime(new Date());
                    updateTask.setLog(JSONObject.toJSONString(logRecords.get()));
                    this.updateTaskDao.updateByPrimaryKey(updateTask);
                    throw throwable;
                }
            }
        }
    }

    private void completeUpdater(InputTaskParameter inputTaskParameter, DataUpdater dataUpdater) {
        ArrayList<SpatioTemporalDatasetInfo> layers = new ArrayList<SpatioTemporalDatasetInfo>();
        dataUpdater.setTargetDbKey(inputTaskParameter.getTargetDatabaseKey());
        for (LayerRelationship layerRelationship : inputTaskParameter.getInputDatas()) {
            SpatioTemporalDatasetInfo datasetInfo = new SpatioTemporalDatasetInfo();
            datasetInfo.setDatasetObj(null);
            datasetInfo.setTargetDatasetName(inputTaskParameter.getTargetFeatureDatasetName());
            datasetInfo.setTargetLayerName(layerRelationship.getTargetLayerName());
            datasetInfo.setSourceLayerName(layerRelationship.getSourceLayerName());
            String frameName = FileUtil.getFileNameWithoutExtension((String)FileUtil.getDirectoryName((String)layerRelationship.getSourceLayerName()));
            datasetInfo.setFrameName(frameName);
            String fullName = layerRelationship.getTargetLayerName().contains(".") ? layerRelationship.getTargetLayerName() : "public." + layerRelationship.getTargetLayerName();
            String targetLayerId = DatasetUtil.getDatasetId((String)inputTaskParameter.getTargetDatabaseKey(), (DatasetTypeEnum)DatasetTypeEnum.FeatureClass, (String)fullName);
            datasetInfo.setTargetLayerId(targetLayerId);
            datasetInfo.setTime(layerRelationship.getTimePhase());
            layers.add(datasetInfo);
        }
        dataUpdater.setLayers(layers);
    }

    private void layerInputFinish(SpatioTemporalDatasetInfo info, LayerUpdateLogRecord logRecord) {
        try {
            if (StringUtil.isNotEmpty((String)logRecord.getLogInfo())) {
                UpdateTaskLog taskLog = new UpdateTaskLog();
                taskLog.setTaskId(this.taskId);
                taskLog.setTime(new Date());
                taskLog.setLayerName(logRecord.getTarLayerName());
                taskLog.setContent(logRecord.getLogInfo());
                this.updateTaskLogDao.insert(taskLog);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            UpdateTaskLog taskLog = new UpdateTaskLog();
            taskLog.setTaskId(this.taskId);
            taskLog.setTime(new Date());
            taskLog.setLayerName(logRecord.getTarLayerName());
            taskLog.setContent(e.getMessage());
            this.updateTaskLogDao.insert(taskLog);
        }
    }

    private void updateVTileRenderIndex(Map<String, List<MyTuple<SpatioTemporalDatasetInfo, LayerUpdateLogRecord>>> updateDatasetMap) {
        for (Map.Entry<String, List<MyTuple<SpatioTemporalDatasetInfo, LayerUpdateLogRecord>>> entry : updateDatasetMap.entrySet()) {
            String targetLayerId = entry.getKey();
            String targetLayerName = null;
            try {
                targetLayerName = ((SpatioTemporalDatasetInfo)entry.getValue().get((int)0).item1).getTargetLayerName();
                LayerUpdateLogRecord udpateLogRecord = new LayerUpdateLogRecord();
                udpateLogRecord.setTarLayerName(targetLayerName);
                udpateLogRecord.setSuccess(false);
                for (MyTuple<SpatioTemporalDatasetInfo, LayerUpdateLogRecord> tuple : entry.getValue()) {
                    SpatioTemporalDatasetInfo info = (SpatioTemporalDatasetInfo)tuple.item1;
                    LayerUpdateLogRecord logRecord = (LayerUpdateLogRecord)tuple.item2;
                    if (logRecord.getSuccess().booleanValue()) {
                        udpateLogRecord.setSuccess(true);
                    }
                    if (logRecord.maxUpdateTime.after(udpateLogRecord.maxUpdateTime)) {
                        udpateLogRecord.maxUpdateTime = logRecord.maxUpdateTime;
                    }
                    if (logRecord.dataUpdateExtent == null) continue;
                    if (udpateLogRecord.dataUpdateExtent == null) {
                        udpateLogRecord.dataUpdateExtent = logRecord.dataUpdateExtent;
                        continue;
                    }
                    IGeometry geo = udpateLogRecord.dataUpdateExtent.union(logRecord.dataUpdateExtent);
                    if (geo == null) continue;
                    udpateLogRecord.dataUpdateExtent = geo;
                }
                if (!udpateLogRecord.getSuccess().booleanValue()) continue;
                DatasetRenderDTO render = this.dataSourceManager.getDatasetRender(targetLayerId);
                if (render == null) {
                    String serviceName = PinyinUtil.convertToPinYin((String)targetLayerName).toLowerCase(Locale.ROOT);
                    if (serviceName.length() > 60) {
                        serviceName = serviceName.substring(0, 60);
                    }
                    VTileServiceCreateDTO serviceCreateDTO = new VTileServiceCreateDTO();
                    serviceCreateDTO.setServiceName(serviceName);
                    serviceCreateDTO.setDatasetId(targetLayerId);
                    serviceCreateDTO.setCreateMapCache(Boolean.valueOf(true));
                    this.renderIndexService.createVectorRenderIndex(serviceCreateDTO);
                    continue;
                }
                VTileRenderIndexUpdater vTileUpdater = new VTileRenderIndexUpdater();
                vTileUpdater.updateVTileService(render, udpateLogRecord);
            }
            catch (Exception e) {
                log.error(targetLayerName, (Throwable)e);
            }
        }
    }
}

