/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.webstore.update.manager.task;

import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.common.util.PinyinUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.config.dto.user.LoginUserInfo;
import com.geoway.adf.dms.config.util.ThreadLocalUtil;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.renderindex.DatasetRenderDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.VTileServiceCreateDTO;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.RenderIndexService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.webstore.datamodel.dao.LayerUpdateInfoDao;
import com.geoway.webstore.datamodel.dao.LayerVersionKeyInfoDao;
import com.geoway.webstore.datamodel.dao.UpdateCaseInfoDao;
import com.geoway.webstore.datamodel.entity.LayerUpdateInfo;
import com.geoway.webstore.datamodel.entity.UpdateCaseInfo;
import com.geoway.webstore.update.constant.TaskStatusEnum;
import com.geoway.webstore.update.constant.UpdateTaskTypeEnum;
import com.geoway.webstore.update.dao.UpdateTaskDao;
import com.geoway.webstore.update.dao.UpdateTaskLogDao;
import com.geoway.webstore.update.dto.LayerUpdateLogRecord;
import com.geoway.webstore.update.dto.SpatioTemporalDatasetInfo;
import com.geoway.webstore.update.dto.param.RevokeTaskParameter;
import com.geoway.webstore.update.entity.UpdateTask;
import com.geoway.webstore.update.entity.UpdateTaskLog;
import com.geoway.webstore.update.manager.DataUpdater;
import com.geoway.webstore.update.manager.DataUpdaterFactory;
import com.geoway.webstore.update.manager.VTileRenderIndexUpdater;
import com.geoway.webstore.update.manager.task.IUpdateTaskExecutor;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class RevokeTaskExecutor
implements IUpdateTaskExecutor {
    private static final Logger log = LoggerFactory.getLogger(RevokeTaskExecutor.class);
    private final UpdateTaskDao updateTaskDao = (UpdateTaskDao)SpringContextUtil.getBean(UpdateTaskDao.class);
    private final ThreadPoolTaskExecutor executor = (ThreadPoolTaskExecutor)SpringContextUtil.getBean((String)"threadPoolTaskExecutorData", ThreadPoolTaskExecutor.class);
    private final UpdateCaseInfoDao updateCaseinfoDao = (UpdateCaseInfoDao)SpringContextUtil.getBean(UpdateCaseInfoDao.class);
    private final LayerUpdateInfoDao layerUpdateInfoDao = (LayerUpdateInfoDao)SpringContextUtil.getBean(LayerUpdateInfoDao.class);
    private final UpdateTaskLogDao updateTaskLogDao = (UpdateTaskLogDao)SpringContextUtil.getBean(UpdateTaskLogDao.class);
    private final LayerVersionKeyInfoDao versionKeyInfoDao = (LayerVersionKeyInfoDao)SpringContextUtil.getBean(LayerVersionKeyInfoDao.class);
    private final RenderIndexService renderIndexService = (RenderIndexService)SpringContextUtil.getBean(RenderIndexService.class);
    private final DataSourceManager dataSourceManager = (DataSourceManager)SpringContextUtil.getBean(DataSourceManager.class);
    private String targetDbKey;
    private Long taskId;

    @Override
    public void execute(UpdateTask updateTask) {
        LoginUserInfo loginUserInfo = ThreadLocalUtil.getCurrentUser();
        this.executor.execute(() -> {
            if (loginUserInfo != null) {
                ThreadLocalUtil.addCurrentUser((LoginUserInfo)loginUserInfo);
            }
            this.doExecutor(updateTask);
            if (loginUserInfo != null) {
                ThreadLocalUtil.removeUser();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecutor(UpdateTask updateTask) {
        this.taskId = updateTask.getId();
        AtomicInteger totalCount = new AtomicInteger();
        AtomicReference logRecords = new AtomicReference(new ArrayList());
        UpdateTaskTypeEnum taskTypeEnum = UpdateTaskTypeEnum.getByValue(updateTask.getTaskType());
        AtomicReference<SpatioTemporalDatasetInfo> curStDatasetInfo = new AtomicReference<SpatioTemporalDatasetInfo>(new SpatioTemporalDatasetInfo());
        if (taskTypeEnum == UpdateTaskTypeEnum.Cancel) {
            boolean success = false;
            try {
                updateTask.setStatus(TaskStatusEnum.Processing.getValue());
                updateTask.setStartTime(new Date());
                updateTask.setEndTime(null);
                this.updateTaskDao.updateByPrimaryKey(updateTask);
                String taskParameter = updateTask.getParam();
                RevokeTaskParameter revokeTaskParameter = (RevokeTaskParameter)JSONObject.parseObject((String)taskParameter, RevokeTaskParameter.class);
                if (revokeTaskParameter == null || revokeTaskParameter.getCaseId() == null) {
                    throw new RuntimeException("CaseID\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u64a4\u9500\uff01");
                }
                DataUpdater dataUpdater = DataUpdaterFactory.createRevokeDataUpdater();
                this.completeUpdater(revokeTaskParameter.getCaseId(), dataUpdater);
                curStDatasetInfo.set(dataUpdater.getLayers().get(0));
                dataUpdater.progressMessageChanged = msg -> {
                    UpdateTaskLog taskLog = new UpdateTaskLog();
                    taskLog.setTaskId(updateTask.getId());
                    taskLog.setTime(new Date());
                    taskLog.setLayerName(((SpatioTemporalDatasetInfo)curStDatasetInfo.get()).getSourceLayerName());
                    taskLog.setContent(msg);
                    this.updateTaskLogDao.insert(taskLog);
                };
                dataUpdater.progressCountChanged = totalCount::set;
                dataUpdater.progressPositionChanged = value -> {
                    updateTask.setProgress(value / totalCount.get() * 100);
                    this.updateTaskDao.updateByPrimaryKey(updateTask);
                };
                dataUpdater.layerUpdateChanged = curStDatasetInfo::set;
                dataUpdater.layerUpdateFinished = this::layerUpdateFinished;
                success = dataUpdater.run();
                updateTask.setSucceed(success ? 1 : 0);
                updateTask.setStatus(success ? TaskStatusEnum.FinishedSuccessed.getValue() : TaskStatusEnum.FinishedFailed.getValue());
                updateTask.setEndTime(new Date());
                updateTask.setLog(JSONObject.toJSONString(logRecords.get()));
                this.updateTaskDao.updateByPrimaryKey(updateTask);
            }
            catch (Exception e) {
                try {
                    log.error(e.getMessage(), (Throwable)e);
                    UpdateTaskLog taskLog = new UpdateTaskLog();
                    taskLog.setTaskId(updateTask.getId());
                    taskLog.setTime(new Date());
                    taskLog.setLayerName(updateTask.getName());
                    taskLog.setContent(e.getMessage());
                    this.updateTaskLogDao.insert(taskLog);
                    updateTask.setSucceed(success ? 1 : 0);
                    updateTask.setStatus(success ? TaskStatusEnum.FinishedSuccessed.getValue() : TaskStatusEnum.FinishedFailed.getValue());
                    updateTask.setEndTime(new Date());
                    updateTask.setLog(JSONObject.toJSONString(logRecords.get()));
                    this.updateTaskDao.updateByPrimaryKey(updateTask);
                }
                catch (Throwable throwable) {
                    updateTask.setSucceed(success ? 1 : 0);
                    updateTask.setStatus(success ? TaskStatusEnum.FinishedSuccessed.getValue() : TaskStatusEnum.FinishedFailed.getValue());
                    updateTask.setEndTime(new Date());
                    updateTask.setLog(JSONObject.toJSONString(logRecords.get()));
                    this.updateTaskDao.updateByPrimaryKey(updateTask);
                    throw throwable;
                }
            }
        }
    }

    private void completeUpdater(Long cassId, DataUpdater dataUpdater) {
        UpdateCaseInfo caseInfo = this.updateCaseinfoDao.selectByPrimaryKey(cassId);
        List infos = this.layerUpdateInfoDao.selectByTaskID(caseInfo.getId());
        List<LayerUpdateInfo> currentUpdateInfos = this.getDistinctRegionUpdateTimeInfo(infos);
        if (currentUpdateInfos.size() <= 0) {
            throw new RuntimeException("\u56fe\u5c42\u66f4\u65b0\u8bb0\u5f55\u4e22\u5931\uff01");
        }
        String datasetId = currentUpdateInfos.get(0).getDatasetId();
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo((String)datasetId);
        this.targetDbKey = datasetNameInfo.getDsKey();
        dataUpdater.setTargetDbKey(this.targetDbKey);
        dataUpdater.setUpdateTaskId(currentUpdateInfos.get(0).getCaseId());
        List<SpatioTemporalDatasetInfo> spatioTemporalDatasetInfos = this.getLayers(currentUpdateInfos);
        dataUpdater.setLayers(spatioTemporalDatasetInfos);
    }

    private List<LayerUpdateInfo> getDistinctRegionUpdateTimeInfo(List<LayerUpdateInfo> source) {
        ArrayList<LayerUpdateInfo> result = new ArrayList<LayerUpdateInfo>();
        for (LayerUpdateInfo item : source) {
            boolean exist = result.stream().anyMatch(p -> p.getLayerName().equals(item.getLayerName()) && p.getPostDateTime() == item.getPostDateTime() && p.getPreDateTime() == item.getPreDateTime());
            if (exist) continue;
            result.add(item);
        }
        return result;
    }

    private List<SpatioTemporalDatasetInfo> getLayers(List<LayerUpdateInfo> source) {
        ArrayList<SpatioTemporalDatasetInfo> spatioTemporalDatasetInfos = new ArrayList<SpatioTemporalDatasetInfo>();
        for (LayerUpdateInfo info : source) {
            SpatioTemporalDatasetInfo layer = new SpatioTemporalDatasetInfo();
            layer.setSourceLayerName(info.getLayerName());
            String targetLayerName = info.getLayerName() + "_WORK";
            layer.setTargetLayerName(targetLayerName);
            String fullName = targetLayerName.contains(".") ? targetLayerName : "public." + targetLayerName;
            String targetLayerId = DatasetUtil.getDatasetId((String)this.targetDbKey, (DatasetTypeEnum)DatasetTypeEnum.FeatureClass, (String)fullName);
            layer.setTargetLayerId(targetLayerId);
            spatioTemporalDatasetInfos.add(layer);
        }
        return spatioTemporalDatasetInfos;
    }

    private void layerUpdateFinished(SpatioTemporalDatasetInfo info, LayerUpdateLogRecord logRecord) {
        try {
            if (StringUtil.isNotEmpty((String)logRecord.getLogInfo())) {
                UpdateTaskLog taskLog = new UpdateTaskLog();
                taskLog.setTaskId(this.taskId);
                taskLog.setTime(new Date());
                taskLog.setLayerName(logRecord.getSrcLayerName());
                taskLog.setContent(logRecord.getLogInfo());
                this.updateTaskLogDao.insert(taskLog);
            }
            if (logRecord.getSuccess().booleanValue()) {
                String serviceName;
                String layerId = DatasetUtil.getDatasetId((String)this.targetDbKey, (DatasetTypeEnum)DatasetTypeEnum.FeatureClass, (String)("public." + info.getSourceLayerName()));
                DatasetRenderDTO render = this.dataSourceManager.getDatasetRender(layerId);
                if (render != null) {
                    VTileRenderIndexUpdater vTileUpdater = new VTileRenderIndexUpdater();
                    vTileUpdater.updateVTileService(render, logRecord);
                }
                if ((serviceName = PinyinUtil.convertToPinYin((String)info.getTargetLayerName()).toLowerCase(Locale.ROOT)).length() > 60) {
                    serviceName = serviceName.substring(0, 60);
                }
                VTileServiceCreateDTO serviceCreateDTO = new VTileServiceCreateDTO();
                serviceCreateDTO.setServiceName(serviceName);
                String workLayerId = info.getTargetLayerId();
                serviceCreateDTO.setDatasetId(workLayerId);
                this.renderIndexService.createVectorRenderIndex(serviceCreateDTO);
            }
        }
        catch (Exception e) {
            UpdateTaskLog taskLog = new UpdateTaskLog();
            taskLog.setTaskId(this.taskId);
            taskLog.setTime(new Date());
            taskLog.setLayerName(logRecord.getSrcLayerName());
            taskLog.setContent(e.getMessage());
            this.updateTaskLogDao.insert(taskLog);
        }
    }
}

