/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.webstore.update.util;

import com.geoway.adf.gis.basic.geometry.IEnvelope;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.field.IFields;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CopyFeatureHelper {
    public static List<String> getCommonCustomFields(IFeatureClass fcSource) {
        ArrayList<String> result = new ArrayList<String>();
        IFields pFields = fcSource.getFields();
        for (IField fld : pFields) {
            if (fld.getFieldType() == FieldType.OID || fld.getFieldType() == FieldType.Shape || result.contains(fld.getName().toUpperCase(Locale.ROOT))) continue;
            result.add(fld.getName().toUpperCase(Locale.ROOT));
        }
        return result;
    }

    public static Boolean startEdit(IFeatureClass trgFeatureClass) {
        IFeatureWorkspace pWorkspace = trgFeatureClass.getWorkspace();
        if (pWorkspace == null) {
            return false;
        }
        if (!pWorkspace.getInTransaction()) {
            pWorkspace.beginTransaction();
        }
        return true;
    }

    public static void stopEdit(IFeatureClass trgFeatureClass, boolean isSave) {
        IFeatureWorkspace pWorkspace = trgFeatureClass.getWorkspace();
        if (pWorkspace == null) {
            return;
        }
        if (pWorkspace.getInTransaction()) {
            if (isSave) {
                pWorkspace.commitTransaction();
            } else {
                pWorkspace.rollbackTransaction();
            }
        }
    }

    public static Boolean copyFeature(IFeature sourceFeature, IFeature targetFeature, ISpatialReferenceSystem spatialReference, List<String> targetFields, IEnvelope dataExtent) {
        IGeometry pNewShape = sourceFeature.getGeometry();
        IGeometry pCopyGeo = null;
        pCopyGeo = !SpatialReferenceSystemFunc.equals((ISpatialReferenceSystem)sourceFeature.getFeatureClass().getSpatialReferenceSystem(), (ISpatialReferenceSystem)spatialReference) ? pNewShape.projectToCopy(sourceFeature.getFeatureClass().getSpatialReferenceSystem(), spatialReference) : pNewShape;
        targetFeature.setGeometry(pCopyGeo);
        if (pCopyGeo != null) {
            CopyFeatureHelper.unionExtent(dataExtent, pCopyGeo.getEnvelope());
        }
        CopyFeatureHelper.copyCustomFields(targetFields, (IRow)sourceFeature, (IRow)targetFeature);
        return true;
    }

    public static void copyCustomFields(List<String> cmCustomFields, IRow srcFeature, IRow trgFcBuffer) {
        for (String name : cmCustomFields) {
            CopyFeatureHelper.copyFieldValueByName(srcFeature, trgFcBuffer, name, name);
        }
    }

    public static void copyFieldValueByName(IRow srcFeature, IRow desFeature, String srcFldName, String desFldName) {
        int srcIndex = srcFeature.getFields().findFieldIndex(srcFldName);
        if (srcIndex == -1) {
            return;
        }
        Object objValue = srcFeature.getValue(srcIndex);
        int desIndex = desFeature.getFields().findFieldIndex(desFldName);
        if (desIndex == -1) {
            switch (desFldName) {
                case "SHAPE_LENGTH": {
                    desFldName = "SHAPE.LEN";
                    break;
                }
                case "SHAPE_AREA": {
                    desFldName = "SHAPE.AREA";
                    break;
                }
                case "SHAPE.LEN": {
                    desFldName = "SHAPE_LENGTH";
                    break;
                }
                case "SHAPE.AREA": {
                    desFldName = "SHAPE_AREA";
                    break;
                }
            }
            desIndex = desFeature.getFields().findFieldIndex(desFldName);
        }
        if (desIndex == -1) {
            return;
        }
        IField pField = desFeature.getFields().getField(desIndex);
        desFeature.setValue(desIndex, objValue);
    }

    public static void setExtentFields(IRow buffer, Map<String, String> dicExtendFields) {
        try {
            if (dicExtendFields == null || dicExtendFields.size() == 0) {
                return;
            }
            for (String item : dicExtendFields.keySet()) {
                CopyFeatureHelper.setValue(buffer, item, dicExtendFields.get(item));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setValue(IRow buffer, String fldName, Object fldValue) {
        int targetIndex = buffer.getFields().findFieldIndex(fldName);
        if (targetIndex > -1) {
            IField targetField = buffer.getFields().getField(targetIndex);
            buffer.setValue(targetIndex, fldValue);
        }
    }

    public static void unionExtent(IEnvelope extent1, IEnvelope extent2) {
        extent1.setXMin(Math.min(extent1.getXMin(), extent2.getXMin()));
        extent1.setYMin(Math.min(extent1.getYMin(), extent2.getYMin()));
        extent1.setXMax(Math.max(extent1.getXMax(), extent2.getXMax()));
        extent1.setYMax(Math.max(extent1.getYMax(), extent2.getYMax()));
    }
}

