/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.webstore.update.manager;

import com.geoway.webstore.datamodel.entity.LayerUpdateInfo;
import com.geoway.webstore.datamodel.entity.LayerVersionKeyInfo;
import com.geoway.webstore.datamodel.entity.VersionHistoryInfo;
import com.geoway.webstore.update.dto.LayerUpdateLogRecord;
import com.geoway.webstore.update.dto.SpatioTemporalDatasetInfo;
import com.geoway.webstore.update.manager.DataUpdater;
import com.geoway.webstore.update.manager.LayerUpdaterRevoke;
import com.geoway.webstore.update.util.VersionDeleteHelper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class GeowayDataUpdaterRevoke
extends DataUpdater {
    @Override
    public void setTargetDbKey(String dbKey) {
        super.setTargetDbKey(dbKey);
    }

    @Override
    public boolean run() {
        this.invokeProgressCountChanged(this.layers.size());
        int count = 0;
        this.successfulResultObjects = new ArrayList();
        List lstUpdateTimeInfo = this.layerUpdateInfoDao.selectByTaskID(this.updateTaskId);
        for (SpatioTemporalDatasetInfo stDataInfo : this.layers) {
            this.invokeProgressPositionChanged(count++);
            this.invokeLayerUpdateChanged(stDataInfo);
            this.invokeProgressMessageChanged(String.format("\u5f00\u59cb\u64a4\u9500\u56fe\u5c42%s\u66f4\u65b0", stDataInfo.getSourceLayerName()));
            LayerUpdateLogRecord logRecord = new LayerUpdateLogRecord();
            logRecord.setSrcLayerName(stDataInfo.getSourceLayerName());
            logRecord.setTarLayerName(stDataInfo.getSourceLayerName());
            LayerUpdaterRevoke updater = new LayerUpdaterRevoke();
            updater.updateTaskId = this.updateTaskId;
            updater.progressMessageChanged = x$0 -> super.invokeProgressMessageChanged(x$0);
            updater.setGwWorkspace(this.dbKey);
            updater.update(stDataInfo, logRecord);
            this.logRecords.add(logRecord);
            if (logRecord.getSuccess().booleanValue()) {
                List updateInfoList = lstUpdateTimeInfo.stream().filter(p -> p.getLayerName().toLowerCase(Locale.ROOT).equals(stDataInfo.getSourceLayerName().toLowerCase(Locale.ROOT))).collect(Collectors.toList());
                if (updateInfoList.size() > 0) {
                    LayerUpdateInfo currentRegionUpdateTimeInfo = (LayerUpdateInfo)updateInfoList.get(0);
                    this.invokeProgressMessageChanged(String.format("\u603b\u5171\u64a4\u9500\u66f4\u65b0%d\u6761\u8981\u7d20\uff0c\u5176\u4e2d\u64a4\u9500\u589e\u52a0%d\u6761\u8981\u7d20\uff0c\u64a4\u9500\u4fee\u6539%d\u6761\u8981\u7d20\uff0c\u64a4\u9500\u5220\u9664%d\u6761\u8981\u7d20", logRecord.addFeatureCount + logRecord.updateFeatureCount + logRecord.delFeatureCount, logRecord.addFeatureCount, logRecord.updateFeatureCount, logRecord.delFeatureCount));
                    this.updateTimeSpan(this.dbKey, stDataInfo.getSourceLayerName(), currentRegionUpdateTimeInfo.getPreDateTime());
                    this.deleteHistoryVersion(stDataInfo.getSourceLayerName(), currentRegionUpdateTimeInfo.getPostDateTime());
                    this.layerUpdateInfoDao.deleteByPrimaryKey(currentRegionUpdateTimeInfo.getId());
                    this.successfulResultObjects.add(stDataInfo.getSourceLayerName());
                    this.invokeProgressMessageChanged(String.format("\u56fe\u5c42%s\u64a4\u9500\u66f4\u65b0\u5b8c\u6210", stDataInfo.getSourceLayerName()));
                }
            } else {
                this.invokeProgressMessageChanged(String.format("\u56fe\u5c42%s\u64a4\u9500\u66f4\u65b0\u5931\u8d25", stDataInfo.getSourceLayerName()));
            }
            this.invokeLayerUpdateFinished(stDataInfo, logRecord);
        }
        this.invokeProgressPositionChanged(this.layers.size());
        return true;
    }

    private void deleteHistoryVersion(String layerName, Date refDateTime) {
        LayerVersionKeyInfo versionKeyInfo = this.versionKeyInfoDao.selectByNonceLayer(this.dbKey, layerName);
        List versions = this.versionHistoryInfoDao.selectByKeyInfoId(versionKeyInfo.getId());
        for (int i = 0; i < versions.size(); ++i) {
            boolean deleteVersion = false;
            if (refDateTime.before(((VersionHistoryInfo)versions.get(i)).getStartTime())) {
                deleteVersion = true;
            } else if (refDateTime == ((VersionHistoryInfo)versions.get(i)).getStartTime()) {
                deleteVersion = true;
            }
            if (!deleteVersion) continue;
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            if (VersionDeleteHelper.delete(((VersionHistoryInfo)versions.get(i)).getDatasetId()).booleanValue()) {
                this.invokeProgressMessageChanged(String.format("\u56fe\u5c42%s\u7684\u65f6\u95f4\u70b9\u4e3a%s\u7684\u5386\u53f2\u7248\u672c%s\u5220\u9664\u6210\u529f\u3002", layerName, format.format(((VersionHistoryInfo)versions.get(i)).getStartTime()), ((VersionHistoryInfo)versions.get(i)).getLayerName()));
                continue;
            }
            this.invokeProgressMessageChanged(String.format("\u56fe\u5c42%s\u7684\u65f6\u95f4\u70b9\u4e3a%s\u7684\u5386\u53f2\u7248\u672c%s\u5220\u9664\u5931\u8d25\u3002", layerName, format.format(((VersionHistoryInfo)versions.get(i)).getStartTime()), ((VersionHistoryInfo)versions.get(i)).getLayerName()));
        }
    }
}

