/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.webstore.update.manager;

import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DatabaseDTO;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.IEnvelope;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.webstore.datamodel.constant.STDataChangeTypeEnum;
import com.geoway.webstore.datamodel.dao.LayerVersionKeyInfoDao;
import com.geoway.webstore.datamodel.entity.LayerVersionKeyInfo;
import com.geoway.webstore.update.constant.MyTuple;
import com.geoway.webstore.update.dto.LayerUpdateLogRecord;
import com.geoway.webstore.update.dto.SpatioTemporalDatasetInfo;
import com.geoway.webstore.update.manager.listener.IProgressMessageCallBack;
import com.geoway.webstore.update.util.CopyFeatureHelper;
import com.geoway.webstore.update.util.DataUpdateHelper;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

public class LayerUpdater {
    protected final LayerVersionKeyInfoDao versionKeyInfoDao = (LayerVersionKeyInfoDao)SpringContextUtil.getBean(LayerVersionKeyInfoDao.class);
    protected final GeoDatabaseService geoDatabaseService = (GeoDatabaseService)SpringContextUtil.getBean(GeoDatabaseService.class);
    protected IFeatureWorkspace gwWorkspace;
    protected String dbKey;
    private String fldChangeType;
    private String fldUpdateTime;
    private Map<STDataChangeTypeEnum, String> dicUpdateValue;
    protected IFeatureClass sourceFc;
    protected IFeatureClass nonceFc;
    protected IFeatureClass workFc;
    protected List<String> cmCustomFields;
    protected String uniqueField;
    protected SpatioTemporalDatasetInfo stDataInfo;
    protected LayerVersionKeyInfo versionKeyInfo;
    protected IFeatureCursor nonceInsertCursor;
    protected IFeatureCursor workInsertCursor;
    protected IEnvelope dataExtentOfNonce;
    protected IEnvelope dataExtentOfWork;
    public Long updateTaskId;
    public String filter;
    public Map<String, String> extendFields;
    public IProgressMessageCallBack progressMessageChanged;

    public String getFldChangeType() {
        return this.fldChangeType;
    }

    public void setFldChangeType(String fldChangeType) {
        this.fldChangeType = fldChangeType;
    }

    public String getFldUpdateTime() {
        return this.fldUpdateTime;
    }

    public void setFldUpdateTime(String fldUpdateTime) {
        this.fldUpdateTime = fldUpdateTime;
    }

    public Map<STDataChangeTypeEnum, String> getDicUpdateValue() {
        return this.dicUpdateValue;
    }

    public void setDicUpdateValue(Map<STDataChangeTypeEnum, String> dicUpdateValue) {
        this.dicUpdateValue = dicUpdateValue;
    }

    public void setGwWorkspace(String targetDatabaseKey) {
        this.dbKey = targetDatabaseKey;
        DatabaseDTO dataSourceDTO = this.geoDatabaseService.getDatabaseDetail(targetDatabaseKey);
        this.gwWorkspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)dataSourceDTO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(SpatioTemporalDatasetInfo stDataInfo, LayerUpdateLogRecord logRecord) {
        boolean hasException;
        block38: {
            this.stDataInfo = stDataInfo;
            int addFeaCount = 0;
            int delFeaCount = 0;
            int updateFeaCount = 0;
            int allFeaCount = 0;
            logRecord.setSuccess(false);
            logRecord.addFeatureCount = 0;
            logRecord.delFeatureCount = 0;
            logRecord.updateFeatureCount = 0;
            logRecord.allFeatureCount = 0;
            if (!this.checkAndInitDataset(logRecord).booleanValue()) {
                return;
            }
            if (!this.startEdit(logRecord).booleanValue()) {
                return;
            }
            Date maxFeatureUpdateTime = new Date();
            try {
                maxFeatureUpdateTime = new SimpleDateFormat("yyyy-MM-dd").parse("1000-1-1");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Date currentLayerTimeStamp = this.versionKeyInfo.getTimestamp();
            hasException = false;
            this.nonceInsertCursor = null;
            this.workInsertCursor = null;
            IQueryFilter queryFilter = this.getUpdateQueryFilter(this.sourceFc);
            IFeatureCursor sourceCursor = this.sourceFc.searchFeature(queryFilter);
            if (sourceCursor == null) {
                logRecord.setLogInfo(String.format("\u56fe\u5c42%s\u67e5\u8be2\u5931\u8d25,\u67e5\u8be2\u6761\u4ef6:%s", stDataInfo.getSourceLayerName(), queryFilter.getWhereClause()));
                return;
            }
            try {
                int changeTypeIndex = sourceCursor.getFields().findFieldIndex(this.fldChangeType);
                int changeTimeIndex = sourceCursor.getFields().findFieldIndex(this.fldUpdateTime);
                this.stDataInfo.setUpdateTypeFld(this.fldChangeType);
                this.stDataInfo.setFeatureType(this.sourceFc.getFeatureType());
                this.nonceInsertCursor = this.nonceFc.insertFeature();
                this.workInsertCursor = this.workFc.insertFeature();
                IFeature feature = sourceCursor.nextFeature();
                while (feature != null) {
                    MyTuple<Boolean, String> saveResult;
                    ++allFeaCount;
                    Object changeValue = feature.getValue(changeTypeIndex);
                    if (changeValue == null) {
                        feature = sourceCursor.nextFeature();
                        continue;
                    }
                    STDataChangeTypeEnum changeType = this.getChangeType(changeValue.toString());
                    if (changeType == null) {
                        feature = sourceCursor.nextFeature();
                        continue;
                    }
                    Object changeTimeValue = feature.getValue(changeTimeIndex);
                    Date updateDateTime = (Date)changeTimeValue;
                    if (updateDateTime == null) {
                        String msg = String.format("\u56fe\u5c42%s\u7684OID\u4e3a%s\u7684\u8981\u7d20\u66f4\u65b0\u65f6\u95f4\u5b57\u6bb5\u503c\u5f02\u5e38\u3002", stDataInfo.getSourceLayerName(), feature.getObjectId());
                        this.invokeProgressMessageChanged(msg);
                        feature = sourceCursor.nextFeature();
                        continue;
                    }
                    switch (changeType) {
                        case Add: {
                            saveResult = this.addFeature(feature, updateDateTime);
                            if (!((Boolean)saveResult.item1).booleanValue()) {
                                this.invokeProgressMessageChanged((String)saveResult.item2);
                                break;
                            }
                            if (++addFeaCount % 2000 != 0) break;
                            break;
                        }
                        case PropertyChange: {
                            saveResult = this.modifyFeature(feature, updateDateTime, changeType, changeValue.toString(), true, false);
                            if (!((Boolean)saveResult.item1).booleanValue()) {
                                this.invokeProgressMessageChanged((String)saveResult.item2);
                                break;
                            }
                            ++updateFeaCount;
                            break;
                        }
                        case ShapeChange: {
                            saveResult = this.modifyFeature(feature, updateDateTime, changeType, changeValue.toString(), false, true);
                            if (!((Boolean)saveResult.item1).booleanValue()) {
                                this.invokeProgressMessageChanged((String)saveResult.item2);
                                break;
                            }
                            ++updateFeaCount;
                            break;
                        }
                        case AllChange: {
                            saveResult = this.modifyFeature(feature, updateDateTime, changeType, changeValue.toString(), true, true);
                            if (!((Boolean)saveResult.item1).booleanValue()) {
                                this.invokeProgressMessageChanged((String)saveResult.item2);
                                break;
                            }
                            ++updateFeaCount;
                            break;
                        }
                        case Delete: {
                            saveResult = this.deleteFeature(feature, updateDateTime);
                            if (!((Boolean)saveResult.item1).booleanValue()) {
                                this.invokeProgressMessageChanged((String)saveResult.item2);
                                break;
                            }
                            ++delFeaCount;
                            break;
                        }
                        default: {
                            saveResult = new MyTuple<Boolean, String>(false, "\u66f4\u65b0\u7c7b\u578b\u9519\u8bef\uff1a" + changeType.getDesc());
                        }
                    }
                    if (((Boolean)saveResult.item1).booleanValue()) {
                        if (allFeaCount % 2000 == 0) {
                            // empty if block
                        }
                        if (updateDateTime.after(maxFeatureUpdateTime)) {
                            maxFeatureUpdateTime = updateDateTime;
                        }
                    }
                    feature = sourceCursor.nextFeature();
                }
                this.nonceInsertCursor.release();
                this.workInsertCursor.release();
                logRecord.dataUpdateExtent = this.dataExtentOfWork == null ? null : GeometryFunc.createGeometry((String)this.dataExtentOfWork.toWkt());
                this.updateExtent();
                maxFeatureUpdateTime = currentLayerTimeStamp.after(maxFeatureUpdateTime) ? currentLayerTimeStamp : maxFeatureUpdateTime;
                logRecord.addFeatureCount = addFeaCount;
                logRecord.delFeatureCount = delFeaCount;
                logRecord.updateFeatureCount = updateFeaCount;
                logRecord.allFeatureCount = allFeaCount;
                logRecord.setSuccess(allFeaCount - addFeaCount - updateFeaCount - delFeaCount == 0);
                logRecord.setLogInfo(String.format("\u589e\u52a0%d\u6761\u8981\u7d20\uff0c\u4fee\u6539%d\u6761\u8981\u7d20\uff0c\u5220\u9664%d\u6761\u8981\u7d20\uff0c\u5931\u8d25%d\u6761\u8981\u7d20", addFeaCount, updateFeaCount, delFeaCount, allFeaCount - addFeaCount - updateFeaCount - delFeaCount));
                logRecord.currentLayerTime = currentLayerTimeStamp;
                logRecord.maxUpdateTime = maxFeatureUpdateTime;
                if (sourceCursor == null) break block38;
            }
            catch (Exception e) {
                block39: {
                    try {
                        e.printStackTrace();
                        logRecord.setLogInfo(String.format("\u56fe\u5c42%s\u66f4\u65b0\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef\uff1a%s", stDataInfo.getTargetLayerName(), e.getMessage()));
                        hasException = true;
                        if (sourceCursor == null) break block39;
                    }
                    catch (Throwable throwable) {
                        if (sourceCursor != null) {
                            sourceCursor.release();
                        }
                        if (this.nonceInsertCursor != null) {
                            this.nonceInsertCursor.release();
                        }
                        if (this.workInsertCursor != null) {
                            this.workInsertCursor.release();
                        }
                        this.nonceInsertCursor = null;
                        this.workInsertCursor = null;
                        CopyFeatureHelper.stopEdit(this.nonceFc, !hasException);
                        CopyFeatureHelper.stopEdit(this.workFc, !hasException);
                        if (this.gwWorkspace != null) {
                            this.gwWorkspace.close();
                        }
                        throw throwable;
                    }
                    sourceCursor.release();
                }
                if (this.nonceInsertCursor != null) {
                    this.nonceInsertCursor.release();
                }
                if (this.workInsertCursor != null) {
                    this.workInsertCursor.release();
                }
                this.nonceInsertCursor = null;
                this.workInsertCursor = null;
                CopyFeatureHelper.stopEdit(this.nonceFc, !hasException);
                CopyFeatureHelper.stopEdit(this.workFc, !hasException);
                if (this.gwWorkspace != null) {
                    this.gwWorkspace.close();
                }
            }
            sourceCursor.release();
        }
        if (this.nonceInsertCursor != null) {
            this.nonceInsertCursor.release();
        }
        if (this.workInsertCursor != null) {
            this.workInsertCursor.release();
        }
        this.nonceInsertCursor = null;
        this.workInsertCursor = null;
        CopyFeatureHelper.stopEdit(this.nonceFc, !hasException);
        CopyFeatureHelper.stopEdit(this.workFc, !hasException);
        if (this.gwWorkspace != null) {
            this.gwWorkspace.close();
        }
    }

    protected Boolean checkAndInitDataset(LayerUpdateLogRecord logRecord) {
        this.sourceFc = (IFeatureClass)this.stDataInfo.getDatasetObj();
        if (this.sourceFc == null) {
            logRecord.setLogInfo(String.format("\u56fe\u5c42%s\u7684\u6570\u636e\u6e90\u4fe1\u606f\u4e22\u5931\u3002", this.stDataInfo.getSourceLayerName()));
            return false;
        }
        this.versionKeyInfo = this.versionKeyInfoDao.selectByFeatureClassId(this.stDataInfo.getTargetLayerId());
        if (this.versionKeyInfo == null) {
            logRecord.setLogInfo(String.format("\u627e\u4e0d\u5230\u56fe\u5c42%s\u7684\u65f6\u7a7a\u6570\u636e\u6a21\u578b\u4fe1\u606f\u3002", this.stDataInfo.getTargetLayerName()));
            return false;
        }
        this.uniqueField = this.versionKeyInfo.getUniqueField();
        if (StringUtil.isEmptyOrWhiteSpace((String)this.uniqueField)) {
            logRecord.setLogInfo(String.format("\u56fe\u5c42%s\u7684\u65f6\u7a7a\u6570\u636e\u6a21\u578b\u552f\u4e00\u6807\u8bc6\u5b57\u6bb5\u4e3a\u7a7a\u3002", this.stDataInfo.getTargetLayerName()));
            return false;
        }
        int index = this.sourceFc.getFields().findFieldIndex(this.uniqueField);
        if (index < 0) {
            logRecord.setLogInfo(String.format("\u56fe\u5c42%s\u7f3a\u5931\u5b57\u6bb5%s\u3002", this.stDataInfo.getSourceLayerName(), this.uniqueField));
            return false;
        }
        int changeTypeIndex = this.sourceFc.getFields().findFieldIndex(this.fldChangeType);
        if (changeTypeIndex < 0) {
            logRecord.setLogInfo(String.format("\u56fe\u5c42%s\u7f3a\u5931\u5b57\u6bb5%s\u3002", this.stDataInfo.getSourceLayerName(), this.fldChangeType));
            return false;
        }
        int changeTimeIndex = this.sourceFc.getFields().findFieldIndex(this.fldUpdateTime);
        if (changeTimeIndex < 0) {
            logRecord.setLogInfo(String.format("\u56fe\u5c42%s\u7f3a\u5931\u5b57\u6bb5%s\u3002", this.stDataInfo.getSourceLayerName(), this.fldUpdateTime));
            return false;
        }
        this.nonceFc = this.gwWorkspace.openFeatureClass(this.stDataInfo.getTargetLayerName());
        if (this.nonceFc == null) {
            logRecord.setLogInfo(String.format("\u627e\u4e0d\u5230\u56fe\u5c42%s\u5bf9\u5e94\u7684\u73b0\u52bf\u5c42%s\u3002", this.stDataInfo.getTargetLayerName(), this.stDataInfo.getTargetLayerName()));
            return false;
        }
        if (this.nonceFc.getFields().findFieldIndex("F_TIME") < 0) {
            logRecord.setLogInfo(String.format("\u56fe\u5c42%s\u7f3a\u5931\u5b57\u6bb5%s\u3002", this.stDataInfo.getTargetLayerName(), "F_TIME"));
            return false;
        }
        this.workFc = this.gwWorkspace.openFeatureClass(this.versionKeyInfo.getWorkLayer());
        if (this.workFc == null) {
            logRecord.setLogInfo(String.format("\u627e\u4e0d\u5230\u56fe\u5c42%s\u5bf9\u5e94\u7684\u589e\u91cf\u5c42%s\u3002", this.stDataInfo.getTargetLayerName(), this.versionKeyInfo.getWorkLayer()));
            return false;
        }
        this.cmCustomFields = CopyFeatureHelper.getCommonCustomFields(this.nonceFc);
        this.dataExtentOfNonce = GeometryFunc.createEnvelope((double)Double.MAX_VALUE, (double)Double.MAX_VALUE, (double)Double.MIN_VALUE, (double)Double.MIN_VALUE);
        this.dataExtentOfNonce.setRange(Double.MAX_VALUE, Double.MAX_VALUE, Double.MIN_VALUE, Double.MIN_VALUE);
        this.dataExtentOfWork = GeometryFunc.createEnvelope((double)Double.MAX_VALUE, (double)Double.MAX_VALUE, (double)Double.MIN_VALUE, (double)Double.MIN_VALUE);
        return true;
    }

    protected Boolean startEdit(LayerUpdateLogRecord logRecord) {
        if (!CopyFeatureHelper.startEdit(this.nonceFc).booleanValue()) {
            logRecord.setLogInfo(String.format("\u56fe\u5c42%s\u5bf9\u5e94\u7684\u73b0\u52bf\u5c42%s\u65e0\u6cd5\u542f\u52a8\u7f16\u8f91\u3002", this.stDataInfo.getTargetLayerName(), this.stDataInfo.getTargetLayerName()));
            return false;
        }
        if (!CopyFeatureHelper.startEdit(this.workFc).booleanValue()) {
            logRecord.setLogInfo(String.format("\u56fe\u5c42%s\u5bf9\u5e94\u7684\u589e\u91cf\u5c42%s\u65e0\u6cd5\u542f\u52a8\u7f16\u8f91\u3002", this.stDataInfo.getTargetLayerName(), this.versionKeyInfo.getWorkLayer()));
            return false;
        }
        return true;
    }

    protected void updateExtent() {
        IEnvelope srcExtent = this.nonceFc.getExtent();
        if (this.dataExtentOfNonce != null && !this.dataExtentOfNonce.isEmpty()) {
            CopyFeatureHelper.unionExtent(this.dataExtentOfNonce, srcExtent);
            this.nonceFc.changeExtent(this.dataExtentOfNonce);
        }
        IEnvelope srcExtentOfWork = this.workFc.getExtent();
        if (this.dataExtentOfWork != null && !this.dataExtentOfWork.isEmpty()) {
            CopyFeatureHelper.unionExtent(this.dataExtentOfWork, srcExtentOfWork);
            this.workFc.changeExtent(this.dataExtentOfWork);
        }
    }

    private IQueryFilter getUpdateQueryFilter(IFeatureClass featureClass) {
        return DataUpdateHelper.getUpdateQueryFilter(featureClass, this.dicUpdateValue, this.filter, this.fldChangeType);
    }

    private STDataChangeTypeEnum getChangeType(String changeType) {
        STDataChangeTypeEnum enumType = null;
        for (STDataChangeTypeEnum item : this.dicUpdateValue.keySet()) {
            String[] values = this.dicUpdateValue.get(item).split(";");
            List valueList = Arrays.stream(values).filter(StringUtil::isNotEmpty).collect(Collectors.toList());
            if (!valueList.contains(changeType)) continue;
            enumType = item;
            break;
        }
        return enumType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MyTuple<Boolean, String> addFeature(IFeature feature, Date updateDateTime) {
        IFeature trgFBuffer = this.nonceFc.createFeature();
        try {
            String uniqueValue;
            CopyFeatureHelper.copyFeature(feature, trgFBuffer, this.nonceFc.getSpatialReferenceSystem(), this.cmCustomFields, this.dataExtentOfNonce);
            int srcIndex = feature.getFields().findFieldIndex(this.uniqueField);
            Object valueObj = feature.getValue(srcIndex);
            String string = uniqueValue = valueObj == null ? null : valueObj.toString();
            if (StringUtil.isEmptyOrWhiteSpace((String)uniqueValue)) {
                uniqueValue = String.format("{%s}", UUID.randomUUID());
                CopyFeatureHelper.setValue((IRow)trgFBuffer, this.uniqueField, uniqueValue);
            } else if (this.exist(this.nonceFc.getName(), String.format("%s='%s'", this.uniqueField, uniqueValue)).booleanValue()) {
                MyTuple<Boolean, String> myTuple = new MyTuple<Boolean, String>(false, String.format("OID\u4e3a%s\u7684\u8981\u7d20%s\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u65b0\u589e", feature.getObjectId(), uniqueValue));
                return myTuple;
            }
            CopyFeatureHelper.setValue((IRow)trgFBuffer, "F_TIME", updateDateTime);
            CopyFeatureHelper.setValue((IRow)trgFBuffer, "F_TASKID", this.updateTaskId);
            this.setExtentFields(trgFBuffer, this.extendFields);
            boolean saveSuccess = this.nonceInsertCursor.insertFeature(trgFBuffer);
            if (!saveSuccess) {
                String msg = String.format("OID\u4e3a%s\u7684\u65b0\u589e\u8981\u7d20\u4fdd\u5b58\u5931\u8d25\u3002", feature.getObjectId());
                throw new RuntimeException(msg);
            }
            MyTuple<Boolean, String> myTuple = this.insert2WorkDataset(feature, updateDateTime, STDataChangeTypeEnum.Add, uniqueValue);
            return myTuple;
        }
        finally {
            if (trgFBuffer != null) {
                trgFBuffer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MyTuple<Boolean, String> modifyFeature(IFeature feature, Date updateDateTime, STDataChangeTypeEnum changeType, String changeTypeValue, Boolean updateProperty, Boolean updateShape) {
        IQueryFilter filter = DataUpdateHelper.buildUniqueFldFilter((IRow)feature, this.uniqueField, "");
        IFeatureCursor updateCursor = this.nonceFc.updateFeature(filter);
        IGeometry pCopyGeo = null;
        pCopyGeo = !SpatialReferenceSystemFunc.equals((ISpatialReferenceSystem)feature.getFeatureClass().getSpatialReferenceSystem(), (ISpatialReferenceSystem)this.nonceFc.getSpatialReferenceSystem()) ? feature.getGeometry().projectToCopy(feature.getFeatureClass().getSpatialReferenceSystem(), this.nonceFc.getSpatialReferenceSystem()) : feature.getGeometry();
        if (updateCursor == null) {
            String msg = String.format("\u56fe\u5c42%s\u7684OID\u4e3a%s\u7684\u8981\u7d20\u67e5\u8be2\u5bf9\u5e94\u7684\u53d8\u5316\u8981\u7d20\u5931\u8d25\u3002", this.stDataInfo.getTargetLayerName(), feature.getObjectId());
            return new MyTuple<Boolean, String>(false, msg);
        }
        try {
            IFeature targetFeature = updateCursor.nextFeature();
            if (targetFeature != null) {
                MyTuple<Boolean, String> result2;
                if (!this.checkUpdateTime(targetFeature, updateDateTime).booleanValue()) {
                    String msg = String.format("\u56fe\u5c42%s\u7684OID\u4e3a%s\u7684\u8981\u7d20\u66f4\u65b0\u65f6\u95f4\u65e9\u4e8e\u5f53\u524d\u8981\u7d20\u65f6\u95f4\u3002", this.stDataInfo.getTargetLayerName(), feature.getObjectId());
                    MyTuple<Boolean, String> myTuple = new MyTuple<Boolean, String>(false, msg);
                    return myTuple;
                }
                if (this.isFeatureFirstInput(targetFeature, filter).booleanValue()) {
                    MyTuple<Boolean, String> result = this.insert2WorkDataset(targetFeature, updateDateTime, null, "");
                    if (!((Boolean)result.item1).booleanValue()) {
                        MyTuple<Boolean, String> myTuple = result;
                        return myTuple;
                    }
                }
                if (updateShape.booleanValue()) {
                    targetFeature.setGeometry(pCopyGeo);
                    if (!updateProperty.booleanValue()) {
                        CopyFeatureHelper.setValue((IRow)targetFeature, this.fldChangeType, changeTypeValue);
                        CopyFeatureHelper.setValue((IRow)targetFeature, this.fldUpdateTime, updateDateTime);
                    }
                }
                if (updateProperty.booleanValue()) {
                    CopyFeatureHelper.copyCustomFields(this.cmCustomFields, (IRow)feature, (IRow)targetFeature);
                }
                CopyFeatureHelper.setValue((IRow)targetFeature, "F_TIME", updateDateTime);
                CopyFeatureHelper.setValue((IRow)targetFeature, "F_TASKID", this.updateTaskId);
                this.setExtentFields(targetFeature, this.extendFields);
                updateCursor.updateFeature(targetFeature);
                if (updateShape.booleanValue()) {
                    CopyFeatureHelper.unionExtent(this.dataExtentOfNonce, pCopyGeo.getEnvelope());
                }
                MyTuple<Boolean, String> myTuple = result2 = this.insert2WorkDataset(targetFeature, updateDateTime, changeType, "");
                return myTuple;
            }
            String msg = String.format("\u56fe\u5c42%s\u7684OID\u4e3a%s\u7684\u8981\u7d20\u672a\u627e\u5230\u5bf9\u5e94\u7684\u53d8\u5316\u8981\u7d20\u3002", this.stDataInfo.getTargetLayerName(), feature.getObjectId());
            MyTuple<Boolean, String> myTuple = new MyTuple<Boolean, String>(false, msg);
            return myTuple;
        }
        finally {
            if (updateCursor != null) {
                updateCursor.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MyTuple<Boolean, String> deleteFeature(IFeature feature, Date updateDateTime) {
        IQueryFilter filter = DataUpdateHelper.buildUniqueFldFilter((IRow)feature, this.uniqueField, "");
        IFeatureCursor updateCursor = this.nonceFc.updateFeature(filter);
        if (updateCursor == null) {
            String msg = String.format("\u56fe\u5c42%s\u7684OID\u4e3a%s\u7684\u5220\u9664\u8981\u7d20\u67e5\u8be2\u5bf9\u5e94\u7684\u8981\u7d20\u5931\u8d25\u3002", this.stDataInfo.getTargetLayerName(), feature.getObjectId());
            return new MyTuple<Boolean, String>(false, msg);
        }
        try {
            IFeature targetFeature = updateCursor.nextFeature();
            if (targetFeature != null) {
                if (!this.checkUpdateTime(targetFeature, updateDateTime).booleanValue()) {
                    String msg = String.format("\u56fe\u5c42%s\u7684OID\u4e3a%s\u7684\u5220\u9664\u8981\u7d20\u66f4\u65b0\u65f6\u95f4\u65e9\u4e8e\u5f53\u524d\u8981\u7d20\u65f6\u95f4\u3002", this.stDataInfo.getTargetLayerName(), feature.getObjectId());
                    MyTuple<Boolean, String> myTuple = new MyTuple<Boolean, String>(false, msg);
                    return myTuple;
                }
                this.insert2WorkDataset(targetFeature, updateDateTime, STDataChangeTypeEnum.Delete, "");
                updateCursor.deleteFeature();
                MyTuple<Boolean, String> msg = new MyTuple<Boolean, String>(true, "");
                return msg;
            }
            String msg = String.format("\u56fe\u5c42%s\u7684OID\u4e3a%s\u7684\u5220\u9664\u8981\u7d20\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8981\u7d20\u3002", this.stDataInfo.getTargetLayerName(), feature.getObjectId());
            MyTuple<Boolean, String> myTuple = new MyTuple<Boolean, String>(false, msg);
            return myTuple;
        }
        finally {
            if (updateCursor != null) {
                updateCursor.release();
            }
        }
    }

    protected MyTuple<Boolean, String> insert2WorkDataset(IFeature feature, Date updateDateTime, STDataChangeTypeEnum updateType, String guid) {
        boolean saveSuccess;
        IFeature workFBuffer = this.workFc.createFeature();
        CopyFeatureHelper.copyFeature(feature, workFBuffer, this.workFc.getSpatialReferenceSystem(), this.cmCustomFields, this.dataExtentOfWork);
        CopyFeatureHelper.setValue((IRow)workFBuffer, "F_TASKID2", this.updateTaskId);
        CopyFeatureHelper.setValue((IRow)workFBuffer, "F_UPDATETIME", updateDateTime);
        CopyFeatureHelper.setValue((IRow)workFBuffer, "F_UPDATETYPE", updateType == null ? null : updateType.getDesc());
        if (!StringUtil.isEmptyOrWhiteSpace((String)guid)) {
            CopyFeatureHelper.setValue((IRow)workFBuffer, this.uniqueField, guid);
        }
        if (updateType != null && updateType != STDataChangeTypeEnum.Delete) {
            this.setExtentFields(workFBuffer, this.extendFields);
            CopyFeatureHelper.setValue((IRow)workFBuffer, "F_TASKID", this.updateTaskId);
            CopyFeatureHelper.setValue((IRow)workFBuffer, "F_TIME", updateDateTime);
        }
        if (!(saveSuccess = this.workInsertCursor.insertFeature(workFBuffer))) {
            String msg = String.format("\u56fe\u5c42%s\u7684OID\u4e3a%s\u7684\u8981\u7d20\u4fdd\u5b58\u5230\u5de5\u4f5c\u5c42\u5931\u8d25\u3002", this.workFc.getName(), feature.getObjectId());
            throw new RuntimeException(msg);
        }
        return new MyTuple<Boolean, String>(true, "");
    }

    protected void setExtentFields(IFeature buffer, Map<String, String> dicExtendFields) {
        CopyFeatureHelper.setExtentFields((IRow)buffer, dicExtendFields);
    }

    protected Boolean exist(String tableName, String whereClause) {
        String sql = String.format("SELECT * FROM %s WHERE %s", tableName, whereClause);
        try {
            Map queryResult = this.gwWorkspace.queryOne(sql, new Object[0]);
            return queryResult != null && queryResult.size() > 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    private Boolean checkUpdateTime(IFeature feature, Date newTime) {
        int timeFldIndex = feature.getFields().findFieldIndex("F_TIME");
        Object currentTimeValue = feature.getValue(timeFldIndex);
        Date curTime = (Date)currentTimeValue;
        try {
            if (curTime == null || newTime.before(curTime)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private Boolean isFeatureFirstInput(IFeature nonceFeature, IQueryFilter filter) {
        int taskIdIndex = nonceFeature.getFields().findFieldIndex("F_TASKID");
        Object taskId = nonceFeature.getValue(taskIdIndex);
        if (taskId == null || StringUtil.isEmptyOrWhiteSpace((String)taskId.toString())) {
            return true;
        }
        int iTaskId = Integer.parseInt(taskId.toString());
        return iTaskId <= 0;
    }

    protected void invokeProgressMessageChanged(String message) {
        if (null != this.progressMessageChanged) {
            this.progressMessageChanged.callBack(message);
        }
    }
}

