/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.webstore.update.manager;

import com.geoway.adf.dms.common.dto.TransferResult;
import com.geoway.adf.dms.common.gis.VectorDataTransfer;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DatabaseDTO;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.IEnvelope;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.QueryFilter;
import com.geoway.webstore.datamodel.constant.STDataChangeTypeEnum;
import com.geoway.webstore.datamodel.constant.UpdateGWFieldNameConstant;
import com.geoway.webstore.datamodel.entity.LayerVersionKeyInfo;
import com.geoway.webstore.update.constant.MyTuple;
import com.geoway.webstore.update.dto.LayerUpdateLogRecord;
import com.geoway.webstore.update.dto.SpatioTemporalDatasetInfo;
import com.geoway.webstore.update.manager.listener.IProgressMessageCallBack;
import com.geoway.webstore.update.util.CopyFeatureHelper;
import com.geoway.webstore.update.util.DataUpdateHelper;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;

public class LayerUpdaterHistoryVer {
    protected final GeoDatabaseService geoDatabaseService = (GeoDatabaseService)SpringContextUtil.getBean(GeoDatabaseService.class);
    protected String dbKey;
    protected IFeatureWorkspace targetWorkspace;
    protected DatabaseDTO dataSourceDTO;
    protected IFeatureClass referFc;
    protected IFeatureClass workFc;
    protected IFeatureClass versionFc;
    protected List<String> cmCustomFields;
    protected String uniqueField;
    protected SpatioTemporalDatasetInfo stDataInfo;
    public LayerVersionKeyInfo versionKeyInfo;
    protected IFeatureCursor versionInsertCursor;
    protected IEnvelope dataExtent;
    public Date nearestVersionTime;
    public IProgressMessageCallBack progressMessageChanged;

    public void setGwWorkspace(String targetDatabaseKey) {
        this.dbKey = targetDatabaseKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update(SpatioTemporalDatasetInfo stDataInfo, LayerUpdateLogRecord logRecord) {
        boolean hasException;
        block29: {
            IFeatureCursor workCursor;
            int allFeaCount;
            int updateFeaCount;
            int delFeaCount;
            int addFeaCount;
            block27: {
                block28: {
                    Date versionTime;
                    block25: {
                        block26: {
                            block23: {
                                block24: {
                                    this.stDataInfo = stDataInfo;
                                    logRecord.setSuccess(false);
                                    addFeaCount = 0;
                                    delFeaCount = 0;
                                    updateFeaCount = 0;
                                    allFeaCount = 0;
                                    if (!this.checkAndInitDataset(logRecord).booleanValue()) {
                                        return;
                                    }
                                    hasException = false;
                                    this.versionInsertCursor = null;
                                    workCursor = null;
                                    versionTime = stDataInfo.getTime();
                                    if (this.startEdit(logRecord).booleanValue()) break block23;
                                    if (workCursor == null) break block24;
                                    workCursor.release();
                                }
                                if (this.versionInsertCursor != null) {
                                    this.versionInsertCursor.release();
                                }
                                this.versionInsertCursor = null;
                                CopyFeatureHelper.stopEdit(this.versionFc, !hasException);
                                if (this.targetWorkspace == null) return;
                                this.targetWorkspace.close();
                                return;
                            }
                            this.copyVersion(this.referFc);
                            if (!versionTime.after(this.nearestVersionTime) && versionTime != this.nearestVersionTime) break block25;
                            logRecord.setSuccess(true);
                            if (workCursor == null) break block26;
                            workCursor.release();
                        }
                        if (this.versionInsertCursor != null) {
                            this.versionInsertCursor.release();
                        }
                        this.versionInsertCursor = null;
                        CopyFeatureHelper.stopEdit(this.versionFc, !hasException);
                        if (this.targetWorkspace == null) return;
                        this.targetWorkspace.close();
                        return;
                    }
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                    GregorianCalendar calendar = new GregorianCalendar();
                    calendar.setTime(versionTime);
                    ((Calendar)calendar).add(5, 1);
                    Date versionTimeAddDay = calendar.getTime();
                    calendar.setTime(this.nearestVersionTime);
                    ((Calendar)calendar).add(5, 1);
                    Date nearestVersionTimeAddDay = calendar.getTime();
                    String timeWhereClause = String.format("%s>='%s' and %s<'%s' and %s is not null", "F_UPDATETIME", format.format(versionTimeAddDay), "F_UPDATETIME", format.format(nearestVersionTimeAddDay), "F_UPDATETYPE");
                    QueryFilter queryFilter = new QueryFilter();
                    queryFilter.setPostfixClause(String.format(" inner join (select %s as %s,min(%s) as %s from %s where %s group by %s) AS T2 on %s.%s=t2.%s and %s.%s =t2.%s  and %s.%s is not null", this.uniqueField, this.uniqueField + "2", "F_TASKID2", "F_TASKID22", this.workFc.getName(), timeWhereClause, this.uniqueField + "2", this.workFc.getName(), this.uniqueField, this.uniqueField + "2", this.workFc.getName(), "F_TASKID2", "F_TASKID22", this.workFc.getName(), "F_UPDATETYPE"));
                    String where = queryFilter.getPostfixClause();
                    workCursor = this.workFc.searchFeature((IQueryFilter)queryFilter);
                    if (workCursor != null) break block27;
                    logRecord.setLogInfo(String.format("\u56fe\u5c42%s\u67e5\u8be2\u5931\u8d25\u3002", this.workFc.getName()));
                    if (workCursor == null) break block28;
                    workCursor.release();
                }
                if (this.versionInsertCursor != null) {
                    this.versionInsertCursor.release();
                }
                this.versionInsertCursor = null;
                CopyFeatureHelper.stopEdit(this.versionFc, !hasException);
                if (this.targetWorkspace == null) return;
                this.targetWorkspace.close();
                return;
            }
            try {
                int changeTypeIndex = workCursor.getFields().findFieldIndex("F_UPDATETYPE");
                int changeTimeIndex = workCursor.getFields().findFieldIndex("F_UPDATETIME");
                this.versionInsertCursor = this.versionFc.insertFeature();
                IFeature feature = workCursor.nextFeature();
                while (feature != null) {
                    ++allFeaCount;
                    STDataChangeTypeEnum changeType = DataUpdateHelper.getWorkChangeType(feature, changeTypeIndex);
                    Date updateDateTime = DataUpdateHelper.getWorkUpdateTime(feature, changeTimeIndex);
                    switch (changeType) {
                        case Add: {
                            this.deleteFeature(feature);
                            ++delFeaCount;
                            break;
                        }
                        case AllChange: 
                        case ShapeChange: 
                        case PropertyChange: {
                            MyTuple<Boolean, String> saveResult = this.modifyFeature(feature, updateDateTime);
                            if (!((Boolean)saveResult.item1).booleanValue()) {
                                this.invokeProgressMessageChanged((String)saveResult.item2);
                                break;
                            }
                            ++updateFeaCount;
                            break;
                        }
                        case Delete: {
                            MyTuple<Boolean, String> saveResult = this.addFeature(feature);
                            if (!((Boolean)saveResult.item1).booleanValue()) {
                                this.invokeProgressMessageChanged((String)saveResult.item2);
                                break;
                            }
                            if (++addFeaCount % 2000 != 0) break;
                            break;
                        }
                    }
                    feature = workCursor.nextFeature();
                }
                this.versionInsertCursor.release();
                this.updateExtent();
                logRecord.setSuccess(allFeaCount - addFeaCount - updateFeaCount - delFeaCount == 0);
                logRecord.setLogInfo(String.format("\u64a4\u9500\u589e\u52a0%d\u6761\u8981\u7d20\uff0c\u64a4\u9500\u4fee\u6539%d\u6761\u8981\u7d20\uff0c\u64a4\u9500\u5220\u9664%d\u6761\u8981\u7d20\uff0c\u64a4\u9500\u5931\u8d25%d\u6761\u8981\u7d20", addFeaCount, updateFeaCount, delFeaCount, allFeaCount - addFeaCount - updateFeaCount - delFeaCount));
                if (workCursor == null) break block29;
            }
            catch (Exception e) {
                block30: {
                    try {
                        e.printStackTrace();
                        logRecord.setLogInfo(String.format("\u56fe\u5c42%s\u7248\u672c\u6ce8\u518c\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef\uff1a%s", stDataInfo.getTargetLayerName(), e.getMessage()));
                        hasException = true;
                        if (workCursor == null) break block30;
                    }
                    catch (Throwable throwable) {
                        if (workCursor != null) {
                            workCursor.release();
                        }
                        if (this.versionInsertCursor != null) {
                            this.versionInsertCursor.release();
                        }
                        this.versionInsertCursor = null;
                        CopyFeatureHelper.stopEdit(this.versionFc, !hasException);
                        if (this.targetWorkspace == null) throw throwable;
                        this.targetWorkspace.close();
                        throw throwable;
                    }
                    workCursor.release();
                }
                if (this.versionInsertCursor != null) {
                    this.versionInsertCursor.release();
                }
                this.versionInsertCursor = null;
                CopyFeatureHelper.stopEdit(this.versionFc, !hasException);
                if (this.targetWorkspace == null) return;
                this.targetWorkspace.close();
                return;
            }
            workCursor.release();
        }
        if (this.versionInsertCursor != null) {
            this.versionInsertCursor.release();
        }
        this.versionInsertCursor = null;
        CopyFeatureHelper.stopEdit(this.versionFc, !hasException);
        if (this.targetWorkspace == null) return;
        this.targetWorkspace.close();
        return;
    }

    private void copyVersion(IFeatureClass srcFc) {
        VectorDataTransfer vectorDataTransfer = new VectorDataTransfer();
        HashMap<String, String> defaultValues = new HashMap<String, String>(0);
        UpdateGWFieldNameConstant.getUpdateField();
        defaultValues.put(UpdateGWFieldNameConstant.FLD_NAME_GW_UpdateType, "");
        vectorDataTransfer.setDefaultValues(defaultValues);
        TransferResult transferResult = vectorDataTransfer.copyFeature(srcFc, this.versionFc, null);
        if (transferResult.isSuccess()) {
            this.dataExtent = srcFc.getExtent();
            this.versionFc.changeExtent(this.dataExtent);
        }
    }

    protected Boolean checkAndInitDataset(LayerUpdateLogRecord logRecord) {
        this.dataSourceDTO = this.geoDatabaseService.getDatabaseDetail(this.dbKey);
        this.targetWorkspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)this.dataSourceDTO);
        if (this.targetWorkspace == null) {
            logRecord.setLogInfo(String.format("\u56fe\u5c42%s\u7684\u7a7a\u95f4\u5e93\u8fde\u63a5\u5931\u8d25\u3002", this.stDataInfo.getSourceLayerName()));
            return false;
        }
        this.uniqueField = this.versionKeyInfo.getUniqueField();
        if (StringUtil.isEmptyOrWhiteSpace((String)this.uniqueField)) {
            logRecord.setLogInfo(String.format("\u56fe\u5c42%s\u7684\u65f6\u7a7a\u6570\u636e\u6a21\u578b\u552f\u4e00\u6807\u8bc6\u5b57\u6bb5\u4e3a\u7a7a\u3002", this.stDataInfo.getTargetLayerName()));
            return false;
        }
        this.referFc = (IFeatureClass)this.stDataInfo.getDatasetObj();
        if (this.referFc == null) {
            logRecord.setLogInfo(String.format("\u56fe\u5c42%s\u7684\u6570\u636e\u6e90\u4fe1\u606f\u4e22\u5931\u3002", this.stDataInfo.getSourceLayerName()));
            return false;
        }
        this.versionFc = this.targetWorkspace.openFeatureClass(this.stDataInfo.getTargetLayerName());
        if (this.versionFc == null) {
            logRecord.setLogInfo(String.format("\u627e\u4e0d\u5230\u7248\u672c\u5c42%s\u3002", this.stDataInfo.getTargetLayerName()));
            return false;
        }
        if (this.versionFc.getFields().findFieldIndex("F_TIME") < 0) {
            logRecord.setLogInfo(String.format("\u56fe\u5c42%s\u7f3a\u5931\u5b57\u6bb5%s\u3002", this.stDataInfo.getTargetLayerName(), "F_TIME"));
            return false;
        }
        this.workFc = this.targetWorkspace.openFeatureClass(this.versionKeyInfo.getWorkLayer());
        if (this.workFc == null) {
            logRecord.setLogInfo(String.format("\u627e\u4e0d\u5230\u56fe\u5c42%s\u5bf9\u5e94\u7684\u589e\u91cf\u5c42%s\u3002", this.stDataInfo.getTargetLayerName(), this.versionKeyInfo.getWorkLayer()));
            return false;
        }
        if (this.workFc.getFields().findFieldIndex("F_UPDATETIME") < 0) {
            logRecord.setLogInfo(String.format("\u56fe\u5c42%s\u7f3a\u5931\u5b57\u6bb5%s\u3002", this.workFc.getName(), "F_UPDATETIME"));
            return false;
        }
        if (this.workFc.getFields().findFieldIndex("F_TASKID2") < 0) {
            logRecord.setLogInfo(String.format("\u56fe\u5c42%s\u7f3a\u5931\u5b57\u6bb5%s\u3002", this.workFc.getName(), "F_TASKID2"));
            return false;
        }
        if (this.workFc.getFields().findFieldIndex("F_UPDATETYPE") < 0) {
            logRecord.setLogInfo(String.format("\u56fe\u5c42%s\u7f3a\u5931\u5b57\u6bb5%s\u3002", this.workFc.getName(), "F_UPDATETYPE"));
            return false;
        }
        this.cmCustomFields = CopyFeatureHelper.getCommonCustomFields(this.versionFc);
        this.dataExtent = GeometryFunc.createEnvelope((double)Double.MAX_VALUE, (double)Double.MAX_VALUE, (double)Double.MIN_VALUE, (double)Double.MIN_VALUE);
        return true;
    }

    protected Boolean startEdit(LayerUpdateLogRecord logRecord) {
        if (!CopyFeatureHelper.startEdit(this.versionFc).booleanValue()) {
            logRecord.setLogInfo(String.format("\u56fe\u5c42%s\u5bf9\u5e94\u7684\u7248\u672c\u5c42%s\u65e0\u6cd5\u542f\u52a8\u7f16\u8f91\u3002", this.stDataInfo.getTargetLayerName(), this.versionKeyInfo.getWorkLayer()));
            return false;
        }
        return true;
    }

    protected void updateExtent() {
        IEnvelope srcExtent = this.versionFc.getExtent();
        if (this.dataExtent != null && !this.dataExtent.isEmpty()) {
            CopyFeatureHelper.unionExtent(this.dataExtent, srcExtent);
            this.versionFc.changeExtent(this.dataExtent);
        }
    }

    protected MyTuple<Boolean, String> addFeature(IFeature feature) {
        IFeature trgFeatureBuffer = this.versionFc.createFeature();
        CopyFeatureHelper.copyFeature(feature, trgFeatureBuffer, this.versionFc.getSpatialReferenceSystem(), this.cmCustomFields, this.dataExtent);
        boolean saveSuccess = this.versionInsertCursor.insertFeature(trgFeatureBuffer);
        if (!saveSuccess) {
            String msg = String.format("OID\u4e3a%s\u7684\u8981\u7d20\u4fdd\u5b58\u5931\u8d25\u3002", feature.getObjectId());
            throw new RuntimeException(msg);
        }
        return new MyTuple<Boolean, String>(true, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MyTuple<Boolean, String> modifyFeature(IFeature feature, Date updateDateTime) {
        IQueryFilter filter = DataUpdateHelper.buildUniqueFldFilter((IRow)feature, this.uniqueField, "");
        IFeatureCursor updateCursor = this.versionFc.updateFeature(filter);
        if (updateCursor == null) {
            String msg = String.format("\u56fe\u5c42%s\u7684OID\u4e3a%s\u7684\u8981\u7d20\u67e5\u8be2\u5bf9\u5e94\u7684\u53d8\u5316\u8981\u7d20\u5931\u8d25\u3002", this.stDataInfo.getTargetLayerName(), feature.getObjectId());
            throw new RuntimeException(msg);
        }
        try {
            IFeature targetFeature = updateCursor.nextFeature();
            if (targetFeature != null) {
                IFeature lastFeature = DataUpdateHelper.findLastUpdatedFeature(this.dataSourceDTO, feature, updateDateTime, this.uniqueField);
                if (lastFeature == null) {
                    String msg = String.format("\u56fe\u5c42%s\u7684OID\u4e3a%s\u7684\u8981\u7d20\u627e\u4e0d\u5230\u6700\u4e34\u8fd1\u8981\u7d20\u3002", this.stDataInfo.getTargetLayerName(), feature.getObjectId());
                    MyTuple<Boolean, String> myTuple = new MyTuple<Boolean, String>(false, msg);
                    return myTuple;
                }
                CopyFeatureHelper.copyCustomFields(this.cmCustomFields, (IRow)lastFeature, (IRow)targetFeature);
                targetFeature.setGeometry(lastFeature.getGeometry());
                if (targetFeature.getGeometry() != null) {
                    CopyFeatureHelper.unionExtent(this.dataExtent, targetFeature.getGeometry().getEnvelope());
                }
                updateCursor.updateFeature(targetFeature);
                MyTuple<Boolean, String> myTuple = new MyTuple<Boolean, String>(true, "");
                return myTuple;
            }
            String msg = String.format("\u56fe\u5c42%s\u7684OID\u4e3a%s\u7684\u8981\u7d20\u672a\u627e\u5230\u5bf9\u5e94\u7684\u53d8\u5316\u8981\u7d20\u3002", this.stDataInfo.getTargetLayerName(), feature.getObjectId());
            MyTuple<Boolean, String> myTuple = new MyTuple<Boolean, String>(false, msg);
            return myTuple;
        }
        finally {
            if (updateCursor != null) {
                updateCursor.release();
            }
        }
    }

    protected MyTuple<Boolean, String> deleteFeature(IFeature feature) {
        IQueryFilter filter = DataUpdateHelper.buildUniqueFldFilter((IRow)feature, this.uniqueField, "");
        String sql = String.format("delete from %s where %s", this.versionFc.getName(), filter.getWhereClause());
        try {
            this.targetWorkspace.excuteSql(sql);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(String.format("\u56fe\u5c42%s\u6279\u91cf\u5220\u9664\u6570\u636e\u5931\u8d25", this.stDataInfo.getSourceLayerName()));
        }
        return new MyTuple<Boolean, String>(true, "");
    }

    protected void invokeProgressMessageChanged(String message) {
        if (null != this.progressMessageChanged) {
            this.progressMessageChanged.callBack(message);
        }
    }
}

