/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.webstore.update.manager;

import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DatabaseDTO;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.IEnvelope;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.QueryFilter;
import com.geoway.webstore.datamodel.constant.STDataChangeTypeEnum;
import com.geoway.webstore.datamodel.dao.LayerVersionKeyInfoDao;
import com.geoway.webstore.datamodel.entity.LayerVersionKeyInfo;
import com.geoway.webstore.update.constant.MyTuple;
import com.geoway.webstore.update.dto.LayerUpdateLogRecord;
import com.geoway.webstore.update.dto.SpatioTemporalDatasetInfo;
import com.geoway.webstore.update.manager.listener.IProgressMessageCallBack;
import com.geoway.webstore.update.util.CopyFeatureHelper;
import com.geoway.webstore.update.util.DataUpdateHelper;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class LayerUpdaterRevoke {
    private static final Logger log = LoggerFactory.getLogger(LayerUpdaterRevoke.class);
    protected final LayerVersionKeyInfoDao versionKeyInfoDao = (LayerVersionKeyInfoDao)SpringContextUtil.getBean(LayerVersionKeyInfoDao.class);
    protected final GeoDatabaseService geoDatabaseService = (GeoDatabaseService)SpringContextUtil.getBean(GeoDatabaseService.class);
    protected String dbKey;
    protected IFeatureWorkspace nonceWorkspace;
    protected IFeatureWorkspace workWorkspace;
    protected DatabaseDTO dataSourceDTO;
    protected IFeatureClass nonceFc;
    protected IFeatureClass workFc;
    protected List<String> cmCustomFields;
    protected String uniqueField;
    protected SpatioTemporalDatasetInfo stDataInfo;
    protected LayerVersionKeyInfo versionKeyInfo;
    protected IFeatureCursor nonceInsertCursor;
    protected IEnvelope dataExtentOfNonce;
    public Long updateTaskId;
    public IProgressMessageCallBack progressMessageChanged;

    public void setGwWorkspace(String targetDatabaseKey) {
        this.dbKey = targetDatabaseKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(SpatioTemporalDatasetInfo stDataInfo, LayerUpdateLogRecord logRecord) {
        this.stDataInfo = stDataInfo;
        logRecord.setSuccess(false);
        logRecord.addFeatureCount = 0;
        logRecord.delFeatureCount = 0;
        logRecord.updateFeatureCount = 0;
        logRecord.allFeatureCount = 0;
        addFeaCount = 0;
        delFeaCount = 0;
        updateFeaCount = 0;
        allFeaCount = 0;
        if (!this.checkAndInitDataset(logRecord).booleanValue()) {
            return;
        }
        if (!this.startEdit(logRecord).booleanValue()) {
            return;
        }
        currentLayerTimeStamp = this.versionKeyInfo.getTimestamp();
        hasException = false;
        this.nonceInsertCursor = null;
        queryFilter = new QueryFilter();
        queryFilter.setWhereClause(String.format("%s=%d and %s<>'%s'", new Object[]{"F_TASKID2", this.updateTaskId, "F_UPDATETYPE", STDataChangeTypeEnum.Add.getDesc()}));
        workCursor = this.workFc.searchFeature((IQueryFilter)queryFilter);
        if (workCursor == null) {
            logRecord.setLogInfo(String.format("\u56fe\u5c42%s\u67e5\u8be2\u5931\u8d25\u3002", new Object[]{stDataInfo.getSourceLayerName()}));
            return;
        }
        try {
            changeTypeIndex = workCursor.getFields().findFieldIndex("F_UPDATETYPE");
            changeTimeIndex = workCursor.getFields().findFieldIndex("F_UPDATETIME");
            this.nonceInsertCursor = this.nonceFc.insertFeature();
            feature = workCursor.nextFeature();
            while (feature != null) {
                ++allFeaCount;
                changeType = DataUpdateHelper.getWorkChangeType(feature, changeTypeIndex);
                updateDateTime = DataUpdateHelper.getWorkUpdateTime(feature, changeTimeIndex);
                switch (1.$SwitchMap$com$geoway$webstore$datamodel$constant$STDataChangeTypeEnum[changeType.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        saveResult = this.modifyFeature(feature, updateDateTime);
                        if (!((Boolean)saveResult.item1).booleanValue()) {
                            this.invokeProgressMessageChanged((String)saveResult.item2);
                            break;
                        }
                        ++updateFeaCount;
                        break;
                    }
                    case 5: {
                        saveResult = this.addFeature(feature);
                        if (!((Boolean)saveResult.item1).booleanValue()) {
                            this.invokeProgressMessageChanged((String)saveResult.item2);
                            break;
                        }
                        if (++delFeaCount % 2000 != 0) break;
                        break;
                    }
                }
                feature = workCursor.nextFeature();
            }
            dataSourceDTO = this.geoDatabaseService.getDatabaseDetail(this.dbKey);
            gwWorkspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)dataSourceDTO);
            try {
                if (gwWorkspace == null) {
                    logRecord.setLogInfo(String.format("\u56fe\u5c42%s\u7684\u7a7a\u95f4\u5e93\u8fde\u63a5\u5931\u8d25\u3002", new Object[]{this.stDataInfo.getSourceLayerName()}));
                    hasException = true;
                }
                ** GOTO lbl90
            }
            catch (Exception e) {
                e.printStackTrace();
                logRecord.setLogInfo(String.format("\u56fe\u5c42%s\u6279\u91cf\u64a4\u9500\u65b0\u589e\u7684\u6570\u636e\u5931\u8d25", new Object[]{this.stDataInfo.getSourceLayerName()}));
                hasException = true;
                if (gwWorkspace != null) {
                    gwWorkspace.rollbackTransaction();
                }
                ** GOTO lbl107
            }
        }
        catch (Exception e) {
            block35: {
                block36: {
                    try {
                        e.printStackTrace();
                        logRecord.setLogInfo(String.format("\u56fe\u5c42%s\u64a4\u9500\u66f4\u65b0\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef\uff1a%s", new Object[]{stDataInfo.getTargetLayerName(), e.getMessage()}));
                        hasException = true;
                        if (workCursor != null) {
                        }
                        break block35;
                    }
                    catch (Throwable var18_20) {
                        if (workCursor != null) {
                            workCursor.release();
                        }
                        if (this.nonceInsertCursor != null) {
                            this.nonceInsertCursor.release();
                        }
                        this.nonceInsertCursor = null;
                        CopyFeatureHelper.stopEdit(this.nonceFc, hasException == false);
                        CopyFeatureHelper.stopEdit(this.workFc, hasException == false);
                        if (this.nonceWorkspace != null) {
                            this.nonceWorkspace.close();
                        }
                        if (this.workWorkspace == null) throw var18_20;
                        this.workWorkspace.close();
                        throw var18_20;
                    }
lbl90:
                    // 1 sources

                    gwWorkspace.beginTransaction();
                    sql = String.format("delete from %s where %s in (select %s from %s where %s=%d and %s='%s')", new Object[]{this.nonceFc.getName(), this.uniqueField, this.uniqueField, this.workFc.getName(), "F_TASKID2", this.updateTaskId, "F_UPDATETYPE", STDataChangeTypeEnum.Add.getDesc()});
                    addFeaCount = gwWorkspace.excuteSql(sql);
                    allFeaCount += addFeaCount;
                    logRecord.dataUpdateExtent = this.getChangedExtent(gwWorkspace);
                    sql = String.format("delete from %s where %s=%d", new Object[]{this.workFc.getName(), "F_TASKID2", this.updateTaskId});
                    gwWorkspace.excuteSql(sql);
                    gwWorkspace.commitTransaction();
                    gwWorkspace.close();
                    if (gwWorkspace != null) {
                        gwWorkspace.close();
                    }
                    break block36;
                    finally {
                        if (gwWorkspace != null) {
                            gwWorkspace.close();
                        }
                    }
                }
                this.nonceInsertCursor.release();
                this.updateExtent();
                logRecord.addFeatureCount = addFeaCount;
                logRecord.delFeatureCount = delFeaCount;
                logRecord.updateFeatureCount = updateFeaCount;
                logRecord.allFeatureCount = allFeaCount;
                logRecord.setSuccess(true);
                logRecord.setLogInfo(String.format("\u64a4\u9500\u589e\u52a0%d\u6761\u8981\u7d20\uff0c\u64a4\u9500\u4fee\u6539%d\u6761\u8981\u7d20\uff0c\u64a4\u9500\u5220\u9664%d\u6761\u8981\u7d20\uff0c\u64a4\u9500\u5931\u8d25%d\u6761\u8981\u7d20", new Object[]{addFeaCount, updateFeaCount, delFeaCount, allFeaCount - addFeaCount - updateFeaCount - delFeaCount}));
                logRecord.currentLayerTime = currentLayerTimeStamp;
                if (workCursor != null) {
                    workCursor.release();
                }
                if (this.nonceInsertCursor != null) {
                    this.nonceInsertCursor.release();
                }
                this.nonceInsertCursor = null;
                CopyFeatureHelper.stopEdit(this.nonceFc, hasException == false);
                CopyFeatureHelper.stopEdit(this.workFc, hasException == false);
                if (this.nonceWorkspace != null) {
                    this.nonceWorkspace.close();
                }
                if (this.workWorkspace == null) return;
                this.workWorkspace.close();
                return;
                workCursor.release();
            }
            if (this.nonceInsertCursor != null) {
                this.nonceInsertCursor.release();
            }
            this.nonceInsertCursor = null;
            CopyFeatureHelper.stopEdit(this.nonceFc, hasException == false);
            CopyFeatureHelper.stopEdit(this.workFc, hasException == false);
            if (this.nonceWorkspace != null) {
                this.nonceWorkspace.close();
            }
            if (this.workWorkspace == null) return;
            this.workWorkspace.close();
            return;
        }
    }

    protected Boolean checkAndInitDataset(LayerUpdateLogRecord logRecord) {
        this.dataSourceDTO = this.geoDatabaseService.getDatabaseDetail(this.dbKey);
        this.nonceWorkspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)this.dataSourceDTO);
        if (this.nonceWorkspace == null) {
            logRecord.setLogInfo(String.format("\u56fe\u5c42%s\u7684\u7a7a\u95f4\u5e93\u8fde\u63a5\u5931\u8d25\u3002", this.stDataInfo.getSourceLayerName()));
            return false;
        }
        this.versionKeyInfo = this.versionKeyInfoDao.selectByNonceLayer(this.dbKey, this.stDataInfo.getSourceLayerName());
        if (this.versionKeyInfo == null) {
            logRecord.setLogInfo(String.format("\u627e\u4e0d\u5230\u56fe\u5c42%s\u7684\u65f6\u7a7a\u6570\u636e\u6a21\u578b\u4fe1\u606f\u3002", this.stDataInfo.getSourceLayerName()));
            return false;
        }
        this.uniqueField = this.versionKeyInfo.getUniqueField();
        if (StringUtil.isEmptyOrWhiteSpace((String)this.uniqueField)) {
            logRecord.setLogInfo(String.format("\u56fe\u5c42%s\u7684\u65f6\u7a7a\u6570\u636e\u6a21\u578b\u552f\u4e00\u6807\u8bc6\u5b57\u6bb5\u4e3a\u7a7a\u3002", this.stDataInfo.getSourceLayerName()));
            return false;
        }
        this.nonceFc = this.nonceWorkspace.openFeatureClass(this.stDataInfo.getSourceLayerName());
        if (this.nonceFc == null) {
            logRecord.setLogInfo(String.format("\u56fe\u5c42%s\u6253\u5f00\u5931\u8d25\u3002", this.stDataInfo.getSourceLayerName()));
            return false;
        }
        if (this.nonceFc.getFields().findFieldIndex("F_TIME") < 0) {
            logRecord.setLogInfo(String.format("\u56fe\u5c42%s\u7f3a\u5931\u5b57\u6bb5%s\u3002", this.stDataInfo.getSourceLayerName(), "F_TIME"));
            return false;
        }
        this.workWorkspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)this.dataSourceDTO);
        this.workFc = this.workWorkspace.openFeatureClass(this.versionKeyInfo.getWorkLayer());
        if (this.workFc == null) {
            logRecord.setLogInfo(String.format("\u56fe\u5c42%s\u6253\u5f00\u5931\u8d25\u3002", this.versionKeyInfo.getWorkLayer()));
            return false;
        }
        if (this.workFc.getFields().findFieldIndex("F_UPDATETIME") < 0) {
            logRecord.setLogInfo(String.format("\u56fe\u5c42%s\u7f3a\u5931\u5b57\u6bb5%s\u3002", this.versionKeyInfo.getWorkLayer(), "F_UPDATETIME"));
            return false;
        }
        if (this.workFc.getFields().findFieldIndex("F_TASKID2") < 0) {
            logRecord.setLogInfo(String.format("\u56fe\u5c42%s\u7f3a\u5931\u5b57\u6bb5%s\u3002", this.versionKeyInfo.getWorkLayer(), "F_TASKID2"));
            return false;
        }
        if (this.workFc.getFields().findFieldIndex("F_UPDATETYPE") < 0) {
            logRecord.setLogInfo(String.format("\u56fe\u5c42%s\u7f3a\u5931\u5b57\u6bb5%s\u3002", this.versionKeyInfo.getWorkLayer(), "F_UPDATETYPE"));
            return false;
        }
        this.cmCustomFields = CopyFeatureHelper.getCommonCustomFields(this.nonceFc);
        this.dataExtentOfNonce = GeometryFunc.createEnvelope((double)Double.MAX_VALUE, (double)Double.MAX_VALUE, (double)Double.MIN_VALUE, (double)Double.MIN_VALUE);
        return true;
    }

    protected Boolean startEdit(LayerUpdateLogRecord logRecord) {
        if (!CopyFeatureHelper.startEdit(this.nonceFc).booleanValue()) {
            logRecord.setLogInfo(String.format("\u56fe\u5c42%s\u5bf9\u5e94\u7684\u73b0\u52bf\u5c42%s\u65e0\u6cd5\u542f\u52a8\u7f16\u8f91\u3002", this.stDataInfo.getSourceLayerName(), this.stDataInfo.getSourceLayerName()));
            return false;
        }
        if (!CopyFeatureHelper.startEdit(this.workFc).booleanValue()) {
            logRecord.setLogInfo(String.format("\u56fe\u5c42%s\u5bf9\u5e94\u7684\u589e\u91cf\u5c42%s\u65e0\u6cd5\u542f\u52a8\u7f16\u8f91\u3002", this.stDataInfo.getSourceLayerName(), this.versionKeyInfo.getWorkLayer()));
            return false;
        }
        return true;
    }

    protected void updateExtent() {
        IEnvelope srcExtent = this.nonceFc.getExtent();
        if (this.dataExtentOfNonce != null && !this.dataExtentOfNonce.isEmpty()) {
            CopyFeatureHelper.unionExtent(this.dataExtentOfNonce, srcExtent);
            this.nonceFc.changeExtent(this.dataExtentOfNonce);
        }
    }

    protected MyTuple<Boolean, String> addFeature(IFeature feature) {
        IFeature trgFBuffer = this.nonceFc.createFeature();
        CopyFeatureHelper.copyFeature(feature, trgFBuffer, this.nonceFc.getSpatialReferenceSystem(), this.cmCustomFields, this.dataExtentOfNonce);
        boolean saveSuccess = this.nonceInsertCursor.insertFeature(trgFBuffer);
        if (!saveSuccess) {
            String msg = String.format("OID\u4e3a%s\u7684\u8981\u7d20\u4fdd\u5b58\u5931\u8d25\u3002", feature.getObjectId());
            throw new RuntimeException(msg);
        }
        return new MyTuple<Boolean, String>(true, "");
    }

    protected MyTuple<Boolean, String> modifyFeature(IFeature feature, Date updateDateTime) {
        IQueryFilter filter = DataUpdateHelper.buildUniqueFldFilter((IRow)feature, this.uniqueField, "");
        IFeatureCursor updateCursor = this.nonceFc.updateFeature(filter);
        if (updateCursor == null) {
            String msg = String.format("\u56fe\u5c42%s\u7684OID\u4e3a%s\u7684\u8981\u7d20\u67e5\u8be2\u5bf9\u5e94\u7684\u53d8\u5316\u8981\u7d20\u5931\u8d25\u3002", this.stDataInfo.getSourceLayerName(), feature.getObjectId());
            throw new RuntimeException(msg);
        }
        try {
            IFeature targetFeature = updateCursor.nextFeature();
            if (targetFeature != null) {
                IFeature lastFeature = DataUpdateHelper.findLastUpdatedFeature(this.dataSourceDTO, feature, updateDateTime, this.uniqueField);
                if (lastFeature == null) {
                    String msg = String.format("\u56fe\u5c42%s\u7684OID\u4e3a%s\u7684\u8981\u7d20\u627e\u4e0d\u5230\u6700\u4e34\u8fd1\u8981\u7d20\uff0c\u8be5\u56fe\u5c42\u65f6\u7a7a\u6a21\u578b\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", this.stDataInfo.getSourceLayerName(), targetFeature.getObjectId());
                    throw new RuntimeException(msg);
                }
                CopyFeatureHelper.copyCustomFields(this.cmCustomFields, (IRow)lastFeature, (IRow)targetFeature);
                targetFeature.setGeometry(lastFeature.getGeometry());
                if (targetFeature.getGeometry() != null) {
                    CopyFeatureHelper.unionExtent(this.dataExtentOfNonce, targetFeature.getGeometry().getEnvelope());
                }
                updateCursor.updateFeature(targetFeature);
                MyTuple<Boolean, String> myTuple = new MyTuple<Boolean, String>(true, "");
                return myTuple;
            }
            String msg = String.format("\u56fe\u5c42%s\u7684OID\u4e3a%s\u7684\u8981\u7d20\u672a\u627e\u5230\u5bf9\u5e94\u7684\u53d8\u5316\u8981\u7d20\u3002", this.stDataInfo.getSourceLayerName(), feature.getObjectId());
            throw new RuntimeException(msg);
        }
        finally {
            if (updateCursor != null) {
                updateCursor.release();
            }
        }
    }

    protected void invokeProgressMessageChanged(String message) {
        if (null != this.progressMessageChanged) {
            this.progressMessageChanged.callBack(message);
        }
    }

    private IEnvelope getChangedExtent(IFeatureWorkspace gwWorkspace) {
        try {
            String sql = String.format("select st_extent(%s) as box from %s where %s=%d", this.workFc.getShapeFieldName(), this.workFc.getFullName(), "F_TASKID2", this.updateTaskId);
            Map result = gwWorkspace.queryOne(sql, new Object[0]);
            Object box = result.get("box");
            Assert.notNull(box, (String)"\u672a\u67e5\u8be2\u5230\u5173\u8054\u6570\u636e");
            String[] boxExtent = box.toString().substring(4, box.toString().length() - 1).split(",");
            String[] minValues = boxExtent[0].split(" ");
            String[] maxValues = boxExtent[1].split(" ");
            return GeometryFunc.createEnvelope((double)Double.parseDouble(minValues[0]), (double)Double.parseDouble(minValues[1]), (double)Double.parseDouble(maxValues[0]), (double)Double.parseDouble(maxValues[1]));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

