/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.webstore.update.manager;

import com.geoway.adf.dms.common.util.FileUtil;
import com.github.pagehelper.util.StringUtil;
import java.io.File;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorUpdateScanner {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private String path;
    private Pattern fileNamePattern;

    public VectorUpdateScanner(String path, String namePattern) {
        this.path = path;
        if (StringUtil.isNotEmpty((String)namePattern)) {
            this.fileNamePattern = Pattern.compile(namePattern);
        }
    }

    public int scan(Consumer<String> scanedOneData) {
        File parentFolder = new File(this.path);
        this.scanFileGDB(parentFolder, scanedOneData);
        return 1;
    }

    private void scanFileGDB(File path, Consumer<String> scanedOneData) {
        if (path.isDirectory() && FileUtil.getExtension((String)path.getName()).equalsIgnoreCase(".gdb") && new File(path, "gdb").exists()) {
            if (this.fileNamePattern == null || this.fileNamePattern.matcher(FileUtil.getFileNameWithoutExtension((String)path.getName())).matches()) {
                scanedOneData.accept(path.getAbsolutePath());
            }
        } else {
            File[] subFiles;
            for (File file : subFiles = path.listFiles()) {
                if (file.isFile()) continue;
                this.scanFileGDB(file, scanedOneData);
            }
        }
    }
}

