/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.webstore.update.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.common.config.UploadPathConfig;
import com.geoway.adf.dms.common.util.DateTimeUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.gis.basic.PageList;
import com.geoway.webstore.datamodel.dto.spatialtemporal.UpdateRecordDTO;
import com.geoway.webstore.datamodel.service.SpatialTemporalDatasetService;
import com.geoway.webstore.update.constant.TaskStatusEnum;
import com.geoway.webstore.update.constant.UpdateTaskTypeEnum;
import com.geoway.webstore.update.dao.UpdateTaskDao;
import com.geoway.webstore.update.dao.UpdateTaskLogDao;
import com.geoway.webstore.update.dto.UpdateTaskDTO;
import com.geoway.webstore.update.dto.UpdateTaskLogDTO;
import com.geoway.webstore.update.dto.UpdateTaskLogItemDTO;
import com.geoway.webstore.update.dto.VersionRegisterInfo;
import com.geoway.webstore.update.dto.create.UpdateTaskCreateDTO;
import com.geoway.webstore.update.dto.param.InputTaskParameter;
import com.geoway.webstore.update.dto.param.LayerRelationship;
import com.geoway.webstore.update.dto.param.RegisterTaskParameter;
import com.geoway.webstore.update.dto.param.RevokeTaskParameter;
import com.geoway.webstore.update.dto.param.UpdateTaskParameter;
import com.geoway.webstore.update.entity.UpdateTask;
import com.geoway.webstore.update.entity.UpdateTaskLog;
import com.geoway.webstore.update.manager.VectorUpdateScanner;
import com.geoway.webstore.update.manager.task.IUpdateTaskExecutor;
import com.geoway.webstore.update.manager.task.TaskExecutorFactory;
import com.geoway.webstore.update.service.SpatialTemporalTaskService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class SpatialTemporalTaskServiceImpl
implements SpatialTemporalTaskService {
    @Resource
    private UpdateTaskDao updateTaskDao;
    @Resource
    private UpdateTaskLogDao updateTaskLogDao;
    @Resource
    private SpatialTemporalDatasetService spatialTemporalDatasetService;

    @Override
    public Long addTask(UpdateTaskCreateDTO createDTO) {
        UpdateTask task = new UpdateTask();
        task.setName(createDTO.getName());
        task.setResPerson(createDTO.getResPerson());
        task.setCreateDateTime(new Date());
        task.setCreatePerson(createDTO.getCreatePerson());
        task.setParam(createDTO.getParam());
        task.setTaskType(createDTO.getTaskType());
        UpdateTaskTypeEnum taskType = UpdateTaskTypeEnum.getByValue(createDTO.getTaskType());
        switch (taskType) {
            case Update: {
                UpdateTaskParameter parameter = (UpdateTaskParameter)JSONObject.parseObject((String)createDTO.getParam(), UpdateTaskParameter.class);
                Assert.notNull((Object)parameter, (String)"\u66f4\u65b0\u53c2\u6570\u6709\u8bef\uff01");
                break;
            }
            case Register: {
                RegisterTaskParameter registerTaskParameter = (RegisterTaskParameter)JSONObject.parseObject((String)createDTO.getParam(), RegisterTaskParameter.class);
                Assert.notNull((Object)registerTaskParameter, (String)"\u6ce8\u518c\u53c2\u6570\u6709\u8bef\uff01");
                for (VersionRegisterInfo info : registerTaskParameter.getRegisterInfos()) {
                    if (this.spatialTemporalDatasetService.checkHistoryVersionValid(registerTaskParameter.getDsKey(), info.getLayerName(), info.getRegisterTime(), info.getVersionName()).booleanValue()) continue;
                    return -1L;
                }
                break;
            }
            case Cancel: {
                RevokeTaskParameter revokeTaskParameter = (RevokeTaskParameter)JSONObject.parseObject((String)createDTO.getParam(), RevokeTaskParameter.class);
                Assert.notNull((Object)revokeTaskParameter, (String)"\u64a4\u9500\u53c2\u6570\u6709\u8bef\uff01");
                if (StringUtil.isEmptyOrWhiteSpace((String)task.getName())) {
                    UpdateRecordDTO updateRecord = this.spatialTemporalDatasetService.getUpdateRecordDetail(revokeTaskParameter.getCaseId());
                    task.setName(updateRecord.getName() + "-\u64a4\u9500");
                }
                String originalName = task.getName();
                UpdateTask tempUpdateTask = this.updateTaskDao.selectByTaskName(originalName);
                int i = 1;
                while (tempUpdateTask != null) {
                    task.setName(originalName + "_" + i);
                    tempUpdateTask = this.updateTaskDao.selectByTaskName(task.getName());
                    ++i;
                }
                break;
            }
            case Input: {
                InputTaskParameter inputTaskParameter = (InputTaskParameter)JSONObject.parseObject((String)createDTO.getParam(), InputTaskParameter.class);
                Assert.notNull((Object)inputTaskParameter, (String)"\u672c\u5e95\u5165\u5e93\u53c2\u6570\u6709\u8bef\uff01");
                Assert.notNull((Object)inputTaskParameter.getTimePhase(), (String)"\u65f6\u76f8\u53c2\u6570\u6709\u8bef\uff01");
                for (LayerRelationship layerRelationship : inputTaskParameter.getInputDatas()) {
                    layerRelationship.setTimePhase(inputTaskParameter.getTimePhase());
                    if (layerRelationship.valid()) continue;
                    throw new RuntimeException("\u56fe\u5c42\u53c2\u6570\u8bbe\u7f6e\u6709\u8bef\uff01");
                }
                if (!StringUtil.isNotEmpty((String)inputTaskParameter.getPath())) break;
                String path = UploadPathConfig.getFullPath((String)inputTaskParameter.getPath()).toString();
                VectorUpdateScanner scanner = new VectorUpdateScanner(path, null);
                LinkedList<LayerRelationship> layers = new LinkedList<LayerRelationship>();
                scanner.scan(dataPath -> {
                    for (LayerRelationship layerRelationship : inputTaskParameter.getInputDatas()) {
                        LayerRelationship layer = new LayerRelationship();
                        layer.setTimePhase(inputTaskParameter.getTimePhase());
                        layer.setTargetLayerName(layerRelationship.getTargetLayerName());
                        layer.setSourceLayerName(Paths.get(dataPath, layerRelationship.getSourceLayerName()).toString());
                        if (!layer.valid()) {
                            throw new RuntimeException("\u56fe\u5c42\u53c2\u6570\u8bbe\u7f6e\u6709\u8bef\uff01");
                        }
                        layers.add(layer);
                    }
                });
                if (layers.size() == 0) {
                    throw new RuntimeException("\u672a\u626b\u63cf\u5230\u56fe\u5c42\uff01");
                }
                inputTaskParameter.setInputDatas(layers);
                task.setParam(JSONObject.toJSONString((Object)inputTaskParameter));
                break;
            }
            default: {
                throw new RuntimeException("\u4efb\u52a1\u7c7b\u578b\u6709\u8bef\uff01");
            }
        }
        UpdateTask tempUpdateTask = this.updateTaskDao.selectByTaskName(task.getName());
        Assert.isNull((Object)tempUpdateTask, (String)"\u4efb\u52a1\u540d\u79f0\u5df2\u5b58\u5728");
        task.setStatus(TaskStatusEnum.Ready.getValue());
        task.setDescription(createDTO.getDescription());
        this.updateTaskDao.insert(task);
        this.executeTask(task.getId());
        return task.getId();
    }

    @Override
    public UpdateTaskDTO getTaskDetail(Long taskId) {
        UpdateTask updateTask = this.updateTaskDao.selectByPrimaryKey(taskId);
        Assert.notNull((Object)updateTask, (String)"\u4efb\u52a1\u4e0d\u5b58\u5728");
        return this.toTaskDTO(updateTask);
    }

    @Override
    public void executeTask(Long taskId) {
        UpdateTask updateTask = this.updateTaskDao.selectByPrimaryKey(taskId);
        Assert.notNull((Object)updateTask, (String)"\u4efb\u52a1\u4e0d\u5b58\u5728");
        UpdateTaskTypeEnum taskType = UpdateTaskTypeEnum.getByValue(updateTask.getTaskType());
        IUpdateTaskExecutor executor = TaskExecutorFactory.getTaskExecutor(taskType);
        if (executor != null) {
            executor.execute(updateTask);
        }
    }

    @Override
    public void deleteTask(Long taskId) {
        UpdateTask updateTask = this.updateTaskDao.selectByPrimaryKey(taskId);
        if (updateTask != null) {
            if (updateTask.getStatus().intValue() == TaskStatusEnum.Processing.getValue()) {
                throw new RuntimeException("\u4efb\u52a1\u6b63\u5728\u6267\u884c\uff0c\u4e0d\u80fd\u5220\u9664");
            }
            this.updateTaskDao.deleteByPrimaryKey(taskId);
        }
    }

    @Override
    public PageList<UpdateTaskDTO> list(int pageIndex, int rows, String status, String types, String keyword) {
        PageHelper.startPage((int)(pageIndex + 1), (int)rows);
        List statusList = null;
        if (StringUtil.isNotEmpty((String)status)) {
            statusList = StringUtil.split((String)status, (String)",", Integer::valueOf);
        }
        List typeList = null;
        if (StringUtil.isNotEmpty((String)types)) {
            typeList = StringUtil.split((String)types, (String)",", Integer::valueOf);
        }
        List<UpdateTask> taskList = this.updateTaskDao.selectByStatus(statusList, typeList, keyword);
        PageInfo pageInfo = new PageInfo(taskList);
        List tasks = ListUtil.convertAll(taskList, this::toTaskDTO);
        return new PageList(tasks, Long.valueOf(pageInfo.getTotal()));
    }

    @Override
    public List<UpdateTaskLogDTO> getTaskLogs(Long taskId) {
        ArrayList<UpdateTaskLogDTO> result = new ArrayList<UpdateTaskLogDTO>();
        List<UpdateTaskLog> logs = this.updateTaskLogDao.selectByTaskId(taskId);
        if (logs == null || logs.size() == 0) {
            logs = new ArrayList<UpdateTaskLog>();
            UpdateTask updateTask = this.updateTaskDao.selectByPrimaryKey(taskId);
            Assert.notNull((Object)updateTask, (String)"\u4efb\u52a1\u4e0d\u5b58\u5728");
            UpdateTaskLog log = new UpdateTaskLog();
            log.setId(updateTask.getId());
            log.setLayerName(updateTask.getName());
            log.setLevel("\u4e00\u822c");
            log.setTime(updateTask.getCreateDateTime());
            String content = StringUtil.isEmptyOrWhiteSpace((String)updateTask.getLog()) ? "\u6682\u65e0\u65e5\u5fd7\uff01" : updateTask.getLog();
            log.setContent(content);
            logs.add(log);
        }
        Map<String, List<UpdateTaskLog>> layerGroups = logs.stream().collect(Collectors.groupingBy(UpdateTaskLog::getLayerName));
        for (String layerName : layerGroups.keySet()) {
            UpdateTaskLogDTO log = new UpdateTaskLogDTO();
            log.setLayerName(layerName);
            ArrayList<UpdateTaskLogItemDTO> logItems = new ArrayList<UpdateTaskLogItemDTO>();
            for (UpdateTaskLog item : layerGroups.get(layerName)) {
                UpdateTaskLogItemDTO logItem = new UpdateTaskLogItemDTO();
                logItem.setId(item.getId());
                logItem.setContent(item.getContent());
                logItem.setTime(item.getTime());
                logItem.setLevel(item.getLevel());
                logItems.add(logItem);
            }
            log.setLogs(logItems);
            result.add(log);
        }
        return result;
    }

    @Override
    public void downloadLogs(Long taskId) {
        List<UpdateTaskLog> updateTaskLogList = this.updateTaskLogDao.selectByTaskId(taskId);
        if (updateTaskLogList.isEmpty()) {
            throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u66f4\u65b0\u65e5\u5fd7");
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            ArrayList<JSONObject> jsonLogList = new ArrayList<JSONObject>();
            for (UpdateTaskLog updateLog : updateTaskLogList) {
                JSONObject item = new JSONObject(true);
                item.put("\u56fe\u5c42\u540d\u79f0", (Object)updateLog.getLayerName());
                item.put("\u65f6\u95f4", (Object)sdf.format(updateLog.getTime()));
                item.put("\u65e5\u5fd7\u4fe1\u606f", (Object)updateLog.getContent());
                jsonLogList.add(item);
            }
            UpdateTask task = this.updateTaskDao.selectByPrimaryKey(taskId);
            String filename = String.format("%s.xls", task.getName());
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
            HttpServletResponse response = servletRequestAttributes.getResponse();
            if (response != null) {
                response.setContentType("application/x-download");
                response.setHeader("Content-disposition", "attachment; filename=" + URLEncoder.encode(filename, "utf-8"));
                response.setCharacterEncoding("GBK");
                BufferedOutputStream outputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
                this.exportExcel(jsonLogList, outputStream);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private UpdateTaskDTO toTaskDTO(UpdateTask task) {
        UpdateTaskDTO dto = new UpdateTaskDTO();
        BeanUtils.copyProperties((Object)task, (Object)dto);
        if (task.getStartTime() != null) {
            Date endTime = task.getEndTime() == null ? new Date() : task.getEndTime();
            dto.setTimeCost(DateTimeUtil.getTimeIntervalStr((Date)task.getStartTime(), (Date)endTime));
        }
        return dto;
    }

    private void exportExcel(List<JSONObject> dataObject, OutputStream outputStream) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        Set titles = dataObject.get(0).keySet();
        HSSFRow row = sheet.createRow(0);
        HSSFCellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        int column = 0;
        for (String title : titles) {
            sheet.setColumnWidth(column, 9000);
            HSSFCell cell = row.createCell(column);
            cell.setCellValue(title);
            cell.setCellStyle(style);
            ++column;
        }
        for (int i = 1; i <= dataObject.size(); ++i) {
            HSSFRow td = sheet.createRow(i);
            JSONObject data = dataObject.get(i - 1);
            int j = 0;
            for (String title : titles) {
                HSSFCell cell = td.createCell(j);
                cell.setCellValue(data.get((Object)title) == null ? null : data.get((Object)title).toString());
                cell.setCellStyle(style);
                ++j;
            }
        }
        try {
            wb.write(outputStream);
            outputStream.flush();
            wb.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

