/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.webstore.update.util;

import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DatabaseDTO;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.QueryFilter;
import com.geoway.webstore.datamodel.constant.STDataChangeTypeEnum;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DataUpdateHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IFeature findLastUpdatedFeature(DatabaseDTO dataSourceDTO, IFeature workFeature, Date updateDateTime, String uniqueField) {
        int taskIdIndex = workFeature.getFields().findFieldIndex("F_TASKID2");
        String taskId = workFeature.getValue(taskIdIndex).toString();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String whereClause = String.format("(%s<>%s or %s is null) and %s<='%s'", "F_TASKID", taskId, "F_TASKID", "F_TIME", dateFormat.format(updateDateTime));
        IQueryFilter filter = DataUpdateHelper.buildUniqueFldFilter((IRow)workFeature, uniqueField, whereClause);
        filter.setPostfixClause(String.format("order by %s desc", "F_TASKID2"));
        IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)dataSourceDTO);
        IFeatureClass workFc = workspace.openFeatureClass(workFeature.getFeatureClass().getName());
        IFeatureCursor sourceCursor = workFc.searchFeature(filter);
        if (sourceCursor != null) {
            try {
                IFeature iFeature = sourceCursor.nextFeature();
                return iFeature;
            }
            finally {
                sourceCursor.release();
                workspace.close();
            }
        }
        return null;
    }

    public static IQueryFilter getUpdateQueryFilter(IFeatureClass featureClass, Map<STDataChangeTypeEnum, String> dicUpdateValue, String filter, String fldChangeType) {
        int changeTypeIndex = featureClass.getFields().findFieldIndex(fldChangeType);
        IField fld = featureClass.getFields().getField(changeTypeIndex);
        String strFilter = fld.getFieldType() == FieldType.Decimal || fld.getFieldType() == FieldType.Double || fld.getFieldType() == FieldType.Short || fld.getFieldType() == FieldType.Int || fld.getFieldType() == FieldType.Long || fld.getFieldType() == FieldType.Float ? String.format("%s or %s or %s or %s or %s", DataUpdateHelper.getChangeTypeFilter(dicUpdateValue.get(STDataChangeTypeEnum.Add), fldChangeType, false), DataUpdateHelper.getChangeTypeFilter(dicUpdateValue.get(STDataChangeTypeEnum.Delete), fldChangeType, false), DataUpdateHelper.getChangeTypeFilter(dicUpdateValue.get(STDataChangeTypeEnum.AllChange), fldChangeType, false), DataUpdateHelper.getChangeTypeFilter(dicUpdateValue.get(STDataChangeTypeEnum.ShapeChange), fldChangeType, false), DataUpdateHelper.getChangeTypeFilter(dicUpdateValue.get(STDataChangeTypeEnum.PropertyChange), fldChangeType, false)) : String.format("%s or %s or %s or %s or %s", DataUpdateHelper.getChangeTypeFilter(dicUpdateValue.get(STDataChangeTypeEnum.Add), fldChangeType, true), DataUpdateHelper.getChangeTypeFilter(dicUpdateValue.get(STDataChangeTypeEnum.Delete), fldChangeType, true), DataUpdateHelper.getChangeTypeFilter(dicUpdateValue.get(STDataChangeTypeEnum.AllChange), fldChangeType, true), DataUpdateHelper.getChangeTypeFilter(dicUpdateValue.get(STDataChangeTypeEnum.ShapeChange), fldChangeType, true), DataUpdateHelper.getChangeTypeFilter(dicUpdateValue.get(STDataChangeTypeEnum.PropertyChange), fldChangeType, true));
        if (!StringUtil.isEmptyOrWhiteSpace((String)filter)) {
            strFilter = String.format("(%s) and (%s)", strFilter, filter);
        }
        QueryFilter resultFilter = new QueryFilter();
        resultFilter.setWhereClause(strFilter);
        return resultFilter;
    }

    private static String getChangeTypeFilter(String changeValue, String fldChangeType, boolean isString) {
        String[] values = changeValue.split(";");
        List valueList = Arrays.stream(values).filter(StringUtil::isNotEmpty).collect(Collectors.toList());
        if (isString) {
            return valueList.stream().map(f -> String.format("%s='%s'", fldChangeType, f)).collect(Collectors.joining(" or "));
        }
        return valueList.stream().map(f -> String.format("%s=%s", fldChangeType, f)).collect(Collectors.joining(" or "));
    }

    public static IQueryFilter buildUniqueFldFilter(IRow feature, String uniqueField, String otherFilter) {
        String condition;
        ArrayList<String> conditions = new ArrayList<String>();
        int index = feature.getFields().findFieldIndex(uniqueField);
        IField field = feature.getFields().getField(index);
        if (field.getFieldType() == FieldType.String) {
            condition = String.format("%s = '%s'", uniqueField, feature.getValue(index));
            conditions.add(condition);
        } else {
            condition = String.format("%s = %s", uniqueField, feature.getValue(index));
            conditions.add(condition);
        }
        if (!StringUtil.isEmptyOrWhiteSpace((String)otherFilter)) {
            conditions.add(otherFilter);
        }
        String sql = String.join((CharSequence)" and ", conditions);
        QueryFilter filter = new QueryFilter();
        filter.setWhereClause(sql);
        return filter;
    }

    public static STDataChangeTypeEnum getWorkChangeType(String changeType) {
        if (STDataChangeTypeEnum.Delete.getDesc().equals(changeType)) {
            return STDataChangeTypeEnum.Delete;
        }
        if (STDataChangeTypeEnum.Add.getDesc().equals(changeType)) {
            return STDataChangeTypeEnum.Add;
        }
        if (STDataChangeTypeEnum.AllChange.getDesc().equals(changeType)) {
            return STDataChangeTypeEnum.AllChange;
        }
        if (STDataChangeTypeEnum.PropertyChange.getDesc().equals(changeType)) {
            return STDataChangeTypeEnum.PropertyChange;
        }
        if (STDataChangeTypeEnum.ShapeChange.getDesc().equals(changeType)) {
            return STDataChangeTypeEnum.ShapeChange;
        }
        return null;
    }

    public static STDataChangeTypeEnum getWorkChangeType(IFeature feature, int fldIndex) {
        Object changeValue = feature.getValue(fldIndex);
        return DataUpdateHelper.getWorkChangeType(changeValue == null ? "" : changeValue.toString());
    }

    public static Date getWorkUpdateTime(IFeature feature, int fldIndex) {
        Object changeTimeValue = feature.getValue(fldIndex);
        Date updateDateTime = (Date)changeTimeValue;
        if (updateDateTime == null) {
            String msg = String.format("\u56fe\u5c42%s\u7684OID\u4e3a%s\u7684\u8981\u7d20\u66f4\u65b0\u65f6\u95f4\u5b57\u6bb5\u503c\u5f02\u5e38\u3002", feature.getFeatureClass().getName(), feature.getObjectId());
            throw new RuntimeException(msg);
        }
        return updateDateTime;
    }
}

