/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.base.support.Quartz;

import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.triggers.CronTriggerImpl;

public class QuartzManager {
    private static SchedulerFactory gSchedulerFactory = new StdSchedulerFactory();
    private static String JOB_GROUP_NAME = "JOB-MY-EXCUTOR";
    private static String TRIGGER_GROUP_NAME = "TRIG-MY-EXCUTOR";

    public static void addJob(String jobName, Class cls, String cronTime) {
        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            JobKey jobKey = new JobKey(jobName, JOB_GROUP_NAME);
            boolean isExists = sched.checkExists(jobKey);
            if (isExists) {
                QuartzManager.removeJob(jobName);
            }
            JobDetailImpl jobDetail = new JobDetailImpl();
            jobDetail.setKey(jobKey);
            jobDetail.setJobClass(cls);
            TriggerKey triggerKey = new TriggerKey(jobName, TRIGGER_GROUP_NAME);
            CronTriggerImpl trigger = new CronTriggerImpl();
            trigger.setJobKey(jobKey);
            trigger.setKey(triggerKey);
            trigger.setCronExpression(cronTime);
            sched.scheduleJob((JobDetail)jobDetail, (Trigger)trigger);
            if (!sched.isStarted()) {
                sched.start();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isJobExists(String jobName) {
        boolean isExists = false;
        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            JobKey jobKey = new JobKey(jobName, JOB_GROUP_NAME);
            isExists = sched.checkExists(jobKey);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
        return isExists;
    }

    public static void modifyJobTime(String jobName, String cronTime) {
        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            TriggerKey triggerKey = new TriggerKey(jobName, TRIGGER_GROUP_NAME);
            CronTrigger trigger = (CronTrigger)sched.getTrigger(triggerKey);
            if (trigger == null) {
                return;
            }
            String oldTime = trigger.getCronExpression();
            if (!oldTime.equalsIgnoreCase(cronTime)) {
                CronTriggerImpl myTrigger = (CronTriggerImpl)trigger;
                myTrigger.setCronExpression(cronTime);
                sched.rescheduleJob(triggerKey, (Trigger)myTrigger);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void removeJob(String jobName) {
        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            TriggerKey triggerKey = new TriggerKey(jobName, TRIGGER_GROUP_NAME);
            JobKey jobKey = new JobKey(jobName, JOB_GROUP_NAME);
            sched.pauseTrigger(triggerKey);
            sched.unscheduleJob(triggerKey);
            sched.deleteJob(jobKey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void startJobs() {
        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            sched.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void shutdownJobs() {
        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            if (!sched.isShutdown()) {
                sched.shutdown();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

