/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.base.support;

import com.geoway.base.support.QueryFilterParam;
import com.geoway.base.support.QueryParamUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.lang.StringUtils;
import org.springframework.data.jpa.domain.Specification;

public class QuerySpecification<T>
implements Specification<T> {
    String filterParam;

    public QuerySpecification(String filterParam) {
        this.filterParam = filterParam;
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        List<QueryFilterParam> queryParamFilters = QueryParamUtil.parseQueryFilterParams(this.filterParam);
        Predicate restrictions = this.buildPredicate(queryParamFilters, root, query, cb);
        return restrictions;
    }

    public Predicate getPredicate(String filterParam, Root<?> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        List<QueryFilterParam> queryParamFilters = QueryParamUtil.parseQueryFilterParams(filterParam);
        Predicate restrictions = this.buildPredicate(queryParamFilters, root, query, cb);
        return restrictions;
    }

    private Predicate buildPredicate(List<QueryFilterParam> queryParamFilters, Root<?> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        Predicate restrictions = null;
        Predicate preD = null;
        int size = queryParamFilters.size();
        for (int i = 0; i < size; ++i) {
            QueryFilterParam queryParamFilter = queryParamFilters.get(i);
            preD = queryParamFilter.isNest() && queryParamFilter.getChildrens().size() > 0 ? this.buildPredicate(queryParamFilter.getChildrens(), root, query, cb) : this.predicateByQueryParam(queryParamFilter, root, cb);
            if (i == 0) {
                restrictions = preD;
                continue;
            }
            if (queryParamFilter.getJoinModel() == QueryFilterParam.JoinModel.AND) {
                restrictions = cb.and((Expression)restrictions, (Expression)preD);
                continue;
            }
            if (queryParamFilter.getJoinModel() != QueryFilterParam.JoinModel.OR) continue;
            restrictions = cb.or((Expression)restrictions, (Expression)preD);
        }
        return restrictions;
    }

    private Predicate predicateByQueryParam(QueryFilterParam queryParamFilter, Root<?> root, CriteriaBuilder cb) {
        Predicate preD = null;
        QueryFilterParam.OperationModel opModel = queryParamFilter.getOperationMode();
        HashMap<String, Join> joinMap = new HashMap<String, Join>();
        String propName = queryParamFilter.getParamName();
        String[] tmp = StringUtils.split((String)propName, (char)'.');
        block0 : switch (queryParamFilter.getFieldType()) {
            case DateField: {
                Path exp;
                if (tmp.length == 2) {
                    if (!joinMap.containsKey(tmp[0])) {
                        joinMap.put(tmp[0], root.join(tmp[0], JoinType.LEFT));
                    }
                    exp = ((Join)joinMap.get(tmp[0])).get(tmp[1]);
                } else {
                    exp = root.get(propName);
                }
                switch (opModel) {
                    case EQ: {
                        if (queryParamFilter.getParamValue() == null || queryParamFilter.getParamValue().toString().equalsIgnoreCase("null")) {
                            preD = cb.isNull((Expression)root.get(propName));
                            break block0;
                        }
                        long timeInt = Long.parseLong(queryParamFilter.getParamValue().toString());
                        Date queryDate = new Date(timeInt);
                        preD = cb.equal((Expression)exp, (Object)queryDate);
                        break block0;
                    }
                    case NE: {
                        if (queryParamFilter.getParamValue() == null || queryParamFilter.getParamValue().toString().equalsIgnoreCase("null")) {
                            preD = cb.isNotNull((Expression)root.get(propName));
                            break block0;
                        }
                        long timeInt = Long.parseLong(queryParamFilter.getParamValue().toString());
                        Date queryDate = new Date(timeInt);
                        preD = cb.notEqual((Expression)exp, (Object)queryDate);
                        break block0;
                    }
                    case GT: {
                        long timeInt = Long.parseLong(queryParamFilter.getParamValue().toString());
                        Date queryDate = new Date(timeInt);
                        preD = cb.greaterThan((Expression)exp, (Comparable)queryDate);
                        break block0;
                    }
                    case LT: {
                        long timeInt = Long.parseLong(queryParamFilter.getParamValue().toString());
                        Date queryDate = new Date(timeInt);
                        preD = cb.lessThan((Expression)exp, (Comparable)queryDate);
                        break block0;
                    }
                    case GE: {
                        long timeInt = Long.parseLong(queryParamFilter.getParamValue().toString());
                        Date queryDate = new Date(timeInt);
                        preD = cb.greaterThanOrEqualTo((Expression)exp, (Comparable)queryDate);
                        break block0;
                    }
                    case LE: {
                        long timeInt = Long.parseLong(queryParamFilter.getParamValue().toString());
                        Date queryDate = new Date(timeInt);
                        preD = cb.lessThanOrEqualTo((Expression)exp, (Comparable)queryDate);
                        break block0;
                    }
                    case BTW: {
                        String[] timePair = queryParamFilter.getParamValue().toString().split("&&");
                        long timelo = Long.parseLong(timePair[0]);
                        long timego = Long.parseLong(timePair[1]);
                        Date queryDatelo = new Date(timelo);
                        Date queryDatego = new Date(timego);
                        preD = cb.between((Expression)exp, (Comparable)queryDatelo, (Comparable)queryDatego);
                        break block0;
                    }
                }
                break;
            }
            case NumberField: {
                Path exp2;
                if (tmp.length == 2) {
                    if (!joinMap.containsKey(tmp[0])) {
                        joinMap.put(tmp[0], root.join(tmp[0]));
                    }
                    exp2 = ((Join)joinMap.get(tmp[0])).get(tmp[1]);
                } else {
                    exp2 = root.get(propName);
                }
                switch (opModel) {
                    case EQ: {
                        if (queryParamFilter.getParamValue() == null || queryParamFilter.getParamValue().toString().equalsIgnoreCase("null")) {
                            preD = cb.isNull((Expression)root.get(propName));
                            break block0;
                        }
                        preD = cb.equal((Expression)exp2, (Object)Long.valueOf(queryParamFilter.getParamValue().toString()));
                        break block0;
                    }
                    case NE: {
                        if (queryParamFilter.getParamValue() == null || queryParamFilter.getParamValue().toString().equalsIgnoreCase("null")) {
                            preD = cb.isNotNull((Expression)root.get(propName));
                            break block0;
                        }
                        preD = cb.notEqual((Expression)exp2, (Object)Long.valueOf(queryParamFilter.getParamValue().toString()));
                        break block0;
                    }
                    case GE: {
                        preD = cb.ge((Expression)exp2, (Number)Long.valueOf(queryParamFilter.getParamValue().toString()));
                        break block0;
                    }
                    case LE: {
                        preD = cb.le((Expression)exp2, (Number)Long.valueOf(queryParamFilter.getParamValue().toString()));
                        break block0;
                    }
                    case GT: {
                        preD = cb.gt((Expression)exp2, (Number)Long.valueOf(queryParamFilter.getParamValue().toString()));
                        break block0;
                    }
                    case LT: {
                        preD = cb.lt((Expression)exp2, (Number)Long.valueOf(queryParamFilter.getParamValue().toString()));
                        break block0;
                    }
                    case IN: {
                        String[] numPair = queryParamFilter.getParamValue().toString().split(",");
                        if (numPair.length <= 0) break block0;
                        CriteriaBuilder.In in = cb.in((Expression)exp2);
                        int length = numPair.length;
                        for (int k = 0; k < length; ++k) {
                            in.value((Object)Long.valueOf(numPair[k]));
                        }
                        preD = in;
                        break block0;
                    }
                }
                break;
            }
            case StringField: {
                Path exp3;
                if (tmp.length == 2) {
                    if (!joinMap.containsKey(tmp[0])) {
                        joinMap.put(tmp[0], root.join(tmp[0]));
                    }
                    exp3 = ((Join)joinMap.get(tmp[0])).get(tmp[1]);
                } else {
                    exp3 = root.get(propName);
                }
                switch (opModel) {
                    case EQ: {
                        if (queryParamFilter.getParamValue() == null || queryParamFilter.getParamValue().toString().equalsIgnoreCase("null")) {
                            preD = cb.isNull((Expression)root.get(propName));
                            break block0;
                        }
                        preD = cb.equal((Expression)exp3, queryParamFilter.getParamValue());
                        break block0;
                    }
                    case NE: {
                        if (queryParamFilter.getParamValue() == null || queryParamFilter.getParamValue().toString().equalsIgnoreCase("null")) {
                            preD = cb.isNotNull((Expression)root.get(propName));
                            break block0;
                        }
                        preD = cb.notEqual((Expression)exp3, queryParamFilter.getParamValue());
                        break block0;
                    }
                    case GT: {
                        preD = cb.greaterThan((Expression)exp3, (Comparable)((Object)queryParamFilter.getParamValue().toString()));
                        break block0;
                    }
                    case LT: {
                        preD = cb.lessThan((Expression)exp3, (Comparable)((Object)queryParamFilter.getParamValue().toString()));
                        break block0;
                    }
                    case GE: {
                        preD = cb.greaterThanOrEqualTo((Expression)exp3, (Comparable)((Object)queryParamFilter.getParamValue().toString()));
                        break block0;
                    }
                    case LE: {
                        preD = cb.lessThanOrEqualTo((Expression)exp3, (Comparable)((Object)queryParamFilter.getParamValue().toString()));
                        break block0;
                    }
                    case LK: {
                        preD = cb.like((Expression)exp3, "%" + queryParamFilter.getParamValue().toString() + "%");
                        break block0;
                    }
                    case LFK: {
                        preD = cb.like((Expression)exp3, queryParamFilter.getParamValue().toString() + "%");
                        break block0;
                    }
                    case RHK: {
                        preD = cb.like((Expression)exp3, "%" + queryParamFilter.getParamValue().toString());
                        break block0;
                    }
                    case IN: {
                        String[] strPair = queryParamFilter.getParamValue().toString().split(",");
                        if (strPair.length <= 0) break block0;
                        CriteriaBuilder.In in = cb.in((Expression)exp3);
                        int length = strPair.length;
                        for (int k = 0; k < length; ++k) {
                            in.value((Object)strPair[k]);
                        }
                        preD = in;
                        break block0;
                    }
                }
                break;
            }
        }
        return preD;
    }

    private void printQueryFilterParam(QueryFilterParam queryParam) {
        if (queryParam.isNest()) {
            System.out.println(queryParam.getExpression());
            List<QueryFilterParam> queryParams = queryParam.getChildrens();
            int index = 1;
            for (QueryFilterParam subQueryParam : queryParams) {
                System.out.println("-------------------1" + index + "---------------------");
                this.printQueryFilterParam(subQueryParam);
                ++index;
            }
        } else {
            System.out.println(queryParam.getExpression() + "********" + queryParam.getParamName() + ";" + queryParam.getParamValue());
        }
    }
}

