/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.base.help;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringContextHolder
implements ApplicationContextAware,
DisposableBean {
    private static ApplicationContext applicationContext = null;
    private static HashMap mapContainer = new HashMap();
    private static Logger LOGGER = Logger.getLogger(SpringContextHolder.class);

    public static ApplicationContext getApplicationContext() {
        SpringContextHolder.assertContextInjected();
        return applicationContext;
    }

    public static <T> T getBean(String name) {
        LOGGER.debug((Object)("\u4eceSpringContextHolder\u4e2d\u53d6\u51faBean:" + name));
        SpringContextHolder.assertContextInjected();
        return (T)applicationContext.getBean(name);
    }

    public static <T> T getBean(Class<T> requiredType) {
        SpringContextHolder.assertContextInjected();
        return (T)applicationContext.getBean(requiredType);
    }

    public static void clearHolder() {
        LOGGER.debug((Object)("\u6e05\u9664SpringContextHolder\u4e2d\u7684ApplicationContext:" + applicationContext));
        applicationContext = null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        if (SpringContextHolder.applicationContext != null) {
            LOGGER.warn((Object)("SpringContextHolder\u4e2d\u7684ApplicationContext\u88ab\u8986\u76d6, \u539f\u6709ApplicationContext\u4e3a:" + SpringContextHolder.applicationContext));
        }
        SpringContextHolder.applicationContext = applicationContext;
    }

    public void destroy() throws Exception {
        SpringContextHolder.clearHolder();
    }

    private static void assertContextInjected() {
        if (applicationContext == null) {
            throw new IllegalStateException("applicaitonContext\u5c5e\u6027\u672a\u6ce8\u5165, \u8bf7\u5728applicationContext.xml\u4e2d\u5b9a\u4e49SpringContextHolder.");
        }
    }

    public static Object getAttribute(String key) {
        return mapContainer.get(key);
    }

    public static void setAttribute(String key, Object obj) {
        if (StringUtils.isBlank((CharSequence)key)) {
            mapContainer.put(key, obj);
        }
    }
}

