/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.base.service.mail.impl;

import com.geoway.base.service.mail.IMailService;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

public class MailServiceImpl
implements IMailService {
    protected JavaMailSender mailSender;
    protected SimpleMailMessage simpleMailMessage;

    public JavaMailSender getMailSender() {
        return this.mailSender;
    }

    public void setMailSender(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }

    public SimpleMailMessage getSimpleMailMessage() {
        return this.simpleMailMessage;
    }

    public void setSimpleMailMessage(SimpleMailMessage simpleMailMessage) {
        this.simpleMailMessage = simpleMailMessage;
    }

    @Override
    public void sendMail(String subject, String content, String to) {
        MimeMessage mimeMessage = this.mailSender.createMimeMessage();
        try {
            MimeMessageHelper messageHelper = new MimeMessageHelper(mimeMessage, true, "UTF-8");
            messageHelper.setFrom(this.simpleMailMessage.getFrom());
            messageHelper.setSubject(subject);
            messageHelper.setTo(to);
            messageHelper.setText(content, true);
            this.mailSender.send(mimeMessage);
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String mailTemplate(String approvalUserName, String currentUserName, Integer type, String svrName, String svrUrl) {
        Date now = new Date();
        SimpleDateFormat myFmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String operate = null;
        if (type == 1) {
            operate = "\u7533\u8bf7";
        } else if (type == 2) {
            operate = "\u6ce8\u518c";
        } else if (type == 3) {
            operate = "\u6ce8\u9500";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        sb.append("<body style='padding: 20px;line-height: 24px;'>");
        sb.append("<div style='font-weight: bolder;font-size: 18px;'>{0}\u4f60\u597d\uff1a</div>".replace("{0}", approvalUserName));
        sb.append("<div style='padding: 10px;margin-left: 30px;'>");
        sb.append("<div>{0}{1}\u7684\u670d\u52a1\u5df2\u63d0\u4ea4\uff0c\u8bf7\u5c3d\u5feb\u5ba1\u6279\u3002{1}\u7684\u670d\u52a1\u4fe1\u606f\u4e3a\uff1a</div>".replace("{0}", currentUserName).replace("{1}", operate).replace("{1}", operate));
        sb.append("<div>\u670d\u52a1\u540d\u79f0\uff1a{0}</div>".replace("{0}", svrName));
        sb.append("<div>\u670d\u52a1\u5730\u5740\uff1a<a>{0}</a></div>".replace("{0}", svrUrl));
        sb.append("</div>");
        sb.append("<div style='margin-left: 350px;'>");
        sb.append("<div>\u670d\u52a1\u5ba1\u6279\u63d0\u9192\u6d88\u606f</div>");
        sb.append("<div>{0}</div>".replace("{0}", myFmt.format(now)));
        sb.append("</div>");
        sb.append("</body>");
        sb.append("</html>");
        return sb.toString();
    }
}

