/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.base.support;

import com.geoway.base.support.QueryFilterParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class QueryParamParseUtil {
    public static final String complexFindKey = "#";

    public static boolean isComplexExpession(String matchParam) {
        String regex = "\\([^\\(\\)]+\\)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(matchParam);
        return matcher.find();
    }

    public static QueryFilterParam parseComplexMatchParam(String matchParam, Map<String, String> cacheMap) {
        if (!cacheMap.containsKey(matchParam)) {
            return null;
        }
        String filterParam = cacheMap.get(matchParam);
        QueryFilterParam queryFilterParam = new QueryFilterParam();
        queryFilterParam.setExpression(matchParam);
        String[] paramPairs = filterParam.split(";");
        ArrayList<QueryFilterParam> childrens = new ArrayList<QueryFilterParam>();
        QueryFilterParam subQueryParam = null;
        for (int i = 0; i < paramPairs.length; ++i) {
            String subMatchParam = paramPairs[i];
            if (StringUtils.isBlank((String)subMatchParam)) continue;
            subQueryParam = subMatchParam.contains(complexFindKey) ? QueryParamParseUtil.parseComplexMatchParam(subMatchParam, cacheMap) : QueryParamParseUtil.parseMatchParam(subMatchParam);
            childrens.add(subQueryParam);
        }
        queryFilterParam.setChildrens(childrens);
        queryFilterParam.setNest(true);
        if (childrens.size() > 0) {
            queryFilterParam.setJoinModel(((QueryFilterParam)childrens.get(0)).getJoinModel());
        }
        return queryFilterParam;
    }

    public static List<QueryFilterParam> parse4QueryParams(String filterParam) {
        ArrayList<QueryFilterParam> queryParams = new ArrayList<QueryFilterParam>();
        if (StringUtils.isBlank((String)filterParam)) {
            return queryParams;
        }
        String[] paramPairs = filterParam.split(";");
        for (int i = 0; i < paramPairs.length; ++i) {
            if (StringUtils.isBlank((String)paramPairs[i])) continue;
            queryParams.add(QueryParamParseUtil.parseMatchParam(paramPairs[i]));
        }
        return queryParams;
    }

    public static QueryFilterParam parseMatchParam(String matchParam) {
        QueryFilterParam queryParam = new QueryFilterParam();
        queryParam.setExpression(matchParam);
        String[] paramValPair = matchParam.split("=");
        String parseParam = paramValPair[0].trim();
        String[] fieldInfo = parseParam.split("_");
        String joinParam = fieldInfo[0];
        if (joinParam.toUpperCase().equals("Q") || joinParam.toUpperCase().equals("QA")) {
            queryParam.setJoinModel(QueryFilterParam.JoinModel.AND);
        } else if (joinParam.toUpperCase().equals("QOR")) {
            queryParam.setJoinModel(QueryFilterParam.JoinModel.OR);
        }
        queryParam.setParamName(fieldInfo[1].trim());
        queryParam.setParamValue(paramValPair[1].trim());
        String fieldType = fieldInfo[2];
        if (fieldType.toUpperCase().equals("N")) {
            queryParam.setFieldType(QueryFilterParam.DataFieldType.NumberField);
        } else if (fieldType.toUpperCase().equals("S")) {
            queryParam.setFieldType(QueryFilterParam.DataFieldType.StringField);
        } else if (fieldType.toUpperCase().equals("D")) {
            queryParam.setFieldType(QueryFilterParam.DataFieldType.DateField);
        }
        String operation = fieldInfo[3];
        if (operation.toUpperCase().equals("EQ")) {
            queryParam.setOperationMode(QueryFilterParam.OperationModel.EQ);
        }
        if (operation.toUpperCase().equals("NE")) {
            queryParam.setOperationMode(QueryFilterParam.OperationModel.NE);
        } else if (operation.toUpperCase().equals("LK")) {
            queryParam.setOperationMode(QueryFilterParam.OperationModel.LK);
        } else if (operation.toUpperCase().equals("LFK")) {
            queryParam.setOperationMode(QueryFilterParam.OperationModel.LFK);
        } else if (operation.toUpperCase().equals("RHK")) {
            queryParam.setOperationMode(QueryFilterParam.OperationModel.RHK);
        } else if (operation.toUpperCase().equals("BTW")) {
            queryParam.setOperationMode(QueryFilterParam.OperationModel.BTW);
        } else if (operation.toUpperCase().equals("LT")) {
            queryParam.setOperationMode(QueryFilterParam.OperationModel.LT);
        } else if (operation.toUpperCase().equals("GT")) {
            queryParam.setOperationMode(QueryFilterParam.OperationModel.GT);
        } else if (operation.toUpperCase().equals("LE")) {
            queryParam.setOperationMode(QueryFilterParam.OperationModel.LE);
        } else if (operation.toUpperCase().equals("GE")) {
            queryParam.setOperationMode(QueryFilterParam.OperationModel.GE);
        } else if (operation.toUpperCase().equals("IN")) {
            queryParam.setOperationMode(QueryFilterParam.OperationModel.IN);
        } else if (operation.toUpperCase().equals("NOTIN")) {
            queryParam.setOperationMode(QueryFilterParam.OperationModel.NOTIN);
        }
        return queryParam;
    }
}

