/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.base.support;

import com.geoway.base.support.QueryFilterParam;
import com.geoway.base.support.QueryParamParseUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.springframework.data.domain.Sort;

public class QueryParamUtil {
    public static final String complexFindKey = "#";

    public static List<QueryFilterParam> parseQueryFilterParams(String filterParam) {
        if (!QueryParamParseUtil.isComplexExpession(filterParam)) {
            return QueryParamParseUtil.parse4QueryParams(filterParam);
        }
        String regex = "\\([^\\(\\)]+\\)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(filterParam);
        String finalRes = filterParam;
        int index = 1;
        String matchKey = complexFindKey;
        HashMap<String, String> matchMap = new HashMap<String, String>();
        while (matcher.find()) {
            String group = matcher.group();
            String findKey = complexFindKey + index;
            finalRes = matcher.replaceFirst(findKey);
            matcher.reset(finalRes);
            String innalParam = group.substring(1, group.length() - 1);
            matchMap.put(findKey, innalParam);
            ++index;
        }
        String newFilterParam = finalRes;
        ArrayList<QueryFilterParam> queryParams = new ArrayList<QueryFilterParam>();
        String[] paramPairs = newFilterParam.split(";");
        QueryFilterParam queryParam = null;
        for (int i = 0; i < paramPairs.length; ++i) {
            String matchParam = paramPairs[i];
            if (StringUtils.isBlank((String)matchParam)) continue;
            queryParam = matchParam.contains(complexFindKey) ? QueryParamParseUtil.parseComplexMatchParam(matchParam, matchMap) : QueryParamParseUtil.parseMatchParam(matchParam);
            queryParams.add(queryParam);
        }
        return queryParams;
    }

    public static Sort parseSortParams(String sortParam) {
        if (StringUtils.isBlank((String)sortParam)) {
            return null;
        }
        ArrayList<Sort.Order> list = new ArrayList<Sort.Order>();
        String[] paramPairs = sortParam.split(";");
        for (int i = 0; i < paramPairs.length; ++i) {
            String parseParam = paramPairs[i];
            String[] fieldInfo = parseParam.split("_");
            if (!fieldInfo[0].startsWith("SORT")) continue;
            Sort.Order o = new Sort.Order(Sort.Direction.fromString((String)fieldInfo[2]), fieldInfo[1]);
            list.add(o);
        }
        return Sort.by(list);
    }
}

