/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.base.support.filter;

import com.geoway.base.support.GenericResponseWrapper;
import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class JsonpFilter
implements Filter {
    private Logger logger = Logger.getLogger(JsonpFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        Map parms = httpRequest.getParameterMap();
        if (parms.containsKey("callback")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Wrapping response with JSONP callback '" + ((String[])parms.get("callback"))[0] + "'"));
            }
            ServletOutputStream out = httpResponse.getOutputStream();
            GenericResponseWrapper wrapper = new GenericResponseWrapper(httpResponse);
            chain.doFilter(request, (ServletResponse)wrapper);
            out.write(new String(((String[])parms.get("callback"))[0] + "(").getBytes());
            out.write(wrapper.getData());
            out.write(new String(");").getBytes());
            wrapper.setContentType("application/javascript;charset=UTF-8");
            out.close();
        } else {
            chain.doFilter(request, response);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

