/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.base.metadata.action;

import com.geoway.base.dto.BaseObjectResponse;
import com.geoway.base.dto.BaseResponse;
import com.geoway.base.dto.EasyUIResponse;
import com.geoway.base.metadata.domain.ModelGroup;
import com.geoway.base.metadata.service.ModelGroupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/modelGroup"})
public class ModelGroupAction {
    @Autowired
    private ModelGroupService modelGroupService;

    @RequestMapping(value={"/findPages.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse findPages(@RequestParam(name="filterParam", required=false) String filterParam, @RequestParam(name="sortParam", required=false, defaultValue="") String sortParam, @RequestParam(name="page", defaultValue="1") int page, @RequestParam(name="rows", defaultValue="10") int size) {
        EasyUIResponse response = EasyUIResponse.buildSuccessResponse();
        try {
            Page<ModelGroup> pages = this.modelGroupService.findPages(filterParam, sortParam, page - 1, size);
            response.setRows(pages.getContent());
            response.setTotal(Long.valueOf(pages.getTotalElements()));
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus("FAILURE");
        }
        return response;
    }

    @RequestMapping(value={"/saveModelGroup.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse saveModelGroup(@ModelAttribute ModelGroup modelGroup) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            ModelGroup modelGroupDb = this.modelGroupService.saveModelGroup(modelGroup);
            response.setData((Object)modelGroupDb);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus("FAILURE");
        }
        return response;
    }

    @RequestMapping(value={"/delModelGroupById.do"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse delModelGroupById(@RequestParam(name="id") Long id) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            this.modelGroupService.delModelGroup(id);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus("FAILURE");
        }
        return response;
    }

    @RequestMapping(value={"/getModelGroupById"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public BaseResponse getModelGroupById(@RequestParam(name="id") Long id) {
        BaseObjectResponse response = new BaseObjectResponse();
        try {
            ModelGroup modelGroup = this.modelGroupService.findById(id);
            response.setData((Object)modelGroup);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus("FAILURE");
        }
        return response;
    }
}

