package com.geoway.web.interceptor;

import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Component
public class ApiInterceptor implements HandlerInterceptor {

    private static final Logger logger = LoggerFactory.getLogger(ApiInterceptor.class);
    private static final String TIMER = "_request_begin_time_";

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler)
            throws Exception {
        String url = getRequestUrl(request);
        request.setAttribute(TIMER, System.currentTimeMillis());
        getLogger(handler).info("Begin {} \"{}\"", request.getMethod(), url);
        return true;
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler,
                           ModelAndView modelAndView) throws Exception {
        String url = getRequestUrl(request);
        long beginTime = (Long) request.getAttribute(TIMER);
        long costTime = System.currentTimeMillis() - beginTime;
        getLogger(handler).info("End {} \"{}\" {}ms", request.getMethod(), url, costTime);
    }

    private String getRequestUrl(HttpServletRequest request) {
        StringBuffer url = new StringBuffer(request.getRequestURI());
        if (Strings.isNotBlank(request.getQueryString())) {
            url.append("?").append(request.getQueryString());
        }
        return url.toString();
    }

    private Logger getLogger(Object handler) {
        if (handler != null && handler instanceof HandlerMethod) {
            HandlerMethod method = (HandlerMethod) handler;
            return LoggerFactory.getLogger(method.getBeanType());
        } else {
            return logger;
        }
    }

}
