package com.geoway.web.config;

import cn.hutool.core.util.StrUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.MultipartConfigFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.unit.DataSize;

import javax.servlet.MultipartConfigElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@Configuration
public class FileUploadConfiguration {

    @Value("${fileUpload.allowFileTypes:}")
    private String allowFileTypes;

    @Value("${fileUpload.maxFileSize:100MB}")
    private String maxFileSize;

    public List<String> getAllowFileTypes() {

        List<String> allowFileTypeList = new ArrayList<>();
        if(StrUtil.isBlank(allowFileTypes)) {
            allowFileTypeList.add("all");
        }else{
            String[] fileTypesArr = allowFileTypes.split(",");
            allowFileTypeList = Arrays.asList(fileTypesArr).stream().map(String::trim).collect(Collectors.toList());
        }
        return allowFileTypeList;
    }

    @Bean
    public MultipartConfigElement multipartConfigElement() {
        MultipartConfigFactory factory = new MultipartConfigFactory();

        // 允许上传的文件最大值
        factory.setMaxFileSize(DataSize.parse(maxFileSize.trim())); // KB,MB

        return factory.createMultipartConfig();
    }

}
