package com.geoway.web.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
public class ReContent implements java.io.Serializable {

    @ApiModelProperty("标识号")
    private String uid;
    @ApiModelProperty("状态")
    private boolean status;
    @ApiModelProperty("状态码")
    private int code;
    @ApiModelProperty("结果数据")
    private Object data;
    @ApiModelProperty("消息")
    private Object msg;
    @ApiModelProperty("调试消息")
    private String debug;
    @ApiModelProperty("跳转路径")
    private String rediect;

    private ReContent(){}

    public static ReContent build(){
        ReContent re = new ReContent();
        re.setUid(new Date().getTime() + "");
        return re;
    }

    public static ReContent succ(){
        ReContent re = ReContent.build();
        re.setCode(200);
        re.setStatus(true);
        re.setMsg("请求成功");
        return re;
    }

    public static ReContent succ(Object data){
        ReContent re = ReContent.succ();
        re.setData(data);
        return re;
    }

    public static ReContent fail(){
        ReContent re = ReContent.build();
        re.setCode(500);
        re.setStatus(false);
        re.setMsg("请求失败");
        return re;
    }

    public static ReContent fail(String msg){
        ReContent re = ReContent.build();
        re.setMsg(msg);
        return re;
    }

    public static ReContent fail(Integer code, String msg){
        ReContent re = ReContent.build();
        re.setCode(code);
        re.setMsg(msg);
        return re;
    }
}
