/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.web.interceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class ApiInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(ApiInterceptor.class);
    private static final String TIMER = "_request_begin_time_";

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String url = this.getRequestUrl(request);
        request.setAttribute(TIMER, (Object)System.currentTimeMillis());
        this.getLogger(handler).info("Begin {} \"{}\"", (Object)request.getMethod(), (Object)url);
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        String url = this.getRequestUrl(request);
        long beginTime = (Long)request.getAttribute(TIMER);
        long costTime = System.currentTimeMillis() - beginTime;
        this.getLogger(handler).info("End {} \"{}\" {}ms", new Object[]{request.getMethod(), url, costTime});
    }

    private String getRequestUrl(HttpServletRequest request) {
        StringBuffer url = new StringBuffer(request.getRequestURI());
        if (Strings.isNotBlank((String)request.getQueryString())) {
            url.append("?").append(request.getQueryString());
        }
        return url.toString();
    }

    private Logger getLogger(Object handler) {
        if (handler != null && handler instanceof HandlerMethod) {
            HandlerMethod method = (HandlerMethod)handler;
            return LoggerFactory.getLogger((Class)method.getBeanType());
        }
        return logger;
    }
}

