/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.web.interceptor;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileTypeUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.base.dto.BaseResponse;
import com.geoway.web.config.FileUploadConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class FileTypeFilterInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(FileTypeFilterInterceptor.class);
    @Autowired
    FileUploadConfiguration fileTypeConfig;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(request instanceof MultipartHttpServletRequest)) {
            return true;
        }
        List<String> allowFileTypes = this.fileTypeConfig.getAllowFileTypes();
        if (allowFileTypes.contains("all")) {
            return true;
        }
        MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest)request;
        Map allFiles = multipartHttpServletRequest.getFileMap();
        List<String> notAllowedFiles = this.getNotAllowedFiles(allFiles, allowFileTypes, handler);
        if (CollUtil.isNotEmpty(notAllowedFiles)) {
            String message = CharSequenceUtil.format((CharSequence)"\u4e0d\u88ab\u5141\u8bb8\u7684\u6587\u4ef6\u7c7b\u578b\uff01\u4e0d\u88ab\u5141\u8bb8\u7684\u6587\u4ef6\u5217\u8868\u5982\u4e0b\uff1a{}", (Object[])new Object[]{notAllowedFiles});
            this.markFailureResponse(response, message);
            return false;
        }
        return true;
    }

    private List<String> getNotAllowedFiles(Map<String, MultipartFile> allFiles, List<String> allowFileTypes, Object handler) throws IOException {
        ArrayList<String> notAllowedFilenames = null;
        for (MultipartFile file : allFiles.values()) {
            if (this.isAllowedFile(file, allowFileTypes, handler)) continue;
            if (notAllowedFilenames == null) {
                notAllowedFilenames = new ArrayList<String>();
            }
            notAllowedFilenames.add(file.getOriginalFilename());
        }
        return notAllowedFilenames;
    }

    boolean isAllowedFile(MultipartFile file, List<String> allowFileTypes, Object handler) throws IOException {
        String fileName = file.getOriginalFilename();
        try (InputStream in = file.getInputStream();){
            String type = FileTypeUtil.getType((InputStream)in);
            if (StrUtil.isBlank((CharSequence)type)) {
                boolean bl = false;
                return bl;
            }
            String extType = FileUtil.extName((String)fileName);
            if (StrUtil.isBlank((CharSequence)extType)) {
                boolean bl = false;
                return bl;
            }
            ArrayList<String> fileTypes = new ArrayList<String>(allowFileTypes);
            fileTypes.add(type.toLowerCase(Locale.ROOT));
            fileTypes.add(extType.toLowerCase(Locale.ROOT));
            if (allowFileTypes.containsAll(fileTypes)) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private void markFailureResponse(HttpServletResponse response, String msg) throws IOException {
        response.setStatus(HttpStatus.OK.value());
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Cache-Control", "no-cache, must-revalidate");
        BaseResponse baseResopnse = new BaseResponse();
        baseResopnse.markFailure();
        baseResopnse.setMessage(msg);
        String jsonResult = JSON.toJSONString((Object)baseResopnse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNullStringAsEmpty});
        response.getWriter().write(jsonResult);
    }
}

