package com.geoway.web.interceptor;

import com.geoway.web.constant.AuthContext;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Component
public class SysInterceptor implements HandlerInterceptor {

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String authHeader = request.getHeader(AuthContext.AUTH_HEADER_NAME);
        request.setAttribute(AuthContext.AUTH_HEADER_NAME, authHeader);
        return true;
    }
}
